C
C
      SUBROUTINE LVIEW1 (IX, IY, NUMDEC, NUMOPT, NSTART, NTEXT,
     +                   TEXT,
     +                   TITLES)
C
C ACTION : Get a decision from a tabbed list view. Tabbing at grave accents.
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          16/02/2007 now calls X_LVIEW1
C          01/05/2012 added call to NUMCHK 
C
C IX, IY: (input/unchanged) position of the control
C NUMDEC: (input/output) no. of decision made by user (enter with default value)
C NUMOPT: (input/unchanged) no. of options available
C   TEXT: (input/unchanged)header, titles, options available and trailing text
C TITLES: (input/unchanged) if .TRUE. use the titles supplied in TEXT(NSTART - 1)
C                           if .FALSE. create titles and insert before TEXT(NSTART)
C
C          Strategy
C          ========
C          Only NUMDEC is returned altered by this routine. Everything else
C          is copied and then the original arguments are returned unchanged.
C          The TEXT character array is processed according to the values of
C          NSTART, NTEXT, NUMOPT and TITLES as follows.
C          a) [TITLES = .TRUE.] TEXT(NSTART - 1) is taken to be the titles and
C             so no new lines are created. TEXT(1) to TEXT(NSTART - 2) are the
C             header, which is tabbed at grave characters. TEXT(NSTART) to
C             TEXT(NSTART + NUMOPT - 1) are the menu items, and
C             TEXT(NSTART + NUMOPT) to TEXT(NTEXT) are the trailer, tabbed at
c             grave characters, just like the header.
C          b) [TITLES = .FALSE.] A new line is inserted (to space out the
C             columns and act as a dummy title). Then the TEXT is processed
C             exactly as in a).
C          Then the menu items are processed so that every line starts with
C          a bar and every grave in the menu is replaced by a bar. Finally
C          the character array ITEMS is analysed to make sure every line has
C          precisely the same number of columns, i.e. NCOL bars, separating
C          NCOL columns.
C
      IMPLICIT   NONE  
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: IX, IY, NUMOPT, NSTART,
     +                                       NTEXT
      INTEGER,             INTENT (INOUT) :: NUMDEC 
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT(NTEXT) 
      LOGICAL,             INTENT (IN)    :: TITLES
C
C Locals
C      
      EXTERNAL   X_LVIEW1, NUMCHK
      CALL NUMCHK (NUMDEC, NUMOPT,
     +            'LVIEW1') 
      CALL X_LVIEW1 (IX, IY, NUMDEC, NUMOPT, NSTART, NTEXT,
     +               TEXT,
     +               TITLES)
      END
C
C
