c
c     
      subroutine m2file (isend, ncol, nrmax, nrow, nwide,
     +                   a, title,
     +                   istop)
c
c action: write a large matrix supplied in character format to file
c author: w.g.bardsley, university of manchester, u.k. 12/12/2016
c
c isend = 1: correlation matrix
c isend = 2: covariance matrix
c isend = 3: symmetric
c isend = 4: arbitrary
c
c Several sub-types are identified as follows:
c
c itype = 1: full matrix     
c itype = 2: lower triangle (indicated in output title)
c            output is truncated at the diagonal
c itype = 3: upper triangle (indicated in output title)
c            padding blanks are output up to the diagonal
c itype = 4: but mixed r/p correlation probability type (..... on diagonal)
c            indicated in output title
c            After defining new_title itype = 3 and itype = 4 become itype = 1  
c 
c Flags are added to the titles if needed to identify the types retrospectively
c and in all cases the output files have title and dimension header and trailer.
c
c This version chops off sections (len = 100) then writes them along with any
c remaining sections by concatenation to the output file. A final blank is added
c if the length is a mulitple of 100 to force a newline but this probably over-kill.
c
      implicit none
c
c arguments
c      
      integer,              intent (in)  :: isend, ncol, nrmax, nrow,
     +                                      nwide
      character (len = * ), intent (in)  :: a(nrmax,ncol), title
      logical,              intent (out) :: istop           
c
c locals
c      
      integer    i, ios, itype, j, k1, k2, l, l3, l4, m, n  
      integer    numbld(30), numdec, numopt, nout, numsta, numtxt
      parameter (numopt = 6, numsta = 9)
      integer    n1
      parameter (n1 = 1)
      character (len = 1024) fname
      character (len = 100 ) frmat, text(30), new_title
      character (len = 32  ) word32
      character (len = 12  ) form12, word12(3)
      character (len = 11  ) cipher
      character (len = 1   ) blank
      parameter (blank = ' ')
      logical    abort, repeet
      logical    provide_option(4)
      save       numdec, provide_option
      data       numdec / numopt /
      data       provide_option / .true., .true., .true., .true. /
      data       numbld / 30*0 /
      external   rbox02, form12, ofiles, getnou, patch2, ymdhms,
     +           i1file, i2file
      intrinsic  len, len_trim
c
c initialise istop then check
c         
      istop = .false.
      if (ncol.le.nwide .or. .not.provide_option(isend)) return
      if (nrow.gt.nrmax) return   
c
c set up parameters required
c       
      if (isend.eq.1) then
         if (ncol.ne.nrow) return
         cipher = 'correlation'
      elseif (isend.eq.2) then
         if (ncol.ne.nrow) return
         cipher = 'covariance'
      elseif (isend.eq.3) then
         if (ncol.ne.nrow) return
         cipher = 'symmetric'
      elseif (isend.eq.4) then
         cipher = 'arbitrary'
      else
         return      
      endif   
c
c assume matrix is full: itype = 1 then edit as required
c      
      itype = 1
      if (isend.le.3) then
         if (a(1,2).eq.blank) then
c
c must be lower triangle: itype = 2
c           
            itype = 2
         elseif (a(2,1).eq.blank) then
c
c must be upper triangle : itype = 3
c         
            itype = 3
         endif
      endif
c
c could be a mixed r/p correlation type
c      
      if (itype.eq.1 .and. index(a(1,1),'.....').gt.0) itype = 4
c
c generate a new title so the matrix type can be recognised retrospectively
c        
      new_title = title
      if (itype.eq.2 .and. index(title,'lower triangle').eq.0) then
         new_title = 'lower triangle'//blank//title
      elseif (itype.eq.3 .and. index(title,'upper triangle').eq.0) then
         new_title = 'upper triangle'//blank//title
      elseif (itype.eq.4 .and. index(title,'..... type').eq.0) then
         new_title = '..... type'//blank//title  
      endif 
c
c re-define itype
c             
      if (itype.ne.2) itype = 1
c
c deal with the dimensions nrow and ncol
c        
      word12(1) = form12(nrow)    
      word12(2) = form12(ncol)
c
c loop to choose option required
c      
      repeet = .true.
      do while (repeet)
         write (text,100) cipher, new_title, word12(1), word12(2)
         numtxt = numsta + numopt - 1
         call rbox02 (numdec, numopt, numsta, numtxt,
     +                text)    
         repeet = .false.
         if (numdec.eq.1 .or. numdec.eq.2) then
c
c numdec = 1 or 2: write to file
c           
            if (numdec.eq.2) istop = .true. 
            call getnou (nout)
            close (nout)
            fname = 'No File'
            call ofiles (n1, nout,
     +                   fname,
     +                   abort)
            if (abort) then         
               close (unit = nout)
               istop = .false.
               return
            endif
            write (nout,'(a)',iostat=ios) new_title
            if (ios.eq.0) call i2file (nout, nrow, ncol)
c
c define frmat
c              
            l3 = len(a)
            word12(3) = form12(l3)
            l3 = len_trim(word12(3))
            frmat = blank
            l4 = l3 + 9! extra blank added but probably not needed
            frmat(1:l4) = 
     +      '(100(A'//word12(3)(1:l3)//'))'//blank 
            if (itype.eq.1) then
c
c itype = 1: full matrix, upper triangle, or mixed r/p type
c              
               n = ncol/100
               m = mod(ncol,100)  
               do i = 1, nrow
                  k1 = 0
                  k2 = 0
                  do j = 1, n
                     k1 = k2 + 1
                     k2 = k1 + 99
                     if (ios.eq.0) then 
                        write (nout,frmat,iostat=ios,advance='no')
     +                        (a(i,l), l = k1, k2)
                     endif
                  enddo   
                  if (ios.eq.0) then
                     if (m.eq.0) then
                        write (nout,'(a)',iostat=ios,advance='yes')
     +                         blank 
                     else
                        k1 = k2 + 1
                        k2 = k1 + m - 1 
                        write (nout,frmat,iostat=ios,advance='yes') 
     +                        (a(i,l), l = k1, k2) 
                     endif 
                  endif  
               enddo
            elseif (itype.eq.2) then
c
c itype = 2: lower triangle
c            
               do i = 1, 100
                  if (ios.eq.0) then
                     write (nout,frmat,iostat=ios,advance = 'yes')
     +                     (a(i,j), j = 1, i)       
                  endif
               enddo 
               do i = 101, nrow
                  n = i/100
                  m = mod(i,100)
                  k1 = 0
                  k2 = 0 
                  do j = 1, n
                     k1 = k2 + 1
                     k2 = k1 + 99
                     if (ios.eq.0) then 
                        write (nout,frmat,iostat=ios,advance='no')
     +                        (a(i,l), l = k1, k2)
                     endif
                  enddo   
                  if (ios.eq.0) then
                     if (m.eq.0) then
                        write (nout,'(a)',iostat=ios,advance='yes')
     +                         blank
                     else  
                        k1 = k2 + 1
                        k2 = k1 + m - 1 
                        write (nout,frmat,iostat=ios,advance='yes') 
     +                        (a(i,l), l = k1, k2) 
                     endif
                  endif  
               enddo
            endif
            if (ios.eq.0) call i1file (nout, n1)
            call ymdhms (word32)
            if (ios.eq.0) write (nout,'(a)',iostat=ios) word32
            close (unit = nout)
         elseif (numdec.eq.3) then
c
c numdec = 3: return to view
c             
              istop = .false.
          elseif (numdec.eq.4) then
c
c numdec = 4: return without viewing
c
            istop = .true.
         elseif (numdec.eq.5) then
c
c numdec = 5: switch off file writing for the particular case isend
c         
            provide_option(isend) = .false.
            istop = .false.
         elseif (numdec.eq.numopt) then
c
c numdec = 6: help
c         
            write (text,200)
            numbld(1) = 4
            numbld(3) = 1
            numbld(10) = 1
            numbld(17) = 1
            numtxt = 24
            call patch2 (numbld, numtxt,
     +                   text)            
            numbld(1) = 0
            numbld(3) = 0
            numbld(10) = 0
            numbld(17) = 0
            numdec = 3
            repeet = .true.
            numdec = 1
         endif      
      enddo
c
c format statements
c      
  100 format (
     + 'Writing large',1x,a,1x,'matrices to file'
     +/'.' 
     +/'Title of this matrix:'
     +/A
     +/'.'  
     +/'Number of rows:',1x,a
     +/'Number of columns:',1x,a
     +/'.'
     +/'Write to file ... then view sub-sections'
     +/'Write to file ... no sub-section viewing'
     +/'Exit ... then view sub-sections'
     +/'Exit ... no subsection viewing'
     +/'Exit ... switch off file saving for this session'
     +/'Help')
  200 format ( 
     + 'Viewing, saving, and printing matrices'
     +/   
     +/'Small matrices'   
     +/   
     +/'Most Simfit procedures that generate fairly small matrices, say'   
     +/'with only a dozen or so rows and/or columns, will usually save'   
     +/'them directly to the corresponding results file. In this case'     
     +/'they can be retrieved restrospectively if required.'   
     +/   
     +/'Medimum sized matrices'   
     +/   
     +/'When there say up to a hundred or so rows and/or columns, the'
     +/'matrix can be viewed and, if it is important to save or print'
     +/'details, this is easy to do by copying the whole matrix, or a'
     +/'highlighted section to the clipboard.'
     +/
     +/'Large matrices'
     +/
     +/'In order to view large matrices it is convenient to be able to'
     +/'start viewing from a chosen row/column to view selected parts'
     +/'of the matrix. However, from this current procedure it is also'
     +/'possible to write the whole matrix to a file for future use,'
     +/'and then by-pass subsequent viewing of selected sub-matrices'
     +/'if required.') 
      end
c
c
      
       