c
c      
      subroutine m3file (ncol, nlong, nrmax, nrow, ntype, nwide,
     +                   a,
     +                   title,
     +                   istop)
c
c action: write a large matrix supplied in numerical format to file
c author: w.g.bardsley, university of manchester, u.k. 17/12/2016
C         20/01/2017 added ntype = 5
c
c ntype = 1: integer              ... I10
c ntype = 2: medium sized numbers ... F10.6
c ntype = 3: arbitrary            ... 1P,E15.7
c ntype = 4: i, j, r(i,j), p(i,j) ... 2I7,1X,2(F10.6)
c ntype = 5: i, j, p(k), adustedp(k), FDR(HM)-p(k) ... 2I7,1X,4(F10.6),I4
c
      implicit none
c
c arguments
c      
      integer,              intent (in)  :: ncol, nlong, nrmax, nrow,
     +                                      ntype, nwide
      double precision,     intent (in)  :: a(nrmax,ncol)
      character (len = * ), intent (in)  :: title
      logical,              intent (out) :: istop
c
c locals
c      
      integer    i, ios, j, k1, k2, l, m, n 
      integer    numbld(30), numdec, numopt, nout, numsta, numtxt
      parameter (numopt = 6, numsta = 9)
      integer    n1
      parameter (n1 = 1)
      character (len = 1024) fname
      character (len = 100 ) frmat, text(30)
      character (len = 40  ) cipher
      character (len = 32  ) word32
      character (len = 12  ) form12, word12(2)
      character (len = 1   ) blank
      parameter (blank = ' ')
      logical    abort, repeet
      logical    provide_option(5)
      save       numdec, provide_option
      data       numdec / numopt /
      data       provide_option / .true., .true., .true., .true.,
     +                            .true. /
      data       numbld / 30*0 /
      external   rbox02, form12, ofiles, getnou, patch2, ymdhms, i1file,
     +           i2file
      intrinsic  nint, mod
c
c initialise istop then check
c         
      istop = .false.
      if (ncol.le.nwide .and. nrow.le.nlong) return
      if (.not.provide_option(ntype)) return
      if (nrow.gt.nrmax) return   
c
c set up parameters required
c       
      if (ntype.eq.1) then
         cipher = 'I-format'
      elseif (ntype.eq.2) then
         cipher = 'F-format'
      elseif (ntype.eq.3) then
         cipher = 'E-format'
      elseif (ntype.eq.4) then
         cipher = 'i,j,r,p format'  
      elseif (ntype.eq.5) then
         cipher = 'i,j,p(k),ap(k),fdr(k),l format'     
      else
         return      
      endif   
c
c deal with the dimensions nrow and ncol
c        
      word12(1) = form12(nrow)    
      word12(2) = form12(ncol)
c
c loop to choose option required
c      
      repeet = .true.
      do while (repeet)
         write (text,100) cipher, title, word12(1), word12(2)
         numtxt = numsta + numopt - 1
         call rbox02 (numdec, numopt, numsta, numtxt,
     +                text)    
         repeet = .false.
         if (numdec.eq.1 .or. numdec.eq.2) then
c
c numdec = 1 or 2: write to file
c           
            if (numdec.eq.2) istop = .true. 
            call getnou (nout)
            close (nout)
            fname = 'No File'
            call ofiles (n1, nout,
     +                   fname,
     +                   abort)
            if (abort) then         
               close (unit = nout)
               istop = .false.
               return
            endif
            write (nout,'(a)',iostat=ios) title 
            if (ios.eq.0) call i2file (nout, nrow, ncol) 

            n = ncol/100
            m = mod (ncol,100)
            frmat = blank
            
            if (ntype.eq.1) then
c
c I-format
c              
               frmat = '(100(I10))'
               do i = 1, nrow
                  k1 = 0
                  k2 = 0
                  do j = 1, n
                     k1 = k2 + 1
                     k2 = k1 + 99
                     if (ios.eq.0) then 
                        write (nout,frmat,iostat=ios,advance='no')
     +                        (nint(a(i,l)), l = k1, k2)
                     endif
                  enddo   
                  if (ios.eq.0) then
                     if (m.eq.0) then
                        write (nout,'(a)',iostat=ios,advance='yes')
     +                         blank 
                     else
                        k1 = k2 + 1
                        k2 = k1 + m - 1 
                        write (nout,frmat,iostat=ios,advance='yes') 
     +                        (nint(a(i,l)), l = k1, k2) 
                     endif 
                  endif  
               enddo
            elseif (ntype.eq.2) then
c
c F-format
c            
               frmat = '(100(F10.6))'
               do i = 1, nrow
                  k1 = 0
                  k2 = 0
                  do j = 1, n
                     k1 = k2 + 1
                     k2 = k1 + 99
                     if (ios.eq.0) then 
                        write (nout,frmat,iostat=ios,advance='no')
     +                        (a(i,l), l = k1, k2)
                     endif
                  enddo   
                  if (ios.eq.0) then
                     if (m.eq.0) then
                        write (nout,'(a)',iostat=ios,advance='yes')
     +                         blank 
                     else
                        k1 = k2 + 1
                        k2 = k1 + m - 1 
                        write (nout,frmat,iostat=ios,advance='yes') 
     +                        (a(i,l), l = k1, k2) 
                     endif 
                  endif  
               enddo  
            elseif (ntype.eq.3) then
c
c E-format
c    
               frmat = '(100(1P,E15.7))'
               do i = 1, nrow
                  k1 = 0
                  k2 = 0
                  do j = 1, n
                     k1 = k2 + 1
                     k2 = k1 + 99
                     if (ios.eq.0) then 
                        write (nout,frmat,iostat=ios,advance='no')
     +                        (a(i,l), l = k1, k2)
                     endif
                  enddo   
                  if (ios.eq.0) then
                     if (m.eq.0) then
                        write (nout,'(a)',iostat=ios,advance='yes')
     +                         blank 
                     else
                        k1 = k2 + 1
                        k2 = k1 + m - 1 
                        write (nout,frmat,iostat=ios,advance='yes') 
     +                        (a(i,l), l = k1, k2) 
                     endif 
                  endif  
               enddo  
            elseif (ntype.eq.4) then   
c
c i,j,r,p format
c
               do i = 1, nrow
                  write (nout,'(2i7,1x,2(f10.6))',iostat=ios)
     +            nint(a(i,1)), nint(a(i,2)), a(i,3), a(i,4)
               enddo  
            elseif (ntype.eq.5) then   
               do i = 1, nrow
                  write (nout,'(2i7,1x,3(f10.6),i4)',iostat=ios)
     +            nint(a(i,1)), nint(a(i,2)),
     +            a(i,3), a(i,4), a(i,5), 
     +            nint(a(i,6)) 
               enddo
            endif
            if (ios.eq.0) call i1file (nout, n1) 
            call ymdhms (word32)
            if (ios.eq.0) write (nout,'(a)', iostat=ios) word32
            close (unit = nout)
         elseif (numdec.eq.3) then
c
c numdec = 3: return to view
c             
              istop = .false.
          elseif (numdec.eq.4) then
c
c numdec = 4: return without viewing
c
            istop = .true.
         elseif (numdec.eq.5) then
c
c numdec = 5: switch off file writing
c         
            provide_option(ntype) = .false.
            istop = .false.
         elseif (numdec.eq.numopt) then
c
c numdec = 6: help
c         
            write (text,200)
            numbld(1) = 4
            numbld(3) = 1
            numbld(10) = 1
            numbld(17) = 1
            numtxt = 24
            call patch2 (numbld, numtxt,
     +                   text)            
            numbld(1) = 0
            numbld(3) = 0
            numbld(10) = 0
            numbld(17) = 0
            numdec = 3
            repeet = .true.
            numdec = 1
         endif      
      enddo
c
c format statements
c      
  100 format (
     + 'Writing large',1x,a,1x,'matrices to file'
     +/'.' 
     +/'Title of this matrix:'
     +/A
     +/'.'  
     +/'Number of rows:',1x,a
     +/'Number of columns:',1x,a
     +/'.'
     +/'Write to file ... then view sub-sections'
     +/'Write to file ... no sub-section viewing'
     +/'Exit ... then view sub-sections'
     +/'Exit ... no subsection viewing'
     +/'Exit ... switch off file saving for this session'
     +/'Help')
  200 format ( 
     + 'Viewing, saving, and printing matrices'
     +/   
     +/'Small matrices'   
     +/   
     +/'Most Simfit procedures that generate fairly small matrices, say'   
     +/'with only a dozen or so rows and/or columns, will usually save'   
     +/'them directly to the corresponding results file. In this case'     
     +/'they can be retrieved restrospectively if required.'   
     +/   
     +/'Medimum sized matrices'   
     +/   
     +/'When there say up to a hundred or so rows and/or columns, the'
     +/'matrix can be viewed and, if it is important to save or print'
     +/'details, this is easy to do by copying the whole matrix, or a'
     +/'highlighted section to the clipboard.'
     +/
     +/'Large matrices'
     +/
     +/'In order to view large matrices it is convenient to be able to'
     +/'start viewing from a chosen row/column to view selected parts'
     +/'of the matrix. However, from this current procedure it is also'
     +/'possible to write the whole matrix to a file for future use,'
     +/'and then by-pass subsequent viewing of selected sub_matrices'
     +/'if required.') 
      end
c
c
      
       