C
C The original COMMAS subroutine from MAKSIM edited for more general use
C
      SUBROUTINE MAKSIM_COMMAS (IADD1, NPAD, 
     +                          STRNG)
C
C ACTION : remove '  '... ' ,'... ', ' and transform ,, to ,X, etc.
C          15/04/2008 replaced tests for commas by tests for semicolons, etc.
C                     and now calls PARSE1 
C          28/07/2008 removed from MAKSIM and developed for possible general use
C                     in the future. It is now only really necessary to call PARSE1
C                     with ISEND = 5, but this code also returns NPAD and does prelimary
C                     parsing in case the call to PARSE1 is altered by changing
C                     ISEND or by deleting the call to PARSE1 to speed things up, etc. 
C
C Note: if parameter CWPCHK = .FALSE. then IADD1 is returned unchanged
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (INOUT) :: IADD1, NPAD
      CHARACTER (LEN = *), INTENT (INOUT) :: STRNG
C
C Locals
C      
      INTEGER    ISEND, N0, N1, N2, N3
      PARAMETER (ISEND = 5, N0 = 0, N1 = 1, N2 = 2, N3 = 3)
      INTEGER    I, ICOUNT, J, K, LEN200, LT
      CHARACTER  LINE*10000
      CHARACTER  BLANK*1, COMMA1*1, COMMA2*2, LETTER*1, X*1,
     +           SEMI1*1, SEMI2*2       
      PARAMETER (BLANK = ' ', COMMA1 = ',', COMMA2 = ',,', X = 'X',
     +           SEMI1 = ';', SEMI2 = ';;')
      LOGICAL    CWPCHK, CWPCHK_1
      PARAMETER (CWPCHK = .FALSE.)
      LOGICAL    ABORT
      EXTERNAL   LEN200, TRIML1, PARSE1, COMDOT
      INTRINSIC  INDEX
C
C Remove leading blanks
C
      CALL TRIML1 (STRNG)
C
C Replace commas by dots if there are tabs or semicolons
C      
      CALL COMDOT (STRNG)
      IF (STRNG.EQ.BLANK) RETURN
C
C Check the string length
C
      LT = LEN200(STRNG)
      CWPCHK_1 = CWPCHK
      
C
C Replace any % or & which could cause trouble with CWP and TABLE2, etc.
C Suppressed code as CWP is now protected against % and & so IADD1 is unchanged
C
      IF (CWPCHK_1) THEN
         IF (LT.GT.N0) THEN
            DO I = 1, LT
               IF (STRNG(I:I).EQ.'%') THEN
                  STRNG(I:I) = '?'
                  IADD1 = IADD1 + N1
               ELSEIF (STRNG(I:I).EQ.'&') THEN
                  STRNG(I:I) = '+'
                  IADD1 = IADD1 + N1
               ENDIF
            ENDDO
         ENDIF
      ENDIF   
     
      IF (LT.LE.N0) THEN
C
C The special case LT =< 0
C
         STRNG = X
         NPAD = NPAD + N1
         RETURN
      ELSEIF (LT.EQ.N1) THEN
C
C The special case LT = 1
C
         IF (STRNG.EQ.COMMA1 .OR. STRNG.EQ.SEMI1) THEN
            STRNG = 'X;X'
            NPAD = NPAD + N2
         ENDIF
         RETURN
      ELSEIF (LT.EQ.N2) THEN
C
C The special case LT = 2
C
         IF (STRNG.EQ.COMMA2 .OR. STRNG.EQ.SEMI2) THEN
            STRNG = 'X;X;X'
            NPAD = NPAD + N3
         ENDIF
         RETURN
      ENDIF
C
C Check if the last letter is a comma or semicolon
C
      IF (INDEX(LINE,COMMA1).GT.N0 .OR. INDEX(LINE,SEMI1).GT.N0) THEN
         LETTER = STRNG(LT:LT)
         IF (LETTER.EQ.COMMA1 .OR. LETTER.EQ.SEMI1) THEN
            LT = LT + N1
            STRNG(LT:LT) = X
            NPAD = NPAD + N1
         ENDIF
C
C Check if the first letter is a comma or semicolon
C
         LETTER = STRNG(N1:N1)
         IF (LETTER.EQ.COMMA1 .OR. LETTER.EQ.SEMI1) THEN
            LT = LT + N1
            ICOUNT = LT
               DO I = LT, N2, - N1
               ICOUNT = ICOUNT - N1
               STRNG(I:I) = STRNG(ICOUNT:ICOUNT)
            ENDDO
            STRNG(N1:N1) = X
            NPAD = NPAD + N1
         ENDIF
         IF (INDEX(LINE,COMMA2).GT.N0 .OR. INDEX(LINE,SEMI2).GT.N0) THEN
C
C Systematically replace ,, by ,X, and ;; by ;X;
C
            LT = LEN200(LINE)
            ICOUNT = N0
            DO I = N1, LT - N1
               LETTER = LINE(I:I)
               ICOUNT = ICOUNT + N1
               STRNG(ICOUNT:ICOUNT) = LETTER
               IF (LETTER.EQ.COMMA1 .AND.
     +             LINE(I + 1:I + 1).EQ.COMMA1 .OR.
     +             LETTER.EQ.SEMI1 .AND.
     +             LINE(I + 1: I + 1).EQ.SEMI1) THEN
                  ICOUNT = ICOUNT + N1
                  STRNG(ICOUNT:ICOUNT) = X
                  NPAD = NPAD + N1
               ENDIF
            ENDDO
            ICOUNT = ICOUNT + N1
            STRNG(ICOUNT:ICOUNT) = LINE(LT:LT)      
         ENDIF   
      ENDIF    
C
C Use the powerful editing technique
C
      CALL PARSE1 (ISEND,
     +             STRNG,
     +             ABORT)
     
      IF (ABORT) THEN
C
C This code will only be used if PARSE1 is called with an invalid ISEND
C Copy STRNG into LINE omitting double spaces, space/comma and comma/space
C
         LINE = BLANK
         LETTER = STRNG(N1:N1)
         ICOUNT = N1
         LINE(ICOUNT:ICOUNT) = LETTER
         DO I = N2, LT - N1
            LETTER = STRNG(I:I)
            IF (LETTER.EQ.BLANK) THEN
               J = I - N1
               K = I + N1
               IF (STRNG(J:J).EQ.BLANK .OR. STRNG(J:J).EQ.COMMA1 .OR.
     +            STRNG(K:K).EQ.COMMA1) THEN
                  J = I - N1!to silence ftn95
               ELSE
                  ICOUNT = ICOUNT + N1
                  LINE(ICOUNT:ICOUNT) = LETTER
               ENDIF
            ELSE
               ICOUNT = ICOUNT + N1
               LINE(ICOUNT:ICOUNT) = LETTER
            ENDIF
         ENDDO
         ICOUNT = ICOUNT + N1
         LINE(ICOUNT:ICOUNT) = STRNG(LT:LT)
         LT = ICOUNT

C
C Do nothing if no ,, present o/w blank out the string
C
         IF (INDEX(LINE,COMMA2).LE.N0 .AND.
     +       INDEX(LINE,SEMI2).LE.N0) THEN
            STRNG = LINE
            RETURN
         ELSE
            STRNG = BLANK
         ENDIF
      ENDIF
      END
C
C---------------------------------------------------------------------------