

C
C Subroutine DATAIN from program MAKSIM edited and moved to w_menus.dll for more general use
C
      SUBROUTINE MAKSIM_DATAIN (NCMAX, NCOLS, NFIELD, NIN, NOUT, NRMAX, 
     +                          NROWS,
     +                          FNAME1, FNAME2, MATRIX, STRNG,
     +                          ABORT, CLASH, COLIN, QUERY, READY,
     +                          ROWIN, SUPPLY)
C
C ACTION: read in a data set in various file formats
C AUTHOR: w.g.bardsley, university of manchester
C         21/12/1998 checked for simfit type input file
C         08/02/2000 extensive editing to decide if a simfit file
C         11/04/2008 now uses ISITMF to check for a simfit data file
C         30/07/2008 added QUERY and SUPPLY to arguments and altered behaviour
C                    depending on the input values of QUERY and SUPPLY                     
C         21/04/2009 no longer counts trailing blank lines as they may be ,,, ;;; tab/tab/tab
C         02/05/2010 corrected false exit for when blank lines encountered
C   
C QUERY
C -----     
C If QUERY = .TRUE. then users are asked to open a file for the transformed data
C If QUERY = .FALSE. a tempoprary file is created using GETTMP 
C
C SUPPLY
C ------
C If SUPPLY = .TRUE. then it must be called from SIMFIT only after failure using 
C ISITMF and so will automatically exit after attempting to write a Simfit data
C file. Further, it does not allow the extra editing features.                
C If SUPPLY = .FALSE. then it must be called from MAKSIM which does not then exit
C after attempting to create a Simfit data file. Further, it allows extra editing.
C
C QUERY and SUPPLY
C ----------------
C If QUERY = .FALSE. and SUPPLY = .TRUE. an attempt is made to create a Simfit
C                                        file silently.
C 
C From MAKSIM: use no prior call to ISITMF and set QUERY = .TRUE. and SUPPLY = .FALSE
C From ISITSF: only use if call to ISITMF fails then set QUERY = .FALSE. and SUPPLY = .TRUE.
C
C NFIELD
C ------
C Note: NFIELD(NRMAX) in this subroutine, otherwise it is mainly NFIELD(NCOLS) as
C       it is used in this subroutine as a simple register of items per line but
C       then elsewhere it is used for the field width per column when justifying
C       the display and output 
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NCMAX, NIN, NOUT, NRMAX
      INTEGER,             INTENT (OUT)   :: NCOLS, NROWS
      INTEGER,             INTENT (OUT)   :: NFIELD(NRMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME1, FNAME2
      CHARACTER (LEN = *), INTENT (OUT)   :: MATRIX(NRMAX), STRNG
      LOGICAL,             INTENT (OUT)   :: ABORT, CLASH(NRMAX), 
     +                                       COLIN(NCMAX), READY,
     +                                       ROWIN(NRMAX)
      LOGICAL,             INTENT (IN)    :: QUERY, SUPPLY
C
C Allocatable
C  
      CHARACTER (LEN = 20), ALLOCATABLE :: LABELS(:)   
C
C Locals
C      
      INTEGER    I, IADD1, ICOUNT, IERR, IOS, J, JCOUNT, K, NFSAV,
     +           NWRONG
      INTEGER    NBLANK, NLABEL, NLINES, NPAD
      INTEGER    MAKSIM_NITEMS
      INTEGER    KPRINT, KSTART, KSTOP, LEN200
      PARAMETER (KPRINT = 240)
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART,
     +           NTEXT
      PARAMETER (IXL = 4, IYL = 4, LSHADE = 2, NSTART = 14)
      INTEGER    NUMBLD(30), NUMPOS(10)
      INTEGER    JCOLOR
      CHARACTER (LEN = 12) I12(3), FORM12 
      CHARACTER  LINE*100, TEXT(30)*100
      CHARACTER  WORD4*4, WORD6*6, WORD20*20
      CHARACTER  CIPHER*4
      CHARACTER  BLANK*1, USCORE*1
      PARAMETER (BLANK = ' ', USCORE = '_')
      LOGICAL    ADDLAB, REPEET, THERE, YESNO   
      LOGICAL    USE_ALL
      PARAMETER (USE_ALL = .FALSE.)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   FORM12
      EXTERNAL   OFILES, TABLE1, GETJM1, PUTADV, LBOX01, YESNO2,
     +           TRIML1, PUTWAR, ISITMF, READ_TABS, PATCH2
      EXTERNAL   XML000, HTML00, EOFCHA, LEN200
      EXTERNAL   MAKSIM_COMMAS, MAKSIM_PARSE5, MAKSIM_NITEMS,
     +           MAKSIM_VIEW03       
      INTRINSIC  INDEX, TRIM
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / 10*1 /
C
C Initialise logicals
C
      ABORT = .TRUE.
      READY = .FALSE.
      NCOLS = 0
      NROWS = 0
      DO I = 1, NRMAX
         CLASH(I) = .FALSE.
         ROWIN(I) = .TRUE.
      ENDDO
      DO I = 1, NCMAX
         NFIELD(I) = 0 
         COLIN(I) = .TRUE.
      ENDDO
C
C Initialise the matrix
C
      DO I = 1, NRMAX
        MATRIX(I) = BLANK
      ENDDO
      STRNG = BLANK
C
C Initialise the counters
C
      NBLANK = 0
      NLINES = 0
      NPAD = 0
      IF (SUPPLY) THEN
C
C SUPPLY = .TRUE. so check if FNAME1 exists
C        
         CIPHER = '[NA]'  
         INQUIRE (FILE = FNAME1, EXIST = THERE)
         ABORT = .NOT.THERE
      ELSE     
C
C SUPPLY = .FALSE. so attempt to read in a data file
C
         CIPHER = '    ' 
         I = 3
         CLOSE (UNIT = NIN)
         CALL OFILES (I, NIN,
     +                FNAME1, 
     +                ABORT)
         CLOSE (UNIT = NIN)
      ENDIF  
      IF (ABORT) THEN
C
C Bad or no file
C        
         FNAME1 = BLANK 
         FNAME2 = BLANK
         RETURN
      ELSE
         IF (.NOT.SUPPLY) CALL ISITMF (NCOLS, NROWS,
     +                                 FNAME1)
         IF (NCOLS.GT.0 .AND. NROWS.GT.0) THEN
C
C----------------------------------------------------
C Start of analysis for satisfactory Simfit data file
C----------------------------------------------------
C           
            IF (NCOLS.LE.NCMAX .AND. NROWS.LE.NRMAX) THEN
C
C Check if the file has labels appended
C              
               ADDLAB = .FALSE. 
               NLABEL = NCOLS + NROWS
               IERR = 0
               IF (ALLOCATED (LABELS)) DEALLOCATE (LABELS, STAT = IERR)
               IF (IERR.EQ.0) THEN
                  ALLOCATE (LABELS(NLABEL), STAT = IERR)
                  IF (IERR.EQ.0) CALL EOFCHA (NLABEL,
     +                                        FNAME1, LABELS,
     +                                        ADDLAB)
                  ADDLAB = .NOT.ADDLAB
                  IF (ADDLAB) THEN
C
C Build up the column labels from labels(nrow + i) using a dummy cell(1,1) = R/C
C                    
                     KSTART = 1
                     KSTOP = 3
                     STRNG(KSTART:KSTOP) = 'R/C'
                     DO I = 1, NCOLS
                        KSTOP = KSTOP + 1
                        STRNG(KSTOP:KSTOP) = BLANK
                        WORD20 = LABELS(NROWS + I)
                        CALL TRIML1(WORD20)
                        J = LEN200(WORD20)
                        K = INDEX(WORD20(1:J),BLANK)
                        DO WHILE (K.GT.0)
                           WORD20(K:K) = USCORE
                           K = INDEX(WORD20(1:J),BLANK)
                        ENDDO   
                        KSTART = KSTOP + 1
                        KSTOP = KSTOP + J
                        STRNG(KSTART:KSTOP) = WORD20(1:J)
                     ENDDO  
                  ENDIF     
               ENDIF     
               YESNO = .TRUE.
C               ICOLOR = 1
C               CALL YESNO2 (ICOLOR, IXL, IYL,
C     + 'This maybe a Simfit data file ... Delete header and trailer',
C     +                      YESNO)
C               CALL PUTADV (
C     +'The header and trailer have been deleted from this file')               
               OPEN (UNIT = NIN, FILE = FNAME1)
               IF (YESNO) THEN 
                  READ (NIN,100,IOSTAT=IOS) LINE
                  READ (NIN,100,IOSTAT=IOS) LINE
                  IF (ADDLAB) THEN
                     NLINES = NLINES + 1
                     MATRIX(NLINES) = STRNG
                     DO I = 1, NROWS
                        WORD20 = LABELS(I)
                        CALL TRIML1(WORD20)
                        J = LEN200(WORD20)
                        K = INDEX(WORD20(1:J),BLANK)
                        DO WHILE (K.GT.0)
                           WORD20(K:K) = USCORE
                           K = INDEX(WORD20(1:J),BLANK)
                        ENDDO                           
                        READ (NIN,100,IOSTAT=IOS) STRNG
                        IF (IOS.EQ.0) THEN
                           NLINES = NLINES + 1 
                           MATRIX(NLINES) = WORD20(1:J)//BLANK//STRNG 
                        ENDIF   
                     ENDDO  
                     NCOLS = NCOLS + 1
                  ELSE  
                     DO I = 1, NROWS 
                        READ (NIN,100,IOSTAT=IOS) STRNG
                        IF (IOS.EQ.0) THEN
                           NLINES = NLINES + 1
                           MATRIX(NLINES) = STRNG
                        ENDIF   
                     ENDDO
                  ENDIF
               ELSE
                  IOS = 0
                  NLINES = 0
                  DO WHILE (IOS.EQ.0)
                     IF (ADDLAB) THEN
                        NLINES = NLINES + 1
                        MATRIX(NLINES) = STRNG
                        DO I = 1, NROWS
                           WORD20 = LABELS(I)
                           K = INDEX(WORD20(1:J),BLANK)
                           DO WHILE (K.GT.0)
                              WORD20(K:K) = USCORE
                              K = INDEX(WORD20(1:J),BLANK)
                           ENDDO                              
                           CALL TRIML1(WORD20)
                           J = LEN200(WORD20)
                           READ (NIN,100,IOSTAT=IOS) STRNG
                           IF (IOS.EQ.0) THEN
                              NLINES = NLINES + 1
                              MATRIX(NLINES) = WORD20(1:J)//BLANK//STRNG 
                           ENDIF     
                        ENDDO  
                        NCOLS = NCOLS + 1
                        NROWS = NLINES
                     ELSE   
                        READ (NIN,100,IOSTAT = IOS) STRNG
                        IF (IOS.EQ.0) THEN
                           NLINES = NLINES + 1
                           MATRIX(NLINES) = STRNG
                        ENDIF
                     ENDIF      
                  ENDDO 
               ENDIF
C
C Use the MAKSIM_COMMAS pre-processor to make sure the matrix can be analysed by MAKSIM_PACKIT
C               
               ABORT = .TRUE.
               IADD1 = 0
               ICOUNT = 0
               NBLANK = 0
               NPAD = 0
               DO I = 1, NLINES
                  STRNG = MATRIX(I)
                  IF (STRNG.EQ.BLANK) THEN
                     NBLANK = NBLANK + 1
                  ELSE
                     CALL MAKSIM_COMMAS (IADD1, NPAD,
     +                                   STRNG)
                     IF (STRNG.EQ.BLANK) THEN
                        NBLANK = NBLANK + 1
                     ELSE
                        ICOUNT = ICOUNT + 1
                        MATRIX(ICOUNT) = STRNG
                        NFIELD(ICOUNT) = MAKSIM_NITEMS(STRNG)
                     ENDIF
                  ENDIF   
               ENDDO 
               NROWS = ICOUNT                                                 
               DEALLOCATE(LABELS, STAT = IERR)     
            ELSE
C
C Simfit file but too large
C              
               CLOSE (UNIT = NIN)
               CALL PUTADV ('File too large to analyse')
               ABORT = .TRUE.
               RETURN
            ENDIF
C
C--------------------------------------------------
C End of analysis for satisfactory Simfit data file
C--------------------------------------------------
C            
         ELSE           
C
C All other file types ... Try XML (writes out a standard table if OK) 
C           
            CALL XML000 (NIN, NLINES, NRMAX,
     +                   FNAME1, MATRIX, STRNG) 
            IF (NLINES.LT.1) THEN
C
C All other file types ... Try HTML (writes out a standard table if OK)
C              
               CALL HTML00 (NIN, NLINES, NRMAX,
     +                      FNAME1, MATRIX, STRNG)                
            ENDIF
            IF (NLINES.GT.1) THEN 
C
C OK so must be XML or HTML
C              
                
               ABORT = .TRUE.
               IADD1 = 0
               ICOUNT = 0
               DO I = 1, NLINES
                  STRNG = MATRIX(I)
                  IF (STRNG.EQ.BLANK) THEN
                     IF (I.LT.NLINES) NBLANK = NBLANK + 1
                  ELSE
                     CALL MAKSIM_COMMAS (IADD1, NPAD,
     +                                   STRNG)
                     IF (STRNG.EQ.BLANK) THEN
                        IF (I.LT.NLINES) NBLANK = NBLANK + 1
                     ELSE
                        ICOUNT = ICOUNT + 1
                        MATRIX(ICOUNT) = STRNG
                        NFIELD(ICOUNT) = MAKSIM_NITEMS(STRNG)
                     ENDIF
                  ENDIF   
               ENDDO                     
            ELSE  
C
C Not XML or HTML so try comma/tab/space/semicolon text files
C              
               
               OPEN (UNIT = NIN, FILE = FNAME1) 
               CALL READ_TABS (NIN)
               ABORT = .TRUE.
               ICOUNT = 0
               DO I = 1, NRMAX
                  READ (NIN,100,IOSTAT=IOS) STRNG
                  IF (IOS.EQ.0) THEN
                     IF (STRNG.NE.BLANK) THEN
                        ICOUNT = ICOUNT + 1
                        MATRIX(ICOUNT) = STRNG
                     ENDIF   
                  ELSE
                     EXIT
                  ENDIF      
               ENDDO 
               CLOSE (UNIT = NIN)  
C
C Remove any trailng blank lines
C      
               NLINES = ICOUNT
               DO I = NLINES, 1, -1
                  IF (MATRIX(I).EQ.BLANK) THEN
                     ICOUNT = ICOUNT - 1
                  ELSE
                     EXIT
                  ENDIF      
               ENDDO  
             
               NLINES = ICOUNT   
               IADD1 = 0
               ICOUNT = 0
               DO I = 1, NLINES
                  STRNG = MATRIX(I)
                  IF (STRNG.EQ.BLANK) THEN
                     IF (I.LT.NLINES) NBLANK = NBLANK + 1
                  ELSE
                     CALL MAKSIM_COMMAS (IADD1, NPAD,
     +                                   STRNG)
                     IF (STRNG.EQ.BLANK) THEN
                        IF (I.LT.NLINES) NBLANK = NBLANK + 1
                     ELSE
                        ICOUNT = ICOUNT + 1
                        MATRIX(ICOUNT) = STRNG
                        NFIELD(ICOUNT) = MAKSIM_NITEMS(STRNG)
                     ENDIF
                  ENDIF
               ENDDO   
            ENDIF
         ENDIF   
      ENDIF
      
      CLOSE (UNIT = NIN)

C
C Check things so far
C
      IF (ICOUNT.LE.0) THEN
         CALL PUTADV ('The data set supplied is empty')
         ABORT = .TRUE.
         RETURN
      ENDIF
      IF (NPAD.GT.0) THEN
         WRITE (LINE,'(I6,2X,A)') NPAD,
     +'Empty cells in this data set have been padded out with X'
         CALL PUTWAR (LINE)
      ENDIF
      IF (NBLANK.GT.0) THEN
         WRITE (LINE,'(I6,2X,A)') NBLANK,
     +'Blank rows have been deleted from this data set'
         CALL PUTWAR (LINE)
      ENDIF
      IF (IADD1.GT.0) THEN
         WRITE (LINE,'(I6,2X,A)') IADD1,
     +'substitutions (? for % or + for &) have been made in this file'
         CALL PUTWAR (LINE)
      ENDIF
C
C Main branch point ... Check for clashes, adjust, then abort or proceed 
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
C
C***************************************************************************** 
C        
         J = 0
         JCOUNT = 0
         DO I = 1, ICOUNT
            CLASH(I) = .FALSE.
            IF (ROWIN(I)) THEN
               J = I
               JCOUNT = 1
               NFSAV = NFIELD(J)
               EXIT
            ENDIF
         ENDDO
         NWRONG = 0
         DO I = J + 1, ICOUNT
            CLASH(I) = .FALSE.
            IF (ROWIN(I)) THEN
               JCOUNT = JCOUNT + 1
               IF (NFIELD(I).NE.NFSAV) THEN
                  CLASH(I) = .TRUE.
                  NWRONG = NWRONG + 1
                  NFSAV = NFIELD(I)
               ENDIF
            ENDIF
         ENDDO

C         
C---------------------------------------------------------------
C Start of special action if SUPPLY = .TRUE. and  QUERY = .FALSE.
C         
         IF (SUPPLY .AND. .NOT.QUERY) THEN
            IF (NWRONG.EQ.0) THEN
C
C Save As ...
C              
               NCOLS = 1
               NROWS = ICOUNT
               CALL MAKSIM_PARSE5 (NCOLS, NFIELD, NOUT, NROWS,
     +                             FNAME2, MATRIX,
     +                             COLIN, QUERY, ROWIN, USE_ALL)
               IF (SUPPLY .AND. FNAME2.NE.BLANK) THEN
                  CALL ISITMF (NCOLS, NROWS,
     +                         FNAME2)
                  IF (NCOLS.GT.0 .AND. NROWS.GT.0) THEN
                     ABORT = .FALSE.
                  ELSE
                     NCOLS = 0
                     NROWS = 0
                     FNAME2 = BLANK
                     ABORT = .TRUE.
                  ENDIF      
               ENDIF
            ELSE
               NCOLS = 0
               NROWS = 0
               CALL PUTADV (
     +'Cannot transform this file into a Simfit data file')
               ABORT = .TRUE.
               FNAME2 = BLANK
            ENDIF
            RETURN
         ENDIF  
C         
C End of special action if SUPPLY = .TRUE. and  QUERY = .FALSE.
C--------------------------------------------------------------
C
         
         IF (NWRONG.EQ.0) THEN
C
C All rows have the same number of columns
C           
            NUMDEC = 1
            ICOLOR = 1
            READY = .TRUE.
            I12(1) = FORM12(ICOUNT)
            I12(2) = FORM12(JCOUNT)
            I12(3) = FORM12(NWRONG)
            WRITE (TEXT,200) TRIM(I12(1)), TRIM(I12(2)), I12(3), CIPHER
            DO I = 1, 10
               NUMBLD(I) = 1
            ENDDO
            DO I = 11, 12
               NUMBLD(I) = 0
            ENDDO
            NUMOPT = 5
         ELSE
C
C There are clashes
C           
            NUMDEC = 1
            ICOLOR = 9
            READY = .FALSE.
            I12(1) = FORM12(ICOUNT)
            I12(2) = FORM12(JCOUNT)
            I12(3) = FORM12(NWRONG)
            WRITE (TEXT,300) TRIM(I12(1)), TRIM(I12(2)), I12(3)
            DO I = 1, 10
               NUMBLD(I) = 0
            ENDDO
            DO I = 11, 12
               NUMBLD(I) = 1
            ENDDO
            NUMOPT = 6
         ENDIF
         NTEXT = NSTART + NUMOPT - 1
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                NUMOPT, NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         IF (READY) THEN
            IF (NUMDEC.GT.2) NUMDEC = NUMDEC + 2
         ELSE
            IF (NUMDEC.GT.4) NUMDEC = NUMDEC + 1     
         ENDIF   
         IF (NUMDEC.EQ.1) THEN
C
C NUMDEC = 1: Save As directly or table of clashes
C ===========
C              
            IF (READY) THEN
C
C Save As ...
C              
               NCOLS = 1
               NROWS = ICOUNT
               CALL MAKSIM_PARSE5 (NCOLS, NFIELD, NOUT, NROWS,
     +                             FNAME2, MATRIX,
     +                             COLIN, QUERY, ROWIN, USE_ALL)
               IF (SUPPLY .AND. FNAME2.NE.BLANK) THEN
                  CALL ISITMF (NCOLS, NROWS,
     +                         FNAME2)
                  IF (NCOLS.GT.0 .AND. NROWS.GT.0) THEN
                     ABORT = .FALSE.
                     RETURN
                  ENDIF   
               ENDIF  
            ELSE                      
C
C Table
C
               IF (ICOUNT.GT.KPRINT) THEN
                  I = 1
                  KSTART = 1
                  CALL GETJM1 (I, KSTART, ICOUNT,
     +' Line number to start table')
C***********I = KSTART
c***********CALL GETIM1 (I, KSTOP, ICOUNT, ' Line no. to stop table')
                  KSTOP = ICOUNT
               ELSE
                  KSTART = 1
                  KSTOP = ICOUNT
               ENDIF
               JCOLOR = 15
               CALL TABLE1 (JCOLOR, 'OPEN')
               DO I = KSTART, KSTOP
                  WRITE (WORD4,'(I4)') NFIELD(I)
                  WRITE (WORD6,'(I6)') I
                  CALL TRIML1 (WORD4)
                  CALL TRIML1 (WORD6)
                  IF (ROWIN(I)) THEN
                     IF (CLASH(I)) THEN
                        JCOLOR = 1
                        WRITE (LINE,400) WORD6, WORD4, MATRIX(I)(1:75)
                     ELSE
                        JCOLOR = 0
                        WRITE (LINE,500) WORD6, WORD4, MATRIX(I)(1:75)
                     ENDIF
                     CALL TABLE1 (JCOLOR, LINE)
                  ELSE
                     JCOLOR = 4
                     WRITE (LINE,600) WORD6, WORD4, MATRIX(I)(1:75)
                     CALL TABLE1 (JCOLOR, LINE)
                  ENDIF
               ENDDO
               CALL TABLE1 (JCOLOR, 'CLOSE')
            ENDIF
         ELSEIF (NUMDEC.EQ.2) THEN
C
C NUMDEC = 2: Scrolling display
C ===========
C
            CALL MAKSIM_VIEW03 (NRMAX, ICOUNT,
     +                          MATRIX)
         ELSEIF (NUMDEC.EQ.3) THEN
C
C NUMDEC = 3: Delete a row
C ===========
C
            I = 0
            J = 0
            CALL GETJM1 (I, J, ICOUNT,
     +'Number of the row to be deleted (0 = no action)')
            IF (J.GT.0) ROWIN(J) = .FALSE.
         ELSEIF (NUMDEC.EQ.4) THEN
C
C NUMDEC = 4: Restore a row
C =========== 
C
            I = 0
            J = 0
            CALL GETJM1 (I, J, ICOUNT,
     +'Number of the row to be restored (0 = no action)')
            IF (J.GT.0) ROWIN(J) = .TRUE.
         ELSEIF (NUMDEC.EQ.5) THEN
C
C NUMDEC = 5: Proceed with editing if READY
C ===========
C
            IF (SUPPLY) THEN 
               CALL PUTADV ('Not available ... use program MAKSIM')
            ELSEIF (.NOT.READY) THEN
               CALL PUTADV ('Not yet ready ... Remove current clashes')
            ELSE
               NCOLS = 0
               NROWS = 0
               DO I = 1, ICOUNT
                  IF (ROWIN(I)) THEN
                     NCOLS = NFIELD(I)
                     NROWS = NROWS + 1
                     MATRIX(NROWS) = MATRIX(I)
                     ROWIN(NROWS) = .TRUE.
                  ENDIF
               ENDDO
               IF (NROWS.EQ.0 .OR. NCOLS.EQ.0) THEN
                  CALL PUTADV ('The current matrix is empty')
                  ABORT = .TRUE.
                  READY = .FALSE.
                  RETURN
               ENDIF
               IF (NROWS.LT.ICOUNT) THEN
                  WRITE (LINE,700) ICOUNT - NROWS
                  CALL PUTADV (LINE)
               ENDIF
               ABORT = .FALSE.
               RETURN
            ENDIF
         ELSEIF (NUMDEC.EQ.6) THEN
C
C NUMDEC = 6: Help
C ===========
C
            WRITE (TEXT,1000)
            NTEXT = 20
            NUMBLD(1) = 1
            DO I = 2, NTEXT
               NUMBLD(I) = 0
            ENDDO   
            CALL PATCH2 (NUMBLD, NTEXT,
     +                   TEXT)
            NUMBLD(1) = 0  
         ELSE
C
C NUMDEC = 7: Abort current matrix
C ===========
C
            REPEET = .FALSE. 
            IF (READY) THEN
               ABORT = .FALSE.
               ICOLOR = 1
               CALL YESNO2 (ICOLOR, IXL, IYL,
     + 'The matrix is ready ... Do you really want to quit ?',
     +                      ABORT)
               IF (ABORT) THEN
                  RETURN
               ELSE
                  REPEET = .TRUE.
               ENDIF
            ELSE
               ABORT = .TRUE.
               RETURN
            ENDIF   
         ENDIF

      ENDDO
C
C Format statements
C      
  100 FORMAT (A)
  200 FORMAT (
     + 'Data are ready to Edit or possibly Save As ... a Simfit file.'
     +/
     +/'Every row has the same number of columns so, if there are no'
     +/'interior missing values and any labels are confined to row 1'
     +/'and column 1, you can now Save As ... a Simfit type data file.'
     +/'In general use, Simfit will then proceed to analyse these data'
     +/'but, when using program MAKSIM, you can choose to employ extra'
     +/'editing to only select rows and columns with special features,'
     +/'e.g. males between 30 and 60, or times > 1 week, etc.'
     +/
     +/'Number of rows =',1X,A,' (Number included =',1X,A,')'
     +/'Number of clashes =',1X,A
     +/
     +/'Attempt to Save As ... a Simfit file'
     +/'View the current data table'
     +/'Edit',1X,A
     +/'Help'
     +/'Quit ... Exit current data set')
  300 FORMAT (
     + 'The matrix is not yet ready for further treatment.'
     +/
     +/'Not all rows have got the same number of items. It may be'
     +/'that the file has a header (title, etc.) or a tail (with more'
     +/'detail) that needs to be removed. Maybe you have got an empty'
     +/'column entry that is not filled in (e.g. by an X to indicate'
     +/'a missing value). You cannot proceed further until all of the'
     +/'rows (i.e., cases) in your matrix have got the same number of'
     +/'columns (i.e., variables).'
     +/
     +/'Number of rows =',1X,A,' (Number included =',1X,A,')'
     +/'Number of clashes =',1X,A
     +/
     +/'View table of clashes or suppressed rows'
     +/'View the current data table'
     +/'Delete a row'
     +/'Restore a row'
     +/'Help'
     +/'Quit  ...  Exit current data set')
  400 FORMAT (A6,'|',A4,'clash|',A75,'...')
  500 FORMAT (A6,'|',A4,'   in|',A75,'...')
  600 FORMAT (A6,'|',A4,'  out|',A75,'...')
  700 FORMAT ('Number of deleted rows =',I3,' ... Rows re-numbered')
 1000 FORMAT (
     + 'Transforming rectangular data tables into Simfit data files'
     +/
     +/'The data table can be created with a text editor or be exported'
     +/'from a spreadsheet in comma, tab, space, or semicolon delimited'  
     +/'ASCII text, XML or HTML format.'
     +/
     +/'However, to transform data tables into Simfit data file format,'
     +/'the following rules must be strictly observed.'
     +/
     +/'1)`XML files must have extension .xml'
     +/'2)`HTML files must have extension .htm, .html, .mht, or .mhtml'  
     +/'3)`Every row must have exactly the same number of columns'
     +/'4)`There must be no missing values'
     +/'5)`If there are any labels, then column labels for variables'
     +/'  `must be in the top row, while row labels for cases must be'
     +/'  `in the first column, with a dummy label in cell(1,1)'
     +/'6)`In space delimited files, labels must have no interior'
     +/'  `spaces, e.g. use [TV_set] instead of [TV Set]'
     +/'7)`Numbers can be integers (e.g. 30), floating point style'
     +/'  `(e.g. 30.0), or in exponential notation (e.g. 3.0E+01)')    
      END
C
C
