C
C Subroutine PACKIT moved from MAKSIM for general use
C
      SUBROUTINE MAKSIM_PACKIT (NCOLS, NFIELD, NRMAX, NROWS,
     +                          MATRIX, STRNG)
C
C ACTION : Pack the matrix
C          23/11/1997 replaced LEN200, TRIML1, TRIMR1 by LENG, TRIM@, TRIMR@
C                     as there seemed to be a problem calling my own indirect functions
C                     This is almost certainly a ftn95 problem and my own indirect
C                     calls will probably work OK when ftn95 has stabilised
C          15/04/2008 restored my procedures as the problem was LEN200(STRNG) 
C                     being used as a loop counter which was fixed 
C                     This routine is hopelessly overcomplicated and must be
C                     rewritten as soon as possible, then moved to w_menus.dll
C                     as a general purposes packing routine. 
C          28/07/2008 moved to w_menus.dll but not revised because it is still
C                     called with a variety of possible parsing schemes. I should
C                     firm up on just one scheme eventually which would greatly
C                     simplify and speed up the code.
C          03/08/2022 repaired a long-standing error (line 118) and checked  
C
C Note: this routine is over complicated because it has to be able to work with
C       a variety of possible schemes for parsing between different delimiters 
C       The input matrix must have exactly NCOLS rows and NROWS rows and all
C       labels must be free from internal blanks and have quotes stripped off. 
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NCOLS, NRMAX, NROWS
      INTEGER,             INTENT (INOUT) :: NFIELD(NCOLS)
      CHARACTER (LEN = *), INTENT (INOUT) :: MATRIX(NRMAX), STRNG
C
C Locals
C      
      INTEGER    I, J, K, L, L200, M, N
      INTEGER    LEN200
      INTEGER    KMAX
      PARAMETER (KMAX = 20)
      CHARACTER  LETTER*1
      CHARACTER  BLANK*1, COMMA*1, COMMA2*2
      PARAMETER (BLANK = ' ', COMMA = ',', COMMA2 = ',,')
      EXTERNAL   TRIML1, LEN200, TRIMR1
      INTRINSIC  INDEX
C
C============================================================================================
C LOOP 1: Remove commas, replace by spaces, replace, strip multiple commas, trucate if > NMAX
C============================================================================================
C
      DO I = 1, NROWS
C
C Copy MATRIX(i) into STRNG then set MATRIX(I) = BLANK
C        
         STRNG = MATRIX(I)
         MATRIX(I) = BLANK
C
C Now remove all trailing multiple commas a,b,c,,, to a,b,c
C
         L200 = LEN200(STRNG) 
         DO J = L200, 1, - 1
            IF (STRNG(J:J).EQ.COMMA) THEN
               STRNG(J:J) = BLANK
            ELSE
               EXIT
            ENDIF
         ENDDO
C
C Replace all leading multiple commas ,,,a,b,c to a,b,c
C
          DO J = 1, L200
            IF (STRNG(J:J).EQ.COMMA) THEN
               STRNG(J:J) = BLANK
            ELSE
               EXIT
            ENDIF
         ENDDO
         CALL TRIML1 (STRNG)
C
C Go through the string and replace all internal blanks by commas
C
         L200 = LEN200(STRNG)
         DO J = 1, L200
            IF (STRNG(J:J).EQ.BLANK) STRNG(J:J) = COMMA
         ENDDO
C
C Strip out multiple commas 
C
         L = INDEX(STRNG,COMMA2)
         DO WHILE (L.GT.0)
            DO J = L, L200 - 1
               STRNG(J:J) = STRNG(J + 1:J + 1)
            ENDDO   
            STRNG(L200:L200) = BLANK
            L200 = L200 - 1
            L = INDEX(STRNG,COMMA2)!03/08/2022 ERROR repaired: replaced COMMA by COMMA2 
         ENDDO
         
C
C Re-write MATRIX(I) but truncating labels if > KMAX
C 

         K = 0
         L  = 0
         DO J = 1, L200
            LETTER = STRNG(J:J)
            IF (LETTER.EQ.COMMA) THEN
               K = 0
               L = L + 1
               MATRIX(I)(L:L) = LETTER
            ELSEIF (LETTER.NE.BLANK) THEN
               K = K + 1
               IF (K.LE.KMAX) THEN
                  L = L + 1
                  MATRIX(I)(L:L) = LETTER
               ENDIF
            ENDIF         
         ENDDO
         L = L + 1
         MATRIX(I)(L:L) = COMMA
      ENDDO   
C
C============================================================================================
C LOOP 2: define NFIELD
C         At this stage the items are separated by commas with no blanks
C         but an extra COMMA has been added to the end
C============================================================================================
C
      DO I = 1, NCOLS
         NFIELD(I) = 0
      ENDDO
      DO I = 1, NROWS
         K = 0
         L = 0
         L200 = LEN200(MATRIX(I))
         DO J = 1, L200
            IF (MATRIX(I)(J:J).NE.COMMA) THEN
               K = K + 1
            ELSE
               L = L + 1
               IF (K.GT.NFIELD(L)) NFIELD(L) = K    
               K = 0
            ENDIF
         ENDDO
         MATRIX(I)(L200:L200) = BLANK
      ENDDO
C
C============================================================================================
C LOOP 3:  Now NFIELD are the maximum field widths and the final COMMAS are removed
C          so the string must be packed out to constant field width
C============================================================================================
C
      DO I = 1, NROWS
         STRNG = MATRIX(I)
         MATRIX(I) = BLANK
         K = 0
         L = 0
         M = 0
         L200 = LEN200(STRNG) 
         DO J = 1, L200
            IF (STRNG(J:J).NE.COMMA) THEN
               K = K + 1
               L = L + 1
               MATRIX(I)(K:K) = STRNG(J:J)
            ELSE
               M = M + 1
               IF (L.LT.NFIELD(M)) THEN
                  DO N = 1, NFIELD(M) - L
                     K = K + 1
                     MATRIX(I)(K:K) = BLANK
                  ENDDO
               ENDIF
               K = K + 1
               MATRIX(I)(K:K) = BLANK
               L = 0
            ENDIF
         ENDDO
      ENDDO
C
C============================================================================================
C LOOP 4: Code added 22/11/97 to right justify
C============================================================================================
C
      DO I = 1, NROWS
         K = 1
         L = NFIELD(1)
         IF (L.GT.1) CALL TRIMR1 (MATRIX(I)(K:L))
         DO J = 2, NCOLS
            K = L + 2
            L = K + NFIELD(J) - 1
            IF (L.GT.K) CALL TRIMR1 (MATRIX(I)(K:L))
         ENDDO
      ENDDO
C
C Now all columns are right justified
C
      END
C
C
