c
c Subroutine use_parse5 from MAKSIM renamed maksim_parse5
c
      subroutine maksim_parse5 (ncol, nfield, nout, nrow,
     +                          fname, matrix, 
     +                          colin, query, rowin, use_all)
c
c            if query = .true. user provides filename and title and is informed
c            if query = .false. file creation is silent 
c            if use_all = .true. then use colin, nfield, and rowin
c            if use_all = .false. then only use rowin
c 28/07/2008 version of use_parse5 from MAKSIM edited and moved to w_menus.dll for general use
c 04/08/2022 changed method from 3 to 1
c            
c     
      implicit none                                           
c
c arguments
c
      integer,             intent (in)    :: ncol, nout, nrow
      integer,             intent (in)    :: nfield(ncol)
      character (len = *), intent (in)    :: matrix(nrow)
      character (len = *), intent (inout) :: fname
      logical,             intent (in)    :: colin(ncol), query, 
     +                                       rowin (nrow),
     +                                       use_all     
c
c locals
c      
      integer    icount
      integer    i, i1, i2, j, j1, j2, k, numcin, numrin
      integer    last_col, len200
      integer    isend, method, nmax
      parameter (isend = 2, method = 1, nmax = 100000)
      character  buffer1*(nmax), word2*2, word12*12, title*80
      character  buffer2*(nmax), sim256*1024
      character  blank*1
      parameter (blank = ' ')
      logical    abort, askif, there
      parameter (askif = .false.)
      external   parse5, ofiles, len200, infofl, putadv, deleet,
     +           parse8, getstr, sim256
      intrinsic  char
      save       icount
      data       icount / 0 /
      
      if (use_all) then
         numcin = 0
         numrin = 0
         do i = 1, ncol
            if (colin(i)) then
               last_col = i
               numcin = numcin + 1
            endif
         enddo
         if (numcin.gt.0) then
            do i = 1, nrow
               if (rowin(i)) then
                  numrin = numrin + 1
                  exit
               endif
            enddo
         endif
      else
         numcin = ncol
         numrin = nrow
      endif      
      
      if (numcin.gt.0 .and. numrin.gt.0) then
         
         buffer1 = blank
         buffer2 = blank
         word2 = char(13)//char(10)
         if (use_all) then
c
c use colin, rowin, and nfield to build up the buffer
c           
            j1 = 1
            j2 = 0
            do i = 1, nrow
               if (rowin(i)) then
                  i1 = 1
                  i2 = 0
                  k = j1
                  do j = 1, ncol
                     i2 = i2 + nfield(j) + 1
                     if (colin(j)) then
                        j2 = j2 + nfield(j) + 1
                        buffer1(j1:j2) = matrix(i)(i1:i2)
                        buffer2(j1:j2) = matrix(i)(i1:i2)
                        if (j.eq.last_col) then
                           j1 = j2 + 1
                           j2 = j1 + 1
                           buffer1(j1:j2) = word2
                           buffer2(j1:j2) = word2
                        else
                           j2 = j2 + 1
                           buffer1(j2:j2) = char(9)    
                           buffer2(j2:j2) = char(9)    
                        endif
                        j1 = j2 + 1  
                     endif
                     i1 = i2 + 1
                   enddo
               endif   
            enddo
         else
c
c just use rowin to build up the buffer
c           
            i1 = 1
            i2 = 0
            do i = 1, nrow
               if (rowin(i)) then 
                  k = len200(matrix(i))
                  i2 = i2 + k
                  buffer1(i1:i2) = matrix(i)(1:k)
                  buffer2(i1:i2) = matrix(i)(1:k)
                  j1 = i2 + 1
                  j2 = j1 + 1
                  buffer1(j1:j2) = word2
                  buffer2(j1:j2) = word2
                  i1 = j2 + 1
                  I2 = j2 
               endif   
            enddo   
         endif     

         call parse8 (buffer1,
     +                abort)
         if (abort) then
           
            call putadv ('Data are not ready to write to a Simfit file')

         else  
         
            if (query) then
               CLOSE (UNIT = NOUT)
               I = 1
               CALL OFILES (I, NOUT,
     +                      FNAME,
     +                      ABORT)
               IF (ABORT) THEN
                  FNAME = BLANK
                  CLOSE (UNIT = NOUT)
                  RETURN
               ENDIF

               title = 'Simfit data file'
               call getstr ('Title for this data file', title) 
            else
                icount = icount + 1
                if (icount.lt.10) then
                   write (word12,100) icount
                elseif (icount.lt.100) then   
                   write (word12,200) icount
                else   
                   write (word12,300) icount
                endif  
                fname = sim256(word12)
                title = 'Simfit temporary data file: '//word12
            endif  
           
            close (unit = nout)

            call parse5 (method, 
     +                   buffer2, fname, title,
     +                   abort)
     
            close (unit = nout)
     
            if (abort) then
               call putadv ('No file has been created')
               call deleet (fname,
     +                      askif, there)           
               fname = blank 
            elseif (query) then
               call infofl (isend,
     +                      fname)           
            endif
         endif   
      endif
  100 format ('f$dat00',i1,'.tmp')      
  200 format ('f$dat0',i2,'.tmp')      
  300 format ('f$dat',i3,'.tmp')      
      end
c
c
