C
C
      SUBROUTINE MAT2IN (NIN, NCMAX, NCOL, NRMAX, NROW,
     +                   X,
     +                   FNAME, TITLE,
     +                   ABORT)
C
C ACTION: Read X from a matrix file
C AUTHOR: W. G. Bardsley, University of Manchester
C         27/01/2006 derived from VEC2IN
C         05/06/2006 minor editing
C         16/06/2006 allowed vectors as well as matrices
C         26/02/2007 added INTENTS
C         30/03/2007 allowed NCMAX = 1, i.e. vectors as well as matrices 
C
C            NIN: (input/unchanged) unconnected unit for data input
C          NCMAX: (input/unchanged) maximum column dimension for X
C           NCOL: (input/output) actual no. of columns
C          NRMAX: (input/unchanged) maximum row dimension for X
C           NROW: (input/output) actual no. of rows
C              X: (input/output) data matrix
C          FNAME: (input/output) filename
C          TITLE: (input/output) data title
C          ABORT: (output) error indicator
C
C Usually the file and data have been already checked but on error exit
C redefinition will happen. 
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NIN, NCMAX, NRMAX  
      INTEGER,             INTENT (INOUT) :: NCOL, NROW
      DOUBLE PRECISION,    INTENT (INOUT) :: X(NRMAX,NCMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME, TITLE  
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Locals
C
      INTEGER    N0, N1, N2, N4
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N4 = 4)
      INTEGER    I, ICOUNT, J, IOS
      EXTERNAL   CHKFIL, OFILES
C
C Initialise then check
C
      ABORT = .TRUE.  
      CLOSE (UNIT = NIN)
      IF (NRMAX.LT.N1 .OR. NCMAX.LT.N1) RETURN
C
C Read in the data from a file
C
      CALL OFILES (N4, NIN,
     +             FNAME,
     +             ABORT)
      IF (ABORT) THEN
         CLOSE (UNIT = NIN) 
         NCOL = N0
         NROW = N0 
         FNAME = 'No file'
         TITLE = 'No data'
         RETURN
      ENDIF
      ABORT = .TRUE.
      NCOL = - N1
      NROW = - N1
      ICOUNT = N1
      READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLE
      IF (IOS.NE.N0) GOTO 20
      ICOUNT = N2
      READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) I, J
      IF (IOS.NE.N0) GOTO 20
      NROW = I
      NCOL = J
      IF (NROW.LT.N1 .OR. NROW.GT.NRMAX) GOTO 20
      IF (NCOL.LT.N1 .OR. NCOL.GT.NCMAX) GOTO 20
      DO I = N1, NROW
         ICOUNT = ICOUNT + N1
         READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) (X(I,J), J = N1, NCOL)
         IF (IOS.NE.N0) GOTO 20
      ENDDO
      CLOSE (UNIT = NIN)
      ABORT = .FALSE.
      RETURN
C
C Label 20: Here only if a crash has occurred
C =========
C
   20 CONTINUE
      ABORT = .TRUE.
      CLOSE (UNIT = NIN)
      CALL CHKFIL (ICOUNT, IOS, N1, NCOL, NCMAX, N1, NROW, NRMAX,
     +             FNAME, TITLE)
      NCOL = N0
      NROW = N0 
      FNAME = 'No file'
      TITLE = 'No data'
      END
C
C
