C
C
      SUBROUTINE MAT3IN (ISEND, NCOL, NIN, NROW,
     +                   FNAME, TITLE,
     +                   ABORT, FIXCOL, FIXROW, LABEL)
C
C ACTION : Input data points X(i,j) from console or file
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          27/01/2006 derived from VEC3IN
C          06/02/2006 altered order in argument list 
C          06/06/2007 corrected error in FORMAT 100 and FORMAT 1100
C          17/07/2007 added SIM256 and YMDHMS for version 6
C          19/04/2008 increased output format to E15.7
C          01/08/2008 introduced call to ISITSF
C          11/05/2010 introduced NKLCFG to switch on/off the TYPE-IN-DATA option 
C          19/04/2011 edited main menu
C          04/04/2015 replaced PUTADV by INFOFL
C          01/09/2015 made ISEND intent (in), added KSEND and call to SWITCH
C
C          ISEND: (input/output) as follows
C                 ISEND = 1: user inputs TITLE etc. and ISEND is unchanged
C                 ISEND = 2: TITLE etc. from file and ISEND is unchanged
C                 OTHERWISE: user chooses mode 
C           NCOL: (output) size of X as follows
C                  FIXCOL = .TRUE. then NCOL is unchanged
C                  FIXCOL = .FALSE. then NCOL is arbitrary
C            NIN: (input/unchanged) unconnected unit for data input
C                 Note: if an existing file is successfully opened, then NIN is
C                       returned connected for further reading. Otherwise NIN is
C                       closed on exit
C           NROW: (output) size of X as follows
C                  FIXROW = .TRUE. then NROW is unchanged
C                  FIXROW = .FALSE. then NROW is arbitrary
C          FNAME: (input/output) as follows
C                  ISEND = 1: file supplied by user (unchanged)
C                  OTHERWISE: temporary file name like matrix_k.tmp
C           TITLE: (output) as follows
C                  ISEND = 1: read off file
C                  OTHERWISE: returned depending on LABEL
C           ABORT: (output) error indicator
C          FIXCOL: (input/unchanged)
C                  FIXCOL = .TRUE. return exactly NCOL data points
C                  FIXCOL = .FALSE. then return arbitrary NCOL data points
C          FIXROW: (input/unchanged)
C                  FIXROW = .TRUE. return exactly NROW data points
C                  FIXROW = .FALSE. then return arbitrary NROW data points
C           LABEL: (input/unchanged) as follows if data are to be typed in
C                  LABEL = .TRUE. then the user supplies a title
C                  LABEL = .FALSE. a temporary title is supplied
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: ISEND, NIN 
      INTEGER,             INTENT (INOUT) :: NCOL, NROW
      CHARACTER (LEN = *), INTENT (OUT)   :: FNAME, TITLE
      LOGICAL,             INTENT (IN)    :: FIXCOL, FIXROW, LABEL 
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Local allocatable array
C
      DOUBLE PRECISION, ALLOCATABLE :: X(:,:)
C
C Locals
C
      INTEGER    N0, N1, N2, N3, N22, N34, NBIG, NCBIG, NCMAX, NRBIG,
     +           NRMAX
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N22 = 22, N34 = 34, 
     +           NBIG = 20, NCBIG = 100, NRBIG = 10000)
      INTEGER    NCBOT, NCMID, NCTOP, NRBOT, NRMID, NRTOP
      INTEGER    I, ICOUNT, IOS, J, KSEND, NTEMP
      INTEGER    KVAL10, NKLCFG
      INTEGER    ICOLOR, NUMDEC, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 7, NUMHDR = 23, NUMOPT = 3)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      INTEGER    JSEND
      PARAMETER (JSEND = 2)
      DOUBLE PRECISION BTEMP(1)
      CHARACTER (LEN = 1024) SIM256
      CHARACTER (LEN = 100 ) HEADER(NUMHDR), LINE
      CHARACTER (LEN = 20  ) OPTION(NUMOPT)
      CHARACTER (LEN = 30  ) NUM1
      CHARACTER (LEN = 15  ) WORD15
      CHARACTER (LEN = 8   ) NUM2
      CHARACTER (LEN = 30  ) NO_DATA, NO_FILE, NO_LIMIT
      PARAMETER (NO_DATA = 'No current data',
     +           NO_FILE = 'No current file',
     +           NO_LIMIT = 'No limit')
      LOGICAL    EXIST, READ_ONLY
      EXTERNAL   GETIM1, GETSTR, GETMAT, OFILES, TITLE2, TRIML1, CHKFIL,
     +           PUTFAT, MATVAL, INFOFL, ATTRIB, CHECKF, GETTMP, MATTIN,
     +           SIM256, YMDHMS, ISITSF, SWITCH
      EXTERNAL   NKLCFG
      DATA       NUMBLD / 1*4, 1*0, 1*2, 14*0, 4*1, 2*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION / 'File/Clipboard',
     +                    'Type-in-data',
     +                    'Suppress' /
C
C Initialise and check NIN
C
      KSEND = ISEND
      ABORT = .TRUE.
      FNAME = NO_FILE
      TITLE = NO_DATA
      IF (NIN.LT.N1) THEN
         WRITE (LINE,100) 'NIN < 1'
         CALL PUTFAT (LINE)
         RETURN
      ENDIF
C
C Deallocate X
C
      IOS = N0
      IF (ALLOCATED(X)) DEALLOCATE(X, STAT = IOS)
      IF (IOS.NE.N0) THEN
         WRITE (LINE,100) 'Cannot deallocate X'
         CALL PUTFAT (LINE)
         RETURN
      ENDIF
C
C If FIXCOL .OR. FIXROW call MATTIN directly
C
      IF (FIXCOL .OR. FIXROW) THEN
         IF (FIXCOL .AND. NCOL.LT.N1) THEN
            WRITE (LINE,100) 'NCOL < 1'
            CALL PUTFAT (LINE)
            RETURN
         ELSEIF (FIXROW .AND. NROW.LT.N1) THEN
            WRITE (LINE,100) 'NROW < 1'
            CALL PUTFAT (LINE)
            RETURN
         ELSE
            IF (FIXCOL) THEN
               NCMAX = NCOL
            ELSE
               NCMAX = NCBIG
            ENDIF
            IF (FIXROW) THEN
               NRMAX = NROW
            ELSE
               NRMAX = NRBIG
            ENDIF
            ALLOCATE(X(NRMAX,NCMAX), STAT = IOS)
            IF (IOS.NE.N0) THEN
               WRITE (LINE,100) 'Cannot allocate X'
               CALL PUTFAT (LINE)
               DEALLOCATE(X, STAT = IOS)
               RETURN
            ELSE
               CALL MATTIN (KSEND, NCMAX, NCOL, NIN, NRMAX, NROW,
     +                      X, BTEMP,
     +                      FNAME, TITLE,
     +                      ABORT, FIXCOL, FIXROW, LABEL)
               IF (ABORT) THEN
                  FNAME = NO_FILE
                  TITLE = NO_DATA
               ENDIF
               DEALLOCATE(X, STAT = IOS)
               RETURN
            ENDIF
         ENDIF
      ELSE
         NCBOT = N1
         NCTOP = NCBIG
         NRBOT = N1
         NRTOP = NRBIG
      ENDIF
C
C Special action if KSEND (i.e. ISEND) not 1 or 2
C
      IF (KSEND.LT.N1 .OR. KSEND.GT.N2) THEN
         KVAL10 = NKLCFG(N22)
         IF (KVAL10.EQ.N1) THEN
            WRITE (NUM1,'(A)') NO_LIMIT
            WRITE (NUM2,'(I8)') NBIG
            CALL TRIML1 (NUM1)
            CALL TRIML1 (NUM2)
            WRITE (HEADER,200) NUM1, NUM1, NUM2, NUM2
            NUMDEC = N1
            CALL TITLE2 (ICOLOR, NUMBLD, NUMDEC, NUMHDR, NUMOPT, NUMPOS,
     +                   HEADER,
     +                   OPTION)
         ELSE
            NUMDEC = N1
         ENDIF    
         IF (NUMDEC.EQ.N1) THEN
            KSEND = N2
         ELSEIF (NUMDEC.EQ.N2) THEN
            KSEND = N1
         ELSE
            KSEND = N2
            CALL SWITCH (N34)    
         ENDIF
      ENDIF
      IF (KSEND.EQ.N1) THEN
C
C Type in the data
C
         NCMAX = NBIG
         NRMAX = NBIG
         ALLOCATE(X(NRMAX,NCMAX), STAT = IOS)
         IF (IOS.NE.N0) THEN
            WRITE (LINE,100) 'Cannot allocate X'
            CALL PUTFAT (LINE)
            FNAME = NO_FILE
            TITLE = NO_DATA
            ABORT = .TRUE.
            DEALLOCATE(X, STAT = IOS)
            RETURN
         ENDIF
         WRITE (TITLE,300)
         IF (LABEL) THEN
            WRITE (LINE,400)
            CALL GETSTR (LINE, TITLE)
         ENDIF
         IF (.NOT.FIXROW) THEN
            WRITE (LINE,500)
            CALL GETIM1 (N1, NROW, NBIG,
     +                   LINE)
         ENDIF
         IF (.NOT.FIXCOL) THEN
            WRITE (LINE,600)
            CALL GETIM1 (N1, NCOL, NBIG,
     +                   LINE)
         ENDIF
         CALL GETMAT (NCOL, NRMAX, NROW,
     +                X,
     +                LINE)
C
C Create a temporary file
C
         CALL MATVAL (N1, NTEMP,
     +                ABORT)
         IF (ABORT) THEN
            CALL GETTMP (I,
     +                   FNAME)
         ELSE
            CALL MATVAL (N2, NTEMP,
     +                   ABORT)
            IF (ABORT) THEN
               CALL GETTMP (I,
     +                      FNAME)
            ELSE
               CLOSE (UNIT = NIN)
               IF (NTEMP.LT.10) THEN
                  WRITE (WORD15,700) NTEMP
               ELSEIF (NTEMP.LT.100) THEN
                  WRITE (WORD15,800) NTEMP
               ELSE
                  WRITE (WORD15,900) NTEMP
               ENDIF
               FNAME = SIM256(WORD15)
               CALL ATTRIB (FNAME,
     +                      EXIST, READ_ONLY)
               IF (EXIST .AND. READ_ONLY) THEN
                  WRITE (LINE,1000) WORD15
                  CALL PUTFAT (LINE)
                  CALL GETTMP (I,
     +                         FNAME)
               ENDIF
            ENDIF
         ENDIF
         OPEN (UNIT = NIN, FILE = FNAME)
         WRITE (NIN,'(A)',IOSTAT=IOS) TITLE
         WRITE (NIN,'(2I6)',IOSTAT=IOS) NROW, NCOL
         DO I = N1, NROW
            WRITE (NIN,1100,IOSTAT=IOS) (X(I,J), J = N1, NCOL)
         ENDDO
         WRITE (NIN,'(I6)',IOSTAT=IOS) N1
         CALL YMDHMS (LINE)
         WRITE (NIN,'(A)',IOSTAT=IOS) LINE
         CLOSE (UNIT = NIN)
         CALL INFOFL (JSEND,
     +                FNAME)        
         ABORT = .FALSE.
         DEALLOCATE(X, STAT = IOS)
         RETURN
      ELSE
C
C Read in the data from a file
C
         CLOSE (UNIT = NIN)
         CALL OFILES (N3, NIN,
     +                FNAME,
     +                ABORT)
         CLOSE (UNIT = NIN)
         IF (ABORT) THEN
            FNAME = NO_FILE
            TITLE = NO_DATA
            RETURN
         ENDIF
         CALL ISITSF (NCMID, NRMID,
     +                FNAME)
         IF (NCMID.GT.N0 .AND. NRMID.GT.N0) THEN
            OPEN (UNIT = NIN, FILE = FNAME)
         ELSE 
            ABORT = .TRUE.
            FNAME = NO_FILE
            TITLE = NO_DATA
            RETURN
         ENDIF   
         ABORT = .TRUE.
         NCMID = - N1
         NRMID = - N1
         ICOUNT = N1
         READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLE
         IF (IOS.NE.0) GOTO 20
         ICOUNT = N2
         READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) I, J
         IF (IOS.NE.0) GOTO 20
         NCMID = J
         NRMID = I
         NCMAX = NCMID
         NRMAX = NRMID
         IF (NRMID.LT.N1) GOTO 20
         IF (NCMID.LT.N1) GOTO 20
         IF (FIXCOL .AND. NCMID.NE.NCOL) GOTO 20
         IF (FIXROW .AND. NRMID.NE.NROW) GOTO 20
C
C Give user the choice view/accept/reject
C
         CLOSE (UNIT = NIN)
         CALL CHECKF (FNAME, TITLE,
     +                ABORT)
         IF (ABORT) THEN
            FNAME = NO_FILE
            TITLE = NO_DATA
            RETURN
         ELSE
            OPEN (UNIT = NIN, FILE = FNAME)
            READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLE
            READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) I, J
            IF (I.LT.N1 .OR. J.LT.N1) GOTO 20
         ENDIF
         ALLOCATE(X(I,J), STAT = IOS)
         IF (IOS.NE.N0) THEN
            WRITE (LINE,100) 'Cannot allocate X'
            FNAME = NO_FILE
            TITLE = NO_DATA
            ABORT = .TRUE.
            DEALLOCATE(X, STAT = IOS)
            RETURN
         ENDIF
         NROW = I
         NCOL = J
         DO I = N1, NROW
            ICOUNT = ICOUNT + N1
            READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) (X(I,J), J = N1, NCOL)
            IF (IOS.NE.0) GOTO 20
         ENDDO
         ABORT = .FALSE.
         DEALLOCATE(X, STAT = IOS)
         RETURN
      ENDIF
C
C Label 20: Here if a crash has occurred
C =========
C
   20 CONTINUE
      IF (ALLOCATED(X)) DEALLOCATE(X, STAT = IOS)
      ABORT = .TRUE.
      CLOSE (UNIT = NIN)
      CALL CHKFIL (ICOUNT, IOS, NCBOT, NCMID, NCTOP, NRBOT, NRMID,
     +             NRTOP,
     +             FNAME, TITLE)
      FNAME = NO_FILE
      TITLE = NO_DATA   
C
C Format statements
C      
  100 FORMAT (A,1X,'in call to MAT3IN')
  200 FORMAT (
     + 'Alternative methods for providing a table of data values'
     +/
     +/'To switch [Type-in data] on or off use [Configure]',
     +', [Advanced], [Speedup].'
     +/
     +/'1)`Simfit data files can be just a rectangular table of values'
     +/'  `but may have an optional title and a header with the number'
     +/'  `of rows (cases) and the number of columns (variables).'
     +/'  `Extra details can also be appended after the data.'
     +/'2)`Such files can be prepared/edited by Makmat/Editmt, or'
     +/'  `using any text editor, e.g. Notepad.'
     +/'3)`With small data sets, you can type in values now, when a'
     +/'  `temporary file called matrix_k.tmp (0 =< k =< 20) will'
     +/'  `be created for you to save or discard retrospectively.'
     +/'4)`Clipboard or spreadsheet data must have no missing values,'
     +/'  `but can include row and column labels if required.'
     +/'5)`You can also use macros, e.g. Excel with simfit6.xls.' 
     +/ 
     +/'Maximum number of rows input from file/clipboard =',1X,A
     +/'Maximum number of columns input from file/clipboard =',1X,A
     +/'Maximum number of rows typed in from the terminal =',1X,A
     +/'Maximum number of columns typed in from the terminal =',1X,A
     +/
     +/'[Suppress] switches off future options to [Type-in data] from',
     + ' the terminal.')            
  300 FORMAT ('Temporary data')
  400 FORMAT ('Title for this data set')
  500 FORMAT ('The number of data rows (cases) you require')
  600 FORMAT ('The number of data columns (variables) you require')
  700 FORMAT ('matrix_',I1,'.tmp')
  800 FORMAT ('matrix_',I2,'.tmp')
  900 FORMAT ('matrix_',I3,'.tmp')
 1000 FORMAT ('Read_only file encountered ... Use attrib -r',1X,A)
 1100 FORMAT (1P,50E15.7)
      END
C
C
