C
C
      SUBROUTINE MAT4IN (NCMAX, NCOL, NRMAX, NROW,
     +                   A,
     +                   FNAMEA, HEADER, TITLEA,
     +                   ABORT, NEWDAT)
C
C ACTION : Get a matrix
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          05/02/2006 derived from VEC4IN
C          14/02/2006 added FNAME to arguments and control
C          21/05/2006 deleted X, Y in calls to MATTRN 
C          26/02/2007 added INTENTS 
C          02/04/2007 allowed NCOL = 1, i.e. vectors
C          12/10/2007 removed allocatable and allowed temporary file creation
C          19/04/2008 increased output format to E15.7
C          10/07/2008 added FNAMEB, NWMAX, and call to CPYTRL to copy trailer
C          06/04/2010 trapped ncol < 1 or nrow < 1 but allowed ncol = 1 or nrow = 1
C
C        NCMAX: (input/unchanged) max. column dimension
C         NCOL: (input/unchanged) column dimension
C        NRMAX: (input/unchanged) max. row dimension
C         NROW: (input/unchanged) row dimension
C            A: (input/output) sample (may be edited)
C       FNAMEA: (input/output) file name (may be changed)
C       HEADER: (input/unchanged) header for menu
C       TITLEA: (input/output) title
C        ABORT: (output) error indicator
C       NEWDAT: (output) requests new data
C
C Note: This version does not change NCOL and NROW and only
C       returns ABORT = .TRUE. if there are no appropriate data, or the user
C       has selected Cancel to abort further calculations. It does not set
C       ABORT = .TRUE. if the user fails to read in data as it will just leave
C       any existing data unchanged. This involves the use of X and Y so it
C       is important that NRMAX >= NROW. NEWDAT is returned
C       as .TRUE. only if new data are requested.
C       If data are edited then a new file and title are created.
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NCMAX, NCOL, NRMAX, NROW
      DOUBLE PRECISION,    INTENT (INOUT) :: A(NRMAX,NCMAX)
      CHARACTER (LEN = *), INTENT (IN)    :: HEADER
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAMEA, TITLEA
      LOGICAL,             INTENT (OUT)   :: ABORT, NEWDAT
C
C Locals
C
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMDEC, NUMOPT, NSTART,
     +           NTEXT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, NUMOPT = 7,
     +           NSTART = 15, NTEXT = NUMOPT + NSTART - 1)
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N9
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5,
     +           N6 = 6, N9 = 9)
      INTEGER    NUMBLD(30), NUMPOS(NUMOPT)
      INTEGER    ISEND, ITYPE
      PARAMETER (ITYPE = 1)
      INTEGER    NWMAX
      PARAMETER (NWMAX = 2000)
      INTEGER    I, J, NMAT, NOUT
      CHARACTER  FORM12*12, WORD12_C*12, WORD12_R*12
      CHARACTER  TTITLE*80, ZNAME*80, ZTITLE*80
      CHARACTER  CIPHER*30, LINE*100, SIM256*1024, TEMP*1024,
     +           TEXT(30)*100
      CHARACTER  CHOP80*80, TRIM80*80, WORD14*14, WORD32*32
      CHARACTER  FNAMEB*1024
      CHARACTER  BLANK*1, DONE*30, NODATA*30, READY*30, STATE*30
      PARAMETER ( BLANK = ' ',
     +             DONE = '(... Edited ...)',
     +           NODATA = '(... No data ...)',
     +            READY = '(*** Ready ***)')
      LOGICAL    ABORT1, EXIST, READ_ONLY, REPEET 
      LOGICAL    BORDER, EDITED, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    CURVE, FIXCOL, FIXROW, LABEL, ORDER, WEIGHT
      PARAMETER (CURVE = .FALSE., FIXCOL = .TRUE., FIXROW = .FALSE.,
     +           LABEL = .TRUE., ORDER = .FALSE., WEIGHT = .FALSE.)
      EXTERNAL   PUTFAT, LBOX01, MATTRN, CHOP80, EDITOR, MATVAL, INFOFL,
     +           PATCH1, VIEWER, TRIM80, SIM256, GETNOU, ATTRIB, YMDHMS,
     +           CPYTRL, FORM12 
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / NUMOPT*1 /
C
C Initialise
C
      ABORT = .FALSE.
      NEWDAT = .FALSE.
      ZNAME = TRIM80(FNAMEA)
      ZTITLE = CHOP80(TITLEA)
C
C Loop
C
      EDITED = .FALSE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (NCOL.LT.N1 .OR. NROW.LT.N1) THEN
            STATE = NODATA
            NUMDEC = N5
         ELSE
            STATE = READY
            NUMDEC = N1
         ENDIF
         IF (EDITED) THEN
            CIPHER = DONE
         ELSE
            CIPHER = BLANK
         ENDIF
         WORD12_R = FORM12(NROW)
         WORD12_C = FORM12(NCOL)
         WRITE (TEXT,100) HEADER, ZNAME, ZTITLE, WORD12_R, 
     +                    WORD12_C, STATE, CIPHER
         NUMBLD(1) = N4
         NUMBLD(4) = N1
         NUMBLD(7) = N1
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = N0
         NUMBLD(4) = N0
         NUMBLD(7) = N0
         IF (NUMDEC.LT.N5) THEN
            IF (NCOL.LT.N1 .OR. NROW.LT.N1) THEN
               WRITE (LINE,200)
               CALL PUTFAT (LINE)
               NUMDEC = N0
            ENDIF
         ENDIF   
         IF (NUMDEC.EQ.N1) THEN
C
C Analyse
C
            ABORT = .FALSE.
            NEWDAT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (NUMDEC.EQ.N2) THEN
C
C Transform/Edit
C
            ISEND = N3
            TTITLE = ZTITLE
            CALL MATTRN (ISEND, NCOL, NRMAX, NROW,
     +                   A,
     +                   TTITLE)
            IF (TTITLE.NE.ZTITLE) THEN
               EDITED = .TRUE.
               ZTITLE = TTITLE
            ENDIF    
         ELSEIF (NUMDEC.EQ.N3) THEN
C
C View data
C
            WRITE (LINE,300)
            ISEND = N1
            CALL EDITOR (ISEND, ITYPE, NCOL, NRMAX, NROW,
     +                   A,
     +                   LINE,
     +                   CURVE, FIXCOL, FIXROW, LABEL, ORDER, WEIGHT)
         ELSEIF (NUMDEC.EQ.N4) THEN
C
C View file
C
            CALL VIEWER (N1,
     +                   FNAMEA, BLANK, BLANK)
         ELSEIF (NUMDEC.EQ.N5) THEN
C
C Read in new A data
C
            ABORT = .FALSE.
            NEWDAT = .TRUE.
            REPEET = .FALSE.
         ELSEIF (NUMDEC.EQ.NUMOPT - N1) THEN
C
C Help
C
            WRITE (TEXT,1000)
            I = 22
            NUMBLD(1) = N1
            NUMBLD(10) = N1
            CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, I,
     +                   TEXT,
     +                   BORDER)
            NUMBLD(1) = N0
            NUMBLD(10) = N0
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C Cancel
C
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C If analysis has been requested then check for transforming/editing
C      
      IF (.NOT.ABORT .AND. .NOT.NEWDAT) THEN
         IF (EDITED) THEN
C
C Find n as in matrix_n.tmp
C           
            ISEND = N1
            CALL MATVAL (ISEND, NMAT,
     +                   ABORT)
            IF (.NOT.ABORT) THEN
               ISEND = N2
               CALL MATVAL (ISEND, NMAT,
     +                      ABORT)
            ENDIF
            IF (.NOT.ABORT) THEN
               IF (NMAT.LE.N9) THEN
                  WRITE (WORD14,400) NMAT
               ELSE
                  WRITE (WORD14,500) NMAT
               ENDIF
               TEMP = SIM256(WORD14)
               CALL ATTRIB (TEMP,
     +                      EXIST, READ_ONLY)
               IF (EXIST .AND. READ_ONLY) THEN
C
C Do nothing as matrix_n.tmp is read_only
C                 
                  ISEND = N6
                  CALL INFOFL (ISEND,
     +                         TEMP)
               ELSE    
C
C Overwrite FNAMEA and TITLEA
C            
                  FNAMEB = FNAMEA                  
                  FNAMEA = TEMP
                  TITLEA = ZTITLE
                  CALL GETNOU (NOUT)
                  OPEN (UNIT = NOUT, FILE = FNAMEA)
                  WRITE (NOUT,'(A)') TITLEA
                  WRITE (NOUT,'(2I6)') NROW, NCOL
                  DO I = N1, NROW
                     WRITE (NOUT,'(1P,50E15.7)') (A(I,J), J = N1, NCOL)
                  ENDDO
                  WRITE (NOUT,'(I6)') N1
                  CALL YMDHMS (WORD32)
                  WRITE (NOUT,'(A)') WORD32
                  CLOSE (UNIT = NOUT)
                  IF (NCOL + NROW .LE. NWMAX) CALL CPYTRL (FNAMEB,
     +                                                     FNAMEA,
     +                                                     ABORT1)
                  ISEND = N2
                  CALL INFOFL (ISEND,
     +                         FNAMEA)                
               ENDIF
            ENDIF      
         ENDIF
         ABORT = .FALSE.    
      ENDIF      
C
C Format statements
C
  100 FORMAT (
     + A
     +/
     +/'Name of the current data file is:'
     +/A
     +/
     +/'Title of the current data set is:'
     +/A
     +/
     +/'Transformed or edited data will be written to a'
     +/'temporary file and a new title will be requested.'
     +/ 
     +/'Number of rows =',1X,A
     +/'Number of columns =',1X,A
     +/
     +/'Analyse the current data set',1X,A
     +/'Transform/Edit'
     +/'Display the current data set',1X,A
     +/'View the original data file'
     +/'New data'
     +/'Help'
     +/'Quit ... Exit this data input procedure')
  200 FORMAT ('Insufficient data')
  300 FORMAT ('Viewing the current data')
  400 FORMAT ('matrix_',i1,'.tmp')
  500 FORMAT ('matrix_',i2,'.tmp')
 1000 FORMAT (
     + 'Supplying a data sample for analysis'
     +/
     +/'The analytical procedure you have selected requires one sample'
     +/'in the form of a data matrix with no missing values, that is'
     +/'X with N rows and M columns, and the N*M elements'
     +/'x(1,1), x(1,2), ..., x(1,M)'
     +/'x(2,1), x(2,2), ..., x(2,M)'
     +/'...'
     +/'x(N,1), x(N,2), ..., x(N,M)'
     +/'Alternative methods to supply data'
     +/'1)`You can make a file using program MAKMAT. This is the best'
     +/'  `method since a permanent copy of your data will be saved.'
     +/'2)`You can create a file from your spreadsheet program, e.g.'
     +/'  `from Excel using a macro such as simfit6.xls.'
     +/'3)`You can copy a table from your spreadsheet to the clipboard'
     +/'  `then paste it in after choosing the [New data] option.'
     +/'4)`You can type in small samples at the terminal.'
     +/'5)`You can edit or transform an existing sample interactively.'
     +/'  `If you do this it will not alter the original data set'
     +/'  `which will be restored after analysis has been completed.'
     +/'6)`Any format can be used, e.g. 10, 10.0, 1.e1, 1.0e+01, etc.'
     +/'  `for ten, but you should always supply a meaningful title.')
      END
C
C
