C
C
      SUBROUTINE MATCOV (NCMAX, NCOL, NF,
     +                   A, TITLE,
     +                   FILEIT)
C
C ACTION: Display a title and then a covariance matrix using the viewer
C AUTHOR: W.G.Bardsley, University of Manchester, U.K.
C         06/05/2011 developed from MATCOR 
C         05/05/2016 increased output to 6 significant figures
C         15/12/2016 now calls M2FILE and adds row and column dimension and date
C         10/07/2021 if FILEIT = .true. then write a blank line at the top of the output 
C         31/12/2021 added FILEX to control printing of extra data NF (as with MATCOR)
C         
C  NCMAX: (input/unchanged) dimension
C   NCOL: (input/unchanged) size
C     NF: (input/unchanged) preconnected unit for results
C  TITLE: (input/unchanged) data title
C FILEIT: (input/unchanged) flags output to NF
C
C         If the matrix A is too large a starting column is requested
C         It is assumed that A(I,J) are of length 13
C         If FILEIT = .TRUE. then write output to preconnected UNIT = NF
C
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN) :: NCMAX, NCOL, NF
      CHARACTER (LEN = *), INTENT (IN) :: A(NCMAX,NCOL), TITLE
      LOGICAL,             INTENT (IN) :: FILEIT
C
C Locals
C
      INTEGER    NC_START, NC_STOP, NR_START, NR_STOP, NSTART, NSTOP
      INTEGER    I, IFAIL, IOS, J, LEN200, LC_START, LC_STOP, LR_START,
     +           LR_STOP, NOUT
      INTEGER    ISEND, JSEND, NWIDE
      PARAMETER (ISEND = 1, JSEND = 2, NWIDE = 100)
      INTEGER    ICOLOR, IX, IY
      PARAMETER (ICOLOR = 7, IX = 4, IY = 4)
      INTEGER    N1, N2
      PARAMETER (N1 = 1, N2 = 2)
      CHARACTER (LEN = 1024) FNAME
      CHARACTER (LEN = 32  ) WORD32
      CHARACTER (LEN = 12  ) FORM12, WORD12_CSTART, WORD12_CSTOP,
     +                               WORD12_RSTART, WORD12_RSTOP 
      CHARACTER (LEN = 1   ) BLANK, PATH, PATTERN
      PARAMETER (BLANK = ' ')
      LOGICAL    FILEX
      LOGICAL    ISTOP, REPEET, THERE, WIDE, WIDE1
      LOGICAL    ASKIF
      PARAMETER (ASKIF = .FALSE.)
      EXTERNAL   DELEET, GETNOU, GETTMP, VIEWER, GETIM1, YESNO2, FORM12,
     +           PUTADV, LEN200, M2FILE, YMDHMS, I1FILE, I2FILE
      INTRINSIC  LEN
C
C Edit the definition of FILEX as required to control printing extra information to NF
C      
      IF (FILEIT) THEN
         FILEX = .FALSE.
      ELSE   
         FILEX = .FALSE.
      ENDIF       
C
C Check LEN(A(I,J))
C
      IF (LEN(A(1,1)).NE.13) CALL PUTADV (
     +'LEN(A(i,j)) .NE. 13 in call to MATCOV')
C
C See if the matrix is too big
C
      IF (NCOL.GT.NWIDE) THEN
         WIDE = .TRUE.
         CALL M2FILE (JSEND, NCOL, NCMAX, NCOL, NWIDE,
     +                A, TITLE,
     +                ISTOP)  
         IF (ISTOP) RETURN   
      ELSE
         WIDE = .FALSE.
      ENDIF
C
C Main loop to display the matrix ... only once if .NOT.WIDE
C
      WIDE1 = WIDE
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (WIDE) THEN
C
C Decide where to start the rows if WIDE
C
            I = 1
            J = NCOL - 1
            CALL GETIM1 (I, NR_START, J,
     +     'Number of the row from which to start the display')
            NR_STOP = NR_START + NWIDE - 1
            IF (NR_STOP.GT.NCOL) NR_STOP = NCOL
C
C Decide where to start columns if WIDE
C
            I = 1
            J = NCOL - 1
            CALL GETIM1 (I, NC_START, J,
     +     'Number of the column from which to start the display')
            NC_STOP = NC_START + NWIDE - 1
            IF (NC_STOP.GT.NCOL) NC_STOP = NCOL
         ELSE
C
C Matrix is .NOT.WIDE
C
            NSTART = 1
            NSTOP = NCOL
         ENDIF
C
C Open a temporary file and write the title
C
         CALL GETNOU (NOUT)
         CALL GETTMP (IFAIL, 
     +                FNAME)
         CLOSE (UNIT = NOUT)
         OPEN (UNIT = NOUT, FILE = FNAME, IOSTAT = IOS)
         IF (IOS.NE.0) THEN
            CLOSE (UNIT = NOUT)
            RETURN
         ENDIF
         WRITE (NOUT,100) TITLE
         IF (FILEIT) WRITE (NF,100) BLANK
         IF (FILEIT) WRITE (NF,100) TITLE
C
C Action depends on WIDE
C
         IF (WIDE) THEN
            I = NR_STOP - NR_START + 1
            J = NC_STOP - NC_START + 1
            CALL I2FILE (NOUT, I, J)
            IF (FILEX) CALL I2FILE (NF, I, J)  
            DO I = NR_START, NR_STOP
               WRITE (NOUT,300) (A(I,J),
     +                           J = NC_START, NC_STOP)
               IF (FILEIT) WRITE (NF,300) (A(I,J), 
     +                           J = NC_START, NC_STOP)
            ENDDO
            CALL I1FILE (NOUT, N2)
            IF (FILEX) CALL I1FILE (NF, N2)
            WORD12_RSTART = FORM12(NR_START)
            WORD12_RSTOP = FORM12(NR_STOP)
            WORD12_CSTART = FORM12(NC_START)
            WORD12_CSTOP = FORM12(NC_STOP)
            LR_START = LEN200(WORD12_RSTART)
            LR_STOP = LEN200(WORD12_RSTOP)
            LC_START = LEN200(WORD12_CSTART)
            LC_STOP = LEN200(WORD12_CSTOP)
            WRITE (NOUT,200) WORD12_RSTART(1:LR_START),
     +                       WORD12_RSTOP(1:LR_STOP), 
     +                       WORD12_CSTART(1:LC_START),
     +                       WORD12_CSTOP(1:LC_STOP) 
            IF (FILEX) WRITE (NF,200) WORD12_RSTART(1:LR_START),
     +                                 WORD12_RSTOP(1:LR_STOP), 
     +                                 WORD12_CSTART(1:LC_START),
     +                                 WORD12_CSTOP(1:LC_STOP)
            
         ELSE
C
C Display full matrix 
C           
            CALL I2FILE (NOUT, NCOL, NCOL)
            IF (FILEX) CALL I2FILE (NF, NCOL, NCOL)
            DO I = NSTART, NSTOP
               WRITE (NOUT,300) (A(I,J), J = NSTART, NSTOP)
               IF (FILEIT) WRITE (NF,300) (A(I,J), J = NSTART, NSTOP)
            ENDDO
            CALL I1FILE (NOUT, N1)
            IF (FILEX) CALL I1FILE (NF, N1)
         ENDIF   
         CALL YMDHMS (WORD32)
         WRITE (NOUT,'(A)') WORD32
         IF (FILEX) WRITE (NF,'(A)') WORD32  
C
C Close the temporary file, send to the viewer then delete
C
         CLOSE (UNIT = NOUT)
         PATH = ' '
         PATTERN = ' '
         CALL VIEWER (ISEND,
     +                FNAME, PATH, PATTERN)
         CALL DELEET (FNAME, 
     +                ASKIF, THERE)
C
C If WIDE ask if further viewing is required
C
         IF (WIDE1)  CALL YESNO2 (ICOLOR, IX, IY,
     + 'More viewing ... starting from a different row/column',
     +                            WIDE)
         IF (WIDE) THEN
            REPEET = .TRUE.
         ELSE
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (1X,A)
  200 FORMAT (1X,'Rows',1X,A,1X,'to',1X,A,', Columns',1X,A,1X,'to',1X,A)
  300 FORMAT (100(1X,A13))
      END
C
C
