C
C
      SUBROUTINE MATOUT (ISEND, NCOL, NOUT, NRMAX, NROW, NTEXT,
     +                   A,
     +                   FNAME, TEXT, TITLE,
     +                   ABORT, HEADER, QTEXT, QTITLE)
C
C ACTION : Write a matrix to a data file as follows:-
C
C ISEND  = 1, User supplies filename at terminal, then OPEN new file
C ISEND  = 2, Filename as argument to subroutine, then OPEN new file
C ISEND  = 3, File named FILENAME already opened on unit NOUT
C HEADER = .TRUE. add header and trailing text
C QTEXT  = .TRUE. ask for text , otherwise use TEXT supplied
C QTITLE = .TRUE. ask for title, otherwise use TITLE supplied
C
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 26/11/90
C          03/10/1992 Removed CLOSE statements
C          23/02/1993 New version derived from MAKMAT, removed NCMAX, NRMAX
C          24/02/1993 added NTEXT, TEXT, HEADER
C          23/02/1994 DBOS version
C          01/02/1997 Windows 95 version
C          08/10/1998 added w_edittx
C          13/08/1999 increased possible output formats to use a comma
C                     and space up to 50 columns but then spaces only.
C          17/05/2005 added CLOSE for ISEND < 3 removed comma from output
C                     formats and increased no. of significant figures
C          29/02/2006 changed all output formats to 1P,50E13.5 
C          23/06/2006 introduced I1FILE and I2FILE for dimensions 
C          24/08/2006 corrected error assigning FNAME and TITLE as intent (INOUT)
C          13/10/2006 extensive editing and introduced call to YMDHMS
C          24/03/2008 changed treatment of trailing text
C          19/04/2008 increased all output formats to E15.7 
C          24/09/2021 uses SHOW15 for NCOL < 10 then SHOW13 for NCOL < 1000 then fails with ABORT = .TRUE. for NCOL >= 1000
C
C          ISEND: (input/unchanged) as above 1 =< ISEND =< 3
C           NCOL: (input/unchanged) column size >= 1
C           NOUT: (input/unchanged) unit that must be connected if ISEND = 3
C          NRMAX: (input/unchanged) dimension
C           NROW: (input/unchanged) row size >= 1
C          NTEXT: (input/unchanged) text size >= 1
C              A: (input/unchanged) data matrix
C          FNAME: (input/output) file name as above 
C           TEXT: (input/output) trailing text
C          TITLE: (input/output) title as above
C          ABORT: (output) error indicator
C         HEADER: (input/unchanged) as above
C          QTEXT: (input/unchanged) as above
C         QTITLE: (input/unchanged) as above
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: ISEND, NCOL, NOUT, NRMAX,
     +                                       NROW, NTEXT
      DOUBLE PRECISION,    INTENT (IN)    :: A(NRMAX,NCOL)
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT(NTEXT)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME, TITLE
      LOGICAL,             INTENT (OUT)   :: ABORT
      LOGICAL,             INTENT (IN)    :: HEADER, QTEXT, QTITLE
C
C Locals
C
      INTEGER    NHIGH, NWIDE
      PARAMETER (NHIGH = 100, NWIDE = 80)
      INTEGER    I, IOS, J, LEN200, L1, L2, NLINES
      INTEGER    ICOLOR, NUMHDR
      PARAMETER (ICOLOR = 3, NUMHDR = 8)
      INTEGER    NUMBLD(NUMHDR)
      CHARACTER (LEN = NWIDE) PHRASE(NHIGH)
      CHARACTER (LEN = 100  ) HDR(NUMHDR), LINE 
      CHARACTER (LEN = 32   ) WORD32 
      CHARACTER (LEN = 15   ) FRMAT, WORD15(10), SHOW15 
      CHARACTER (LEN = 13   ) WORD13(1000), SHOW13
      CHARACTER (LEN = 3    ) WORD3
      CHARACTER (LEN = 2    ) WORD2
      CHARACTER (LEN = 1    ) BLANK, COLON, WORD1
      PARAMETER (BLANK = ' ', COLON = ':')
      LOGICAL    YES
      EXTERNAL   OFILES, PUTFAT, ANSWER, EDITTX, GETSTR, I1FILE, I2FILE,
     +           YMDHMS, LEN200, SHOW13, SHOW15 
      INTRINSIC  LEN
      SAVE       PHRASE
      DATA       PHRASE / NHIGH*BLANK /
      DATA       NUMBLD / NUMHDR*0 /
C
C Initialise ABORT then check arguments
C      
      ABORT = .TRUE.
      IF (ISEND.LT.1 .OR. ISEND.GT.3    .OR.
     +    NCOL.LT.1  .OR.  
     +    NROW.LT.1  .OR. NROW.GT.NRMAX .OR. 
     +    NTEXT.LT.1) THEN
         WRITE (LINE,100)
         CALL PUTFAT (LINE)
         RETURN
      ENDIF
      IF (ISEND.LT.3) THEN   
C
C Try to open a file if ISEND < 3
C      
         CLOSE (UNIT = NOUT)
         CALL OFILES (ISEND, NOUT,
     +                FNAME, 
     +                ABORT)
         IF (ABORT) THEN
            CLOSE (UNIT = NOUT)
            RETURN 
         ENDIF   
      ENDIF
      IF (HEADER) THEN      
C
C Add title and dimensions to file if HEADER = .TRUE.
C        
         CALL YMDHMS (WORD32)
         IF (QTITLE) THEN
            WRITE (LINE,200)
            L1 = LEN200(TITLE)
            L2 = LEN(TITLE)
            IF (L2 - L1.GE.9) THEN 
               L1 = L1 + 1
               TITLE(L1:L1) = COLON   
               L1 = L1 + 1
               TITLE(L1:L1 + 7) = WORD32(10:17)
            ENDIF   
            CALL GETSTR (LINE, TITLE)
         ENDIF
         WRITE (NOUT,'(A)',IOSTAT=IOS) TITLE    
         CALL I2FILE (NOUT, NROW, NCOL)
      ENDIF   
C
C Write the data table to the file
C                      
      IF (NCOL.EQ.1) THEN    
         DO I = 1, NROW
            WORD15(1) = SHOW15(A(I,1))
            WRITE (NOUT,'(1X,A)',IOSTAT=IOS) WORD15(1)
         ENDDO
      ELSEIF (NCOL.LT.10) THEN
         WRITE (WORD1,'(I1)',IOSTAT=IOS) NCOL
         FRMAT = '('//WORD1//'(1X,A15)'//')'
         DO I = 1, NROW
            DO J = 1, NCOL
              WORD15(J) = SHOW15(A(I,J))
            ENDDO
            WRITE (NOUT,FRMAT,IOSTAT=IOS) (WORD15(J), J = 1, NCOL)  
         ENDDO    
      ELSEIF (NCOL.LT.100) THEN
         WRITE (WORD2,'(I2)',IOSTAT=IOS) NCOL
         FRMAT = '('//WORD2//'(1X,A13)'//')'
         DO I = 1, NROW
            DO J = 1, NCOL
              WORD13(J) = SHOW13(A(I,J))
            ENDDO
            WRITE (NOUT,FRMAT,IOSTAT=IOS) (WORD13(J), J = 1, NCOL)  
         ENDDO  
      ELSEIF (NCOL.LT.1000) THEN
         WRITE (WORD3,'(I3)',IOSTAT=IOS) NCOL
         FRMAT = '('//WORD3//'(1X,A13)'//')'
         DO I = 1, NROW
            DO J = 1, NCOL
              WORD13(J) = SHOW13(A(I,J))
            ENDDO
            WRITE (NOUT,FRMAT,IOSTAT=IOS) (WORD13(J), J = 1, NCOL)  
         ENDDO  
      ELSE   
         CALL PUTFAT ('This version of MATOUT requires NCOL < 1000') 
         ABORT = .TRUE.
         RETURN
      ENDIF
      IF (HEADER) THEN    
C
C Add trailing material if HEADER = .TRUE.
C      
         IF (QTEXT) THEN
            WRITE (HDR,300)
            YES = .FALSE.
            WRITE (LINE,400)
            CALL ANSWER (ICOLOR, NUMBLD, NUMHDR,
     +                   HDR, LINE,
     +                   YES)
            IF (YES) THEN    
               CALL EDITTX (NHIGH, NLINES, NWIDE, 
     +                      PHRASE)
               IF (NLINES.LE.0) THEN
                  NLINES = 0
               ELSEIF (NLINES.GT.NHIGH) THEN
                  NLINES = NHIGH 
               ENDIF  
               NLINES = NLINES + 1
               CALL I1FILE (NOUT, NLINES)
               DO I = 1, NLINES 
                  IF (I.LT.NLINES) THEN
                     WRITE (NOUT,'(A)',IOSTAT=IOS) PHRASE(I)
                  ELSE   
                     WRITE (NOUT,'(A)',IOSTAT=IOS) WORD32
                  ENDIF   
               ENDDO
            ELSE                  
               NLINES = 1              
               CALL I1FILE (NOUT, NLINES) 
               WRITE (NOUT,'(A)') WORD32
            ENDIF
         ELSE         
            NLINES = NTEXT
            DO WHILE (TEXT(NLINES).EQ.BLANK .AND. NLINES.GT.0)
               NLINES = NLINES - 1
            ENDDO
            IF (NLINES.LE.0) THEN
               NLINES = 1   
               CALL I1FILE (NOUT, NLINES)
               WRITE (NOUT,'(A)') WORD32
            ELSE  
               CALL I1FILE (NOUT, NLINES) 
               WRITE (NOUT,'(A)',IOSTAT=IOS) (TEXT(I), I = 1, NLINES)
            ENDIF   
         ENDIF
      ENDIF
      ABORT = .FALSE.
C
C Format statements
C      
  100 FORMAT ('Error in call to MATOUT')
  200 FORMAT ('Title for these data')
  300 FORMAT (
     + 'Simfit files have a final section which can be used to'
     +/'add starting parameter estimates or control parameters'
     +/'that are required to run some specialised programs in'
     +/'the EXPERT mode.'
     +/
     +/'You can also put details of experimental protocols etc.'
     +/'at the end of this data file for retrospective use, if'
     +/'you want.')
  400 FORMAT ('Add extra details to the file ?')
      END
C
C
