C
C
      SUBROUTINE MATTIN (ISEND, NCMAX, NCOL, NIN, NRMAX, NROW,
     +                   A, B,
     +                   FNAME, TITLE,
     +                   ABORT, FIXCOL, FIXROW, LABEL)
C
C ACTION : Input elements of a matrix A(I,J)
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C
C          03/10/1992 Removed CLOSE statements
C          23/02/1993 Introduced B, GET??? etc.
C          02/04/1994 Introduced call to GETMAT
C          02/04/1994 DBOS version
C          10/11/1995 replaced ANSWER by TITLES and introduced TRIML1
C          04/09/1996 Added CHKFIL
C          10/02/1997 Win32 version
C          22/04/1997 Added ABIG to resolve dimension clash in call to GETMAT
C                     Note that NBIG must be =< NRBIG and NCOL must be =< NCBIG
C                     to use manual input via GETMAT
C          28/10/1998 Stopped redefinition of NCOL, NROW if fixed and substituted
C                     TITLE2 for TITLES
C          05/04/2000 Added extra CLOSE (UNIT = NIN)
C          08/05/2000 Removed CLOSE after success since it may be
C                     required to read the trailer
C          07/01/2001 mentioned clipboard and deleted N5, N7, N13
C          28/11/2001 added VU2CHK
C          28/01/2002 removed call to GETVEC but retained B(NMAX) just in case
C          28/05/2002 added FNAME to call to CHKFIL
C          04/02/2005 added MATVAL, ATTRIB, NTEMP, CHECKF, PUTADV
C          16/06/2006 changed B(NCMAX) to B(*)
C          28/07/2006 edited to prevent fixcol or fixrow cases overflowing if
C                     ISEND not equal 1 by introducing NVBIGC and NVBIGC and 
C                     re-setting JSEND = 2 if required 
C          26/02/2007 added INTENTS
C          17/07/2007 added SIM256 and YMDHMS for version 6
C          19/04/2008 increased output format to E15.7
C          31/07/2008 added call to ISITSF
C          11/05/2010 introduced NKLCFG to switch on/off the TYPE-IN-DATA option 
C          19/04/2011 edited main menu
C          04/04/2015 replaced PUTADV by INFOFL
C          01/09/2015 added call to SWITCH
C
C          ISEND: (input/unchanged) as follows
C                 ISEND = 1: User inputs TITLE etc.
C                 ISEND = 2: TITLE etc. from file prepared by MAKMAT
C                 OTHERWISE : User chooses input mode
C          NCMAX: (input/unchanged) maximum column dimension
C           NCOL: (input/output) actual column dimension depending on FIXCOL
C            NIN: (input/unchanged) unconnected unit number for file opening
C                 If a file is selected NIN is returned connected in case
C                 it is necessary to read the trailer o/w it is closed
C          NRMAX: (input/unchanged) leading dimension
C           NROW: (input/output) actual row dimension depending on FIXROW
C              A: (output)
C              B: workspace (not used in this version)
C          FNAME: (input/output) as follows
C                 ISEND = 1: unchanged 
C                 ISEND = 2: returned as temporary file name
C          TITLE: (input/output) depending on ISEND and LABEL as follows
C                 ISEND = 1: data title from file
C                 Otherwise, LABEL = .TRUE. user chooses
C                            LABEL = .FALSE. default
C          ABORT: (output) error indicator
C         FIXCOL: (input/unchanged) if .TRUE. column size fixed as NCOL
C         FIXROW: (input/unchanged) if .TRUE. row size fixed as NROW
C          LABEL: (input/unchanged) if .TRUE. user inputs title
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: ISEND, NCMAX, NIN, NRMAX   
      INTEGER,             INTENT (INOUT) :: NCOL, NROW
      DOUBLE PRECISION,    INTENT (OUT)   :: A(NRMAX,NCMAX), B(*)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME, TITLE
      LOGICAL,             INTENT (IN)    :: FIXCOL, FIXROW, LABEL   
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Locals
C
      INTEGER    KCSAV, KRSAV, NCSAV, NRSAV
      INTEGER    I, ICOUNT, IOS, J, JSEND, NVBIGC, NVBIGR
      INTEGER    KVAL10, NKLCFG
      INTEGER    NCBIG, NRBIG
      PARAMETER (NCBIG = 50, NRBIG = 250)
      INTEGER    N0, N1, N2, N3, N22, N34
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N22 = 22, N34 = 34)
      INTEGER    ICOLOR, NUMDEC, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 7, NUMHDR = 23, NUMOPT = 3)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      INTEGER    NCBOT, NCMID, NCTOP, NRBOT, NRMID, NRTOP, NTEMP
      DOUBLE PRECISION ABIG(NRBIG,NCBIG)
      CHARACTER (LEN = 1024) SIM256
      CHARACTER (LEN = 100 ) HEADER(NUMHDR), LINE
      CHARACTER (LEN = 20  ) OPTION(NUMOPT)
      CHARACTER (LEN = 15  ) WORD15
      CHARACTER (LEN = 8   ) NUM1, NUM2, NUM3, NUM4
      LOGICAL    EXIST, READ_ONLY
      EXTERNAL   GETJM1, GETSTR, OFILES, PUTFAT, GETMAT, INFOFL, GETTMP,
     +           TITLE2, TRIML1, CHKFIL, MATVAL, ATTRIB, CHECKF, I1FILE,
     +           I2FILE, SIM256, YMDHMS, ISITSF, SWITCH 
      EXTERNAL   NKLCFG
      INTRINSIC  MIN
      SAVE       KCSAV, KRSAV
      DATA       KCSAV, KRSAV / 2, 2 /
      DATA       NUMBLD / 1*4, 1*0, 1*2, 14*0, 4*1, 2*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION / 'File/Clipboard',
     +                    'Type-in-data',
     +                    'Suppress' /
C
C Initialise
C
      ABORT = .TRUE.
      IF (NIN.LT.N1 .OR. NCMAX.LT.N1 .OR. NRMAX.LT.N1) THEN
         WRITE (LINE,100)
         CALL PUTFAT (LINE)
         RETURN
      ENDIF
      JSEND = ISEND
      B(1) = 1.0D+00!to silence ftn95 ... B is not used in this version
      NVBIGC = MIN(NCMAX,NCBIG)
      NVBIGR = MIN(NRMAX,NRBIG)
      IF (FIXCOL) THEN
         IF (NCOL.LT.N1 .OR. NCOL.GT.NCMAX) THEN
            WRITE (LINE,200) 'NCOL'
            CALL PUTFAT (LINE)
            RETURN
         ENDIF  
         IF (NCOL.GT.NCBIG) JSEND = N2
         NCBOT = NCOL
         NCTOP = NCOL
         NCSAV = NCOL
      ELSE
         NCBOT = N1
         NCTOP = NCMAX
         NCSAV = - N1
      ENDIF
      IF (FIXROW) THEN
         IF (NROW.LT.N1 .OR. NROW.GT.NRMAX) THEN
            WRITE (LINE,200) 'NROW'
            CALL PUTFAT (LINE)
            RETURN
         ENDIF    
         IF (NROW.GT.NRBIG) JSEND = N2
         NRBOT = NROW
         NRTOP = NROW
         NRSAV = NROW
      ELSE
         NRBOT = N1
         NRTOP = NRMAX
         NRSAV = - N1
      ENDIF
C
C Give the user a choice if ISEND not 1 or 2
C
      IF (JSEND.LT.N1 .OR. JSEND.GT.N2) THEN
         KVAL10 = NKLCFG(N22)
         IF (KVAL10.EQ.N1) THEN
            WRITE (NUM1,'(I8)') NRMAX
            WRITE (NUM2,'(I8)') NVBIGR
            WRITE (NUM3,'(I8)') NCMAX  
            WRITE (NUM4,'(I8)') NVBIGC
            CALL TRIML1 (NUM1)
            CALL TRIML1 (NUM2)
            CALL TRIML1 (NUM3)    
            CALL TRIML1 (NUM4)
            WRITE (HEADER,300) NUM1, NUM2, NUM3, NUM4
            NUMDEC = N1
            CALL TITLE2 (ICOLOR, NUMBLD, NUMDEC, NUMHDR, NUMOPT, NUMPOS,
     +                   HEADER, OPTION)
         ELSE
            NUMDEC = N1
         ENDIF    
         IF (NUMDEC.EQ.N1) THEN
            JSEND = N2
         ELSEIF (NUMDEC.EQ.N2) THEN
            JSEND = N1
         ELSE
            JSEND = N2
            CALL SWITCH (N34)   
         ENDIF
      ENDIF
      IF (JSEND.EQ.N1) THEN
C
C Type in data if JSEND = 1
C
        WRITE (TITLE,400)
        IF (LABEL) THEN
            WRITE (LINE,500)
            CALL GETSTR (LINE, TITLE)
         ENDIF
         IF (.NOT.FIXROW) THEN                 
            IF (KRSAV.GT.NVBIGR) KRSAV = NVBIGR
            WRITE (LINE,600)
            CALL GETJM1 (N1, KRSAV, NVBIGR,
     +                   LINE)
            NROW = KRSAV
         ENDIF
         IF (.NOT.FIXCOL) THEN   
            WRITE (LINE,700)
            IF (KCSAV.GT.NVBIGC) KCSAV = NVBIGC
            CALL GETJM1 (N1, KCSAV, NVBIGC,
     +                   LINE)
            NCOL = KCSAV
         ENDIF
         WRITE (LINE,800)
         CALL GETMAT (NCOL, NRBIG, NROW,
     +                ABIG,
     +                LINE)
         DO J = N1, NCOL
            DO I = N1, NROW
               A(I,J) = ABIG(I,J)
            ENDDO
         ENDDO
C
C Attempt to create temporary file matrix_k.tmp
C
         CALL MATVAL (N1, NTEMP,
     +                ABORT)
         IF (ABORT) THEN
            CALL GETTMP (I,
     +                   FNAME)
         ELSE
            CALL MATVAL (N2, NTEMP,
     +                   ABORT)
            IF (ABORT) THEN
               CALL GETTMP (I,
     +                      FNAME)
            ELSE
               IF (NTEMP.LT.10) THEN
                  WRITE (WORD15,900) NTEMP
               ELSEIF (NTEMP.LT.100) THEN
                  WRITE (WORD15,1000) NTEMP
               ELSE
                  WRITE (WORD15,1100) NTEMP
               ENDIF
               FNAME = SIM256(WORD15)
               CALL ATTRIB (FNAME,
     +                      EXIST, READ_ONLY)
               IF (EXIST .AND. READ_ONLY) THEN
                  WRITE (LINE,1200) WORD15
                  CALL PUTFAT (LINE)
                  CALL GETTMP (I,
     +                         FNAME)
               ENDIF
            ENDIF
         ENDIF
         OPEN (UNIT = NIN, FILE = FNAME)
         WRITE (NIN,'(A)') TITLE   
         CALL I2FILE (NIN, NROW, NCOL)
         DO I = N1, NROW
            WRITE (NIN,'(1P,50E15.7)') (A(I,J), J = N1, NCOL)
         ENDDO  
         CALL I1FILE (NIN, N1)
         CALL YMDHMS (LINE)
         WRITE (NIN,'(A)') LINE
         CLOSE (UNIT = NIN)
         CALL INFOFL (2,
     +                FNAME)        
         ABORT  = .FALSE.
      ELSE
C
C Attempt to open a file
C
         CLOSE (UNIT = NIN)
         CALL OFILES (N3, NIN,
     +                FNAME,
     +                ABORT)
         CLOSE (UNIT = NIN)
         IF (ABORT) THEN
            FNAME = 'No current file'
            TITLE = 'No current data'
            RETURN
         ENDIF
C
C Use ISITSF to check if the file is or can be transformed into a Simfit data file
C         
         CALL ISITSF (NCMID, NRMID,
     +                FNAME)
         IF (NCMID.GT.N0 .AND. NRMID.GT.N0) THEN
            OPEN (UNIT = NIN, FILE = FNAME)
         ELSE
            ABORT = .TRUE.
            FNAME = 'No current file'
            TITLE = 'No current data'
            RETURN
         ENDIF               
C
C File is now open so check title, header and data
C
         ABORT = .TRUE.
         NCMID = - N1
         NRMID = - N1
         ICOUNT = N1
         READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLE
         IF (IOS.NE.N0) GOTO 20
         ICOUNT = N2
         READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) I, J
         IF (IOS.NE.N0) GOTO 20
         NCMID = J
         NRMID = I
         IF (NCMID.LT.N1 .OR. NCMID.GT.NCMAX) GOTO 20
         IF (NRMID.LT.N1 .OR. NRMID.GT.NRMAX) GOTO 20
         IF (FIXROW .AND. NRMID.NE.NRSAV) GOTO 20
         IF (FIXCOL .AND. NCMID.NE.NCSAV) GOTO 20
         CLOSE (UNIT = NIN)
         CALL CHECKF (FNAME, TITLE,
     +                ABORT)
         IF (ABORT) THEN
            FNAME = 'No current file'
            TITLE = 'No current data'
            RETURN
         ELSE
            OPEN (UNIT = NIN, FILE = FNAME)
            READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLE
            READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) I, J
         ENDIF
         IF (.NOT.FIXCOL) NCOL = NCMID
         IF (.NOT.FIXROW) NROW = NRMID
         DO I = N1, NROW
            ICOUNT = ICOUNT + N1
            READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) (A(I,J), J = N1, NCOL)
            IF (IOS.NE.N0) GOTO 20
         ENDDO
         ABORT = .FALSE.
      ENDIF
      RETURN
C
C Label 20: Here in the event of a crash reading the data from a file
C =========
C
   20 CONTINUE
      ABORT = .TRUE.
      CLOSE (UNIT = NIN)
      CALL CHKFIL (ICOUNT, IOS, NCBOT, NCMID, NCTOP, NRBOT, NRMID,
     +             NRTOP,
     +             FNAME, TITLE)
      FNAME = 'No current file'
      TITLE = 'No current data' 
C
C Format statements
C      
  100 FORMAT ('NIN, NCMAX or NRMAX out of range in call to MATTIN')
  200 FORMAT (A,1X,'out of range in call to MATTIN')
  300 FORMAT (
     + 'Alternative methods for providing a table of data values'
     +/
     +/'To suppress Type-in-data use [Configure],[Advanced],[Speedup].'
     +/
     +/'1)`Simfit data files can be just a rectangular table of values'
     +/'  `but may have an optional title and a header with the number'
     +/'  `of rows (cases) and the number of columns (variables).'
     +/'  `Extra details can also be appended after the data.'
     +/'2)`Such files can be prepared/edited by Makmat/Editmt, or'
     +/'  `using any text editor, e.g. Notepad.'
     +/'3)`With small data sets, you can type in values now, when a'
     +/'  `temporary file called matrix_k.tmp (0 =< k =< 20) will'
     +/'  `be created for you to save or discard retrospectively.'
     +/'4)`Clipboard or spreadsheet data must have no missing values,'
     +/'  `but can include row and column labels if required.'
     +/'5)`You can also use macros, e.g. Excel with simfit6.xls.' 
     +/
     +/'Maximum number of rows from file =',1X,A
     +/'Maximum number of rows from terminal =',1X,A
     +/'Maximum number of columns from file =',1X,A
     +/'Maximum number of columns from terminal =',1X,A
     +/
     +/'[Suppress] switches off future options to [Type-in data] from',
     + ' the terminal.') 
  400 FORMAT ('Temporary data')
  500 FORMAT ('Title for the data')
  600 FORMAT ('The number of rows (down) you want to type in now')
  700 FORMAT ('The number of columns (across) you want to type in now')
  800 FORMAT ('Input the matrix of data values required')
  900 FORMAT ('matrix_',I1,'.tmp')
 1000 FORMAT ('matrix_',I2,'.tmp')
 1100 FORMAT ('matrix_',I3,'.tmp')
 1200 FORMAT ('Read_only file encountered ... Use attrib -r',1X,A)
      END
C
C

