C
C
      SUBROUTINE MATTRN (ISEND, NCOLS, NRMAX, NROWS,
     +                   A,
     +                   TITLE)
C
C ACTION : transform a matrix
C AUTHOR : W.G.Bardsley, University of Manchester, U.K, 29/1/99
C          07/02/2001 added CHOP80
C          26/11/2001 extensive revision and extension
C          15/11/2005 replaced NAG call by call to NAGSUB
C          21/05/2006 deleted X and Y from argument list, made
C                     allocatable and added many further options
C          26/02/2007 added INTENTS
C          14/08/2007 added centralise without scaling 
C          10/07/2008 added NUMTRN
C          26/07/2008 added scaling to st.dev. = 1
C          19/04/2011 edited main menu
C
C  ISEND: (input/unchanged) as follows:
C          ISEND = 1: columns only
C          ISEND = 2: rows only
C          ISEND = 3: columns and rows
C          ISEND = 4: columns and rows but do not ask for new title
C  NCOLS: (input/unchanged) no. of columns in A
C  NRMAX: (input/unchanged) leading dimension of A
C  NROWS: (input/unchanged) no. of rows in A
C      A: (input/output) matrix supplied is returned transformed
C  TITLE: (input/output) data title
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: ISEND, NCOLS, NRMAX, NROWS
      DOUBLE PRECISION,    INTENT (INOUT) :: A(NRMAX,NCOLS)
      CHARACTER (LEN = *), INTENT (INOUT) :: TITLE
C
C Local allocatable workspaces
C
      DOUBLE PRECISION, ALLOCATABLE :: ASAV(:,:), B(:,:), X(:), Y(:)
C
C Locals
C
      INTEGER    I, IERR, IFAIL, ISAV, ICOUNT, IHIST, J, JCOUNT, JSAV,
     +           K, L, NCMAX, NLOG, NMAX, NTRIG
      INTEGER    NCOL1, NROW1, NUMTRN
      INTEGER    JSEND, JTYPE, N0, N1, N4, NF, NHIST, NTYPE
      PARAMETER (JSEND = 2, JTYPE = 1, N0 = 0, N1 = 1, N4 = 4, NF = 4,
     +           NHIST = 500, NTYPE = 3)
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NDEC, NSTART, NUMDEC, NUMOPT,
     +           NUMTXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 0, NSTART = 8)
      INTEGER    NUMBLD(30), NUMPOS(20)
      DOUBLE PRECISION CONST, FACTOR, SSQ, STDEV, TEMP, XBAR
      DOUBLE PRECISION RTOL, X02AMFG, G01EAFG, G01FAFG
      DOUBLE PRECISION ZERO, ONE, TWO, SMALL, VSMALL
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           SMALL = 1.0D-03, VSMALL = 1.0D-06)
      DOUBLE PRECISION PMAX, PMIN
      PARAMETER (PMAX = 0.999D+00, PMIN = 0.001D+00)
      CHARACTER (LEN = 12) FORM12, WORD12_C, WORD12_I, WORD12_J,
     +                     WORD12_R
      CHARACTER  CHOP80*80, CIPHERA*4, CIPHERC*4, CIPHERR*4
      CHARACTER  BASE*2, LINE*100, TEXT(30)*100, WORD4*4, WORD80*80
      CHARACTER  HISTRY(NHIST)*80
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    ABORT, COLS, LOG_E, LOG_10, LOOP, OK, REPEET, ROWS
      LOGICAL    FIXED, FLASH, HIGH
      PARAMETER (FIXED = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    FILEIT, TITLES
      PARAMETER (FILEIT = .FALSE., TITLES = .TRUE.)
      LOGICAL    CURVE, FIXCOL, FIXROW, LABEL, ORDER, WEIGHT
      PARAMETER (CURVE = .FALSE., FIXCOL = .TRUE., FIXROW = .TRUE.,
     +           LABEL = .TRUE., ORDER = .FALSE., WEIGHT = .FALSE.)
      EXTERNAL   VECTRN, PUTFAT, GETJM1, LBOX01, GETSTR, CHOP80, PUTADV,
     +           DSPLAY, EDITOR, TABLE1, PATCH1, WPARAM, LVIEW2, LISTBX,
     +           TRIGMT, TRIML1, FORM12
      EXTERNAL   X02AMFG, G01EAFG, G01FAFG
      INTRINSIC  ABS, DBLE, LOG, LOG10, MAX, NINT
      SAVE       IHIST, JCOUNT, NUMTRN
      SAVE       HISTRY
      DATA       HISTRY  / NHIST*BLANK /
      DATA       IHIST, JCOUNT, NUMTRN / N0, N0, N0 /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / 20*1 /
C
C Check
C
      IF (NCOLS.LT.1 .OR. NROWS.LT.1) THEN
         CALL PUTFAT ('No data to transform')
         RETURN
      ENDIF
C
C Initialise
C
      NLOG = N1
      NTRIG = N0
      RTOL = 1.0D+09*X02AMFG()
      ICOUNT = N0
      JCOUNT = JCOUNT + N1
      ISAV = N0
      JSAV = N0
      IF (ISEND.EQ.1) THEN
         CIPHERA = '(NA)'
         CIPHERC = '    '
         CIPHERR = '(NA)'
         COLS = .TRUE.
         ROWS = .FALSE.
      ELSEIF (ISEND.EQ.2) THEN
         CIPHERA = '(NA)'
         CIPHERC = '(NA)'
         CIPHERR = '    '
         COLS = .FALSE.
         ROWS = .TRUE.
      ELSEIF (ISEND.EQ.3 .OR. ISEND.EQ.4) THEN
         CIPHERA = '    '
         CIPHERC = '    '
         CIPHERR = '    '
         COLS = .TRUE.
         ROWS = .TRUE.
      ELSE
         CALL PUTFAT ('ISEND out of range in call to MATTRN')
         RETURN
      ENDIF
C
C Allocate workspaces
C
      NMAX = MAX(NRMAX, NCOLS)
      IERR = 0
      IF (ALLOCATED(ASAV)) DEALLOCATE(ASAV, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(B)) DEALLOCATE(B, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(X)) DEALLOCATE(X, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(Y)) DEALLOCATE(Y, STAT = IERR)
      IF (IERR.NE.0) RETURN
      NCOL1 = NCOLS
      NROW1 = NROWS  
      ALLOCATE(ASAV(NROW1,NCOL1), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(B(NROW1,NCOL1), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(X(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(Y(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
C
C Store original matrix then define WORD80
C
      DO J = N1, NCOLS
         DO I = N1, NROWS
            ASAV(I,J) = A(I,J)
         ENDDO
      ENDDO
      WORD80 = CHOP80(TITLE)
C
C Main cycle point
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         WORD12_C = FORM12(NCOLS)
         WORD12_I = FORM12(ICOUNT)
         WORD12_J = FORM12(JCOUNT)
         WORD12_R = FORM12(NROWS)
         WRITE (TEXT,100) WORD80,  WORD12_C(1:8), WORD12_R(1:8),
     +                    WORD12_J(1:6), WORD12_I(1:6),
     +                    CIPHERC, CIPHERC, CIPHERC, CIPHERC, CIPHERC,
     +                    CIPHERR, CIPHERR, CIPHERR, CIPHERR, CIPHERR,
     +                    CIPHERA, CIPHERA
         NUMBLD(1) = N4
         NUMBLD(4) = N1
         NUMOPT = 19
         NUMTXT = NSTART + NUMOPT - 1
         NUMDEC = 13
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NUMTXT,
     +                TEXT,
     +                FIXED, FLASH, HIGH)
         NUMBLD(1) = N0
         NUMBLD(4) = N0
         IF (NUMDEC.EQ.1) THEN
C
C NUMDEC = 1: Transform a column
C ===========
C
            IF (COLS) THEN
               I = NCOLS
               J = JSAV
               CALL GETJM1 (N0, J, I,
     +'No. of the column to be transformed (0 to cancel)')
               IF (J.GT.N0) THEN
                  DO I = N1, NROWS
                     X(I) = A(I,J)
                  ENDDO
                  CALL VECTRN (NROWS,
     +                         X, Y,
     +                         ABORT)
                  IF (.NOT.ABORT) THEN
                     ICOUNT = ICOUNT + N1
                     IHIST = IHIST + N1
                     JSAV = J
                     IF (IHIST.GT.NHIST) THEN
                        IHIST = NHIST
                        DO I = N1, NHIST - N1
                           HISTRY(I) = HISTRY(I + N1)
                        ENDDO
                     ENDIF
                     WRITE (HISTRY(IHIST),200) JCOUNT, ICOUNT,
     +'Transformed column', JSAV
                     DO I = N1, NROWS
                        A(I,JSAV) = Y(I)
                     ENDDO
                  ENDIF
               ENDIF
            ELSE
               CALL PUTFAT ('Column has not been transformed')
            ENDIF
         ELSEIF (NUMDEC.EQ.2) THEN
C
C NUMDEC = 2:  Normalise all columns to unit length
C ===========
C
            IF (COLS) THEN
               OK = .TRUE.
               DO J = N1, NCOLS
                  IF (OK) THEN
                     X(J) = ZERO
                     DO I = N1, NROWS
                        X(J) = X(J) + A(I,J)*A(I,J)
                     ENDDO
                     IF (X(J).GT.RTOL) THEN
                        X(J) = SQRT(X(J))
                     ELSE
                        OK = .FALSE.
                        WRITE (LINE,400) 'zero', 'column', J
                        CALL PUTFAT (LINE)
                     ENDIF
                  ENDIF
               ENDDO
               IF (OK) THEN
                  ICOUNT = ICOUNT + N1
                  IHIST = IHIST + N1
                  IF (IHIST.GT.NHIST) THEN
                     IHIST = NHIST
                     DO I = N1, NHIST - N1
                        HISTRY(I) = HISTRY(I + N1)
                     ENDDO
                  ENDIF
                  WRITE (HISTRY(IHIST),300) JCOUNT, ICOUNT,
     +'All columns normalised to unit length'
                  CALL PUTADV (HISTRY(IHIST))
                  DO J = N1, NCOLS
                     DO I = N1, NROWS
                        A(I,J) = A(I,J)/X(J)
                     ENDDO
                  ENDDO
               ENDIF
            ELSE
               CALL PUTFAT ('Column cannot be transformed')
            ENDIF
        ELSEIF (NUMDEC.EQ.3) THEN
C
C NUMDEC = 3: Normalise all columns to s = 1
C ===========
C
            IF (COLS) THEN
               OK = .TRUE.
               DO J = N1, NCOLS
                  IF (OK) THEN
                     XBAR = ZERO
                     SSQ = ZERO
                     DO I = N1, NROWS
                        XBAR = XBAR + A(I,J)
                     ENDDO
                     XBAR = XBAR/DBLE(NROWS)
                     DO I = N1, NROWS
                        SSQ = SSQ + (A(I,J) - XBAR)**2
                     ENDDO
                     SSQ = SSQ/DBLE(NROWS - N1)
                     STDEV = SQRT(SSQ)
                     IF (STDEV.GT.RTOL) THEN
                        Y(J) = STDEV
                     ELSE
                        OK = .FALSE.
                        WRITE (LINE,400) 'constant', 'column', J
                        CALL PUTFAT (LINE)
                     ENDIF
                  ENDIF
               ENDDO
               IF (OK) THEN
                  ICOUNT = ICOUNT + N1
                  IHIST = IHIST + N1
                  IF (IHIST.GT.NHIST) THEN
                     IHIST = NHIST
                     DO I = N1, NHIST - N1
                        HISTRY(I) = HISTRY(I + N1)
                     ENDDO
                  ENDIF
                  WRITE (HISTRY(IHIST),250) JCOUNT, ICOUNT,
     +'All columns scaled to st.dev. = 1'
                  CALL PUTADV (HISTRY(IHIST))
                  DO J = N1, NCOLS
                     DO I = N1, NROWS
                        A(I,J) = A(I,J)/Y(J)
                     ENDDO
                  ENDDO
               ENDIF
            ELSE
               CALL PUTFAT ('Columns cannot be transformed')
            ENDIF               
         ELSEIF (NUMDEC.EQ.4) THEN
C
C NUMDEC = 4: Centralise all columns to mu = 0
C ===========
C
            IF (COLS) THEN
               DO J = N1, NCOLS
                  XBAR = ZERO
                  DO I = N1, NROWS
                     XBAR = XBAR + A(I,J)
                  ENDDO
                  XBAR = XBAR/DBLE(NROWS)
                  X(J) = XBAR
               ENDDO
               ICOUNT = ICOUNT + N1
               IHIST = IHIST + N1
               IF (IHIST.GT.NHIST) THEN
                  IHIST = NHIST
                  DO I = N1, NHIST - N1
                     HISTRY(I) = HISTRY(I + N1)
                  ENDDO
               ENDIF
               WRITE (HISTRY(IHIST),250) JCOUNT, ICOUNT,
     +'All columns centralised to mean = 0'
               CALL PUTADV (HISTRY(IHIST))
               DO J = N1, NCOLS
                  DO I = N1, NROWS
                     A(I,J) = A(I,J) - X(J)
                  ENDDO
               ENDDO
            ELSE
               CALL PUTFAT ('Columns cannot be transformed')
            ENDIF
         ELSEIF (NUMDEC.EQ.5) THEN
C
C NUMDEC = 5: Normalise all columns to mu = 0, s = 1
C ===========
C
            IF (COLS) THEN
               OK = .TRUE.
               DO J = N1, NCOLS
                  IF (OK) THEN
                     XBAR = ZERO
                     SSQ = ZERO
                     DO I = N1, NROWS
                        XBAR = XBAR + A(I,J)
                     ENDDO
                     XBAR = XBAR/DBLE(NROWS)
                     DO I = N1, NROWS
                        SSQ = SSQ + (A(I,J) - XBAR)**2
                     ENDDO
                     SSQ = SSQ/DBLE(NROWS - N1)
                     STDEV = SQRT(SSQ)
                     IF (STDEV.GT.RTOL) THEN
                        X(J) = XBAR
                        Y(J) = STDEV
                     ELSE
                        OK = .FALSE.
                        WRITE (LINE,400) 'constant', 'column', J
                        CALL PUTFAT (LINE)
                     ENDIF
                  ENDIF
               ENDDO
               IF (OK) THEN
                  ICOUNT = ICOUNT + N1
                  IHIST = IHIST + N1
                  IF (IHIST.GT.NHIST) THEN
                     IHIST = NHIST
                     DO I = N1, NHIST - N1
                        HISTRY(I) = HISTRY(I + N1)
                     ENDDO
                  ENDIF
                  WRITE (HISTRY(IHIST),250) JCOUNT, ICOUNT,
     +'All columns centralised/scaled to mean = 0, st.dev. = 1'
                  CALL PUTADV (HISTRY(IHIST))
                  DO J = N1, NCOLS
                     DO I = N1, NROWS
                        A(I,J) = (A(I,J) - X(J))/Y(J)
                     ENDDO
                  ENDDO
               ENDIF
            ELSE
               CALL PUTFAT ('Columns cannot be transformed')
            ENDIF   
         ELSEIF (NUMDEC.EQ.6) THEN
C
C NUMDEC = 6: Transform a row
C ===========
C
            IF (ROWS) THEN
               I = ISAV
               J = NROWS
               CALL GETJM1 (N1, I, J,
     +'No. of the row to be transformed (0 to cancel)')
               IF (I.GT.N0) THEN
                  DO J = N1, NCOLS
                     X(J) = A(I,J)
                  ENDDO
                  CALL VECTRN (NCOLS,
     +                         X, Y,
     +                         ABORT)
                  IF (.NOT.ABORT) THEN
                     ICOUNT = ICOUNT + N1
                     IHIST = IHIST + N1
                     ISAV = I
                     IF (IHIST.GT.NHIST) THEN
                        IHIST = NHIST
                        DO I = N1, NHIST - N1
                           HISTRY(I) = HISTRY(I + N1)
                        ENDDO
                     ENDIF
                     WRITE (HISTRY(IHIST),200) JCOUNT, ICOUNT,
     +                     'Transformed row', ISAV
                     DO J = N1, NCOLS
                        A(ISAV,J) = Y(J)
                     ENDDO
                  ENDIF
               ENDIF
            ELSE
               CALL PUTFAT ('Rows cannot be transformed')
            ENDIF
         ELSEIF (NUMDEC.EQ.7) THEN
C
C NUMDEC = 7: Normalise all rows to unit length
C ===========
C
            IF (ROWS) THEN
               OK = .TRUE.
               DO I = N1, NROWS
                  IF (OK) THEN
                     X(I) = ZERO
                     DO J = N1, NCOLS
                        X(I) = X(I) + A(I,J)*A(I,J)
                     ENDDO
                     IF (X(I).GT.RTOL) THEN
                        X(I) = SQRT(X(I))
                     ELSE
                        OK = .FALSE.
                        WRITE (LINE,400) 'zero', 'row', I
                        CALL PUTFAT (LINE)
                     ENDIF
                  ENDIF
               ENDDO
               IF (OK) THEN
                  ICOUNT = ICOUNT + N1
                  IHIST = IHIST + N1
                  IF (IHIST.GT.NHIST) THEN
                     IHIST = NHIST
                     DO I = N1, NHIST - N1
                        HISTRY(I) = HISTRY(I + N1)
                     ENDDO
                  ENDIF
                  WRITE (HISTRY(IHIST),250) JCOUNT, ICOUNT,
     +'All rows normalised to unit length'
                  CALL PUTADV (HISTRY(IHIST))
                  DO I = N1, NROWS
                     DO J = N1, NCOLS
                        A(I,J) = A(I,J)/X(I)
                     ENDDO
                  ENDDO
               ENDIF
            ELSE
               CALL PUTFAT ('Rows cannot be transformed')
            ENDIF
        ELSEIF (NUMDEC.EQ.8) THEN
C
C NUMDEC = 8: Normalise all rows to s = 1
C ===========
C
            IF (ROWS) THEN
               OK = .TRUE.
               DO I = N1, NROWS
                  IF (OK) THEN
                     XBAR = ZERO
                     SSQ = ZERO
                     DO J = N1, NCOLS
                        XBAR = XBAR + A(I,J)
                     ENDDO
                     XBAR = XBAR/DBLE(NCOLS)
                     DO J = N1, NCOLS
                        SSQ = SSQ + (A(I,J) - XBAR)**2
                     ENDDO
                     SSQ = SSQ/DBLE(NCOLS - N1)
                     STDEV = SQRT(SSQ)
                     IF (STDEV.GT.RTOL) THEN
                        Y(I) = STDEV
                     ELSE
                        OK = .FALSE.
                        WRITE (LINE,400) 'constant', 'row', I
                        CALL PUTFAT (LINE)
                     ENDIF
                  ENDIF
               ENDDO
               IF (OK) THEN
                  ICOUNT = ICOUNT + N1
                  IHIST = IHIST + N1
                  IF (IHIST.GT.NHIST) THEN
                     IHIST = NHIST
                     DO I = N1, NHIST - N1
                        HISTRY(I) = HISTRY(I + N1)
                     ENDDO
                  ENDIF
                  WRITE (HISTRY(IHIST),250) JCOUNT, ICOUNT,
     +'All rows scaled to st.dev. = 1'
                  CALL PUTADV (HISTRY(IHIST))
                  DO I = N1, NROWS
                     DO J = N1, NCOLS
                        A(I,J) = A(I,J)/Y(I)
                     ENDDO
                  ENDDO
               ENDIF
            ELSE
               CALL PUTFAT ('Rows cannot be transformed')
            ENDIF                        
         ELSEIF (NUMDEC.EQ.9) THEN
C
C NUMDEC = 9: centralise all rows to mu = 0
C ===========
C
            IF (ROWS) THEN
               DO I = N1, NROWS
                  XBAR = ZERO
                  DO J = N1, NCOLS
                     XBAR = XBAR + A(I,J)
                  ENDDO
                  XBAR = XBAR/DBLE(NCOLS)
                  X(I) = XBAR
               ENDDO
               ICOUNT = ICOUNT + N1
               IHIST = IHIST + N1
               IF (IHIST.GT.NHIST) THEN
                  IHIST = NHIST
                  DO I = N1, NHIST - N1
                     HISTRY(I) = HISTRY(I + N1)
                  ENDDO
               ENDIF
               WRITE (HISTRY(IHIST),250) JCOUNT, ICOUNT,
     +'All rows centralised to mean = 0'
               CALL PUTADV (HISTRY(IHIST))
               DO I = N1, NROWS
                  DO J = N1, NCOLS
                     A(I,J) = A(I,J) - X(I)
                  ENDDO
               ENDDO
            ELSE
               CALL PUTFAT ('Rows cannot be transformed')
            ENDIF
        ELSEIF (NUMDEC.EQ.10) THEN
C
C NUMDEC = 10: Normalise all rows to mu = 0, s = 1
C ===========
C
            IF (ROWS) THEN
               OK = .TRUE.
               DO I = N1, NROWS
                  IF (OK) THEN
                     XBAR = ZERO
                     SSQ = ZERO
                     DO J = N1, NCOLS
                        XBAR = XBAR + A(I,J)
                     ENDDO
                     XBAR = XBAR/DBLE(NCOLS)
                     DO J = N1, NCOLS
                        SSQ = SSQ + (A(I,J) - XBAR)**2
                     ENDDO
                     SSQ = SSQ/DBLE(NCOLS - N1)
                     STDEV = SQRT(SSQ)
                     IF (STDEV.GT.RTOL) THEN
                        X(I) = XBAR
                        Y(I) = STDEV
                     ELSE
                        OK = .FALSE.
                        WRITE (LINE,400) 'constant', 'row', I
                        CALL PUTFAT (LINE)
                     ENDIF
                  ENDIF
               ENDDO
               IF (OK) THEN
                  ICOUNT = ICOUNT + N1
                  IHIST = IHIST + N1
                  IF (IHIST.GT.NHIST) THEN
                     IHIST = NHIST
                     DO I = N1, NHIST - N1
                        HISTRY(I) = HISTRY(I + N1)
                     ENDDO
                  ENDIF
                  WRITE (HISTRY(IHIST),250) JCOUNT, ICOUNT,
     +'All rows centralised/scaled to mean = 0, st.dev. = 1'
                  CALL PUTADV (HISTRY(IHIST))
                  DO I = N1, NROWS
                     DO J = N1, NCOLS
                        A(I,J) = (A(I,J) - X(I))/Y(I)
                     ENDDO
                  ENDDO
               ENDIF
            ELSE
               CALL PUTFAT ('Rows cannot be transformed')
            ENDIF            
         ELSEIF (NUMDEC.EQ.11) THEN
C
C NUMDEC = 11: Transform whole matrix
C ===========
C
C**********Start of code to transform whole matrix
C*************************************************
C
            WRITE (TEXT,500)
            NUMOPT = 13
            NDEC = NUMOPT
            CALL LVIEW2 (IXL, IYL, NDEC, NUMOPT,
     +                   TEXT,
     +                   TITLES)
            OK = .TRUE.
            IF (NDEC.EQ.1) THEN
C
C NDEC = 1: Add ...
C
               CALL WPARAM (CONST)
               IF (ABS(CONST).GT.ZERO) THEN
                  OK = .TRUE.
                  DO J = N1, NCOLS
                     DO I = N1, NROWS
                        A(I,J) = A(I,J) + CONST
                     ENDDO
                  ENDDO
                  WRITE (LINE,300) JCOUNT, ICOUNT + N1,
     +'All x := x + k, for k =',CONST
               ELSE
                  OK = .FALSE.
               ENDIF
            ELSEIF (NDEC.EQ.2) THEN
C
C NDEC = 2: Subtract ...
C
               CALL WPARAM (CONST)
               IF (ABS(CONST).GT.ZERO) THEN
                  OK = .TRUE.
                  DO J = N1, NCOLS
                     DO I = N1, NROWS
                        A(I,J) = A(I,J) - CONST
                     ENDDO
                  ENDDO
                  WRITE (LINE,300) JCOUNT, ICOUNT + N1,
     +'All x := x - k, for k =',CONST
               ELSE
                  OK = .FALSE.
               ENDIF
            ELSEIF (NDEC.EQ.3) THEN
C
C NDEC = 3: Multiply ...
C
               CALL WPARAM (CONST)
               IF (ABS(CONST - ONE).GT.RTOL) THEN
                  OK = .TRUE.
                  DO J = N1, NCOLS
                     DO I = N1, NROWS
                        A(I,J) = A(I,J)*CONST
                     ENDDO
                  ENDDO
                  WRITE (LINE,300) JCOUNT, ICOUNT + N1,
     +'All x := k*x, for k =', CONST
               ELSE
                  OK = .FALSE.
               ENDIF
            ELSEIF (NDEC.EQ.4) THEN
C
C NDEC = 4: Divide ...
C
               CALL WPARAM (CONST)
               IF (ABS(CONST - ONE).GT.RTOL .AND.
     +             ABS(CONST).GT.RTOL) THEN
                  OK = .TRUE.
                  DO J = N1, NCOLS
                     DO I = N1, NROWS
                        A(I,J) = A(I,J)/CONST
                     ENDDO
                  ENDDO
                  WRITE (LINE,300) JCOUNT, ICOUNT + N1,
     +'All x := x/k, for k =', CONST
               ELSE
                  OK = .FALSE.
               ENDIF
            ELSEIF (NDEC.EQ.5) THEN
C
C NDEC = 5: Divide into
C
               CALL WPARAM (CONST)
               OK = .TRUE.
               DO J = N1, NCOLS
                  IF (OK) THEN
                     DO I = N1, NROWS
                        IF (OK) THEN
                           IF (ABS(A(I,J)).LE.RTOL) THEN
                               OK = .FALSE.
                               WRITE (LINE,700) I, J, A(I,J)
                               CALL PUTFAT (LINE)
                           ENDIF
                        ENDIF
                     ENDDO
                  ENDIF
               ENDDO
               IF (OK) THEN
                  WRITE (LINE,300) JCOUNT, ICOUNT + N1,
     +'All x := k/x, for k =', CONST
                  DO J = N1, NCOLS
                     DO I = N1, NROWS
                        A(I,J) = CONST/A(I,J)
                     ENDDO
                  ENDDO
               ENDIF
            ELSEIF (NDEC.EQ.6) THEN
C
C NDEC = 6: x^k
C
               CALL WPARAM (CONST)
               IF (CONST.GE.RTOL) THEN
                  OK = .TRUE.
                  IF (CONST.GE.TWO) THEN
                     K = NINT(CONST)
                     TEMP = DBLE(K)
                     IF (ABS(TEMP - CONST).LE.SMALL) THEN
                        LOOP = .TRUE.
                     ELSE
                        LOOP = .FALSE.
                     ENDIF
                  ELSE
                     LOOP = .FALSE.
                  ENDIF
                  IF (.NOT.LOOP) THEN
                     DO J = N1, NCOLS
                        IF (OK) THEN
                           DO I = N1, NROWS
                              IF (OK) THEN
                                 IF (A(I,J).LE.RTOL) THEN
                                     OK = .FALSE.
                                     WRITE (LINE,700) I, J, A(I,J)
                                     CALL PUTFAT (LINE)
                                 ENDIF
                              ENDIF
                           ENDDO
                        ENDIF
                     ENDDO
                  ENDIF
               ELSE
                  WRITE (LINE,800)
                  CALL PUTFAT (LINE)
                  OK = .FALSE.
               ENDIF
               IF (OK) THEN
                  WRITE (LINE,300) JCOUNT, ICOUNT + N1,
     +'All x := x^k, for k =', CONST
                  IF (LOOP) THEN
                     DO J = N1, NCOLS
                        DO I = N1, NROWS
                           TEMP = A(I,J)
                           DO L = 2, K
                              TEMP = TEMP*A(I,J)
                           ENDDO
                           A(I,J) = TEMP
                        ENDDO
                     ENDDO
                  ELSE
                     DO J = N1, NCOLS
                        DO I = N1, NROWS
                           A(I,J) = (A(I,J))**CONST
                        ENDDO
                     ENDDO
                  ENDIF
               ENDIF
            ELSEIF (NDEC.EQ.7) THEN
C
C NDEC = 7: k^x
C
               CALL WPARAM (CONST)
               IF (CONST.GE.RTOL) THEN
                  OK = .TRUE.
                  WRITE (LINE,300) JCOUNT, ICOUNT + N1,
     +'All x := k^x, for k =', CONST
                  DO J = N1, NCOLS
                     DO I = N1, NROWS
                        A(I,J) = CONST**(A(I,J))
                     ENDDO
                  ENDDO
               ELSE
                  WRITE (LINE,800)
                  CALL PUTFAT (LINE)
                  OK = .FALSE.
               ENDIF
            ELSEIF (NDEC.EQ.8) THEN
C
C NDEC = 8: log
C
               OK = .TRUE.
               DO J = N1, NCOLS
                  IF (OK) THEN
                     DO I = N1, NROWS
                        IF (OK) THEN
                           IF (A(I,J).LE.RTOL) THEN
                               OK = .FALSE.
                               WRITE (LINE,700) I, J, A(I,J)
                               CALL PUTFAT (LINE)
                           ENDIF
                        ENDIF
                     ENDDO
                  ENDIF
               ENDDO
               IF (OK) THEN
                  J = 10
                  WRITE (TEXT,600)
                  CALL LISTBX (NLOG, J,
     +                         TEXT)
                  LOG_E = .FALSE.
                  LOG_10 = .FALSE.
                  IF (NLOG.EQ.1) THEN
                     BASE = 'e '
                     LOG_E = .TRUE.
                  ELSEIF (NLOG.EQ.10) THEN
                     BASE = '10'
                     LOG_10 = .TRUE.
                  ELSE
                     WRITE (BASE,'(I1,1X)') NLOG
                     FACTOR = LOG(DBLE(NLOG))
                  ENDIF
                  WRITE (LINE,250) JCOUNT, ICOUNT + N1,
     +'All x := log(x), base'//BLANK//BASE
                  IF (LOG_E) THEN
                     DO J = N1, NCOLS
                        DO I = N1, NROWS
                           A(I,J) = LOG(A(I,J))
                        ENDDO
                     ENDDO
                  ELSEIF (LOG_10) THEN
                     DO J = N1, NCOLS
                        DO I = N1, NROWS
                           A(I,J) = LOG10(A(I,J))
                        ENDDO
                     ENDDO
                  ELSE
                     DO J = N1, NCOLS
                        DO I = N1, NROWS
                           A(I,J) = LOG(A(I,J))/FACTOR
                        ENDDO
                     ENDDO
                  ENDIF
               ENDIF
            ELSEIF (NDEC.EQ.9) THEN
C
C NDEC = 9: logit
C
               CALL WPARAM (CONST)
               OK = .TRUE.
               DO J = N1, NCOLS
                  IF (OK) THEN
                     DO I = N1, NROWS
                        IF (OK) THEN
                           TEMP = CONST - A(I,J)
                           IF (ABS(CONST).GT.RTOL) THEN
                              IF (A(I,J)/TEMP.LE.RTOL) THEN
                                  OK = .FALSE.
                                  WRITE (LINE,700) I, J, A(I,J)
                                  CALL PUTFAT (LINE)
                              ENDIF
                           ELSE
                              OK = .FALSE.
                              WRITE (LINE,700) I, J, A(I,J)
                              CALL PUTFAT (LINE)
                           ENDIF
                        ENDIF
                     ENDDO
                  ENDIF
               ENDDO
               IF (OK) THEN
                  J = 10
                  WRITE (TEXT,600)
                  CALL LISTBX (NLOG, J,
     +                         TEXT)
                  LOG_E = .FALSE.
                  LOG_10 = .FALSE.
                  IF (NLOG.EQ.1) THEN
                     BASE = 'e '
                     LOG_E = .TRUE.
                  ELSEIF (NLOG.EQ.10) THEN
                     BASE = '10'
                     LOG_10 = .TRUE.
                  ELSE
                     WRITE (BASE,'(I1,1X)') NLOG
                     FACTOR = LOG(DBLE(NLOG))
                  ENDIF
                  WRITE (LINE,300) JCOUNT, ICOUNT + N1,
     +'All x := log[x/(x - k)], base'//BLANK//BASE//', k =', CONST
                  IF (LOG_E) THEN
                     DO J = N1, NCOLS
                        DO I = N1, NROWS
                           A(I,J) = LOG(A(I,J)/(CONST - A(I,J)))
                        ENDDO
                     ENDDO
                  ELSEIF (LOG_10) THEN
                     DO J = N1, NCOLS
                        DO I = N1, NROWS
                           A(I,J) = LOG10(A(I,J)/(CONST - A(I,J)))
                        ENDDO
                     ENDDO
                  ELSE
                     DO J = N1, NCOLS
                        DO I = N1, NROWS
                           A(I,J) = LOG(A(I,J)/(CONST - A(I,J)))/FACTOR
                        ENDDO
                     ENDDO
                  ENDIF
               ENDIF
            ELSEIF (NDEC.EQ.10) THEN
C
C NDEC = 10: Phi(x)
C
               OK = .TRUE.
               DO J = N1, NCOLS
                  IF (OK) THEN
                     DO I = N1, NROWS
                        IF (OK) THEN
                           IFAIL = 0
                           B(I,J) = G01EAFG('L', A(I,J), IFAIL)
                           IF (IFAIL.NE.0) THEN
                              WRITE (LINE,700) I, J, A(I,J)
                              CALL PUTFAT (LINE)
                              OK = .FALSE.
                           ENDIF
                        ENDIF
                     ENDDO
                  ENDIF
               ENDDO
               IF (OK) THEN
                  DO J = N1, NCOLS
                     DO I = N1, NROWS
                        A(I,J) = B(I,J)
                     ENDDO
                  ENDDO
                  WRITE (LINE,250) JCOUNT, ICOUNT + N1,
     +'All x := Phi(x)'
               ENDIF
            ELSEIF (NDEC.EQ.11) THEN
C
C NDEC = 11: Phi^{-1}(x)
C
               OK = .TRUE.
               DO J = N1, NCOLS
                  IF (OK) THEN
                     DO I = N1, NROWS
                        IF (OK) THEN
                           IF (A(I,J).GE.PMIN .AND. A(I,J).LE.PMAX) THEN
                              IFAIL = 0
                              B(I,J) = G01FAFG('L', A(I,J), IFAIL)
                              IF (IFAIL.NE.0) THEN
                                 WRITE (LINE,700) I, J, A(I,J)
                                 CALL PUTFAT (LINE)
                                 OK = .FALSE.
                              ENDIF
                           ELSE
                              WRITE (LINE,700) I, J, A(I,J)
                              CALL PUTFAT (LINE)
                              OK = .FALSE.
                           ENDIF
                        ENDIF
                     ENDDO
                  ENDIF
               ENDDO
               IF (OK) THEN
                  DO J = N1, NCOLS
                     DO I = N1, NROWS
                        A(I,J) = B(I,J)
                     ENDDO
                  ENDDO
                  WRITE (LINE,250) JCOUNT, ICOUNT + N1,
     +'All x := Phi_inverse(x)'
               ENDIF
            ELSEIF (NDEC.EQ.12) THEN
C
C NDEC = 12: Trig/Hyperbolic
C
               DO J = 1, NCOLS
                  DO I = 1, NROWS
                     B(I,J) = A(I,J)
                  ENDDO
               ENDDO
               CALL TRIGMT (NCOLS, NROWS, NROWS, NTRIG,
     +                      B,
     +                      ABORT)
               OK = .NOT.ABORT
               IF (OK) THEN
                  DO J = N1, NCOLS
                     DO I = N1, NROWS
                        A(I,J) = B(I,J)
                     ENDDO
                  ENDDO
                  WRITE (LINE,250) JCOUNT, ICOUNT + N1,
     +'All x := Trig/Hyperbolic transform'
               ENDIF
            ELSEIF (NDEC.EQ.NUMOPT) THEN
C
C NDEC = NUMOPT ... Cancel
C
               OK = .FALSE.
            ENDIF
            IF (OK) THEN
               ICOUNT = ICOUNT + N1
               IHIST = IHIST + N1
               IF (IHIST.GT.NHIST) THEN
                  IHIST = NHIST
                  DO I = N1, NHIST - N1
                     HISTRY(I) = HISTRY(I + N1)
                  ENDDO
               ENDIF
               HISTRY(IHIST) = LINE(1:80)
               CALL PUTADV (HISTRY(IHIST))
            ENDIF
C
C********End of code to transform whole matrix
C*********************************************
C
         ELSEIF (NUMDEC.EQ.12) THEN
C
C NUMDEC = 12: Edit
C ===========
C
            IF (COLS .AND. ROWS) THEN
               LINE = 'Current edited matrix'
               CALL EDITOR (JSEND, JTYPE, NCOLS, NRMAX, NROWS,
     +                      A,
     +                      LINE,
     +                      CURVE, FIXCOL, FIXROW, LABEL, ORDER, WEIGHT)
               ICOUNT = ICOUNT + N1
               IHIST = IHIST + N1
               IF (IHIST.GT.NHIST) THEN
                  IHIST = NHIST
                  DO I = N1, NHIST - N1
                     HISTRY(I) = HISTRY(I + N1)
                  ENDDO
               ENDIF
               WRITE (HISTRY(IHIST),250) JCOUNT, ICOUNT,
     +'Matrix edited interactively'
               CALL PUTADV (HISTRY(IHIST))
            ELSE
               CALL PUTFAT ('Not allowed in this mode')
            ENDIF
         ELSEIF (NUMDEC.EQ.13) THEN
C
C NUMDEC = 13: Display A
C ===========
C
            LINE = 'Current edited matrix'
            NCMAX = NCOLS
            CALL DSPLAY (NCMAX, NCOLS, NF, NRMAX, NROWS, NTYPE,
     +                   A,
     +                   LINE,
     +                   FILEIT)
         ELSEIF (NUMDEC.EQ.14) THEN
C
C NUMDEC = 14: Display ASAV
C ============
C
            LINE = 'Original matrix'
            NCMAX = NCOLS
            CALL DSPLAY (NCOLS, NCOLS, NF, NROWS, NROWS, NTYPE,
     +                   ASAV,
     +                   LINE,
     +                   FILEIT)
         ELSEIF (NUMDEC.EQ.15) THEN
C
C NUMDEC = 15: Display ASAV - A
C ============
C
            DO J = 1, NCOLS
               DO I = 1, NROWS
                  TEMP = (ASAV(I,J) - A(I,J))/
     +                   (ABS(ASAV(I,J)) + ABS(A(I,J)) + RTOL)
                  IF (ABS(TEMP).LE.VSMALL) THEN
                     B(I,J) = ZERO
                  ELSE
                     B(I,J) = ASAV(I,J) - A(I,J)
                  ENDIF
               ENDDO
            ENDDO
            LINE = 'Difference = Original - Edited'
            NCMAX = NCOLS
            CALL DSPLAY (NCOLS, NCOLS, NF, NROWS, NROWS, NTYPE,
     +                   B,
     +                   LINE,
     +                   FILEIT)
         ELSEIF (NUMDEC.EQ.16) THEN
C
C NUMDEC = 16: History
C ============
C
            J = 15
            CALL TABLE1 (J, 'OPEN')
            WRITE (LINE,900)
            J = 4
            CALL TABLE1 (J,LINE)
            J = 0
            DO I = N1, IHIST
               CALL TABLE1 (J, HISTRY(I))
            ENDDO
            CALL TABLE1 (J, 'CLOSE')
         ELSEIF (NUMDEC.EQ.NUMOPT - 2) THEN
C
C NUMDEC = NUMOPT - 2: Help
C ============
C
            WRITE (TEXT,1000)
            NUMTXT = 20
            NUMBLD(1) = N1
            CALL PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMTXT,
     +                   TEXT,
     +                   FIXED)
            NUMBLD(1) = N0
         ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
C
C NUMDEC = NUMOPT - 1: Accept
C ====================
C
            IF (ICOUNT.GT.0) THEN
               CALL PUTADV (TEXT(6))
               IF (ISEND.LT.4) THEN
                  NUMTRN = NUMTRN + N1
                  WRITE (WORD4,'(I4)') NUMTRN
                  CALL TRIML1 (WORD4)
                  TITLE = 'Edit/Transform Number '//WORD4
                  WRITE (LINE,1100)
                  CALL GETSTR (LINE, TITLE)
               ENDIF
            ELSE
               WRITE (LINE,1200)
               CALL PUTADV (LINE)
            ENDIF
            REPEET = .FALSE.
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C NUMDEC = NUMOPT: Cancel
C ================
C
            DO J = 1, NCOLS
               DO I = 1, NROWS
                  A(I,J) = ASAV(I,J)
               ENDDO
            ENDDO
            WRITE (LINE,1200)
            CALL PUTADV (LINE)
            REPEET = .FALSE.
         ENDIF
      ENDDO
      DEALLOCATE(ASAV, STAT = IERR)
      DEALLOCATE(B, STAT = IERR)
      DEALLOCATE(X, STAT = IERR)
      DEALLOCATE(Y, STAT = IERR)
C
C Format statements
C
  100 FORMAT (
     + 'Options to edit or transform a data matrix'
     +/ 
     +/'Title of this data set is:'
     +/A
     +/
     +/'Columns =',1X,A,'Rows =',1X,A,'Session =',1X,A,'Changes =',1X,A
     +/
     +/'Columns: transform individually',1X,A
     +/'Columns: scale all to unit length',1X,A
     +/'Columns: scale all to st.dev. = 1',1X,A
     +/'Columns: centralise all to mean = 0',1X,A
     +/'Columns: centralise/scale all to mean = 0, st.dev. = 1',1X,A
     +/'Rows: transform individually',1X,A
     +/'Rows: scale all to unit length',1X,A
     +/'Rows: scale all to st.dev. = 1',1X,A
     +/'Rows: centralise all to mean = 0',1X,A
     +/'Rows: centralise/scale all to mean = 0, std.dev. = 1',1X,A
     +/'All matrix: transform',1X,A
     +/'All matrix: edit',1X,A
     +/'View: current matrix, B'
     +/'View: original matrix, A'
     +/'View: difference, A - B'
     +/'History'
     +/'Help'
     +/'Apply ... accept editing'
     +/'Cancel ... discard editing')
  200 FORMAT (I7,',',I5,':',2X,A,I6,A)
  250 FORMAT (I7,',',I5,':',2X,A)
  300 FORMAT (I7,',',I5,':',2X,A,1P,E11.3)
  400 FORMAT (A,' vector encountered at ',A,I6)
  500 FORMAT (
     + 'Transformation       `Effect produced on all matrix'
     +/'x := x + k           `Add'
     +/'x := x - k           `Subtract'
     +/'x := k*x             `Multiply'
     +/'x := x/k             `Divide'
     +/'x := k/x             `Reciprocate'
     +/'x := x^k             `Power'
     +/'x := k^x             `Exponentiate'
     +/'x := log(x)          `log (any base)'
     +/'x := log[x/(k - x)]  `logit (any base)'
     +/'x := Phi(x)          `N(0,1) cdf'
     +/'x := Phi_inverse(x)  `N(0,1) inverse'
     +/'x := arcsin,sinh,etc.`Trig/Hyperbolic'
     +/'Cancel               `No transformation')
  600 FORMAT (
     + 'log to base e'
     +/'log to base 2'
     +/'log to base 3'
     +/'log to base 4'
     +/'log to base 5'
     +/'log to base 6'
     +/'log to base 7'
     +/'log to base 8'
     +/'log to base 9'
     +/'log to base 10')
  700 FORMAT (
     +'Illegal value encountered: A(',I6,',',I3,') =',1P,E11.3)
  800 FORMAT ('k must be positive for this transformation')
  900 FORMAT ('Session  Edit   Procedure')
 1000 FORMAT (
     + 'Transforming and editing data interactively'
     +/
     +/'It is not often necessary to transform data files, as Simfit'
     +/'can do all the usual transformations, like square root, log,'
     +/'arcsin, log[x/(1 - x)], etc. interactively as required before'
     +/'analysis or graph plotting. You now have the option to edit or'
     +/'transform the current data set, but note some important points.'
     +/
     +/'1)`Simfit will only overwrite your original data in a file if'
     +/'  `this is specifically requested, i.e., there is no automatic'
     +/'  `Save ..., but only a Save As ... facility.'
     +/'2)`Because of this there is no Undo function, as you can always'
     +/'  `open the original data file again if you want to Undo.'
     +/'3)`If a transformation is not possible (e.g. log(x) for x < 0),'
     +/'  `then no elements of any rows or columns will be transformed.'
     +/'4)`It is (usually) impossible to re-scale all rows and columns'
     +/'  `of a matrix to unit or standard vectors at the same time.'
     +/'5)`Each time this control is used, a counter is intialised to 0'
     +/'  `then incremented to record editing history for recall.'
     +/'6)`After editing you must change the title to avoid confusion.')
 1100 FORMAT ('Matrix has been edited/transformed so input a new title')
 1200 FORMAT ('The matrix remains unchanged')
      END
