C
C
      SUBROUTINE MIDDLE (XBOT, XMID, XTOP)
C
C ACTION : IF XMID < XBOT SET XMID = XBOT
C          IF XMID > XTOP SET XMID = XTOP
C AUTHOR : W. G. BARDSLEY, UNIVERSITY OF MANCHESTER, U.K., 23/3/92
C          No test for XBOT >= XBOT for fast execution, .e.g. exponentials
C          26/02/2007 added INTENTS
C          14/07/2022 dealt with the unusual case when XBOT > XTOP
C
      IMPLICIT NONE
C
C Arguments
C      
      DOUBLE PRECISION, INTENT (IN)    :: XBOT, XTOP  
      DOUBLE PRECISION, INTENT (INOUT) :: XMID
C
C Locals
C
      DOUBLE PRECISION XBOT1, XTOP1  
      INTRINSIC MAX, MIN
      IF (XBOT.LT.XTOP) THEN
C
C The usual case
C        
         IF (XMID.LT.XBOT) THEN
            XMID = XBOT
         ELSEIF (XMID.GT.XTOP) THEN
            XMID = XTOP
         ENDIF
      ELSE
C
C The unusual case
C        
         XBOT1 = MIN(XBOT,XTOP)
         XTOP1 = MAX(XBOT,XTOP)  
         IF (XMID.LT.XBOT1) THEN
            XMID = XBOT1
         ELSEIF (XMID.GT.XTOP1) THEN
            XMID = XTOP1
         ELSE
            XMID = XBOT   
         ENDIF
      ENDIF
      END
C
C
