C
C NAG substitute routines from maths.dll to make the graphics.dll
C free standing. Routines end in G not $ so there will be no clashes.
C
C G01EAF
C G01EBF
C G01EEF
C G01FAF
C G01FBF
C G01FCF
C G01FDF
C G01FEF
C
      DOUBLE PRECISION FUNCTION G01EAFG(TAIL, X, IFAIL)
C
C ACTION : Tails of the normal distribution
C AUTHOR : W.G.Bardsley, University of Manchester, 3/3/97
C          Just calls S15ABF$
C ADVICE : This version does not check IFAIL on entry so it
C          is equivalent to soft fail, IFAIL = 1
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION X
      CHARACTER  TAIL*(*)
C
C Local variables
C
      INTEGER    I
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      DOUBLE PRECISION S15ABFG, XTEMP
      CHARACTER  C*1
      EXTERNAL   S15ABFG
      INTRINSIC  ABS
C
C Is it safe ?
C
      IFAIL = 0
      I = 1
      C = TAIL(1:1)
      IF (C.EQ.'L' .OR. C.EQ.'l') THEN
C
C Lower tail
C
         XTEMP = X
         G01EAFG = S15ABFG(XTEMP, I)
      ELSEIF (C.EQ.'U' .OR. C.EQ.'u') THEN
C
C Upper tail
C
         XTEMP = X
         G01EAFG = ONE - S15ABFG(XTEMP, I)
      ELSEIF (C.EQ.'S' .OR. C.EQ.'s') THEN
C
C Two tail sig. level
C
         XTEMP =  ABS(X)
         G01EAFG = TWO*(ONE - S15ABFG(XTEMP, I))
      ELSEIF (C.EQ.'C' .or. C.eq.'c') THEN
C
C Confidence interval
C
         XTEMP = ABS(X)
         G01EAFG = TWO*S15ABFG(XTEMP, I) - ONE
      ELSE
C
C Faulty argument
C
         G01EAFG = ZERO
         IFAIL = 1
         RETURN
      ENDIF
C
C Make sure the value is in range (0,1)
C
      IF (G01EAFG.LT.ZERO) THEN
         G01EAFG = ZERO
      ELSEIF (G01EAFG.GT.ONE) THEN
         G01EAFG = ONE
      ENDIF
      END
C
C
      DOUBLE PRECISION FUNCTION G01EBFG(TAIL, T, DF, IFAIL)
C
C ACTION : The t distribution
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 12/3/97
C
C          After:- ACM 395 Hill Comm ACM vol 13 no. 10 p 617-619
C          The code always sets AREA to the lower tail area then
C          corrects as required by TAIL
C
C          Note that The entry value of IFAIL is not tested so it is
C          equivalent to soft fail with IFAIL = 1
C
C          02/10/2000 revised for large/small t
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION T, DF
      CHARACTER  TAIL*(*)
C
C Local variables
C
      INTEGER    I
      DOUBLE PRECISION ZERO, HALF, ONE, TWO, TWENTY
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00,
     +           TWO = 2.0D+00, TWENTY = 20.0D+00)
      DOUBLE PRECISION EPSI, TOL
      PARAMETER (EPSI = 1.0D-32, TOL = 1.0D-06)
      DOUBLE PRECISION TMAX, TMIN
      PARAMETER (TMAX = 1.0D+10, TMIN = - TMAX)
      DOUBLE PRECISION AREA, BETA, PDFVAL, PVAL, QVAL, R, S, TOLVAL,
     +                 TVAL
      DOUBLE PRECISION A, B, BOT, CHI, TOP, Z
      DOUBLE PRECISION G01EAFG
      CHARACTER  C*1
      EXTERNAL   G01EAFG, G01EEFG
      INTRINSIC  ABS, SQRT, LOG
C
C Initialise and check
C
      IFAIL = 0
      G01EBFG = ZERO
      C = TAIL(1:1)
      IF (C.EQ.'L' .OR. C.EQ.'l') THEN
         TVAL = T
         C = 'L'
      ELSEIF (C.EQ.'U' .OR. C.EQ.'u') THEN
         TVAL = T
         C = 'U'
      ELSEIF (C.EQ.'S' .OR. C.EQ.'s') THEN
         IF (T.GT.ZERO) THEN
            TVAL = - T
         ELSE
            TVAL = T
         ENDIF
         C = 'S'
      ELSEIF (C.EQ.'C' .OR. C.EQ.'c') THEN
         IF (T.GT.ZERO) THEN
            TVAL = - T
         ELSE
            TVAL = T
         ENDIF
         C = 'C'
      ELSE
         IFAIL = 1
         RETURN
      ENDIF
      IF (DF.LE.ZERO) THEN
         IFAIL = 2
         RETURN
      ENDIF
      IF (T.LT.TMIN) THEN
C
C T very small
C
         AREA = ZERO
      ELSEIF (T.GT.TMAX) THEN
C
C T very large
C
         AREA = ONE
      ELSEIF (ABS(T).LE.EPSI) THEN
C
C The special case T = 0
C
         AREA = HALF
      ELSEIF (DF.LT.TWENTY) THEN
C
C Use a Beta distribution for n < 20
C
         BETA = DF/(DF + T**2)
         R = DF/TWO
         S = HALF
         TOLVAL = TOL
         I = 1
         CALL G01EEFG(BETA, R, S, TOLVAL, PVAL, QVAL, PDFVAL, I)
         IF (TVAL.LE.ZERO) THEN
            AREA = HALF*PVAL
         ELSE
            AREA = HALF + HALF*QVAL
         ENDIF
      ELSE
C
C Use a Cornish-Fisher expansion for n > 20
C
         A = DF - HALF
         B = 48.0D+00*A**2
         Z = SQRT(A*LOG(ONE + TVAL**2/DF))
         CHI = Z
         CHI = CHI + Z*(Z**2 + 3.0D+00)/B
         TOP = Z*(4.0D+00*Z**6 + 33.0D+00*Z**4 + 240.0D+00*Z**2 +
     +            855.0D+00)
         BOT = 10.0D+00*B*(B + 0.8D+00*Z**4 + 100.0D+00)
         CHI = CHI - TOP/BOT
         IF (C.EQ.'L' .OR. C.EQ.'U') THEN
            IF (T.LT.ZERO .AND. CHI.GT.ZERO) CHI = - CHI
         ELSEIF (C.EQ.'C' .OR. C.EQ.'S') THEN
            IF (CHI.GT.ZERO) CHI = - CHI
         ENDIF
         I = 1
         AREA = G01EAFG('L', CHI, I)
      ENDIF
      IF (C.EQ.'L') THEN
         G01EBFG = AREA
      ELSEIF (C.EQ.'U') THEN
         G01EBFG = ONE - AREA
      ELSEIF (C.EQ.'C') THEN
         G01EBFG = ONE - TWO*AREA
      ELSE
         G01EBFG = TWO*AREA
      ENDIF
      IF (G01EBFG.LT.ZERO) THEN
         G01EBFG = ZERO
      ELSEIF (G01EBFG.GT.ONE) THEN
         G01EBFG = ONE
      ENDIF
      END
C
C
      SUBROUTINE G01EEFG(XVAL, AVAL, BVAL, TOLVAL, PVAL, QVAL, PDFVAL,
     +                   IFAIL)
C
C ACTION : beta distribution
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 4/3/97
C          AS 63 Majumder and Bhattacharjee, 409-411, 1973
C
C          This version uses log(beta) to avoid underflow problems
C
C          Note: there is no test for IFAIL on entry so it is
C                equivalent to soft fail, i.e. IFAIL = 1
C
      IMPLICIT NONE
      INTEGER   IFAIL
      DOUBLE PRECISION AVAL, BVAL, PVAL, PDFVAL, QVAL, TOLVAL, XVAL
C
C Local variables
C
      INTEGER   I, NS
      DOUBLE PRECISION ZERO, EPSI, ONE
      PARAMETER (ZERO = 0.0D+00, EPSI = 1.0D-10, ONE = 1.0D+00)
      DOUBLE PRECISION ABLIM, XMAX, XMIN, XMIN4
      PARAMETER (ABLIM = 1.0D+06, XMIN = 1.0D-16, XMAX = ONE - XMIN,
     +           XMIN4 = XMIN**4)
      DOUBLE PRECISION ACU, AI, BETA, BETAIN, CX, P, PP, PSQ, Q, QQ,
     +                 RX, TEMP, TERM, X, XX, X1, X2, X3
      DOUBLE PRECISION S14ABFG
      LOGICAL INDEX1
      EXTERNAL S14ABFG
      INTRINSIC ABS, EXP, INT, LOG
C
C Initialise
C
      IFAIL = 0
      PDFVAL = ZERO
      PVAL = ZERO
      QVAL = ZERO
C
C Is it safe ?
C
      IF (XVAL.LT.ZERO .OR. XVAL.GT.ONE) THEN
         IFAIL = 1
         RETURN
      ELSE
         X = XVAL
         IF (X.LE.XMIN4) THEN
            X = XMIN4
         ELSEIF (X.GT.XMAX) THEN
            X = XMAX
         ENDIF
      ENDIF
      IF (AVAL.LE.ZERO .OR. AVAL.GT.ABLIM .OR.
     +    BVAL.LE.ZERO .OR. BVAL.GT.ABLIM) THEN
         IFAIL = 2
         RETURN
      ELSE
         P = AVAL
         Q = BVAL
      ENDIF
      ACU = TOLVAL
      IF (ACU.LT.EPSI) ACU = EPSI
C
C Calculate the normalising factor BETA
C
       I = 1
       X1 = S14ABFG(P, I)
       I = 1
       X2 = S14ABFG(Q, I)
       I = 1
       TEMP = P + Q
       X3 = S14ABFG(TEMP, I)
       TEMP = X1 + X2 - X3
C********************************************
C******BETA = EXP(TEMP)....(original version)
C Use log(beta) instead of beta itself
C********************************************
       BETA = TEMP
C
C Swap tails if recommended
C
       PSQ = P + Q
       CX = ONE - X
       IF (P .LT. PSQ*X) THEN
          INDEX1 = .TRUE.
          XX = CX
          CX = X
          PP = Q
          QQ = P
       ELSE
          INDEX1 = .FALSE.
          XX = X
          PP = P
          QQ = Q
       ENDIF
C
C Set up the iteration
C
       TERM = ONE
       AI = ONE
       BETAIN = ONE
       NS = INT(QQ + CX*PSQ)
       RX = XX/CX
C
C Use Soper's reduction formula
C
   20 CONTINUE
      TEMP = QQ - AI
      IF (NS.EQ.0) RX = XX
   40 CONTINUE
      TERM = TERM*TEMP*RX/(PP + AI)
      BETAIN = BETAIN + TERM
      TEMP = ABS(TERM)
      IF (TEMP.LE.ACU .AND. TEMP.LE.ACU*BETAIN) GOTO 60
      AI = AI + ONE
      NS = NS - 1
      IF (NS.GE.0) GOTO 20
      TEMP = PSQ
      PSQ = PSQ + ONE
      GOTO 40
   60 CONTINUE
C
C Final calculation
C
C******************************************************************
C Use log(beta) rather than beta itself
C ....original version
C     BETAIN = BETAIN*EXP(PP*LOG(XX) + (QQ - ONE)*LOG(CX))/(PP*BETA)
C*******************************************************************
      BETAIN = BETAIN*EXP(PP*LOG(XX) + (QQ - ONE)*LOG(CX) - BETA)/PP
      IF (BETAIN.LT.ZERO) THEN
         BETAIN = ZERO
      ELSEIF (BETAIN.GT.ONE) THEN
         BETAIN = ONE
      ENDIF
      IF (INDEX1) BETAIN = ONE - BETAIN
      PVAL = BETAIN
      QVAL = ONE - PVAL
C*****************************************************
C Use log(beta) instead of beta as in original version
C     PDFVAL = X**(P - ONE)*(ONE - X)**(Q - ONE)/BETA
C*****************************************************
      PDFVAL = EXP((P - ONE)*LOG(X) + (Q - ONE)*LOG(ONE - X) - BETA)
      END
C
C
C
      DOUBLE PRECISION FUNCTION G01FAFG(TAIL, P, IFAIL)
C
C ACTION : % points of the normal distribution
C AUTHOR : W.G.Bardsley, University of Manchester, 3/3/97
C          AS 111 J.D.Beasley and S.G.Springer App Stat 26 118-120, 1977
C ADVICE : This version does not check IFAIL on entry so it
C          is equivalent to soft fail, IFAIL = 1
C          It agrees with the NAG routine to 6 or 7 decimal places but
C          the NAG routine is more accurate in the further figures.
C
      IMPLICIT  NONE
      INTEGER   IFAIL
      DOUBLE PRECISION P
      CHARACTER TAIL*(*)
C
C Local variables
C
      DOUBLE PRECISION ZERO, HALF, ONE
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00)
      DOUBLE PRECISION SPLIT
      PARAMETER (SPLIT = 0.42D+00)
      DOUBLE PRECISION A0, A1, A2, A3, B1, B2, B3, B4, C0, C1, C2,
     +                 C3, D1, D2
      PARAMETER (A0 =   2.50662823884D+00,
     +           A1 = -18.61500062529D+00,
     +           A2 =  41.39119773534D+00,
     +           A3 = -25.44106049637D+00,
     +           B1 =  -8.47351093090D+00,
     +           B2 =  23.08336743743D+00,
     +           B3 = -21.06224101826D+00,
     +           B4 =   3.13082909833D+00,
     +           C0 =  -2.78718931138D+00,
     +           C1 =  -2.29796479134D+00,
     +           C2 =   4.85014127135D+00,
     +           C3 =   2.32121276858D+00,
     +           D1 =   3.54388924762D+00,
     +           D2 =   1.63706781897D+00)
      DOUBLE PRECISION PMAX, PMIN
      PARAMETER (PMIN = 1.0D-300, PMAX = 0.9999999999999999D+00)
      DOUBLE PRECISION BOT, PNEW, PPND, Q, R, TOP
      CHARACTER C*1
      INTRINSIC ABS, SQRT, LOG
C
C Is it safe ?
C
      G01FAFG = ZERO
      IF (P.LT.ZERO .OR. P.GT.ONE) THEN
         IFAIL = 2
         RETURN
      ENDIF
      C = TAIL(1:1)
      IF (C.EQ.'L' .OR. C.EQ.'l') THEN
         PNEW = P
      ELSEIF (C.EQ.'U' .OR. C.EQ.'u') THEN
         PNEW = ONE - P
      ELSEIF (C.EQ.'C' .OR. C.EQ.'c') THEN
         PNEW = P + HALF*(ONE - P)
      ELSEIF (C.EQ.'S' .or. c.eq.'S') THEN
         PNEW = ONE - HALF*P
      ELSE
         IFAIL = 1
         RETURN
      ENDIF
C
C Limit the range
C
      IFAIL = 0
      IF (PNEW.LT.PMIN) THEN
         PNEW = PMIN
      ELSEIF (PNEW.GT.PMAX) THEN
         PNEW = PMAX
      ENDIF
      Q = PNEW - HALF
      IF (ABS(Q).LE.SPLIT) THEN
         R = Q*Q
         TOP = Q*(((A3*R + A2)*R + A1)*R + A0)
         BOT = (((B4*R + B3)*R + B2)*R + B1)*R + ONE
         PPND = TOP/BOT
      ELSE
         IF (Q.GT.ZERO) THEN
            R = ONE - PNEW
         ELSE
            R = PNEW
         ENDIF
         IF (R.GT.ZERO) THEN
            R = SQRT(-LOG(R))
            TOP = ((C3*R + C2)*R + C1)*R + C0
            BOT = (D2*R + D1)*R + ONE
            PPND = TOP/BOT
            IF (Q.LT.ZERO) PPND = -PPND
         ELSE
            PPND = ZERO
         ENDIF
      ENDIF
      G01FAFG = PPND
      IFAIL = 0
      END
C
C
      DOUBLE PRECISION FUNCTION G01FBFG(TAIL, P, DF, IFAIL)
C
C ACTION : Inverse of the t distribution
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 12/3/97
C
C          ACM 396 Hill, G.W. Comm ACM vol 13 no. 10 p 619-620, 1970
C
C          Note that The entry value of IFAIL is not tested so it is
C          equivalent to soft fail with IFAIL = 1
C
C          Special cases are n=1, n=2, n<3, p=1/2 (lower/upper tails)
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION P, DF
      CHARACTER  TAIL*(*)
C
C Local variables
C
      INTEGER    I
      DOUBLE PRECISION ZERO, HALF, ONE, TWO, THREE, FOUR, FIVE, SIX
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00,
     +           TWO = 2.0D+00, THREE = 3.0D+00, FOUR = 4.0D+00,
     +           FIVE = 5.0D+00, SIX = 6.0D+00)
      DOUBLE PRECISION EPSI, PMAX, PMIN, TOL
      PARAMETER (EPSI = 1.0D-32, TOL = 1.0D-06, PMIN = 1.0D-16,
     +           PMAX = ONE - PMIN)
      DOUBLE PRECISION PNEW, PVAL, R, S, TOLVAL, TVAL
      DOUBLE PRECISION PIBY2
      PARAMETER (PIBY2 = 1.5707963268D+00)
      DOUBLE PRECISION A, B, D, E, X, Y
      DOUBLE PRECISION ROOT, TEMP
      DOUBLE PRECISION G01FAFG, G01FEFG
      CHARACTER  C*1
      EXTERNAL   G01FAFG, G01FEFG
      INTRINSIC  ABS, SQRT, COS, SIN, EXP
C
C Initialise and check
C
      IFAIL = 0
      G01FBFG = ZERO
      IF (DF.LT.ONE) THEN
         IFAIL = 3
         RETURN
      ENDIF
      IF (P.LE.ZERO .OR. P.GE.ONE) THEN
         IFAIL = 2
         RETURN
      ENDIF
      IF (P.LE.PMIN) THEN
         PNEW = PMIN
      ELSEIF (P.GE.PMAX) THEN
         PNEW = PMAX
      ELSE
         PNEW = P
      ENDIF
      C = TAIL(1:1)
      IF (C.EQ.'L' .OR. C.EQ.'l') THEN
         PVAL = TWO*(ONE - PNEW)
         C = 'L'
      ELSEIF (C.EQ.'U' .OR. C.EQ.'u') THEN
         PVAL = TWO*PNEW
         C = 'U'
      ELSEIF (C.EQ.'S' .OR. C.EQ.'s') THEN
         PVAL = PNEW
         C = 'S'
      ELSEIF (C.EQ.'C' .OR. C.EQ.'c') THEN
         PVAL = ONE - PNEW
         C = 'C'
      ELSE
         IFAIL = 1
         RETURN
      ENDIF
      IF (C.EQ.'L' .AND. ABS(PNEW - HALF).LE.EPSI .OR.
     +    C.EQ.'U' .AND. ABS(PNEW - HALF).LE.EPSI) THEN
C
C The special case C = 'L', C = 'U' and P = 1/2
C
         TVAL = ZERO
      ELSEIF (ABS(DF - ONE).LE.EPSI) THEN
C
C The special case n = 1
C
         A = PVAL*PIBY2
         TVAL =  COS(A)/SIN(A)
      ELSEIF (ABS(DF - TWO).LE.EPSI) THEN
C
C The special case n = 2
C
         A = TWO/(PVAL*(TWO - PVAL)) - TWO
         TVAL = SQRT(A)
      ELSEIF (DF.LT.THREE) THEN
C
C Use a Beta distribution for n < 3
C
         R = HALF*DF
         S = HALF
         TOLVAL = TOL
         I = 1
         IF (C.EQ.'L') THEN
            IF (PNEW.LT.HALF) THEN
               PVAL = TWO*PNEW
               ROOT = G01FEFG(PVAL, R, S, TOLVAL, I)
               TVAL = - SQRT(DF/ROOT - DF)
            ELSE
               PVAL = TWO*(ONE - PNEW)
               ROOT = G01FEFG(PVAL, R, S, TOLVAL, I)
               TVAL = SQRT(DF/ROOT - DF)
            ENDIF
         ELSEIF (C.EQ.'U') THEN
            TEMP = ONE - PNEW
            IF (TEMP.LT.HALF) THEN
               PVAL = TWO*TEMP
               ROOT = G01FEFG(PVAL, R, S, TOLVAL, I)
               TVAL = - SQRT(DF/ROOT - DF)
            ELSE
               PVAL = TWO*(ONE - TEMP)
               ROOT = G01FEFG(PVAL, R, S, TOLVAL, I)
               TVAL = SQRT(DF/ROOT - DF)
            ENDIF
         ELSEIF (C.EQ.'S') THEN
            TEMP = ONE - HALF*PNEW
            IF (TEMP.LT.HALF) THEN
               PVAL = TWO*TEMP
               ROOT = G01FEFG(PVAL, R, S, TOLVAL, I)
               TVAL = - SQRT(DF/ROOT - DF)
            ELSE
               PVAL = TWO*(ONE - TEMP)
               ROOT = G01FEFG(PVAL, R, S, TOLVAL, I)
               TVAL = SQRT(DF/ROOT - DF)
            ENDIF
         ELSEIF (C.EQ.'C') THEN
            TEMP = HALF*(ONE - PNEW)
            IF (TEMP.LT.HALF) THEN
               PVAL = TWO*TEMP
               ROOT = G01FEFG(PVAL, R, S, TOLVAL, I)
               TVAL = - SQRT(DF/ROOT - DF)
            ELSE
               PVAL = TWO*(ONE - TEMP)
               ROOT = G01FEFG(PVAL, R, S, TOLVAL, I)
               TVAL = SQRT(DF/ROOT - DF)
            ENDIF
         ENDIF
      ELSE
C
C Use a Cornish-Fisher expansion for n > 3
C
         A = ONE/(DF - HALF)
         B = 48.0D+00/A**2
         E = ((20700.0D+00*A/B - 98.0D+00)*A - FOUR**2)*A + 96.36D+00
         D = ((94.5D+00/(B + E) - THREE)/B + ONE)*SQRT(A*PIBY2)*DF
         X = D*PVAL
         Y = X**(TWO/DF)
         IF (Y .GT. 0.05D+00 + A) THEN
            I = 1
            TEMP = HALF*PVAL
            X = G01FAFG('L', TEMP, I)
            Y = X**2
            IF (DF .LT. FIVE) E = E +
     +                        0.3D+00*(DF - 4.5D+00)*(X + 0.6D+00)
            E = (((0.05D+00*D*X - FIVE)*X - 7.0D+00)*X - TWO)*X + B + E
            Y = (((((0.4D+00*Y + 6.3D+00)*Y + 36.0D+00)*Y + 94.5D+00)/E
     +            - Y - THREE)/B + ONE)*X
            Y = A*Y**2
            IF (Y .GT. 0.002D+00) THEN
               Y = EXP(Y) - ONE
            ELSE
               Y = HALF*Y**2 + Y
            ENDIF
         ELSE
            Y = ((ONE/(((DF + SIX)/(DF*Y) - 0.089D+00*D - 0.822D+00)*
     +          (DF + TWO)*THREE) + HALF/(DF + FOUR))*Y - ONE)*
     +          (DF + ONE)/(DF + TWO) + ONE/Y
         ENDIF
         TVAL = SQRT(DF*Y)
      ENDIF
      IF (C.EQ.'L') THEN
         IF (P.GT.HALF) THEN
            G01FBFG = ABS(TVAL)
         ELSE
            G01FBFG = - ABS(TVAL)
         ENDIF
      ELSEIF (C.EQ.'U') THEN
         IF (P.GT.HALF) THEN
            G01FBFG = - ABS(TVAL)
         ELSE
            G01FBFG = ABS(TVAL)
         ENDIF
      ELSEIF (C.EQ.'C') THEN
         G01FBFG = ABS(TVAL)
      ELSE
         G01FBFG = ABS(TVAL)
      ENDIF
      END
C
C
      DOUBLE PRECISION FUNCTION G01FCFG(PVAL, DF, IFAIL)
C
C ACTION : percentage points of the chi-square distribution
C AUTHOR : W.G.Bardsley, University of Manchester, 3/3/97
C
C          Ref: Best and Roberts AS 91 24, 385-388, 1975
C
C ADVICE : This version does not check IFAIL on entry so it
C          is equivalent to soft fail, IFAIL = 1
C          It agrees with the NAG routine up to about six places
C          28/02/2002 edited
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION PVAL, DF
C
C Local variables
C
      INTEGER    I, IF1
      INTEGER    ICOUNT, NMAX
      PARAMETER (NMAX = 50)
      DOUBLE PRECISION ZERO, HALF, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00,
     +           TWO = 2.0D+00)
      DOUBLE PRECISION TOL
      PARAMETER (TOL = 1.0D-6)
      DOUBLE PRECISION AA, E
      PARAMETER (AA = 0.6931471805D+00, E = 5.0D-7)
      DOUBLE PRECISION G01FAFG, S14ABFG
      DOUBLE PRECISION A, B, C, CH, G, P, PP, P1, P2, Q, QQ, T,
     +                 V, X, XX, Y
      DOUBLE PRECISION S1, S2, S3, S4, S5, S6
      CHARACTER  TAIL*1
      PARAMETER (TAIL = 'L')
      EXTERNAL   G01FAFG, S14ABFG, S14BAFG
      INTRINSIC  ABS, SQRT, LOG, EXP
C
C Is it safe ?
C
      IFAIL = 0
      G01FCFG = ZERO
      IF (PVAL.LT.ZERO .OR. PVAL.GT.ONE) THEN
         IFAIL = 1
         RETURN
      ENDIF
      IF (DF.LT.ONE) THEN
         IFAIL = 2
         RETURN
      ENDIF
C
C Define parameters
C
      IF (PVAL.LE.0.000002D+00) THEN
         P = 0.000002D+00
      ELSEIF (PVAL.GE.0.999998D+00) THEN
         P = 0.999998D+00
      ELSE
         P = PVAL
      ENDIF
      IF (DF.GE.1.0D+05) THEN
C
C Wilson Hilferty approximation for large DF
C
         V = DF
         IF1 = 1
         X = G01FAFG(TAIL, P, IF1)
         P1 = 0.222222D+00/V
         CH = V*(X*SQRT(P1) + ONE - P1)**3
         IF (CH.LE.ZERO) CH = ZERO
         G01FCFG = CH
         RETURN
      ENDIF
      V = DF
      XX = V/TWO
      I = 1
      G = S14ABFG(XX, I)
      XX = V/TWO
      C = XX - ONE
C
C Starting estimates ... The method depends on V and P
C
      IF (V .LT. -1.24D+00*LOG(P)) THEN
         CH = (P*XX*EXP(G + XX*AA))**(ONE/XX)
         IF (CH.LT.E) THEN
            G01FCFG = CH
            RETURN
         ENDIF
      ELSE
         IF (V .LT. 0.32D+00) THEN
C
C Newton Raphson
C
            CH = 0.4D+00
            A = LOG(ONE - P)
            ICOUNT = 0
   20       CONTINUE
            ICOUNT = ICOUNT + 1
            Q = CH
            P1 = ONE + CH*(4.67D+00 + CH)
            P2 = CH*(6.73D+00 + CH*(6.66D+00 + CH))
            T = - HALF + (4.67D+00 + TWO*CH)/P1
     +          - (6.73D+00 + CH*(13.32D+00 + 3.0D+00*CH))/P2
            CH = CH - (ONE - EXP(A + G + HALF*CH + C*AA)*P2/P1)/T
            IF (ABS(Q/CH - ONE) - 0.01D+00 .GT. ZERO .AND.
     +         ICOUNT.LT.NMAX) GOTO 20
         ELSE
C
C Wilson Hilferty approximation
C
            IF1 = 1
            X = G01FAFG(TAIL, P, IF1)
            P1 = 0.222222D+00/V
            CH = V*(X*SQRT(P1) + ONE - P1)**3
C
C The special case P -> 1
C
            IF (CH .GT. 2.2D+00*V + 6.0D+00) CH = - TWO*(LOG(ONE - P)
     +                                    - C*LOG(HALF*CH) + G)
         ENDIF
      ENDIF
C
C The evaluation process
C
      ICOUNT = 0
   40 CONTINUE
      ICOUNT = ICOUNT + 1
      Q = CH
      P1 = HALF*CH
      IF1 = 1
      CALL S14BAFG(XX, P1, TOL, PP, QQ, IF1)
      IF (IF1.NE.0) RETURN
      Y = PP
      P2 = P - Y
      T = P2*EXP(XX*AA + G + P1 - C*LOG(CH))
      B = T/CH
      A = HALF*T - B*C
      S1 = (210.0D+00 + A*(140.0D+00 + A*(105.0D+00 +
     +      A*(84.0D+00 + A*(70.0D+00 + 60.0D+00*A)))))/420.0D+00
      S2 = (420.0D+00 + A*(735.0D+00 + A*(966.0D+00 +
     +      A*(1141.0D+00 + 1278.0D+00*A))))/2520.0D+00
      S3 = (210.0D+00 + A*(462.0D+00 +
     +      A*(707.0D+00 + 932.0D+00*A)))/2520.0D+00
      S4 = (252.0D+00 + A*(672.0D+00 + 1182.0D+00*A) +
     +      C*(294.0D+00 + A*(889.0D+00 + 1740.0D+00*A)))/5040.0D+00
      S5 = (84.0D+00 + 264.0D+00*A +
     +      C*(175.0D+00 + 606.0D+00*A))/2520.0D+00
      S6 = (120.0D+00 + C*(346.0D+00 + 127.0D+00*C))/5040.0D+00
      CH = CH + T*(ONE + HALF*T*S1 - B*C*(S1 - B*(S2 - B*(S3
     +                             - B*(S4 - B*(S5 - B*S6))))))
      IF (ABS(Q/CH - ONE) .GT. E .AND. ICOUNT.LT.NMAX) GOTO 40
      IF (CH.LT.ZERO) CH = ZERO
      G01FCFG = CH
      END
C
C
      DOUBLE PRECISION FUNCTION G01FDFG(P, DF1, DF2, IFAIL)
C
C ACTION : Inverse F distribution
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 11/3/97
C          16/10/2003 revised for increased accuracy
C
C          Uses transformation except for extreme cases when normal
C          or chi-square approximations are used instead of the inverse
C          beta distribution. See Ab and Steg p947
C
      IMPLICIT NONE
      INTEGER   IFAIL
      DOUBLE PRECISION P, DF1, DF2
C
C Local variables
C
      INTEGER   I
      DOUBLE PRECISION ZERO, EPSI, ONE, TWO, FOUR
      PARAMETER (ZERO = 0.0D+00, EPSI = 1.0E-06, ONE = 1.0D+00,
     +           TWO = 2.0D+00, FOUR = 4.0D+00)
      DOUBLE PRECISION BMAX, BMIN
      PARAMETER (BMIN = 1.0D-16, BMAX = ONE - BMIN)
      DOUBLE PRECISION BETA, BOT, CHISQD, PVAL, R, S, TOL, TOP, XNORM
      DOUBLE PRECISION G01FAFG, G01FEFG, G01FCFG
      EXTERNAL G01FAFG, G01FEFG, G01FCFG
      INTRINSIC SQRT
C
C Is it safe ?
C
      IFAIL = 0
      G01FDFG = ZERO
      IF (P.LT.ZERO .OR. P.GE.ONE) THEN
         IFAIL = 1
         RETURN
      ENDIF
      IF (DF1.LE.ZERO .OR. DF2.LE.ZERO) THEN
         IFAIL = 2
         RETURN
      ENDIF
      PVAL = P
      I = 1
      IF (PVAL.GT.0.999D+00 .AND. DF1.GT.1.0D+04 .OR.
     +    PVAL.GT.0.999D+00 .AND. DF2.GT.1.0D+04) THEN
C
C Treat as special case if at upper tail > .999 (found empirically)
C
         XNORM = G01FAFG('L', PVAL, I)
         TOP = TWO*(DF1 + DF2  - TWO)
         BOT = DF1*(DF2 - FOUR)
         G01FDFG = DF2*(ONE + XNORM*SQRT(TOP/BOT))/(DF2 - TWO)
      ELSEIF (DF1.GT.1.0D+05 .AND. DF2.GT.1.0D+05) THEN
C
C DF1 and DF2 both large
C
         XNORM = G01FAFG('L', PVAL, I)
         TOP = TWO*(DF1 + DF2  - TWO)
         BOT = DF1*(DF2 - FOUR)
         G01FDFG = DF2*(ONE + XNORM*SQRT(TOP/BOT))/(DF2 - TWO)
      ELSEIF (DF1.GT.1.0D+05) THEN
C
C DF1 large
C
         CHISQD = G01FCFG(PVAL, DF2, I)
         IF (CHISQD.LE.1.0D-300) CHISQD = 1.0D-300
         G01FDFG = DF2/CHISQD
      ELSEIF (DF2.GT.1.0D+05) THEN
C
C DF2 large
C
         CHISQD = G01FCFG(PVAL, DF1, I)
         G01FDFG = CHISQD/DF1
      ELSE
C
C Transform to beta
C
         R = DF1/TWO
         S = DF2/TWO
         TOL = EPSI
         BETA = G01FEFG(PVAL, R, S, TOL, I)
         IF (BETA.LE.BMIN) THEN
            BETA = BMIN
         ELSEIF (BETA.GE.BMAX) THEN
            BETA = BMAX
         ENDIF
         TOP = DF2*BETA
         BOT = DF1*(ONE - BETA)
         G01FDFG = TOP/BOT
      ENDIF
C
C Final check that F >= 0
C
      IF (G01FDFG.LT.ZERO) G01FDFG = ZERO
      END
C
C
      DOUBLE PRECISION FUNCTION G01FEFG(PVAL, AVAL, BVAL, TOLVAL, IFAIL)
C
C ACTION : inverse beta distribution
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 4/3/97
C
C          Developed from:-
C          AS 64 Majumder and Bhattacharjee, 411-414, 1973
C
C          This sometimes fails to converge so I implemented
C          AS 109 Correction to the previous by Cran, Martin and Thomas
C          to prevent Newton Raphson diverging. BETA is now log(beta)
C          and ACU = TOLVAL**2 (Appl Statist 26,111-114)
C
C          Subsequently I came across R83 by Berry, Mielke, Grant
C          p 309-310 (1990 ?) replacing ACU and introducing IEX and
C          FPU so TOLVAL is not now used.
C
C          This version accepts the starting estimate if the root has
C          not been located by Newton Raphson. Also it is protected
C          from overflow, e.g. with 0.001, 2345, 5678
C
C          Note: there is no test for IFAIL on entry so it is
C                equivalent to soft fail, i.e. IFAIL = 1
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION AVAL, BVAL, PVAL, TOLVAL
C
C Local variables
C
      INTEGER    I, ICOUNT, IEX, JCOUNT, NMAX
      PARAMETER (NMAX = 40)
      DOUBLE PRECISION ZERO, EPSI, HALF, ONE, TWO, THREE, FOUR, FIVE,
     +                 SIX, NINE, TEN
      PARAMETER (ZERO = 0.0D+00, EPSI = 1.0D-16, HALF = 0.5D+00,
     +           ONE = 1.0D+00, TWO = 2.0D+00, THREE = 3.0D+00,
     +           FOUR = 4.0D+00, FIVE = 5.0D+00,
     +           SIX = 6.0D+00, NINE = 9.0D+00, TEN = 10.0D+00)
      DOUBLE PRECISION ABLIM, AMAX, AMIN, XMAX, XMIN
      PARAMETER (ABLIM = 1.0D+06, AMIN = 1.0D-16, AMAX = ONE - AMIN,
     +           XMIN = 1.0D-300, XMAX = ONE - AMIN)
      DOUBLE PRECISION EXPBOT, EXPTOP, XTINY
      PARAMETER (EXPTOP = 100.0D+00, EXPBOT = - EXPTOP, XTINY = XMIN)
      DOUBLE PRECISION SAE, FPU
      PARAMETER (SAE = - 300.0D+00)
      DOUBLE PRECISION ACU, BETA, P, PP, Q, QQ, TEMP, X1, X2, X3
      DOUBLE PRECISION A, ALPHA, R, T, TOL, XINBTA, XTEMP, Y
      DOUBLE PRECISION ADJ, G, H, PREV, YPREV, S, SQ, TX, W
      DOUBLE PRECISION F1, F2, XSAV
      DOUBLE PRECISION S14ABFG
      LOGICAL    INDEX1
      EXTERNAL   G01EEFG, S14ABFG
      INTRINSIC  ABS, EXP, LOG, SQRT, MAX, NINT
C
C Initialise
C
      IFAIL = 0
      G01FEFG = ZERO
C
C Is it safe ?
C
      IF (PVAL.LT.ZERO .OR. PVAL.GT.ONE) THEN
         IFAIL = 1
         RETURN
      ELSE
         ALPHA = PVAL
         IF (ALPHA.LE.AMIN) THEN
            ALPHA = AMIN
         ELSEIF (ALPHA.GE.AMAX) THEN
            ALPHA = AMAX
         ENDIF
      ENDIF
      IF (AVAL.LE.ZERO .OR. AVAL.GT.ABLIM .OR.
     +    BVAL.LE.ZERO .OR. BVAL.GT.ABLIM) THEN
         IFAIL = 2
         RETURN
      ELSE
         P = AVAL
         Q = BVAL
      ENDIF
C
C In this version the next definition of ACU is overwritten by IEX
C
      ACU = TOLVAL*TOLVAL
      IF (ACU.LT.EPSI) ACU = EPSI
C
C Calculate the normalising factor BETA, i.e. log(beta)
C
       I = 1
       X1 = S14ABFG(P, I)
       I = 1
       X2 = S14ABFG(Q, I)
       I = 1
       TEMP = P + Q
       X3 = S14ABFG(TEMP, I)
       BETA = X1 + X2 - X3
C
C Swap tails if recommended
C
       IF (ALPHA.GT.HALF) THEN
          INDEX1 = .TRUE.
          A = ONE - ALPHA
          PP = Q
          QQ = P
       ELSE
          INDEX1 = .FALSE.
          A = ALPHA
          PP = P
          QQ = Q
       ENDIF
C
C Set up the initial approximation
C
      TEMP =  A*A
      IF (TEMP.LE.XTINY) TEMP = XTINY
C
C Calculate Hasting's approximation to y-alpha
C
      R = SQRT( - LOG(TEMP))
      Y = R - (2.30753D+00 + 0.27061D+00*R)/
     +   (ONE + (0.99229D+00 + 0.04481D+00*R)*R)
      IF (PP.GT.ONE .AND. QQ.GT.ONE) THEN
C
C The new case treated by Cran, Martin and Thomas
C
         R = (Y*Y - THREE)/SIX
         S = ONE/(TWO*PP - ONE)
         T = ONE/(TWO*QQ - ONE)
         H = TWO/(S + T)
         W = Y*SQRT(H + R)/H - (T - S)*(R + FIVE/SIX - TWO/(THREE*H))
         XINBTA = PP/(PP + QQ*EXP(TWO*W))
      ELSE
C
C Calculate Wilson and Hilferty's approximation to chi-square
C
         R = TWO*QQ
         T = ONE/(NINE*QQ)
         T = R*(ONE - T + Y*SQRT(T))**3
         IF (T.LE.ZERO) THEN
C
C Deal with negative chi-square
C
            TEMP = (ONE - A)*QQ
            IF (TEMP.LE.XTINY) TEMP = XTINY
            TEMP = (LOG(TEMP) + BETA)/QQ
            IF (TEMP.LE.EXPBOT) THEN
               TEMP = EXPBOT
            ELSEIF (TEMP.GE.EXPTOP) THEN
                TEMP = EXPTOP
            ENDIF
            XINBTA = ONE - EXP(TEMP)
         ELSE
C
C Calculate the RHS of Sheffe and Tukey's equation
C
            T = (FOUR*PP + R - TWO)/T
            IF (T.GT.ONE) THEN
C
C Solve the equation for RHS > 1
C
               XINBTA = ONE - TWO/(T + ONE)
            ELSE
C
C The alternative solution
C
               TEMP = A*PP
               IF (TEMP.LE.XTINY) TEMP = XTINY
               TEMP = (LOG(TEMP) + BETA)/PP
               IF (TEMP.LE.EXPBOT) THEN
                  TEMP = EXPBOT
               ELSEIF (TEMP.GE.EXPTOP) THEN
                  TEMP = EXPTOP
               ENDIF
               XINBTA = EXP(TEMP)
            ENDIF
         ENDIF
      ENDIF
C
C Reflect back extreme values then save the estimate
C
      IF (XINBTA.LE.0.0001D+00) THEN
         XINBTA = 0.0001D+00
      ELSEIF (XINBTA.GE.0.9999D+00) THEN
         XINBTA = 0.9999D+00
      ENDIF
      XSAV = XINBTA
C
C The starting estimate XINBTA has now been calculated
C
C......................................................................
C
C Prepare for Newton Raphson
C
      R = ONE - PP
      T = ONE - QQ
      YPREV = ZERO
      SQ = ONE
      PREV = ONE
      ICOUNT = 0
C
C The new code suggested by Berry, Mielke and Grant
C
      FPU = TEN**SAE
      IEX = NINT(MAX(-FIVE/PP**2 - ONE/A**0.2D+00 - 13.0D+00, SAE))
      ACU = TEN**IEX
C
C Main cycling point for the iteration
C
   20 CONTINUE
      ICOUNT = ICOUNT + 1
C
C Function evaluation: X1 = lower tail area
C
      I = 1
      TOL = TOLVAL
      XTEMP = XINBTA
      CALL G01EEFG(XTEMP, PP, QQ, TOL, X1, X2, X3, I)
      IF (I.EQ.0) THEN
         Y = X1
         TEMP = BETA + R*LOG(XINBTA) + T*LOG(ONE - XINBTA)
         IF (TEMP.LE.EXPBOT) THEN
            TEMP = EXPBOT
         ELSEIF (TEMP.GE.EXPTOP) THEN
            TEMP = EXPTOP
         ENDIF
         Y = (Y - A)*EXP(TEMP)
         IF (Y*YPREV.LE.ZERO) PREV = MAX(SQ, FPU)
         G = ONE
C
C Adjust if required
C
         JCOUNT = 0
   40    CONTINUE
         JCOUNT = JCOUNT + 1
         ADJ = G*Y
         SQ = ADJ*ADJ
         IF (SQ.GE.PREV) THEN
            IF (JCOUNT.LE.NMAX) THEN
               G = G/THREE
               GOTO 40
            ENDIF
         ENDIF
         TX = XINBTA - ADJ
         IF (TX.LT.ZERO .OR. TX.GT.ONE) THEN
            IF (JCOUNT.LE.NMAX) THEN
               G = G/THREE
               GOTO 40
            ENDIF
         ENDIF
C
C Check to see if it has converged or used up iterations
C
         IF (ICOUNT.EQ.NMAX .OR. PREV.LE.ACU .OR. Y*Y.LE.ACU .OR.
     +       ABS(TX - XINBTA).LE.EPSI) GOTO 60
         IF (TX.LE.XMIN .OR. TX.GE.XMAX) THEN
            IF (JCOUNT.LE.NMAX) THEN
               G = G/THREE
               GOTO 40
            ENDIF
         ENDIF
         XINBTA = TX
C
C Reflect back extreme values
C
         IF (XINBTA.LE.AMIN) THEN
            XINBTA = AMIN
         ELSEIF (XINBTA.GE.AMAX) THEN
            XINBTA = AMAX
         ENDIF
         YPREV = Y
         GOTO 20
      ENDIF
C
C Final calculation
C
   60 CONTINUE
C
C First check if the iteration has improved the solution
C
      I = 1
      TOL = TOLVAL
      XTEMP = XSAV
      CALL G01EEFG(XTEMP, PP, QQ, TOL, X1, X2, X3, I)
      F1 = X1 - A
      I = 1
      TOL = TOLVAL
      XTEMP = XINBTA
      CALL G01EEFG(XTEMP, PP, QQ, TOL, X1, X2, X3, I)
      F2 = X1 - A
C
C If not swap XSAV for XINBTA
C
      IF (ABS(F1).LT.ABS(F2)) XINBTA = XSAV
C
C Reverse tails if necessary
C
      IF (INDEX1) XINBTA = ONE - XINBTA
      G01FEFG = XINBTA
      IF (G01FEFG.LT.ZERO) THEN
         G01FEFG = ZERO
      ELSEIF (G01FEFG.GT.ONE) THEN
         G01FEFG = ONE
      ENDIF
      END
C
