C
C NAG substitute routines from maths.dll to make the graphics.dll
C free standing. Routines end in G not $ so there will be no clashes.
C
C G02CAF
C G05SBF      
C S14ABF
C S14BAF
C S15ABF
C S15ADF
C X01AAF
C X02AJF
C X02AMF
C
C
      SUBROUTINE G02CAFG(N, X, Y, RESUL, IFAIL)
C
C ACTION : Simple linear regression
C AUTHOR : W.G.Bardsley, University of Manchester, U.K, 19/2/97
C
C          This subroutine is not very carefully sculptured for
C          accuracy and can easily be improved to increase both
C          the execution speed and accuracy. In particular the
C          error trapping is not very sophisticated and I hope
C          to revise it all eventually.
C
C          There is no test for IFAIL on entry so it is like IFAIL = 1
C
      IMPLICIT   NONE
      INTEGER    IFAIL, N
      DOUBLE PRECISION X(N), Y(N), RESUL(20)
C
C Local variables
C
      INTEGER    I
      DOUBLE PRECISION ZERO, EPSI, EPSI10, ONE
      PARAMETER (ZERO = 0.0D+00, EPSI = 1.0D-150, EPSI10 = 1.0D+10*EPSI,
     +           ONE = 1.0D+00)
      DOUBLE PRECISION A, B, DFT, DFD, DN, DFR, F, P, R, RMSD, RMSR,
     +                 SEA, SEB, SSD, SSR, SST, SX, SY, TA, TB, XBAR,
     +                 YBAR
      LOGICAL    SAFE
      INTRINSIC  DBLE, SQRT
C
C Initialise
C
      IFAIL = 0
      DO I = 1, 20
         RESUL(I) = ZERO
      ENDDO
      IF (N.LE.2) THEN
         IFAIL = 1
         RETURN
      ENDIF
      DN = DBLE(N)
      DFT = DN - ONE
      DFD = DFT - ONE
      DFR = ONE
      R = ZERO
      B = ZERO
      F = ZERO
      SEB = ZERO
      SEA = ZERO
      TB = ZERO
      TA = ZERO
C
C XBAR, YBAR, SX and SY
C
      XBAR = ZERO
      YBAR = ZERO
      DO I = 1, N
         XBAR = XBAR + X(I)
         YBAR = YBAR + Y(I)
      ENDDO
      XBAR = XBAR/DN
      YBAR = YBAR/DN
      SX = ZERO
      SY = ZERO
      DO I = 1, N
         SX = SX + (XBAR - X(I))**2
         SY = SY + (YBAR - Y(I))**2
      ENDDO
      IF (SX.LE.EPSI .OR. SY.LE.EPSI) THEN
         IFAIL = 2
         RETURN
      ENDIF
      SX = SQRT(SX/DFT)
      SY = SQRT(SY/DFT)
      IF (SX.GT.EPSI10) THEN
         SAFE = .TRUE.
      ELSE
         SAFE = .FALSE.
      ENDIF
C
C P and R
C
      P = ZERO
      DO I = 1, N
         P = P + (X(I) - XBAR)*(Y(I) - YBAR)
      ENDDO
      IF (SAFE) R = P/(DFT*SX*SY)
C
C A and B
C
      IF (SAFE) B = P/(DFT*SX**2)
      A = YBAR - B*XBAR
C
C SST, SSD, SSR, RMSR, RMSD and F
C
      SST = DFT*SY**2
      SSD = ZERO
      DO I = 1, N
         SSD = SSD + (Y(I) - A - B*X(I))**2
      ENDDO
      SSR = SST - SSD
      RMSR = SSR/DFR
      RMSD = SSD/DFD
      IF (RMSD.GT.EPSI10) F = RMSR/RMSD
C
C SEA, SEB, TA and TB
C
      IF (SAFE) THEN
         SEB = SQRT(RMSD)/(SQRT(DFT)*SX)
         SEA = SQRT(RMSD*(ONE/DN + XBAR**2/(DFT*SX**2)))
      ENDIF
      IF (SEB.GT.EPSI10) TB = B/SEB
      IF (SEA.GT.EPSI10) TA = A/SEA
C
C RESULS
C
      RESUL(1) = XBAR
      RESUL(2) = YBAR
      RESUL(3) = SX
      RESUL(4) = SY
      RESUL(5) = R
      RESUL(6) = B
      RESUL(7) = A
      RESUL(8) = SEB
      RESUL(9) = SEA
      RESUL(10) = TB
      RESUL(11) = TA
      RESUL(12) = SSR
      RESUL(13) = DFR
      RESUL(14) = RMSR
      RESUL(15) = F
      RESUL(16) = SSD
      RESUL(17) = DFD
      RESUL(18) = RMSD
      RESUL(19) = SST
      RESUL(20) = DFT
      END

C
C
      SUBROUTINE G05SBFG (N, A, B, STATE, X, IFAIL)
C
C Substitute for G05SBF in NAGSUB2
C      
      IMPLICIT NONE
      INTEGER,          INTENT (IN)    :: N, STATE(*)
      INTEGER,          INTENT (INOUT) :: IFAIL
      DOUBLE PRECISION, INTENT (IN)    :: A, B
      DOUBLE PRECISION, INTENT (OUT)   :: X(N)  
      INTEGER    I
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      LOGICAL   ABORT
      EXTERNAL  BETARVG
      IF (N.LT.1) THEN
         IFAIL = 1
         RETURN
      ELSEIF (A.LE.ZERO) THEN
         IFAIL = 2
         RETURN
      ELSEIF (B.LE.ZERO) THEN
         IFAIL = 3
         RETURN
      ENDIF
      I = STATE(1)!	to stop ftn95 complaining 
      DO I = 1, N
         X(I) = ZERO
      ENDDO   
      DO I = 1, N
         CALL BETARVG(A, B, X(I),
     +                ABORT)
         IF (ABORT) THEN
            IFAIL = 100
            RETURN
         ENDIF   
      ENDDO
      END                    
C
C
      subroutine betarvg (alpha, beta, x,
     +                    abort)
c
c action: calculate a beta pseudo-random variate
c author: w.g.bardsley, university of manchester, u.k.,09/03/2019
c     
      implicit none
c
c arguments
c      
      double precision, intent (in)  :: alpha, beta
      double precision, intent (out) :: x
      logical,          intent (out) :: abort 
c
c locals
c
      integer    ifail
      double precision dummy, p, value
      double precision g01fefg, g05cafg
      double precision epsi, one, pbot, ptop, xmax
      parameter (epsi = 1.0d-07, one = 1.0d+00, xmax = 1.0d+06)
      parameter (pbot = epsi, ptop = one - epsi)
      external   g01fefg, g05cafg 
c
c initialise abort and check input parameters
c
      abort = .true. 
      if (alpha.lt.epsi .or. beta.lt.epsi .or.
     +    alpha.gt.xmax .or. beta.gt.xmax) return
      p = g05cafg(dummy)
      if (p.lt.pbot) then
         p = pbot
      elseif (p.gt.ptop) then
         p = ptop
      endif   
      ifail = 0
      value = g01fefg(p, alpha, beta, epsi, ifail)
      if (ifail.eq.0) then
         x = value
         abort = .false.
      endif   
      end
c
c              
C
C
      DOUBLE PRECISION FUNCTION S14ABFG(XX, IFAIL)
C
C ACTION : log gamma function
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 4/3/97
C          Equivalent to IFAIL = 1 soft fail, no error trapping
C          Returns IFAIL = 2 for large values but just keeps on
C          Set to 0 to trap the poles occurring at 1 and 2
C
      IMPLICIT NONE
      INTEGER   IFAIL
      DOUBLE PRECISION XX
C
C Local variables
C
      INTEGER   I, IPART
      DOUBLE PRECISION X
      DOUBLE PRECISION ZERO, HALF, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00,
     +           TWO = 2.0D+00)
      DOUBLE PRECISION XLIM1, XLIM2, XLIM3, XLIM4
      PARAMETER (XLIM1 = 1.0D-10, XLIM2 = 15.0D+00, XLIM3 = 1.2D+03,
     +           XLIM4 = 1.0D300)
      DOUBLE PRECISION EPSI, FACTOR, TOP, Z1LO, Z1HI, Z2LO, Z2HI
      PARAMETER (EPSI = 1.0D-10, FACTOR = 0.918938533D+00,
     +           TOP = 450.0D+00,
     +           Z1LO = ONE - EPSI, Z1HI = ONE + EPSI,
     +           Z2LO = TWO - EPSI, Z2HI = TWO + EPSI)
      DOUBLE PRECISION A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10,
     +                 A11, A12
      PARAMETER (A12 =  1.88278283D-6,
     +           A11 = -5.48272091D-6,
     +           A10 =  1.03144033D-5,
     +            A9 = -3.13088821D-5,
     +            A8 =  1.01593694D-4,
     +            A7 = -2.98340924D-4,
     +            A6 =  9.15547391D-4,
     +            A5 = -2.42216251D-3,
     +            A4 =  9.04037536D-3,
     +            A3 = -1.34119055D-2,
     +            A2 =  1.03703361D-1,
     +            A1 =  1.61692007D-2,
     +            A0 =  8.86226925D-1)
      DOUBLE PRECISION B0, B1, B2
      PARAMETER (B0 =  8.33271644D-2,
     +           B1 = -6.16502533D-6,
     +           B2 =  3.89980902D-9)
      DOUBLE PRECISION RPART, T, Y
      INTRINSIC DBLE, INT, LOG
C
C Copy X into XX so X is returned unchanged and set IFAIL = 0
C
      X = XX
      S14ABFG = ZERO
      IFAIL = 0
      IF (X.LE.ZERO) THEN
C
C Failure if X < 0
C
         IFAIL = 1
      ELSEIF (X.GT.Z1LO .AND. X.LT.Z1HI .OR.
     +        X.GT.Z2LO .AND. X.LT.Z2HI) THEN
C
C Trap the poles at X = 1 and X = 2
C
         IFAIL = 0!to silence ftn95
      ELSEIF (X.LE.XLIM1) THEN
C
C For very small values use -log(x)
C
         S14ABFG = -LOG(X)
      ELSEIF (X.LE.XLIM2) THEN
C
C Medium sized values
C
         IPART = INT(X)
         T = TWO*(X - DBLE(IPART)) - ONE
         IPART = IPART - 1
         RPART = ONE
         IF (IPART.LT.0) THEN
            RPART = RPART/X
         ELSEIF (IPART.GT.0) THEN
            DO I = 1, IPART
               RPART = (X - DBLE(I))*RPART
            ENDDO
         ENDIF
         Y = (((((((((((A12*T + A11)*T + A10)*T + A9)*T + A8)*T
     +                        +  A7)*T +  A6)*T + A5)*T + A4)*T
     +                        +  A3)*T +  A2)*T + A1)*T + A0
         S14ABFG = LOG(RPART*Y)
      ELSEIF (X.LE.XLIM3) THEN
C
C Large values
C
         T = TOP/(X*X) - ONE
         Y = (B2*T + B1)*T + B0
         S14ABFG = (X - HALF)*LOG(X) - X + FACTOR + Y/X
      ELSE
C
C Very large values
C
         IF (X.GT.XLIM4) THEN
            IFAIL = 2
            X = XLIM4
         ENDIF
         S14ABFG = (X - HALF)*LOG(X) - X + FACTOR
      ENDIF
      END
C
C
      SUBROUTINE S14BAFG(A, X, TOL, P, Q, IFAIL)
C
C ACTION : Incomplete gamma function after Abramovitch and Stegun
C          using the series or continued fraction depending on
C          the values of X and A
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 4/3/97
C          28/02/2002 edited
C
      IMPLICIT NONE
      INTEGER  IFAIL
      DOUBLE PRECISION A, X, TOL, P, Q
C
C Local variables
C
      INTEGER    NMAX
      PARAMETER (NMAX = 100)
      INTEGER    I
      DOUBLE PRECISION ZERO, RTOL, EPSI, ONE
      PARAMETER (ZERO = 0.0D+00, RTOL = 1.0D-300, EPSI = 1.0D-06,
     +           ONE = 1.0D+00)
      DOUBLE PRECISION ADD1, ARG, A1, CHECK, GAMLOG, TERM, TOL1, SUM1,
     +                 X1
      DOUBLE PRECISION A00, A11, B00, B11, CF1, CF2, DI, DIMA1, DITF,
     +                 FACTOR
      DOUBLE PRECISION S14ABFG
      EXTERNAL S14ABFG
      INTRINSIC ABS, DBLE, EXP, LOG
C
C Check arguments supplied
C
      IFAIL = 0
      P = ZERO
      Q = ZERO
      IF (A.LT.ZERO) THEN
         IFAIL = 1
         RETURN
      ELSEIF (X.LT.ZERO) THEN
         IFAIL = 2
         RETURN
      ENDIF
C
C Make copies of the arguments supplied
C
      IF (TOL.LT.EPSI) THEN
         TOL1 = EPSI
      ELSE
         TOL1 = TOL
      ENDIF
      IF (A.LE.RTOL) THEN
         A1 = RTOL
      ELSE
         A1 = A
      ENDIF
      IF (X.LE.RTOL) THEN
          X1 = RTOL
      ELSE
          X1 = X
      ENDIF
C
C The method to be used depends on whether x > a + 1 but first log(gamma)
C
      I = 1
      GAMLOG = S14ABFG(A1, I)
      IF (X1.LT.A1 + ONE) THEN
C
C Use the series exploiting the recursive gamma function identity
C
         ADD1 = A1
         SUM1 = ONE/ADD1
         TERM = SUM1
         DO I = 1, NMAX
            ADD1 = ADD1 + ONE
            TERM = TERM*X1/ADD1
            SUM1 = SUM1 + TERM
            CHECK = TOL1*SUM1
            IF (TERM.LE.CHECK) GOTO 20
         ENDDO
   20    CONTINUE
         ARG = X1 - A1*LOG(X1) + GAMLOG
         P = SUM1*EXP(- ARG)
         Q = ONE - P
      ELSE
C
C Use the continued fraction normalising after each cycle
C
         CF1 = ZERO
         A00 = ONE
         A11 = X1
         B00 = ZERO
         B11 = ONE
         FACTOR = ONE
         DO I = 1, NMAX
            DI = DBLE(I)
            DIMA1 = DI - A1
            A00 = (A11 + A00*DIMA1)*FACTOR
            B00 = (B11 + B00*DIMA1)*FACTOR
            DITF = DI*FACTOR
            A11 = X1*A00 + DITF*A11
            B11 = X1*B00 + DITF*B11
            IF (ABS(A11).GT.RTOL) THEN
               FACTOR = ONE/A11
               CF2 = B11*FACTOR
               IF (ABS(CF2).GT.RTOL) THEN
                  CHECK = ABS(ONE - CF1/CF2)
                  IF (CHECK.LE.TOL1) GOTO 40
               ENDIF
               CF1 = CF2
            ENDIF
         ENDDO
   40    CONTINUE
         ARG = X1 - A1*LOG(X1) + GAMLOG
         Q =  EXP(-ARG)*CF2
         P = ONE - Q
      ENDIF
      END
C
C
      DOUBLE PRECISION FUNCTION S15ABFG(XX, IFAIL)
C
C ACTION : Normal CDF = (1/2) erfc[-x/sqrt(2)]
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 3/3/97
C
      IMPLICIT NONE
      INTEGER   IFAIL
      DOUBLE PRECISION XX
C
C Local variables
C
      DOUBLE PRECISION HALF, ROOT2
      PARAMETER (HALF = 0.5D+00, ROOT2 = 1.41421356237D+00)
      DOUBLE PRECISION S15ADFG, XNEW
      EXTERNAL S15ADFG
      XNEW = - XX/ROOT2
      S15ABFG = HALF*S15ADFG(XNEW, IFAIL)
      END
C
C
      DOUBLE PRECISION FUNCTION S15ADFG(X, IFAIL)
C
C ACTION : erfc(x) using SLATEC
C AUTHOR : W.G.BARDSLEY, University of manchester, U.K, 14/12/2001
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION X
      DOUBLE PRECISION ZERO, TWO, XMAX, XMIN
      PARAMETER (ZERO = 0.0D+00, TWO = 2.0D+00, XMAX = 25.0D+00,
     +           XMIN = -5.0D+00)
      DOUBLE PRECISION DERFCG
      EXTERNAL   DERFCG
      IFAIL = 0
      IF (X.LT.XMIN) THEN
         S15ADFG = TWO
      ELSEIF (X.GT.XMAX) THEN
         S15ADFG = ZERO
      ELSE
         S15ADFG = DERFCG(X)
      ENDIF
      END
C
C Note that this routine has a dummy argument which is not used
C

      DOUBLE PRECISION FUNCTION X01AAFG(X)
      DOUBLE PRECISION X
      X01AAFG = 3.14159265358979323846264338328D+00
      X = 0.0D+00!to silence ftn95
      END

C
C
      DOUBLE PRECISION FUNCTION X02AJFG()
      X02AJFG = 1.111307226798D-016
      END
C
C
      DOUBLE PRECISION FUNCTION X02AMFG()
      X02AMFG = 2.574667400493D-308
      END

