C
C Random number generators for w_menus.dll
C ========================================
C G05CAF
C G05CBF
C G05CCF
C G05DDF
C
C
C
C these routines end in G to avoid confusion with true NAG routines
C
C G05CAF$ and the Seeding routines G05CBF$ and G05CCF$
C ====================================================
C Note: make sure these three are consistent if the generator
C       is changed
C       The routines RANDOM@, SET_SEED@, DATE_TIME_SEED@ are from
C       the ftn95 library and can easily be relaced by, e.g., the
C       Knuth codes or similar.
C
C
      DOUBLE PRECISION FUNCTION G05CAFG(X)
C
C ACTION : Random number U(0,1)
C AUTHOR : W.G.Bardsley, University of Manchester, U.K, 8/8/97
C
C          X is a dummy argument which is not used
C
      IMPLICIT NONE
      DOUBLE PRECISION X
      DOUBLE PRECISION RANDOM
      INTRINSIC RANDOM_NUMBER
      CALL RANDOM_NUMBER (RANDOM)
      G05CAFG = RANDOM
      X = 0.0D+00!to silence ftn95
      END
C
C
C      SUBROUTINE G05CBFG(ISEED)
C
C ACTION : Set generator seed
C AUTHOR : W.G.Bardsley, University of Manchester,U.K.,8/5/97
C
C      IMPLICIT  NONE
C      INTEGER   ISEED
C      DOUBLE PRECISION DSEED
C      EXTERNAL  SET_SEED
C      INTRINSIC DBLE
C      IF (ISEED.EQ.0) THEN
C
C Evasive action required for ftn95 library SET_SEED@
C
C         DSEED = 0.5D+00
C      ELSE
C         DSEED = DBLE(ISEED)
C      ENDIF
C      CALL SET_SEED(DSEED)
C      END
C
C
      SUBROUTINE G05CCFG
C
C ACTION : Set a non repeatable seed
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 8/5/97
C
      IMPLICIT NONE
      INTRINSIC RANDOM_SEED
      CALL RANDOM_SEED
      END
C
C
      DOUBLE PRECISION FUNCTION G05DDFG(A, B)
C
C ACTION : Normal deviates by the Box Muller method (using only one).
C          Only one is used since this routine may be called sequentially
C          from different subroutines with different seeds leading
C          to correlation effects.
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 8/5/97
C
      IMPLICIT   NONE
      DOUBLE PRECISION A, B
      DOUBLE PRECISION ONE, TWO
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00)
      DOUBLE PRECISION DUMMY, G05CAFG, Q, RTOL, X02AMFG, X1, X2
      EXTERNAL   G05CAFG, X02AMFG
      INTRINSIC  ABS, SQRT, LOG
      RTOL = 1.0D+09*X02AMFG()
   20 CONTINUE
      X1 = TWO*G05CAFG(DUMMY) - ONE
      X2 = TWO*G05CAFG(DUMMY) - ONE
      Q = X1**2 + X2**2
      IF (Q.LT.RTOL .OR. Q.GE.ONE) GOTO 20
      X2 = X1*SQRT(-TWO*LOG(Q)/Q)
      G05DDFG = A + X2*ABS(B)
      END
C
C
