c
c
      subroutine numchk (numdec, numopt,
     +                   srname) 
c     
c action: check/adjust value of NUMDEC supplied to SRNAME against NUMOPT supplied
c author: w.g.bardsley, university of manchester, U.K, 01/05/2012
c 
c numdec: starting list box element
c numopt: number of list box elements
c srname: subroutine name, e.g. lbox01, lbox02, listbx, lstbx, lview1
c
c Advice: set noisy = .true. for noisy adjustment
c     
      implicit none
c
c arguments
c      
      integer,             intent (inout) :: numdec
      integer,             intent (in)    :: numopt
      character (len = *), intent (in)    :: srname
c
c locals
c      
      character (len = 100) line
      character (len = 12 ) form12, word12
      character (len = 6  ) word6
      logical    noisy
      external   form12, putadv, putfat
c
c initialise noisy and word6
c      
      noisy = .true.
      word6 = srname
c
c first check numopt
c      
      if (numopt.lt.1) then
         word12 = form12(numopt)
         write (line,100) word6, word12
         call putfat (line)
         return
      endif
c
c check numdec is in range 1 =< numdec =< numopt 
c      
      if (numdec.lt.1) then
         numdec = 1
         if (noisy) then
            write (line,200) word6
            call putadv (line)
         endif
      elseif (numdec.gt.numopt) then
         numdec = numopt     
         if (noisy) then
            write (line,200) word6
            word12 = form12(numopt)
            write (line,300) word6, word12
            call putadv (line)
         endif
      endif
  100 format ('NUMOPT in call to ',a,' =',1x,a) 
  200 format ('NUMDEC in call to ',a,' < 1 ... re-set to 1')
  300 format ('NUMDEC in call to ',a,' > NUMOPT ... re-set to',1x,a)
      end