C
C
      SUBROUTINE NX3FIL (N,
     +                   X1, X2, X3)
C
C ACTION : Write a set of 3 coordinates to a file
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 26/11/90
C          27/12/1992 Added commas as separators and other changes
C          21/02/1994 DBOS version
C          30/06/1999 added call to GETNOU
C          03/02/2001 replaced GETIL1 by GETJL1
C          28/02/2006 changed output format 
C          23/06/2006 used I1FILE and I2FILE for header dimensions
C
C          N: (input/unchanged) number of points
C X1, X2, X3: (input/unchanged) vectors of values    
C
C Note: this version invents a temporary UNIT which must be close on exit
C
      IMPLICIT   NONE    
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: N
      DOUBLE PRECISION, INTENT (IN) :: X1(N), X2(N), X3(N)
C
C Locals
C      
      INTEGER    NBIG
      PARAMETER (NBIG = 50)
      INTEGER    I, NLINES, NOUT
      INTEGER    ICOLOR, IX, IY, N1, N3
      PARAMETER (ICOLOR = 7, IX = 4, IY = 4, N1 = 1, N3 = 3)
      CHARACTER  FNAME*1024, TITLE*80
      LOGICAL    ABORT
      EXTERNAL   GETJL1, GETTXT, OFILES, YESNO2, GETNOU, I1FILE, I2FILE,
     +           PUTFAT
C
C Check N
C      
      IF (N.LT.1) THEN
         CALL PUTFAT ('Insufficient data to create a file')
         RETURN
      ENDIF   
C
C Open a file
C      
      CALL GETNOU (NOUT)
      CALL OFILES (N1, NOUT, 
     +             FNAME,
     +             ABORT)
      IF (ABORT) THEN
         CLOSE (UNIT = NOUT)
         RETURN   
      ENDIF      
C
C Get title then write header and data to the file
C      
      CALL GETTXT ('Title of data', TITLE)
      WRITE (NOUT,'(A)') TITLE
      CALL I2FILE (NOUT, N, N3)
      DO I = N1, N
         WRITE (NOUT,'(1P,3E13.5)') X1(I), X2(I), X3(I)
      ENDDO 
C
C Ask if extra details are required
C      
      CALL YESNO2 (ICOLOR, IX, IY,
     +             'Add extra details ?', 
     +             ABORT)
      IF (ABORT) THEN
         NLINES = N1
         CALL GETJL1 (N1, NLINES, NBIG, 
     +                'No. of extra lines required')
         CALL I1FILE (NOUT, NLINES)
         DO I = N1, NLINES
            CALL GETTXT ('Next line', TITLE)
            WRITE (NOUT,'(A)') TITLE
         ENDDO
      ELSE  
         CALL I1FILE (NOUT, N1)
         WRITE (NOUT,'(A)') 'Default line'
      ENDIF  
C
C Close the output unit before returning
C      
      CLOSE (UNIT = NOUT)
      END
C
C
