C
C
      SUBROUTINE NXYTRN (N,
     +                   V, X, Y,
     +                   ABORT)
C
C ACTION : Transform vectors X and Y by elementary algebra
C ADVICE : Temporary vector V may be partially or completely transformed
C          X is completely transformed or not transformed at all
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.,13/8/92
C          23/02/1994 DBOS version 
C          10/2/1997 Win32 version
C          24/03/1997 Restored X02 routines
C          15/11/2005 replaced call to NAG by call to NAGSUB
C          28/02/2007 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: N
      DOUBLE PRECISION, INTENT (INOUT) :: V(N), X(N), Y(N)
      LOGICAL,          INTENT (OUT)   :: ABORT
C
C Locals
C      
      INTEGER    I, J, NDEC
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMOPT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, LSHADE = 1, NUMOPT = 6)
      INTEGER    NSTART, NTEXT
      PARAMETER (NSTART = 1, NTEXT = 10)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      DOUBLE PRECISION BIG, EPSI, SMALL, X02AJFG, X02AMFG
      DOUBLE PRECISION TEMP
      CHARACTER  LINE*100, TEXT(NTEXT)*100
      LOGICAL    TAB_TOP, TAB_MID, TAB_BOT
      PARAMETER (TAB_TOP = .TRUE., TAB_MID = .TRUE., TAB_BOT = .TRUE.)
      EXTERNAL   PUTADV, PUTFAT, TBOX01
      EXTERNAL   X02AJFG, X02AMFG
      INTRINSIC  ABS
      DATA       NUMBLD / 7*0, 3*1 /
      DATA       NUMPOS / NUMOPT*1 /
      BIG = 1.0D+00/(1.0D+09*X02AMFG())
      SMALL = - BIG
      EPSI = X02AJFG()
      ABORT = .FALSE.
      NDEC = 6
      WRITE (TEXT,100)
      CALL TBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT, 
     +             TEXT,
     +             TAB_TOP, TAB_MID, TAB_BOT)
      IF (NDEC.EQ.1) THEN
         DO I = 1, N
            V(I) = Y(I)
            Y(I) = X(I)
         ENDDO
      ELSEIF (NDEC.EQ.2) THEN
         DO I = 1, N
            J = I
            TEMP = X(I) + Y(I)
            IF (TEMP.GT.BIG .OR. TEMP.LT. SMALL) GOTO 20
            V(I) = TEMP
         ENDDO
      ELSEIF (NDEC.EQ.3) THEN
         DO I = 1, N
            J = I
            TEMP = X(I) - Y(I)
            IF (TEMP.GT.BIG .OR. TEMP.LT. SMALL) GOTO 20
            V(I) = TEMP
         ENDDO
      ELSEIF (NDEC.EQ.4) THEN
         DO I = 1, N
            J = I
            TEMP = X(I)*Y(I)
            IF (TEMP.GT.BIG .OR. TEMP.LT. SMALL) GOTO 20
            V(I) = TEMP
         ENDDO
      ELSEIF (NDEC.EQ.5) THEN
         DO I = 1, N
            J = I
            IF (ABS(Y(I)).LT.EPSI) GOTO 20
            TEMP = X(I)/Y(I)
            IF (TEMP.GT.BIG .OR. TEMP.LT. SMALL) GOTO 20
            V(I) = TEMP
         ENDDO
      ELSE
         RETURN
      ENDIF
      DO I = 1, N
         X(I) = V(I)
      ENDDO
      WRITE (LINE,200)
      CALL PUTADV (LINE)
      ABORT = .FALSE.
      RETURN
   20 CONTINUE
      ABORT = .TRUE.
      WRITE (LINE,300) J
      CALL PUTFAT (LINE)
C
C Format statements
C      
  100 FORMAT (
     + 'x, y := y, x      `swap'
     +/'x, y := (x + y), y`add'
     +/'x, y := (x - y), y`subtract'
     +/'x, y := (x*y), y  `multiply'
     +/'x, y := (x/y), y  `divide'
     +/'Return            `no action'/
     +/'Transformations (except for swap) leave'
     +/'the y components unchanged but use y to'
     +/'transform x to f(x,y) as indicated.')
  200 FORMAT ('Vectors have been transformed')
  300 FORMAT ('Calculation stopped at component',I5)
      END
C
C
