C
C
      SUBROUTINE OFILES (ISEND, NOUT,
     +                   FNAME,
     +                   ABORT)
C
C ACTION : Open files depending upon ISEND
C AUTHOR : W. G. Bardsley, 07/12/1989, University of Manchester, U.K.
C          02/10/1994 DBOS version
C          07/10/1994 Added overwrite/menu-selection and new ERROR handling
C          31/10/1994 Added call to file PATTERN.CFG
C          14/12/1994 Altered call to file PATTERN.CFG to create on change
C          12/10/1995 Added extra information about search patterns
C          07/08/1996 Added INPUT_CFG and OUTPUT_CFG
C          12/01/1997 Second W95 version
C          30/01/1997 Third W95 version with call to TITLES/TUTORS
C          03/03/1997 Further development of Win32 version
C          01/07/1997 Added calls to ADDSTR
C          01/12/1997 Checked for FNAME = BLANK
C          05/02/1998 Relaced calls to TITLES by calls to W_OFILE1 and
C                     increased the number of files saved for recall to 20
C                     Renamed input.cfg/output.cfg to w_input.cfg and w_output.cfg
C                     and filter.cfg to w_filter.cfg
C          07/08/1998 define FSAV1 and FSAV3 every time for ISEND = 1, 3
C          08/08/1998 Increased NSAV to 30, only add file to saved list if
C                     distinct, ABORT if attempt to open/save .exe or .dll files,
C                     initialised IOS to 0 and cleaned up the code
C          11/09/1998 increased dimension 10 NSAV = 50 (was 30)
C          18/10/1998 Added clipboard functionality
C          01/02/1999 Replaced TUTORS by TUTOR1
C          05/07/1999 saves new filenames to .cfg files or rolls the last
C                     repeated filename at position NSTOP to the top of the heap
C          18/09/1999 added code to allow w_ofile1 to return NUMDEC = 6,7
C                     then select test or library files
C          10/02/2000 Increased NFSAV to 100 and added code to check the
C                     cfg files and prevent file creation in the simfit
C                     folder (W_CHKFLD and W_CHKCFG). Also increased the
C                     filename size to 256
C          29/11/2000 changed filenames to lower case
C          21/01/2001 replaced erase@ by deleet and redefined error_code
C          13/02/2002 XP version
C          20/08/2003 removed call to W_CHKCFG and variable ICOUNT
C          01/12/2006 replaced call to CONFIG by call to SIMDIR and added FULL_PATH 
C          19/01/2007 checked SIMFIT string before using as FULL_PATH prefix  
C          15/02/2007 introduced SIM256 and call to W_GETFFS  
C          07/06/2007 added 'Untitled' and corrected MUST_EXIST = 0 before calling W_GETFFS
C          17/07/2007 replaced SIMDIR by DEMDIR
C          01/01/2015 increased NFSAV to 200, redefined STARS as blanks, extensive editing,
C                     and added call to X_SAVCFG to update w_input.cfg and w_output.cfg
C          22/12/2018 increased NFILT1 to 11 and NFILT3 to 16
C          17/01/2019 increased NFILT1 to 13 and NFILT3 to 18
C          07/02/2019 changed length of FILT1 and FILT3 from (len = 129) to (len = 15) 
C          24/02/2024 added FIRST1 to make sure w_filter.cfg is regulartly updated
C
C ADVICE: ISEND and NOUT are unchanged by this subroutine
C         UNITS 1, 2, 5 and 6 cannot be opened in this version
C         This version checks for valid units and pre-connections
C         This version calls GET_FILTERED_FILE@ and takes the search
C         pattern from w_filter.cfg each time it is called
C         This version allows FILTERS etc. to be changed interactively
C         and uses w_input.cfg and w_output.cfg to remember filenames
C
C ISEND: (input/unchanged) as follows:
C         ISEND = 1, User supplies FILENAME at terminal, then SAVE new file
C                    i.e. Save as ... then update w_output.cfg
C         ISEND = 2, FILENAME as argument to subroutine, then SAVE new file
C                   (re-try with JSEND = 1 if failure with JSEND = 2)
C                    but do not update w_output.cfg
C         ISEND = 3, User supplies FILENAME at terminal/from panel, then OPEN old file
C                    Search pattern = FNAME set on initial entry in this version
C                    i.e. Open ... then update w_input.cfg
C         ISEND = 4, FILENAME as argument to subroutine, then OPEN old file
C                   (re-try with JSEND = 3 if failure with JSEND = 4)
C                    but do not update w_input.cfg
C  NOUT: (input/unchanged) unconnected UNIT number
C FNAME: (input/output) FILENAME (depends on operating system)
C ABORT: (output) .TRUE. for failure, .FALSE. if no faults (query 12/09/2023 ws this wrong previously ?
C

C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ISEND, NOUT  
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Locals
C      
      INTEGER    I, IADD1, IOS, J, JSEND, K, L, L1, L2, LEN200
      INTEGER    NUMDEC, NUMERR
      INTEGER    ICOLOR, IX, IY, LSHADE, NTEXT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, NTEXT = 20)
      INTEGER    NUMCOL, NUMROW
      PARAMETER (NUMCOL = 2, NUMROW = 0)
      INTEGER    NFILT1, NFILT3, NFSAV
      PARAMETER (NFILT1 = 13, NFILT3 = 18, NFSAV = 200)
      INTEGER    NUMBLD(NTEXT)
      INTEGER    ERROR_CODE, MUST_EXIST
      CHARACTER  FILTER_CFG*12, TITLE_1*45, TITLE_3*45,
     +           TYPE1(NFILT1)*45, TYPE3(NFILT3)*45
      PARAMETER (FILTER_CFG = 'w_filter.cfg',
     +           TITLE_1 = 'Simfit: Save data to a new file',
     +           TITLE_3 = 'Simfit: Open a file containing data')
      CHARACTER  INFO1*45, INFO3*45
      PARAMETER (INFO1 = 'Simfit: Save data to a new file',
     +           INFO3 = 'Simfit: Open a file containing data') 
      CHARACTER  FULL_PATH*1024, SIMFIT*1024, SIM256*1024
      CHARACTER  FILT1(NFILT1)*15, FILT3(NFILT3)*15, PATH1*1024,
     +           PATH3*1024
      CHARACTER  FSAV1(NFSAV)*1024, FSAV3(NFSAV)*1024,
     +           TEMP(2*(NFILT1 + NFILT3 + 2))*1024
      CHARACTER  BLANK*1, LINE*100, MYERR(6)*100, STARS*3
      PARAMETER (BLANK = ' ', STARS = '   ')
      CHARACTER  INPUT_CFG*11, OUTPUT_CFG*12
      PARAMETER (INPUT_CFG = 'w_input.cfg', OUTPUT_CFG = 'w_output.cfg')
      CHARACTER  TEXT(NTEXT)*100
      CHARACTER  WORD4*4
      CHARACTER  SAV_PATH*1024, SAV_FILT*1024, SAV_TYPE*45
      LOGICAL    EX, NAM, OP, READ_ONLY, SELECT, YES
      LOGICAL    FIRST, FIRST1
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    FIXED, NEXT, UPDOWN
      PARAMETER (FIXED = .FALSE., UPDOWN = .TRUE.)
      LOGICAL    ASKIF, THERE
      PARAMETER (ASKIF = .FALSE.)
      LOGICAL    NOISY, OK
      EXTERNAL   PUTFAT, PUTIOS, PUTADV, YESNO1, YESNO2, PUTBEL, LEN200,
     +           GETIM1, TUTOR1, GETSTR, ATTRIB, LCASE1, DELEET, DEMDIR,
     +           SIM256
      EXTERNAL   W95_TXT2FN, W_OFILE1, W_CHKFLD, W_GETFFS, X_CHKEXT,
     +           X_SAVCFG
      SAVE       FILT1, FILT3, FSAV1, FSAV3, PATH1, PATH3, TYPE1, TYPE3
      SAVE       FIRST, FIRST1, JSEND
      DATA NUMBLD / NTEXT*0 /
      DATA FILT1 / '*.*',   '*.txt', '*.*', '*.*', '*.*',
     +             '*.*', '*.ps',  '*.eps', '*.svg', '*.*', '*.tmp',
     +             '*.tex', '*.*' /
      DATA FILT3 / '*.*',   '*.txt', '*.*', '*.*', '*.*',
     +             '*.*', '*.ps',  '*.eps', '*.svg', '*.*', '*.tmp',
     +             '*.tf?', '*.tfl', '*.001', '*.002', '*.003', '*.tex',
     +             '*.*'  /
      DATA FSAV1, FSAV3 / NFSAV*BLANK, NFSAV*STARS /
      DATA PATH1  / 'C:' /
      DATA PATH3  / 'C:\Program Files\Simfit' /
      DATA TYPE1  / 'All files',
     +              'Text files',
     +              'Vector files',
     +              'Matrix files',
     +              'Statistics files',
     +              'Curve fit files',
     +              'Postscript files',
     +              'EPS files',
     +              'SVG files',
     +              'Results files',
     +              'Temporary files',
     +              'TEX files',
     +              'Metafiles' /
      DATA TYPE3  / 'All files',
     +              'Text files',
     +              'Vector files',
     +              'Matrix files',
     +              'Statistics files',
     +              'Curve fit files',
     +              'PostScript files',
     +              'EPS files',
     +              'SVG files',
     +              'Results files',
     +              'Temporary files',
     +              'Simfit test files',
     +              'Simfit library files',
     +              'Type *.001 files',
     +              'Type *.002 files',
     +              'Type *.003 files',
     +              'TEX files', 
     +              'Metafiles' /
      DATA SIMFIT / 'C:\Program Files\Simfit' /
      DATA FIRST, FIRST1 / .TRUE., .TRUE. /
 
C
C Write out the default parameters
C
      IF (FIRST1) THEN
          FIRST1 = .FALSE.
          FULL_PATH = SIM256(FILTER_CFG)
          OPEN (UNIT = NOUT, FILE = FULL_PATH, IOSTAT = IOS)
          WRITE (NOUT,'(A)') INFO1
          WRITE (NOUT,'(A)') PATH1
          DO I = 1, NFILT1
             WRITE (NOUT,'(A)') TYPE1(I)
             WRITE (NOUT,'(A)') FILT1(I)
          ENDDO
          WRITE (NOUT,'(A)') INFO3
          WRITE (NOUT,'(A)') PATH3
          DO I = 1, NFILT3
             WRITE (NOUT,'(A)') TYPE3(I)
             WRITE (NOUT,'(A)') FILT3(I)
          ENDDO
          CLOSE (UNIT = NOUT)
      ENDIF   
      

C
C First set ABORT = .TRUE., IOS = 0 and JSEND = ISEND..................
C
      ABORT = .TRUE.
      SELECT = .TRUE.
      IOS = 0
      JSEND = ISEND

C
C Now check if ISEND and NOUT are consistent............................
C

      IF (ISEND.LT.1 .OR. ISEND.GT.4) THEN
         ABORT = .TRUE.
         CALL PUTFAT (
     +'ISEND must be 1, 2, 3 or 4 in calls to OFILES')
         RETURN
      ENDIF
      IF (NOUT.EQ.1 .OR. NOUT.EQ.2 .OR. NOUT.EQ.5 .OR. NOUT.EQ.6) THEN
         ABORT = .TRUE.
         CALL PUTFAT (
     +'NOUT cannot be 1, 2, 5 or 6 in calls to OFILES')
         RETURN
      ENDIF
      
C
C Next see if NOUT is already connected etc.............................
C

      INQUIRE (UNIT = NOUT, EXIST = EX, NAME = TEMP(1), NAMED = NAM,
     +         OPENED = OP, IOSTAT = IOS)
      IF (.NOT.EX) THEN
         ABORT = .TRUE.
         CALL PUTFAT (
     +'Unit NOUT supplied to OFILES is not valid')
         RETURN
      ENDIF
      IF (OP) THEN
         CALL PUTFAT (
     +'Unit NOUT supplied to OFILES is already connected')
         IF (NAM) THEN
            WRITE (LINE,'(''FILE ='',A)') TEMP(1)
            CALL PUTADV (LINE)
         ENDIF
         LINE = 
     +'Close this unit ... Disconnect file ?'
         YES = .FALSE.
         CALL YESNO2 (ICOLOR, IX, IY,
     +                LINE,
     +                YES)
         IF (YES) THEN
            CLOSE (UNIT = NOUT, IOSTAT = IOS, STATUS = 'KEEP')
         ELSE
            ABORT = .TRUE.
            RETURN
         ENDIF
      ENDIF
      IF (IOS.NE.0) THEN
         ABORT = .TRUE.
         CALL PUTIOS (IOS,
     +                'OFILES')
         RETURN
      ENDIF
C
C The first time called ... Check W_FILTER_CFG..........................
C Now checks every time ... does not check FIRST
C
      IF (JSEND.EQ.1 .OR. JSEND.EQ.3) THEN  
         FULL_PATH = SIM256(FILTER_CFG)
         INQUIRE (FILE = FULL_PATH, EXIST = EX, IOSTAT = IOS)
         IF (IOS.EQ.0 .AND. EX) THEN
C
C Read in the search parameters
C
            OPEN (UNIT = NOUT, FILE = FULL_PATH, IOSTAT = IOS)
            IF (IOS.EQ.0) THEN
               DO I = 1, 2*(NFILT1 + NFILT3 + 2)
                  READ (NOUT,'(A)',END=20,ERR=20,IOSTAT=IOS) TEMP(I)
                  IF (IOS.NE.0) GOTO 20
               ENDDO
               J = 2
               PATH1 = TEMP(J)
               DO I = 1, NFILT1
                  J = J + 1
                  TYPE1(I) = TEMP(J)(1:45)
                  J = J + 1
                  FILT1(I) = TEMP(J)(1:15)
               ENDDO
               J = J + 2
               PATH3 = TEMP(J)
               DO I = 1, NFILT3
                  J = J + 1
                  TYPE3(I) = TEMP(J)(1:45)
                  J = J + 1
                  FILT3(I) = TEMP(J)(1:15)
               ENDDO
            ENDIF
         ELSE
C
C Write out the default parameters
C
            OPEN (UNIT = NOUT, FILE = FULL_PATH, IOSTAT = IOS)
            WRITE (NOUT,'(A)') INFO1
            WRITE (NOUT,'(A)') PATH1
            DO I = 1, NFILT1
               WRITE (NOUT,'(A)') TYPE1(I)
               WRITE (NOUT,'(A)') FILT1(I)
            ENDDO
            WRITE (NOUT,'(A)') INFO3
            WRITE (NOUT,'(A)') PATH3
            DO I = 1, NFILT3
               WRITE (NOUT,'(A)') TYPE3(I)
               WRITE (NOUT,'(A)') FILT3(I)
            ENDDO
         ENDIF
         CLOSE (UNIT = NOUT)
      ENDIF
C
C**********************************************************************
C LABEL 20
C ========
C Main entry/re-entry point ... Set FIRST = .TRUE., ABORT = .TRUE......
C**********************************************************************
C
      
      FIRST = .TRUE.
   20 CONTINUE
      ABORT = .TRUE.

C
C Read w_output.cfg and w_input.cfg if ISEND is 1 or 3 and FIRST
C
      IF (ISEND.EQ.1 .OR. ISEND.EQ.3) THEN       
         IF (FIRST) THEN
C
C If FIRST check OUTPUT_CFG ..........................................
C                        
            FULL_PATH = SIM256(OUTPUT_CFG)
            INQUIRE (FILE = FULL_PATH, EXIST = EX, IOSTAT = IOS)
            IF (IOS.EQ.0 .AND. EX) THEN
               OPEN (UNIT = NOUT, FILE = FULL_PATH, IOSTAT = IOS)
               IF (IOS.EQ.0) THEN
                  IADD1 = 0
                  DO I = 1, NFSAV
                     IF (IOS.EQ.0) THEN
                        READ (NOUT,'(A)',IOSTAT=IOS) TEMP(1)
                        IF (IOS.EQ.0 .AND. TEMP(1).NE.BLANK) THEN
                           IADD1 = IADD1 + 1
                           FSAV1(IADD1) = TEMP(1)
                        ENDIF
                     ENDIF
                  ENDDO
               ENDIF
            ELSE    
               OPEN (UNIT = NOUT, FILE = FULL_PATH, IOSTAT = IOS)
               IF (IOS.EQ.0) THEN
                  DO I = 1, NFSAV
                     WRITE (NOUT,'(A)',IOSTAT=IOS) FSAV1(I)
                  ENDDO
               ENDIF   
            ENDIF
            CLOSE (UNIT = NOUT)
C
C If FIRST check w_input.cfg ...........................................
C                                           
            FULL_PATH = SIM256(INPUT_CFG)
            INQUIRE (FILE = FULL_PATH, EXIST = EX, IOSTAT = IOS)
            IF (IOS.EQ.0 .AND. EX) THEN
               OPEN (UNIT = NOUT, FILE = FULL_PATH, IOSTAT = IOS)
               IF (IOS.EQ.0) THEN
                  IADD1 = 0
                  DO I = 1, NFSAV
                     IF (IOS.EQ.0) THEN
                        READ (NOUT,'(A)',IOSTAT=IOS) TEMP(1)
                        IF (IOS.EQ.0 .AND. TEMP(1).NE.BLANK) THEN
                           IADD1 = IADD1 + 1
                           FSAV3(IADD1) = TEMP(1)
                        ENDIF
                     ENDIF
                  ENDDO
               ENDIF
            ELSE      
               OPEN (UNIT = NOUT, FILE = FULL_PATH, IOSTAT = IOS)
               IF (IOS.EQ.0) THEN
                  DO I = 1, NFSAV
                     WRITE (NOUT,'(A)',IOSTAT=IOS) FSAV3(I)
                  ENDDO
               ENDIF   
            ENDIF
            CLOSE (UNIT = NOUT)
            FIRST = .FALSE.
         ENDIF
C
C***********************************************************************
C Now call the file selection routine W_OFILE1
C***********************************************************************
C
         IF (JSEND.EQ.1) THEN
            FNAME = FSAV1(1)
            CALL W_OFILE1 (NFSAV, NUMDEC,
     +                     FNAME, FSAV1, FSAV3, 'SAVE')
         ELSEIF (JSEND.EQ.3) THEN
            FNAME = FSAV3(1)
            CALL W_OFILE1 (NFSAV, NUMDEC, 
     +                     FNAME, FSAV1, FSAV3, 'OPEN')
         ENDIF

C
C Act on the value of NUMDEC
C

         IF (NUMDEC.EQ.1) THEN
C
C Check the file name returned from w_ofile1
C
            CALL W95_TXT2FN (FNAME, 
     +                       ABORT)
            IF (ABORT .OR. FNAME.EQ.BLANK .OR. FNAME.EQ.STARS) THEN
               CALL PUTFAT (
     +'This is not a valid filename ... Try again')
               GOTO 20
            ENDIF
            SELECT = .FALSE.
         ELSEIF (NUMDEC.EQ.2) THEN
C
C Windows file selection requested in w_ofile1
C
            SELECT = .TRUE.
         ELSEIF (NUMDEC.EQ.3) THEN
C
C Configuration selected in w_ofile1
C
            IF (JSEND.EQ.1) THEN
               K = NFILT1
            ELSE
               K = NFILT3
            ENDIF
            I = 0
            CALL GETIM1 (I, J, K,
     +'Number of the type/filter pair to be changed (or 0 to cancel)')
            IF (J.EQ.0) GOTO 20
            LINE = 
     +'File type required (e.g. Data file)'
            IF (JSEND.EQ.1) THEN
               CALL GETSTR (LINE, TYPE1(J))
            ELSE
               CALL GETSTR (LINE, TYPE3(J))
            ENDIF
            LINE = 
     +'File filter required (e.g. *.dat)'
            IF (ISEND.EQ.1) THEN
               CALL GETSTR (LINE, FILT1(J))
            ELSE
               CALL GETSTR (LINE, FILT3(J))
            ENDIF
            GOTO 20
         ELSEIF (NUMDEC.EQ.4) THEN
C
C Help selected in w_ofile1
C
            WRITE (TEXT,100)
            NUMBLD(1) = 1
            NEXT = .TRUE.
            CALL TUTOR1 (ICOLOR, NUMBLD, NTEXT, 
     +                   TEXT,
     +                   FIXED, NEXT, UPDOWN)
            WRITE (TEXT,200)
            CALL TUTOR1 (ICOLOR, NUMBLD, NTEXT,
     +                   TEXT,
     +                   FIXED, NEXT, UPDOWN)
            NEXT = .FALSE.
            WRITE (TEXT,300)
            CALL TUTOR1 (ICOLOR, NUMBLD, NTEXT,
     +                   TEXT,
     +                   FIXED, NEXT, UPDOWN)
            NUMBLD(1) = 0
            GOTO 20
         ELSEIF (JSEND.GE.3 .AND. NUMDEC.GT.5) THEN
C
C Simfit test file or library file selected in w_ofile1
C
            SELECT = .TRUE.
         ELSE
C
C NUMDEC = 5 since cancel selected in w_ofile1
C
            ABORT = .TRUE.
            FNAME = BLANK
            RETURN
         ENDIF
      ENDIF

C
C Set NUMERR = 1 and define MYERR(1)....................................
C

      NUMERR = 1
      MYERR(NUMERR) = 
     +'An error has occurred concerning the file:'

C
C**********************************************************************
C Next is the code to open a new file if ISEND = 1 or ISEND = 2
C Note that if failure occurs with JSEND = 2, JSEND is re-set to 1
C**********************************************************************
C

C
C Attempt to open a new file for output................................
C

      IF (JSEND.EQ.1) THEN
         IF (SELECT) THEN
C***********************************************************************
C Action depends on whether FNAME is to be set in call to W_OFILE1
C***********************************************************************
            MUST_EXIST = 0 
            FNAME = 'Untitled'  
            CALL W_GETFFS (TITLE_1, FNAME, PATH1, TYPE1,
     +                     FILT1, NFILT1, MUST_EXIST)
         ENDIF
C
C Check for FNAME = BLANK
C
         IF (FNAME.EQ.BLANK) THEN
            ABORT = .TRUE.
            RETURN
         ENDIF
C
C Check for opening a binary file
C
         NOISY = .TRUE.
         CALL X_CHKEXT (FNAME,
     +                  NOISY, OK)
         IF (.NOT.OK) THEN
            ABORT = .TRUE.
            RETURN
         ENDIF                    
C
C Check to prevent the user opening a file in the simfit folder
C
         CALL W_CHKFLD (FNAME, 
     +                  ABORT)
         IF (ABORT) GOTO 20
      ENDIF
C
C Set NUMERR = 2 and define MYERR(2)...................................
C

      NUMERR = 2
      MYERR(NUMERR) = FNAME

C
C If ISEND = 2 then JSEND is re-set to 1 to read name after failure.....
C

      IF (JSEND.EQ.1 .OR. JSEND.EQ.2) THEN
         JSEND = 1
         I = LEN200(FNAME)
         IF (I.GT.4) THEN
            WORD4 = FNAME(I - 3:I)
            CALL LCASE1 (WORD4)
            IF (WORD4.EQ.'.exe' .OR. WORD4.EQ.'.dll') THEN
               ABORT = .TRUE.
               NUMERR = NUMERR + 1
               MYERR(NUMERR) = 
     +'Cannot Open/Save .exe or .dll files'
               GOTO 60
            ENDIF
         ENDIF
         CALL W95_TXT2FN (FNAME,
     +                    ABORT)
         IF (ABORT) THEN
            NUMERR = NUMERR + 1
            MYERR(NUMERR) =
     +'Filename is not consistent with this operating system'
            GOTO 60
         ENDIF
         CALL ATTRIB (FNAME,
     +                EX, READ_ONLY)
         IF (EX .AND. READ_ONLY) THEN
            NUMERR = NUMERR + 1
            MYERR(NUMERR) =
     +'This file is read only and cannot be deleted'
            GOTO 60
         ENDIF
         INQUIRE (FILE = FNAME, EXIST = EX, ERR = 60, IOSTAT = IOS,
     +            OPENED = OP)
         IF (EX .AND. OP) THEN
            NUMERR = NUMERR + 1
            MYERR(NUMERR) =
     +'This file is currently connected for I/O'
            GOTO 60
         ENDIF
         IF (EX) THEN
            CALL PUTBEL
            IF (OP) THEN
               NUMERR = NUMERR + 1
               MYERR(NUMERR) =
     +'This file is currently connected for I/O'
               GOTO 60
            ENDIF
            LINE = 
     +'This file already exists ... Delete then over-write it ?'
            YES = .FALSE.
            CALL YESNO2 (ICOLOR, IX, IY,
     +                   LINE,
     +                   YES)
            IF (YES) THEN
               CALL DELEET (FNAME,
     +                      ASKIF, THERE)
               IF (THERE) THEN
                  NUMERR = NUMERR + 1
                  MYERR(NUMERR) =
     +'This file is currently connected for I/O'
                  GOTO 60
               ENDIF
            ELSE
               NUMERR = NUMERR + 1
               MYERR(NUMERR) = 
     +'This file already exists in filestore'
               GOTO 60
            ENDIF
         ENDIF
         IF (IOS.NE.0) GOTO 60

         IF (ISEND.EQ.1) THEN
C
C Write a new FILTER_CFG file only if successful........................
C           
            FULL_PATH = SIM256(FILTER_CFG)
            INQUIRE (FILE = FULL_PATH, EXIST = EX, IOSTAT = IOS)
            ERROR_CODE = 0
            IF (IOS.EQ.0 .AND. EX) CALL DELEET (FULL_PATH,
     +                                          ASKIF, THERE)
            IF (THERE) THEN
               ERROR_CODE = 1
            ELSE
               ERROR_CODE = 0
            ENDIF
            IF (ERROR_CODE.EQ.0) THEN
               L2 = LEN200 (FNAME)
               DO I = L2, 1, - 1
                  IF (ERROR_CODE.EQ.0) THEN
                     IF (FNAME(I:I).EQ.'\') THEN
                        ERROR_CODE = 1
                        L1  = I
                     ELSEIF (FNAME(I:I).EQ.':') THEN
                        ERROR_CODE = 1
                        L1 = I + 1
                     ENDIF
                  ENDIF
               ENDDO
               IF (ERROR_CODE.NE.0 .AND. L1.LT.L2 .AND. L1.GT.1) THEN
                  ERROR_CODE = 0
                  IF (FNAME(2:2).EQ.':') PATH1 = FNAME(1:L1 - 1)
               ENDIF
               OPEN (UNIT = NOUT, FILE = FULL_PATH)
               WRITE (NOUT,'(A)') INFO1
               WRITE (NOUT,'(A)') PATH1
               DO I = 1, NFILT1
                  WRITE (NOUT,'(A)') TYPE1(I)
                  WRITE (NOUT,'(A)') FILT1(I)
               ENDDO
               WRITE (NOUT,'(A)') INFO3
               WRITE (NOUT,'(A)') PATH3
               DO I = 1, NFILT3
                  WRITE (NOUT,'(A)') TYPE3(I)
                  WRITE (NOUT,'(A)') FILT3(I)
               ENDDO
               CLOSE (UNIT = NOUT)
            ENDIF
         ENDIF

C
C Now attempt to connect FNAME to NOUT and update w_output.cfg if ISEND = 1
C
         OPEN (UNIT = NOUT, FILE = FNAME, IOSTAT = IOS, STATUS = 'NEW')
         IF (IOS.NE.0) GOTO 60
         IF (ISEND.EQ.1) THEN
            CLOSE (UNIT = NOUT)
            IF (FNAME.NE.FSAV1(1)) THEN
               DO I = NFSAV, 2, -1
                  FSAV1(I) = FSAV1(I - 1)
               ENDDO  
               FSAV1(1) = FNAME
            ENDIF   
            CALL X_SAVCFG (ISEND,
     +                     FNAME)
            OPEN (UNIT = NOUT, FILE = FNAME, IOSTAT = IOS)
         ENDIF                 
C
C Success ... A new/overwritten file is now connected for writing......
C
         ABORT = .FALSE.
         RETURN
      ENDIF

C
C**********************************************************************
C Here when ISEND = 3 or ISEND = 4 to open an existing file for input
C Note that if failure occurs with JSEND = 4, then JSEND is re-set to 3
C**********************************************************************
C

C
C Attempt to open a file for reading...................................
C

      IF (JSEND.EQ.3) THEN
         IF (SELECT) THEN
C**********************************************************************
C Action depends on whether FNAME is to be set in call to W_OFILE1
C**********************************************************************
            IF (NUMDEC.EQ.6 .OR. NUMDEC.EQ.7) THEN
C
C Special action if a test or library file has been requested in w_ofile1
C
               SAV_FILT = FILT3(1)
               SAV_PATH = PATH3
               SAV_TYPE = TYPE3(1) 
               CALL DEMDIR (L,
     +                      SIMFIT)                
               PATH3 = SIMFIT
               IF (NUMDEC.EQ.6) THEN
                  FILT3(1) = '*.tf?'
                  TYPE3(1) = 'Simfit test files'
               ELSE
                  FILT3(1) = '*.tfl'
                  TYPE3(1) = 'Simfit library files'
               ENDIF
            ENDIF
            MUST_EXIST = 1
            CALL W_GETFFS (TITLE_3, FNAME, PATH3, TYPE3,
     +                     FILT3, NFILT3, MUST_EXIST)
            IF (NUMDEC.EQ.6 .OR. NUMDEC.EQ.7) THEN
C
C Restore defaults if test or library files had been requested in w_ofile1
C
               PATH3 = SAV_PATH
               FILT3(1) = SAV_FILT(1:15)
               TYPE3(1) = SAV_TYPE
            ENDIF
         ENDIF
C
C Check for FNAME = BLANK
C
         IF (FNAME.EQ.BLANK) THEN
            ABORT = .TRUE.
            RETURN
         ENDIF
C
C Check for binary files
C
         I = LEN200(FNAME)
         IF (I.GT.4) THEN
            NOISY = .TRUE.
            CALL X_CHKEXT (FNAME,
     +                     NOISY, OK)
            IF (.NOT.OK) THEN
               ABORT = .TRUE.
               FNAME = BLANK
               RETURN            
            ENDIF
         ENDIF
         INQUIRE (FILE = FNAME, EXIST = EX, IOSTAT = IOS)
         IF (IOS.NE.0 .OR. .NOT.EX) GOTO 40
         IF (ISEND.EQ.3) THEN
C
C Write a new FILTER_CFG file only if successful
C                                                 
            FULL_PATH = SIM256(FILTER_CFG)
            INQUIRE (FILE = FULL_PATH, EXIST = EX, IOSTAT = IOS)
            ERROR_CODE = 0
            IF (IOS.EQ.0 .AND. EX) CALL DELEET (FULL_PATH,
     +                                          ASKIF, THERE)
            IF (THERE) THEN
               ERROR_CODE = 1
            ELSE
               ERROR_CODE = 0
            ENDIF
            IF (ERROR_CODE.EQ.0) THEN
               L2 = LEN200 (FNAME)
               DO I = L2, 1, - 1
                  IF (ERROR_CODE.EQ.0) THEN
                     IF (FNAME(I:I).EQ.'\') THEN
                        ERROR_CODE = 1
                        L1 = I
                     ELSEIF (FNAME(I:I).EQ.':') THEN
                        ERROR_CODE = 1
                        L1 = I + 1
                     ENDIF
                  ENDIF
               ENDDO
               IF (ERROR_CODE.NE.0 .AND. L1.LT.L2 .AND. L1.GT.1) THEN
                  ERROR_CODE = 0
                  IF (FNAME(2:2).EQ.':') PATH3 = FNAME(1:L1 - 1)
               ENDIF
               OPEN (UNIT = NOUT, FILE = FULL_PATH)
               WRITE (NOUT,'(A)') INFO1
               WRITE (NOUT,'(A)') PATH1
               DO I = 1, NFILT1
                  WRITE (NOUT,'(A)') TYPE1(I)
                  WRITE (NOUT,'(A)') FILT1(I)
               ENDDO
               WRITE (NOUT,'(A)') INFO3
               WRITE (NOUT,'(A)') PATH3
               DO I = 1, NFILT3
                  WRITE (NOUT,'(A)') TYPE3(I)
                  WRITE (NOUT,'(A)') FILT3(I)
               ENDDO
               CLOSE (UNIT = NOUT)
            ENDIF
         ENDIF
      ENDIF

C
C Now attempt to connect FNAME to NOUT and update w_input.cfg if ISEND = 3
C
      IF (ISEND.EQ.3) THEN
         CLOSE (UNIT = NOUT)
         IF (FNAME.NE.FSAV3(1)) THEN
            DO I = NFSAV, 2, -1
               FSAV3(I) = FSAV3(I - 1)
            ENDDO
            FSAV3(1) = FNAME    
         ENDIF   
         I = 2
         CALL X_SAVCFG (I,
     +                  FNAME)
      ENDIF       
      OPEN (UNIT = NOUT, FILE = FNAME, IOSTAT = IOS, STATUS = 'OLD')
      IF (IOS.NE.0) GOTO 60

C
C Success ... A file is now connected for reading in data...............
C

      ABORT = .FALSE.
      RETURN

C
C***********************************************************************
C LABEL 40
C ========
C Arrive here if failure to read in a file..............................
C***********************************************************************
C

   40 CONTINUE
C
C Set NUMERR = 2 so that MYERR(2) = FNAME...............................
C
      NUMERR = 2
      MYERR(NUMERR) = FNAME
C
C If JSEND = 4 then JSEND is re-set to 3 to read name after failure.....
C
      IF (JSEND.EQ.3 .OR. JSEND.EQ.4) THEN
         JSEND = 3
         CALL W95_TXT2FN (FNAME,
     +                    ABORT)
         IF (ABORT) THEN
            NUMERR = NUMERR + 1
            MYERR(NUMERR) = 
     +'Filename is not consistent with this operating system'
            GOTO 60
         ENDIF
         INQUIRE (FILE = FNAME, EXIST = EX, ERR = 60, IOSTAT = IOS,
     +            OPENED = OP)
         IF (.NOT.EX) THEN
            NUMERR = NUMERR + 1
            MYERR(NUMERR) = 
     +'This file was not found in filestore'
            GOTO 60
         ELSE
            IF (OP) THEN
               NUMERR = NUMERR + 1
               MYERR(NUMERR) =
     +'This file is currently connected for I/O'
               GOTO 60
            ENDIF
         ENDIF
         IF (IOS.NE.0) GOTO 60
         ABORT = .FALSE.
         RETURN
      ENDIF

C
C***********************************************************************
C LABEL 60
C ========
C Here if an error has occurred........................................
C***********************************************************************
C

   60 CONTINUE
      CALL PUTBEL
      IF (IOS.NE.0) THEN
         NUMERR = NUMERR + 1
         WRITE (MYERR(NUMERR),400) IOS
         NUMERR = NUMERR + 1
         WRITE (MYERR(NUMERR),500)
      ENDIF
      NUMERR = NUMERR + 1
      MYERR(NUMERR) = BLANK
      LINE = 
     +'Try another filename ?'
      YES = .TRUE.
      CALL YESNO1 (ICOLOR, IX, IY, LSHADE, NUMCOL, NUMROW, NUMERR,
     +             LINE, MYERR,
     +             BORDER, FLASH, HIGH, YES)
      IF (YES) GOTO 20
      ABORT = .TRUE.
C
C Format statements
C      
  100 FORMAT (
     + 'Created and Analysed file types'
     +/
     +/'In order to facilitate the naming of new files and locating of'
     +/'old files, Simfit distinguishes between recently created and'
     +/'recently analysed file types.'
     +/
     +/'Created files are files generated from Simfit using the Save As'
     +/'mode, for example data files or results files.'
     +/
     +/'Analysed files are files that have been accessed using the Open'
     +/'mode, for example data files read in for plotting or fitting.'
     +/
     +/'Simfit saves the names of the last 200 files you have created'
     +/'or analysed in two lists, i.e. 100 of each type.'
     +/'Clearly some files can occur in both categories but it does not'
     +/'matter since you will usually remember if the file you want now'
     +/'was recently analysed or recently created.'
     +/'You can toggle between the lists of file types and you can also'
     +/'step sequentially backwards or forwards to help locate a file'
     +/'name for editing, e.g. changing results.10 to results.11, etc.')
  200 FORMAT (
     + 'Alternative ways to use this file selection control'
     +/'1)`You can type filenames into the box and press [OK], which is'
     +/'  `useful if the filename required is the same as the filename'
     +/'  `in the box, or can be transformed easily into the desired'
     +/'  `filename by a few key presses. Use the [<<] [>>] buttons'
     +/'  `to step backwards or forwards through recent files and the'
     +/'  `[Swap Type] button to toggle between Analysed/Created types.'
     +/'2)`In Open mode you can click on the [Analysed] or [Created]'
     +/'  `buttons to select from recently Analysed or Created files.'
     +/'  `If you select from these Analysed or Created file lists the'
     +/'  `file is selected directly and you cannot overwrite letters'
     +/'  `in the file name. Pressing the [Demo] button allows you to'
     +/'  `select from test files to demonstrate the program functions.'
     +/'3)`In Open mode when there are data on the clipboard, you can'
     +/'  `select the [Paste] button to paste to a temporary file, but'
     +/'  `make sure that the clipboard data are correctly formatted.'
     +/'4)`You can always click the [Browse] button to use the Windows'
     +/'  `control. Wildcards, e.g. c:\Program Files\simfit\*.tf?, have'
     +/'  `the effect of re-setting the path and filter to facilitate'
     +/'  `temporary re-grouping for file selection.')
  300 FORMAT (
     + 'Editing the paths, types and filters'
     +/
     +/'File selection by mouse click is facilitated by setting paths'
     +/'and filters to appropriate values for your current project.'
     +/'Path means the path from the drive to the folder concerned, and'
     +/'types are descriptive, while filters make use of wildcards.'
     +/'Suppose, for example, you require a test file, e.g. exfit.tf4.'
     +/'The file might be c:\Program Files\simfit\exfit.tf4, so that'
     +/'path = c:\Program Files\simfit, type = Simfit test file, and'
     +/'filter could be exfit.*, *.tf?, *.tf4, ex???.tf4, ex*, etc.'
     +/'You can select a path interactively by changing the folder and'
     +/'you can select a filter as required from the defaults but, to'
     +/'set up your own defaults, you can choose the option to change a'
     +/'filter (and it''s associated type) using the Configure button.'
     +/'The information to store paths, types and filters is written to'
     +/'a configuration file (w_filter.cfg) which is created in the'
     +/'current folder when you successfully make or read in a file.'
     +/'You can edit w_filter.cfg and make it read only, or delete it,'
     +/'in which case Simfit will create a new local default file.'
     +/'Similarly w_input.cfg and w_output.cfg archive file names.')
  400 FORMAT ('Input/Output status specifier value: IOSTAT =',I6)
  500 FORMAT (
     +'Path-filename error, File is read-only, or File is connected ?')
      END
C
C
