C
C
      SUBROUTINE ONEFIT (NCOL, NIN, NROW,
     +                   FNAMEA, HEADER, TFILE, TITLEA,
     +                   ABORT, SHOWIT)
C
C ACTION : Get an arbitrary file but no space allocated
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          14/02/2008 derived from FITONE but with no restrictions on n, m, or A(i,j)
C
C         NCOL: (input/output) column dimension
C          NIN: (input/unchanged) unconnected unit for reading in data
C         NROW: (input/output) row dimension
C       FNAMEA: (input/output) file name
C       HEADER: (input/unchanged) header for menu
C        TFILE: (input/unchanged) appropriate test file
C       TITLEA: (input/output) title
C        ABORT: (output) error indicator
C
C Note: This version can change NCOL and NROW and only returns
C       ABORT = .TRUE. if there are no appropriate data, or the
C       user has selected Cancel to abort further calculations.
C
      IMPLICIT   NONE
C
C Arguments
C       
      INTEGER,             INTENT (IN)    :: NIN
      INTEGER,             INTENT (INOUT) :: NCOL, NROW 
      CHARACTER (LEN = *), INTENT (IN)    :: HEADER, TFILE
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAMEA, TITLEA
      LOGICAL,             INTENT (INOUT) :: SHOWIT
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Locals
C
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMDEC, NUMOPT, NSTART,
     +           NTEXT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, NUMOPT = 5,
     +           NSTART = 10, NTEXT = NUMOPT + NSTART - 1)
      INTEGER    N0, N1, N2, N3, N4
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4)
      INTEGER    NUMBLD(30), NUMPOS(NUMOPT)
      INTEGER    ISEND
      INTEGER    I, NCOL1, NROW1
      CHARACTER  ZNAME*80, ZTITLE*80
      CHARACTER  LINE*100, TEXT(30)*100
      CHARACTER  CHOP80*80, TRIM80*80, TRIM60*60
      CHARACTER  BLANK*1, NODATA*30, NOFILE*30, READY*30, STATE*30
      PARAMETER ( BLANK = ' ',
     +           NODATA = '(... No data ...)',
     +           NOFILE = '(... No file ...)',
     +            READY = '(*** Ready ***)')
      LOGICAL    BORDER, FLASH, HIGH, REPEET
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    FIXCOL, FIXROW, LABEL
      PARAMETER (FIXCOL = .FALSE., FIXROW = .FALSE., LABEL = .TRUE.)
      EXTERNAL   PUTFAT, LBOX01, CHOP80, PUTADV,  PATCH1, VIEWER,
     +           TRIM80, MAT3IN, TRIM60, ISITMF
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / NUMOPT*1 /
C
C Check parameters supplied
C
      CALL ISITMF (NCOL1, NROW1,
     +             FNAMEA)
      IF (NCOL1.NE.NCOL .OR. NROW1.NE.NROW) THEN
         NCOL = N0
         NROW = N0
      ENDIF
      IF (NCOL.LT.N1 .OR. NROW.LT.N2) THEN
         NCOL = N0
         NROW = N0
         FNAMEA = NOFILE
         TITLEA = NODATA
      ENDIF
C
C Initialise
C
      ZNAME = TRIM80(FNAMEA)
      ZTITLE = CHOP80(TITLEA)
C
C Loop
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (NCOL.LT.N1 .OR. NROW.LT.N2) THEN
            NCOL = N0
            NROW = N0
            STATE = NODATA
            NUMDEC = N3
            ZNAME = NOFILE
            ZTITLE = NODATA
         ELSE
            STATE = READY
            NUMDEC = N1
         ENDIF
         WRITE (TEXT,100) HEADER, ZNAME, ZTITLE, NROW, NCOL, STATE
         NUMBLD(1) = N4
         NUMBLD(4) = N1
         NUMBLD(7) = N1
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = N0
         NUMBLD(4) = N0
         NUMBLD(7) = N0
         IF (NUMDEC.LT.N2) THEN
            IF (NCOL.LT.N1 .OR. NROW.LT.N1) THEN
               WRITE (LINE,200)
               CALL PUTFAT (LINE)
               NUMDEC = N0
            ENDIF
         ENDIF
         IF (NUMDEC.EQ.N1) THEN
C
C Analyse
C
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (NUMDEC.EQ.N2) THEN
C
C View file
C
            CALL VIEWER (N1,
     +                   FNAMEA, BLANK, BLANK)
         ELSEIF (NUMDEC.EQ.N3) THEN
C
C Read in new A data
C
            IF (SHOWIT) THEN
               SHOWIT = .FALSE.
               WRITE (LINE,300) TRIM60(TFILE)
               CALL PUTADV (LINE)
            ENDIF   
            ISEND = N2
            CLOSE (UNIT = NIN)
            CALL MAT3IN (ISEND, NCOL, NIN, NROW,
     +                   FNAMEA, TITLEA,
     +                   ABORT, FIXCOL, FIXROW, LABEL)
            CLOSE (UNIT = NIN)
            IF (ABORT) THEN
               NCOL = N0
               NROW = N0
            ELSE
               ZNAME = TRIM80(FNAMEA)
               ZTITLE = CHOP80(TITLEA)
            ENDIF
         ELSEIF (NUMDEC.EQ.NUMOPT - N1) THEN
C
C Help
C
            WRITE (TEXT,400)
            I = 22
            NUMBLD(1) = N1
            NUMBLD(11) = N1
            CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, I,
     +                   TEXT,
     +                   BORDER)
            NUMBLD(1) = N0
            NUMBLD(11) = N0
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C Cancel
C
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statements
C
  100 FORMAT (
     + A
     +/
     +/'Name of the current data file:'
     +/A
     +/
     +/'Title of the current data set:'
     +/A
     +/
     +/'Number of rows:',I6,', Number of columns:',I3
     +/'Analyse the current data set',1X,A
     +/'View the current data file'
     +/'New data'
     +/'Help'
     +/'Quit ... Exit this data input procedure')
  200 FORMAT ('no. of rows < 1, or no. of columns < 1')
  300 FORMAT ('Input data formatted like',1X,A)
  400 FORMAT (
     + 'Supplying data samples A(i,j) for analysis'
     +/
     +/'There must be no missing values, n rows and m columns'
     +/'as follows:' 
     +/'A(1,1), A(1,2), ..., A(1,m)'
     +/'A(2,1), A(2,2), ..., A(2,m)'
     +/'...'
     +/'A(n,1), A(n,2), ..., A(n,m)'
     +/'There may be restrictions on n, m, or the A(i,j) values.'
     +/
     +/'Alternative methods to supply data'
     +/'1)`You can make a file using program MAKMAT. This is the best'
     +/'  `method since a permanent copy of your data will be saved.'
     +/'2)`You can create a file from your spreadsheet program, e.g.'
     +/'  `from Excel using a macro such as simfit4.xls.'
     +/'3)`You can copy a table from your spreadsheet to the clipboard'
     +/'  `then paste it in after choosing the [New data] option.'
     +/'4)`You can edit or transform an existing sample interactively.'
     +/'  `If you do this it will not alter the original data set'
     +/'  `which will be restored after analysis has been completed.'
     +/'5)`Any format can be used, e.g. 10, 10.0, 1.e1, 1.0e+01, etc.'
     +/'  `for ten, but you should always supply a meaningful title.')
      END
C
C
