c
c
      subroutine parse1 (isend,
     +                   line,
     +                   abort)
c
c action: elementary string operations prior to parsing clipboard, etc.
c author: w.g.bardsley, university of manchester, u.k.
c         30/02/2007 now calls x_parse1

c         About the parse? routines
c         =========================
c         Note that maximum string length (nmax) should be the same in all
c         of these routines.
c         The routines are designed to take a string and manipulate it
c         or analyse it as follows.
c
c         parse1: perform elementary string transformations to prepare a
c                 string for further analysis. This can be used as a free
c                 standing string parser and transformer.
c         parse2: calculate the number of numerical and non-numerical values
c                 in a string processed by parse1 with isend = 5, i.e. with
c                 non-printing characters removed, ',,' replaced by ',X,',
c                 commas suppressed, and multiple blanks replaced by single
c                 blanks so that the string only contains space separated tokens.
c                 This will ONLY work on strings pre-processed by parse1 with
c                 isend = 5
c         parse3: break up a string at DOS-type hard returns then write a
c                 temporary file with the data after processing by parse1 with
c                 isend = 5 and suppressing blank lines.
c                 After further use the temporary file must be deleted.
c         parse4: analyse a file created by parse4 to calculate statistics
c                 for the number of words, numerical values, etc. This routine
c                 will only work on files of the type returned by parse3.
c                 After further use the temporary file must be deleted.
c         parse5: This relies on the other parse? routines to take in a
c                 string, parse, display diagnostics, and then Save As ...
c                 A file name must be provided and this is not deleted.
c                 Failure to write a file is signalled by abort = .true. on return.
c         parse6: This checks that if a line has a nonnumeric token it is the
c                 first, so allowing simfit label type files with row labels
c                 in column 1.
c         parse7: This breaks a string into labels at tabs, semicolons, or commas.   
c         parse8: checks if a simfit file can be created
c         parse9: checks if a token is numerical
c
c         isend: (input/unchanged) as follows:-
c                isend = -4: replace commas by dots if there are tabs or semi-colons present
c                isend = -3: replace nonpronting ASCII characters by blanks
c                isend = -2: deal with quoted tokens
c                isend = -1: break into tokens at tabs and underscore potential labels
c                isend = 0: break into tokens at semicolons and underscore potential labels
c                isend = 1: replace all nonprinting characters by blanks
c                isend = 2: break into tokens at commas and underscore potential labels
c                isend = 3: replace all commas by single blanks
c                isend = 4: replace all multiple blanks by single blanks
c                isend = 5: all of the above sequentially
c          line: (input/output) line to be transformed
c         abort: (output) error indicator
c
      implicit   none
c
c arguments
c
      integer,             intent (in)    :: isend
      character (len = *), intent (inout) :: line
      logical,             intent (out)   :: abort
c
c locals
c
      integer    new_isend
      external   x_parse1 
      new_isend = isend
      call x_parse1 (new_isend,
     +               line,
     +               abort) 
      end
c
c
