c
c 06/02/2019 now contains:
c            pfile0 and 
c            qfile0
c
      subroutine pfile0
c
c action: select project archive type required then call pfiles
c author: w.g.bardsley, university of manchester, u.k.,16/03/2009
c         24/12/2018 added SVG file type 
c         29/01/2019 corrected code for nin and nout to prevent writing a local file
c
      implicit   none
      integer    i, iprev, itype, nfiles, nin, nout, numdec 
      integer    nmax, ntext, numopt, numsta, numtxt
      parameter (nmax = 1000, numopt = 10, numsta = 9,
     +           numtxt = numsta + numopt - 1, ntext = 24)
      integer    numbld(30)
      character (len = 1024) files(nmax)
      character (len = 100 ) text(30)
      character  (len = 1  )  blank
      parameter (blank = ' ')
      logical    op1, op2
      logical    accept(nmax), repeet
      external   lstbox, pfiles, patch2
      data       numbld / 30*0 /
c
c define two unopened units nin and nout
c      
      nin = 12
      inquire (unit = nin, opened = op1)
      do while (op1)
         nin = nin + 1
         inquire (unit = nin, opened = op1)
      enddo
      nout = nin + 1   
      inquire (unit = nout, opened = op2)
      do while (op2)
         nout = nout + 1 
         inquire (unit = nout, opened = op2)
      enddo   
      close (unit = nin) 
      close (unit = nout)
c
c main loop
c       
      repeet = .true.
      do while (repeet)
         write (text,100)
         numdec = numopt - 1
         numbld(1) = 4
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         numbld(1) = 0
         if (numdec.lt.numopt - 1) then
c
c edit the chosen project archive file
c           
            iprev = 0
            itype = 0
            nfiles = 0
            do i = 1, nmax 
               files(i) = blank
               accept(i) = .false.
            enddo  
            itype = numdec
            call pfiles (iprev, itype, nfiles, nin, nmax, nout, 
     +                   files,
     +                   accept)
         elseif (numdec.eq.numopt - 1) then
c
c help
c         
            write (text,200)
            numbld(1) = 1
            numbld(19) = 1
            call patch2 (numbld, ntext,
     +                   text)
            numbld(1) = 0
            numbld(19) = 0            
         else
c
c cancel
c           
            repeet = .false.           
         endif            
      enddo 
      close (nin)
      close (nout) 
c
c format statements
c      
  100 format (
     + 'Select the project archive file type required'
     +/
     +/'Your project archives store lists of files of the same type'
     +/'to facilitate the selecting of one or multiple files for input'
     +/'into Simfit programs. For example multiple graphics files'
     +/'for program Simplot, or using programs Editps or Editsvg to'
     +/'create collages. Now select the file type required.'
     +/
     +/'Arbitrary file types'
     +/'Vector files'
     +/'Matrix files'
     +/'Graphics files'
     +/'Curve fitting files'
     +/'EPS (encapsulated PostScript files)'
     +/'Parameter/Covariance matrix files'
     +/'SVG (scalable vector graphics files)'
     +/'Help'
     +/'Quit ... Exit file type selection procedure')     
  200 format (
     + 'Simfit project archive listing files'   
     +/
     +/'This is the superior way for advanced users to select single'
     +/'files, or groups of files, for analysis by Simfit. For each'
     +/'file type, a list can be created of files that are consistent'
     +/'with the procedure required. When a project archive data input'
     +/'technique is chosen, the corresponding listing file is checked'
     +/'and updated, by deleting missing or inconsistent files.'
     +/'The project archive listing files are as follows:'
     +/'a_recent.cfg`... all file type'
     +/'v_recent.cfg`... vector files'
     +/'m_recent.cfg`... matrix files'
     +/'g_recent.cfg`... graphics files'
     +/'f_recent.cfg`... curve fitting files'
     +/'p_recent.cfg`... EPS (encapsulated PostScript files)'
     +/'c_recent.cfg`... parameter/covariance-matrix files'
     +/'s_recent.cfg`... SVG (scalable vector graphics files)'
     +/
     +/'Further details'
     +/'1)`To add, choose [Add n files from disk/filestore] then choose'
     +/'  `[Accept] then [Add these n files to the PROJECT archive ..].'
     +/'2)`Simfit library files have a title, then a list of the files'
     +/'  `to be analysed, and are more suitable for repeated analysis'
     +/'  `with fixed groups of related files.')
      end
c
c---------------------------------------------------------------------------------
c
      subroutine qfile0
c
c action: select project archive type required then call qfiles
c author: w.g.bardsley, university of manchester, u.k.,16/03/2009
c         04/02/2019 developed from pfile0 
c
      implicit   none
      integer    i, itype, nfiles, nin, nout, numdec 
      integer    nmax, ntext, numopt, numsta, numtxt
      parameter (nmax = 1000, numopt = 10, numsta = 9,
     +           numtxt = numsta + numopt - 1, ntext = 24)
      integer    numbld(30)
      character (len = 1024) files(nmax)
      character (len = 100 ) text(30)
      character  (len = 1  )  blank
      parameter (blank = ' ')
      logical    op1, op2
      logical    accept(nmax), repeet
      external   lstbox, qfiles, patch2
      data       numbld / 30*0 /
c
c define two unopened units nin and nout
c      
      nin = 12
      inquire (unit = nin, opened = op1)
      do while (op1)
         nin = nin + 1
         inquire (unit = nin, opened = op1)
      enddo
      nout = nin + 1   
      inquire (unit = nout, opened = op2)
      do while (op2)
         nout = nout + 1 
         inquire (unit = nout, opened = op2)
      enddo   
      close (unit = nin) 
      close (unit = nout)
c
c main loop
c       
      repeet = .true.
      do while (repeet)
         write (text,100)
         numdec = numopt - 1
         numbld(1) = 4
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         numbld(1) = 0
         if (numdec.lt.numopt - 1) then
c
c edit the chosen project archive file
c           
            itype = 0
            nfiles = 0
            do i = 1, nmax 
               files(i) = blank
               accept(i) = .false.
            enddo  
            itype = numdec
            call qfiles (itype, nfiles, nin, nmax, nout, 
     +                   files,
     +                   accept)
         elseif (numdec.eq.numopt - 1) then
c
c help
c         
            write (text,200)
            numbld(1) = 1
            numbld(19) = 1
            call patch2 (numbld, ntext,
     +                   text)
            numbld(1) = 0
            numbld(19) = 0            
         else
c
c cancel
c           
            repeet = .false.           
         endif            
      enddo 
      close (nin)
      close (nout) 
c
c format statements
c      
  100 format (
     + 'Select the project archive file type required'
     +/
     +/'Your project archives store lists of files of the same type'
     +/'to facilitate the selecting of one or multiple files for input'
     +/'into Simfit programs. For example multiple graphics files'
     +/'for program Simplot, or using programs Editps or Editsvg to'
     +/'create collages. Now select the file type required.'
     +/
     +/'Arbitrary file types'
     +/'Vector files'
     +/'Matrix files'
     +/'Graphics files'
     +/'Curve fitting files'
     +/'EPS (encapsulated PostScript files)'
     +/'Parameter/Covariance matrix files'
     +/'SVG (scalable vector graphics files)'
     +/'Help'
     +/'Quit ... Exit file type selection procedure')     
  200 format (
     + 'Simfit project archive listing files'   
     +/
     +/'This is the superior way for advanced users to select single'
     +/'files, or groups of files, for analysis by Simfit. For each'
     +/'file type, a list can be created of files that are consistent'
     +/'with the procedure required. When a project archive data input'
     +/'technique is chosen, the corresponding listing file is checked'
     +/'and updated, by deleting missing or inconsistent files.'
     +/'The project archive listing files are as follows:'
     +/'a_recent.cfg`... all file type'
     +/'v_recent.cfg`... vector files'
     +/'m_recent.cfg`... matrix files'
     +/'g_recent.cfg`... graphics files'
     +/'f_recent.cfg`... curve fitting files'
     +/'p_recent.cfg`... EPS (encapsulated PostScript files)'
     +/'c_recent.cfg`... parameter/covariance-matrix files'
     +/'s_recent.cfg`... SVG (scalable vector graphics files)'
     +/
     +/'Further details'
     +/'1)`To add, choose [Add n files from disk/filestore] then choose'
     +/'  `[Accept] then [Add these n files to the PROJECT archive ..].'
     +/'2)`Simfit library files have a title, then a list of the files'
     +/'  `to be analysed, and are more suitable for repeated analysis'
     +/'  `with fixed groups of related files.')
      end
c
c-------------------------



