c
c 06/02/2019 now contains
c            pfile1 and
c            qfile1  
c
      subroutine pfile1 (itype, nfiles, nfmax,
     +                   files,
     +                   new)
c
c action: build up a project set of files using single or multiple file selection
c author: w.g.bardsley, university of manchester, u.k., 16/02/2001
c         25/10/2002 increased dimension of maxpro from 200 to 300, changed
c                    supplied dimension argument from nmax to nfmax then
c                    limited maximum files allowed for a project to
c                    min(maxpro,nfmax)
c         30/03/2006 increased MAXPRO to 1000 
c         23/01/2007 added sim256 and redimensioned w_recent_cfg 
c         14/03/2007 corrected error re-initialising files
c         24/12/2018 added SVG file type 
c
c  itype: (input/unchanged) as follows:
c          itype = 1: all files,                          a_recent.cfg
c          itype = 2: vector files,                       v_recent.cfg
c          itype = 3: matrix files,                       m_recent.cfg
c          itype = 4: graphics files,                     g_recent.cfg
c          itype = 5: fitting files,                      f_recent.cfg
c          itype = 6: EPS PostScript graphics files,      p_recent.cfg
c          itype = 7: Covariance matrix,                  c_recent.cfg
c          itype = 8: SVG scalable vector graphics files, s_recent.cfg 
c nfiles: (input/output) as follows:
c          nfiles = 0 on entry: start a new project (no files intitialised)
c          nfiles > 0 on entry: add to an existing project with nfiles files
c          nfiles = dimension of project on exit
c  nfmax: (input/unchanged) as follows:
c          nfmax = maxmimum number of files allowed in project
c  files: (input/output) as follows:
c          files = names of files selected
c    new: (output) as follows:
c          new = .true. if new files are selected, not just project files
c
c          ******************************************************
c          Note: maxpro must be consistent with PFILES and PFILE2
c                and be =< nmax in lbox02 and lboxm2
c          ******************************************************
c
      implicit   none
c
c arguments
c
      integer,             intent (in)    :: itype, nfmax  
      integer,             intent (inout) :: nfiles
      character (len = *), intent (inout) :: files(nfmax)
      logical,             intent (out)   :: new
c
c locals
c
      integer    i, isend, ios, nfile1, jbot, jmid, jtop, nmax, nmax1,
     +           nout, n_project, nsav, nstart
      integer    maxpro, ntop
      parameter (maxpro = 1000, ntop = maxpro + 1)
      integer    icolor, ix, iy, numdec, numopt, 
     +           numsta, numtxt
      parameter (icolor = 7, ix = 4, iy = 4, 
     +           numopt = 10, numsta = 9, numtxt = numsta + numopt - 1)
      integer    numbld(30), numpos(ntop)
      character  buffer(ntop)*1024
      character  fname*1024, fsav*1024, line*100, project(maxpro)*1024,
     +           proj80(maxpro)*80, word80*80, text(ntop)*100, trim80*80
      character  path*1, pattern*1, sim256*1024, w_recent_cfg*1024
      character  blank*1
      parameter (blank = ' ')
      logical    abort, repeet, there
      external   getjm1, getnou, lbox02, mfiles, putfat, trim80, 
     +           viewer, yesno2, ofiles, lboxm2, sim256, lstbox,
     +           help_project 
      intrinsic  min
      data       numbld / 30*0 /
      data       numpos / ntop*1 /
c
c Initialise then check maximum dimension and itype
c
      new = .false.  
      nsav = 0
      nmax = min(maxpro,nfmax)
c
c This list MUST be consistent with PFILES
c ========================================
c
      if (itype.eq.1) then
         w_recent_cfg = sim256('a_recent.cfg')
      elseif (itype.eq.2) then
         w_recent_cfg = sim256('v_recent.cfg')
      elseif (itype.eq.3) then
         w_recent_cfg = sim256('m_recent.cfg')
      elseif (itype.eq.4) then
         w_recent_cfg = sim256('g_recent.cfg')
      elseif (itype.eq.5) then
         w_recent_cfg = sim256('f_recent.cfg')
      elseif (itype.eq.6) then
         w_recent_cfg = sim256('p_recent.cfg')
      elseif (itype.eq.7) then
         w_recent_cfg = sim256('c_recent.cfg')
      elseif (itype.eq.8) then
         w_recent_cfg = sim256('s_recent.cfg')    
      else
         call putfat ('ITYPE out of range in call to PFILE1')
         return
      endif
c
c Is there a current project file ?
c
      n_project = 0
      inquire (file = w_recent_cfg, exist = there, iostat = ios)
      if (there .and. ios.eq.0) then
         call getnou (nout)
         open (unit = nout, file = w_recent_cfg, iostat = ios)
         do while (ios.eq.0)
            read (nout,'(a)',iostat=ios) fname
            if (ios.eq.0) inquire (file = fname, exist = there,
     +                             iostat = ios)
            if (there .and. ios.eq.0 .and. n_project.lt.maxpro) then
               n_project = n_project + 1
               project(n_project) = fname
               proj80(n_project) = trim80(fname)
            endif
         enddo
         close (unit = nout)
      endif
c
c Initialise main loop
c
      numdec = 8
      repeet = .true.
c
c Main loop
c
      do while (repeet)
         write (text,100) n_project, nfiles, nsav
         numbld(1) = 4 
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         numbld(1) = 0
         if (numdec.eq.1) then
c
c Select just 1 file
c
            call getnou (nout)
            close (unit = nout)
            isend = 3
            call ofiles (isend, nout,
     +                   fname,
     +                   abort)
            close (unit = nout)
            if (.not.abort) then
               nfiles = nfiles + 1
               files(nfiles) = fname
               new = .true.
            endif
            numdec = 4
         elseif (numdec.eq.2) then
c
c Select multiple files but set nfile1 = 0 and call with files(nfiles+1)
c
            nmax1 = nmax - nfiles
            if (nmax1.lt.1) then
               call putfat ('Project buffer is now full')
            else
               nfile1 = 0
               nstart = nfiles + 1
               call mfiles (nfile1, nmax1,
     +                      files(nstart))
               nfiles = nfiles + nfile1
               if (nfile1.gt.0) new = .true.
            endif
            numdec = 4
         elseif (numdec.eq.3) then
c
c Select multiple files from project archive
c
            nmax1 = nmax - nfiles
            if (n_project.lt.1) then
               call putfat ('Project archive is empty')
            elseif (nmax1.lt.1) then
               call putfat ('Project buffer is now full')
            else
               do i = 1, n_project
                  numpos(i) = 0
               enddo
               call lboxm2 (icolor, ix, iy, i, n_project, numpos,
     +                      proj80)
               do i = 1, n_project
                  if (numpos(i).eq.1 .and. nfiles.lt.nmax) then
                     nfiles = nfiles + 1
                     files(nfiles) = project(i)
                  endif
               enddo
            endif
            numdec = 4
         elseif (numdec.eq.4) then
c
c List/View
c
            if (nfiles.lt.1) then
               call putfat ('No files selected')
            else
               numdec = 1
               text(1) = 'Cancel'
               do i = 1, nfiles
                  word80 = trim80(files(i))
                  text(i + 1) = word80
               enddo
               nfile1 = nfiles + 1
               call lbox02 (icolor, ix, iy, numdec, nfile1, numpos,
     +                      text)
               if (numdec.gt.1) then
                  nfile1 = numdec - 1
                  isend = 1
                  path = blank
                  pattern = blank
                  call viewer (isend,
     +                         files(nfile1), path, pattern)
               endif
            endif
            numdec = 4
         elseif (numdec.eq.5) then
c
c Delete 1 file
c
            if (nfiles.lt.1) then
               call putfat ('No files selected')
            else
               numdec = 1
               text(1) = 'Cancel'
               do i = 1, nfiles
                  word80 = trim80(files(i))
                  text(i + 1) = word80
               enddo
               nfile1 = nfiles + 1
               call lbox02 (icolor, ix, iy, numdec, nfile1, numpos,
     +                      text)
               if (numdec.gt.1) then
                  nfile1 = numdec - 1
                  nsav = nfile1
                  fsav = files(nfile1)
                  do i = nfile1, nfiles - 1
                     files(i) = files(i + 1)
                  enddo
                  nfiles = nfiles - 1
               endif
            endif
            numdec = 4
         elseif (numdec.eq.6) then
c
c Delete n files
c
            if (nfiles.lt.1) then
               call putfat ('No files selected')
            else
               do i = 1, nfiles
                  numpos(i) = 0
                  word80 = trim80(files(i))
                  text(i) = word80
               enddo
               call lboxm2 (icolor, ix, iy, i, nfiles, numpos,
     +                      text)
               nfile1 = nfiles
               nfiles = 0
               do i = 1, nfile1
                  if (numpos(i).eq.0) then
                     nfiles = nfiles + 1
                     buffer(nfiles) = files(i)
                  endif
               enddo
               if (nfiles.gt.0) then
                  do i = 1, nfiles
                     files(i) = buffer(i)
                  enddo
               endif
            endif
            numdec = 4
         elseif (numdec.eq.7) then
c
c Restore 1 file
c
            if (nsav.lt.1) then
               call putfat ('No current deleted file')
            elseif (nfiles.eq.nmax) then
               call putfat ('Project buffer is full')
            else
               write (line,200) nsav
               jbot = 1
               jtop = nfiles + 1
               if (nsav.le.jtop) then
                  jmid = nsav
               else
                  jmid = jtop
               endif
               call getjm1 (jbot, jmid, jtop,
     +                      line)
               nfiles = nfiles + 1
               if (jmid.eq.jtop) then
                  files (nfiles) = fsav
               else
                  do i = nfiles, jmid + 1, - 1
                     files(i) = files(i - 1)
                  enddo
                  files (jmid) = fsav
               endif
            endif
            numdec = 4
         elseif (numdec.eq.8) then
c
c Help
c
            call help_project ('project') 
            numdec = 4
         elseif (numdec.eq.9) then
c
c Cancel
c
            if (nfiles.lt.1) then
               nfiles = 0
               new = .false.
               repeet = .false.
            else
               write (line,300) nfiles
               abort = .false.
               call yesno2 (icolor, ix, iy,
     +                     line,
     +                     abort)
               if (abort) then
                  nfiles = 0
                  new = .false.
                  repeet = .false.
               else
                  numdec = 4
               endif
            endif
         else
c
c Accept
c
            repeet = .false.
         endif
      enddo
c
c Format statements
c
  100 format (
     + 'Adding files to a Project Archive or to a [SELECTION]'
     +/
     +/'A [SELECTION] is a set of files input from disk/filestore'
     +/'or extracted from the current Project Archive that can be'
     +/'used for analysis/plotting, etc. However, if files have'
     +/'been input from disk/filestore you will be given the chance' 
     +/'to add them to the Project Archive after choosing [Accept].'
     +/  
     +/'Input 1 file from disk/filestore'
     +/'Input n files from disk/filestore'
     +/'Extract n files from the Project Archive (',i4,' files)'
     +/'List/View the current [SELECTION] (',i4,' files)'
     +/'Delete 1 file from this [SELECTION] (then store)'
     +/'Delete n files from this [SELECTION] (not stored)'
     +/'Restore 1 saved file to this [SELECTION] (',i4,')'
     +/'Help'
     +/'Cancel ... Do not use the files selected'
     +/'Accept ... Use the the files selected')
  200 format ('Position required for restored file (',i4,' ?)')
  300 format ('Discard current set of',i5,' selected files')
      end
c
c--------------------------------------------------------------------------------------------
c
      subroutine qfile1 (itype, nfiles, nfmax,
     +                   files)
c
c action: build up a project set of files using single or multiple file selection
c author: w.g.bardsley, university of manchester, u.k., 16/02/2001
c         04/02/2019 developed from PFILE1                    
c
c  itype: (input/unchanged) as follows:
c          itype = 1: all files,                          a_recent.cfg
c          itype = 2: vector files,                       v_recent.cfg
c          itype = 3: matrix files,                       m_recent.cfg
c          itype = 4: graphics files,                     g_recent.cfg
c          itype = 5: fitting files,                      f_recent.cfg
c          itype = 6: EPS PostScript graphics files,      p_recent.cfg
c          itype = 7: Covariance matrix,                  c_recent.cfg
c          itype = 8: SVG scalable vector graphics files, s_recent.cfg 
c nfiles: (input/output) as follows:
c          nfiles = 0 on entry: start a new project (no files intitialised)
c          nfiles > 0 on entry: add to an existing project with nfiles files
c          nfiles = dimension of project on exit
c  nfmax: (input/unchanged) as follows:
c          nfmax = maxmimum number of files allowed in project
c  files: (input/output) as follows:
c          files = names of files selected
c
c          ******************************************************
c          Note: maxpro must be consistent with PFILES and PFILE2
c                and be =< nmax in lbox02 and lboxm2
c          ******************************************************
c
      implicit   none
c
c arguments
c
      integer,             intent (in)    :: itype, nfmax  
      integer,             intent (inout) :: nfiles
      character (len = *), intent (inout) :: files(nfmax)
c
c locals
c
      integer    i, isend, ios, nfile1, nmax, nmax1,
     +           nout, n_project, nsav, nstart
      integer    maxpro, ntop
      parameter (maxpro = 500, ntop = maxpro + 1)
      integer    icolor, ix, iy, numdec, numopt, 
     +           numsta, numtxt
      parameter (icolor = 7, ix = 4, iy = 4, 
     +           numopt = 8, numsta = 11, numtxt = numsta + numopt - 1)
      integer    numbld(30), numpos(ntop)
      character (len = 1024) buffer(ntop), fname, fsav(maxpro), 
     +                       project(maxpro), sim256, w_recent_cfg
      character (len = 100 ) word100, text(ntop), trim100
      character (len = 1   ) blank, path, pattern
      parameter (blank = ' ')
      logical    abort, repeet, there
      external   getnou, lbox02, mfiles, putadv, trim100, 
     +           viewer, ofiles, lboxm2, sim256, lstbox,
     +           help_project 
      intrinsic  min
      data       numbld / 30*0 /
      data       numpos / ntop*1 /
c
c Initialise then check maximum dimension and itype
c
      nmax = min(maxpro,nfmax)
c
c This list MUST be consistent with PFILES
c ========================================
c
      if (itype.eq.1) then
         w_recent_cfg = sim256('a_recent.cfg')
      elseif (itype.eq.2) then
         w_recent_cfg = sim256('v_recent.cfg')
      elseif (itype.eq.3) then
         w_recent_cfg = sim256('m_recent.cfg')
      elseif (itype.eq.4) then
         w_recent_cfg = sim256('g_recent.cfg')
      elseif (itype.eq.5) then
         w_recent_cfg = sim256('f_recent.cfg')
      elseif (itype.eq.6) then
         w_recent_cfg = sim256('p_recent.cfg')
      elseif (itype.eq.7) then
         w_recent_cfg = sim256('c_recent.cfg')
      elseif (itype.eq.8) then
         w_recent_cfg = sim256('s_recent.cfg')    
      else
         call putadv ('ITYPE out of range in call to PFILE1')
         return
      endif
c
c Is there a current project file ?
c
      n_project = 0
      inquire (file = w_recent_cfg, exist = there, iostat = ios)
      if (there .and. ios.eq.0) then
         call getnou (nout)
         open (unit = nout, file = w_recent_cfg, iostat = ios)
         do while (ios.eq.0)
            read (nout,'(a)',iostat=ios) fname
            if (ios.eq.0) inquire (file = fname, exist = there,
     +                             iostat = ios)
            if (there .and. ios.eq.0 .and. n_project.lt.maxpro) then
               n_project = n_project + 1
               project(n_project) = fname
            endif
         enddo
         close (unit = nout)
c
c Save the current files
c         
         nsav = n_project
         do i = 1, nsav
            fsav(i) = project(i)
         enddo   
      endif
c
c Initialise main loop
c
      numdec = numopt
      repeet = .true.
c
c Main loop
c
      do while (repeet)
         write (text,100) n_project
         numbld(1) = 4 
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         numbld(1) = 0
         if (numdec.eq.1) then
c
c Add just 1 file
c
            fname = ' '   
            call getnou (nout)
            close (unit = nout)
            isend = 3
            call ofiles (isend, nout,
     +                   fname,
     +                   abort)
            close (unit = nout)
            if (.not.abort) then
               n_project = n_project + 1
               project(n_project) = fname
            endif
            numdec = 3
         elseif (numdec.eq.2) then
c
c Add multiple files 
c
            nmax1 = nmax - nfiles
            if (nmax1.lt.1) then
               call putadv ('Project buffer is now full')
            else
               nfile1 = 0
               nstart = 1
               call mfiles (nfile1, nmax1,
     +                      files(nstart))
               if (nfile1.gt.0) then 
                  do i = 1, nfile1
                      n_project = n_project + 1
                      project(n_project) = files(i)
                  enddo
               endif      
            endif
            numdec = 3
         elseif (numdec.eq.3) then
c
c List/View
c
            if (n_project.lt.1) then
               call putadv ('No files selected')
            else
               numdec = 1
               text(1) = 'Cancel'
               do i = 1, n_project
                  word100 = trim100(project(i))
                  text(i + 1) = word100
               enddo
               nfile1 = n_project + 1
               call lbox02 (icolor, ix, iy, numdec, nfile1, numpos,
     +                      text)
               if (numdec.gt.1) then
                  nfile1 = numdec - 1
                  isend = 1
                  path = blank
                  pattern = blank
                  call viewer (isend,
     +                         project(nfile1), path, pattern)
               endif
            endif
            numdec = 1
         elseif (numdec.eq.4) then
c
c Delete 1 file
c
            if (n_project.lt.1) then
               call putadv ('No files selected')
            else
               numdec = 1
               text(1) = 'Cancel'
               do i = 1, n_project
                  word100 = trim100(project(i))
                  text(i + 1) = word100
               enddo
               nfile1 = n_project + 1
               call lbox02 (icolor, ix, iy, numdec, nfile1, numpos,
     +                      text)
               if (numdec.gt.1) then
                  nfile1 = numdec - 1
                  do i = nfile1, n_project - 1
                     project(i) =  project(i + 1)
                  enddo
                  project(n_project) = blank
                  n_project = n_project - 1
               endif
            endif
            numdec = 3
         elseif (numdec.eq.5) then
c
c Delete n files
c
            if (n_project.lt.1) then
               call putadv ('No files selected')
            else
               do i = 1, n_project
                  numpos(i) = 0
                  word100 = trim100(project(i))
                  text(i) = word100
               enddo
               call lboxm2 (icolor, ix, iy, i, n_project, numpos,
     +                      text)
               nfile1 = n_project
               nfiles = 0
               do i = 1, nfile1
                  if (numpos(i).eq.0) then
                     nfiles = nfiles + 1
                     buffer(nfiles) = project(i)
                  endif
               enddo
               if (nfiles.gt.0) then
                  n_project = 0
                  do i = 1, nfiles
                     n_project = n_project + 1
                     project(n_project) = buffer(i)
                  enddo
                  do i = n_project + 1, nfile1
                     project(i) = blank
                  enddo   
               endif
            endif
            numdec = 3
         elseif (numdec.eq.6) then
c
c Help
c
            call help_project ('project') 
            numdec = 3
         elseif (numdec.eq.7) then
c
c Cancel
c
             nfiles = nsav 
             do i = 1, nfiles
                files(i) = fsav(i)
             enddo   
             repeet = .false.
         else   
c
c Accept
c            
            repeet = .false.
            call getnou (nout)
            open (unit = nout, file = w_recent_cfg, iostat = ios)
            i = 0
            do while (i.lt.n_project .and. ios.eq.0)
               i = i + 1
               if (ios.eq.0) write (nout,'(a)',iostat=ios) project(i)
            enddo
            close (unit = nout)
            nfiles = n_project
            do i = 1, n_project
               files(i) = project(i)
            enddo   
         endif
      enddo
c
c Format statements
c
  100 format (
     + 'Adding/Deleting/Checking files in a Project Archive List'
     +/
     +/'A Project Archive List is a set of files of identical types'
     +/'from which you can select one or more files for statistics,'
     +/'graph plotting, or curve-fitting, etc.'
     +/
     +/'You can add files to or delete files from the archive but,'
     +/'on exit from this routine, any new files added to the archive' 
     +/'will be checked and removed if inconsistent.'
     +/  
     +/'Input 1 file from disk/filestore'
     +/'Input n files from disk/filestore'
     +/'List/View the current project (',i4,' files)'
     +/'Delete 1 file from this project'
     +/'Delete n files from this project'
     +/'Help'
     +/'Cancel ... Reject the current editing'
     +/'Apply ... Accept the current editing')
      end
c
c