c
c
      subroutine pfile2 (itype,
     +                   file,
     +                   askif)
c
c action: add a file to the current project archive
c author: w.g.bardsley, university of manchester, u.k., 11/03/2001
c         18/05/2001 checked for duplicates if itype = 7
c         25/10/2002 increased maxpro from 200 to 300
c         30/03/2006 increased MAXPRO to 1000 and edited 
c         23/01/2007 added sim256 and redimensioned w_recent_cfg
c         14/02/2007 added triml1
c         24/08/2009 added trim60
c         27/06/2010 added infofl
c         27/12/2018 added SVG (itype = 8)
c
c  itype: (input/unchanged) as follows:
c          itype = 1: all files,         a_recent.cfg
c          itype = 2: vector files,      v_recent.cfg
c          itype = 3: matrix files,      m_recent.cfg
c          itype = 4: graphics files,    g_recent.cfg
c          itype = 5: fitting files,     f_recent.cfg
c          itype = 6: EPS,               p_recent.cfg
c          itype = 7: Covariance matrix, c_recent.cfg
c          itype = 8: SVG,               s_recent.cfg 
c   file: (input/unchanged) file just created or opened
c  askif: (input/unchanged) if askif = .true. then ask before adding file
c
c          ******************************************************
c          Note: maxpro must be consistent with PFILES and PFILE1
c          ******************************************************
c
      implicit   none
c
c arguments
c
      integer,             intent (in) :: itype
      character (len = *), intent (in) :: file
      logical,             intent (in) :: askif
c
c locals
c
      integer    icount, ios, nout, n_project
      integer    maxpro, n6
      parameter (maxpro = 1000, n6 = 6)
      integer    icolor, ix, iy
      parameter (icolor = 1, ix = 4, iy = 4)
      character  buffer(maxpro)*1024, line*1024, temp1*1024, temp2*1024
      character  sim256*1024, w_recent_cfg*1024
      character  trim60*60
      character  blank*1
      parameter (blank = ' ')
      logical    exist, read_only, yes
      external   attrib, getnou, putfat, yesno2, lcase1, sim256, triml1,
     +           trim60, infofl
c
c Check that file exists
c
      if (file.eq.blank) return
      call attrib (file,
     +             exist, read_only)
      if (.not.exist) return
c
c This list MUST be consistent with PFILES
c ========================================
c
      if (itype.eq.1) then
         w_recent_cfg = sim256('a_recent.cfg')
      elseif (itype.eq.2) then
         w_recent_cfg = sim256('v_recent.cfg')
      elseif (itype.eq.3) then
         w_recent_cfg = sim256('m_recent.cfg')
      elseif (itype.eq.4) then
         w_recent_cfg = sim256('g_recent.cfg')
      elseif (itype.eq.5) then
         w_recent_cfg = sim256('f_recent.cfg')
      elseif (itype.eq.6) then
         w_recent_cfg = sim256('p_recent.cfg')
      elseif (itype.eq.7) then
         w_recent_cfg = sim256('c_recent.cfg')
      elseif (itype.eq.8) then   
         w_recent_cfg = sim256('s_recent.cfg')
      else
         call putfat ('ITYPE out of range in call to PFILE2')
         return
      endif
c
c test for duplicate if itype = 7
c
      if (itype.eq.7) then
         call attrib (w_recent_cfg,
     +                exist, read_only)
         if (exist) then
            temp1 = file  
            call triml1 (temp1)
            call lcase1 (temp1)
            call getnou (nout)
            open (unit = nout, file = w_recent_cfg)
            ios = 0
            do while (ios.eq.0)
               read (nout,'(a)',iostat=ios) temp2
               if (ios.eq.0) then 
                  call triml1 (temp2)
                  call lcase1 (temp2)
                  if (temp1.eq.temp2) then
                     close (unit = nout)
                     return
                  endif
               endif
            enddo
            close (unit = nout)
         endif
      endif
c
c interrogate the user if askif = .true.
c
      if (askif) then
         write (line,100) trim60(w_recent_cfg)
         yes = .true.
         call yesno2 (icolor, ix, iy,
     +                line,
     +                yes)
         if (.not.yes) return
      endif
c
c Is there a current project file ?
c
      call attrib (w_recent_cfg,
     +             exist, read_only)
      if (.not.exist) then
c
c create a new file
c
         call getnou (nout)
         open (unit = nout, file = w_recent_cfg, iostat = ios)
         if (ios.eq.0) write (nout,'(a)',iostat=ios) file
         close (unit = nout)
      elseif (read_only) then
c
c complain if read_only
c
         call infofl (n6,
     +                w_recent_cfg)         
      else
c
c add the new file at position 1
c
         call getnou (nout)
         open (unit = nout, file = w_recent_cfg, iostat = ios)
         n_project = 0
         do while (ios.eq.0 .and. n_project.lt.maxpro)
            read (nout,'(a)',iostat=ios) line
            exist = .false.
            if (ios.eq.0) call attrib (line,
     +                                 exist, read_only)
            if (exist .and. n_project.lt.maxpro) then
               n_project = n_project + 1
               buffer(n_project) = line
            endif
         enddo
         close (unit = nout)
         call getnou (nout)
         open (unit = nout, file = w_recent_cfg, iostat = ios)
         if (ios.eq.0) write (nout,'(a)',iostat=ios) file
         icount = 0
         do while (ios.eq.0 .and. icount.lt.n_project .and.
     +             icount.lt.maxpro - 1)
            icount = icount + 1
            write (nout,'(a)',iostat=ios) buffer(icount)
         enddo
         close (unit = nout)
      endif
c
c format statements
c
  100 format ('Add this file to the project archive ',a)
      end
c
c
    






