c 06/02/2019 now contains
c            pfiles and 
c            qfiles 
C
C
      SUBROUTINE PFILES (IPREV, ITYPE, NFILES, NIN, NMAX, NOUT,
     +                   FILES,
     +                   ACCEPT)
C 
C----------------------------------------------------------------------------------------------------------    
C The project archive files along with their arguments functions and calls between other PFILE* subroutines 
C----------------------------------------------------------------------------------------------------------
C
C  USAGE: call PFILES if the file type is known
C         call PFILE0 to get the file type then call PFILES
C         call PFILE2 to add a new file to a known project 
C
C PFILES: arguments: (IPREV, ITYPE, NFILES, NIN, NMAX, NOUT,
C     +               FILES,
C     +               ACCEPT)
C            action: Build up a project by selecting project files
C             calls: PFILE1
C PFILE0: arguments: no arguments
C            action: select project archive type required then call pfiles   
C             calls: PFILES 
C PFILE1: arguments: (itype, nfiles, nfmax,
C     +               files,
C     +               new)  
C            action: build up a project set of files using single or multiple file selection
C             calls: none
C PFILE2: arguments: (itype,
C     +               file,
C     +               askif)
C            action: add a file to the current project archive on request
C             calls: none  
C-----------------------------------------------------------------------------------------------------------    
C
C
C ACTION: Build up a project by selecting project files
C AUTHOR: W. G. Bardsley, University of Manchester, U.K.,23/02/2001
C         13/05/2001 added covariance matrix: ITYPE = 7
C         25/10/2002 increased MAXPRO from 200 to 300
C         30/03/2006 increased MAXPRO to 1000 and edited 
C         23/01/2007 introduced SIM256 and redimensioned W_RECENT_CFG 
C         14/03/2007 added TRIM60, increased length of TITLE, and made A allocatable 
C         27/06/2010 added INFOFL
C         27/12/2018 checked and upgraded to include SVG (ITYPE = 8)
C
C  IPREV: (input/output) previous selection type, re-set to NTYPE on exit
C  ITYPE: (input/unchanged) selection type
C NFILES: (input/output)  = no. of existing files on entry
C                         = no. files selected on exit
C    NIN: (input/unchanged) unconnected unit for data input
C   NMAX: (input/unchanged) max no. files
C   NOUT: (input/unchanged) unconnected output unit for library file or project
C  FILES: (input/output) files selected
C ACCEPT: (output) workspace then checks each file for OK on exit
C
C         IPREV = previous ITYPE
C         MAXPRO = max. size of project file
C         ******************************************************
C         Note: MAXPRO must be consistent with PFILE1 and PFILE2
C         ******************************************************
C
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: ITYPE, NIN, NMAX, NOUT 
      INTEGER,             INTENT (INOUT) :: IPREV, NFILES
      CHARACTER (LEN = *), INTENT (INOUT) :: FILES(NMAX)
      LOGICAL,             INTENT (OUT)   :: ACCEPT(NMAX)
C
C Local alocatable workspace
C     
      DOUBLE PRECISION, ALLOCATABLE :: A(:,:) 
C
C Locals
C
      INTEGER    MAXPRO
      PARAMETER (MAXPRO = 1000)
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N7, N8, N15
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4,
     +           N5 = 5, N6 = 6, N7 = 7, N8 = 8, N15 = 15)
      INTEGER    ICOLOR, IX, IY
      PARAMETER (ICOLOR = 7, IX = 4, IY = 4)
      INTEGER    NCMAX, NRMAX
      INTEGER    ISVG, JSVG, KSVG
      INTEGER    I, ICOUNT, IERR, IOS, J, JCOLOR, K, NBAD, NCOL,
     +           N_PROJECT, NROW
      DOUBLE PRECISION X1, X2, Y1, Y2
      DOUBLE PRECISION EPSI, SMALL
      PARAMETER (EPSI = 1.0D-100, SMALL = 1.0D-10)
      CHARACTER (LEN = 1024) BUFFER(MAXPRO), FNAME, TITLE, SIM256,
     +                       W_RECENT_CFG
      CHARACTER (LEN = 60  ) TRIM60   
      CHARACTER (LEN = 40  ) CIPHER   
      LOGICAL    NEW, THERE, READ_ONLY
      LOGICAL    ABORT, AGAIN, YES
      LOGICAL    ALLOW_BLANKS, ALLOW_ISVG
      PARAMETER (ALLOW_BLANKS = .FALSE., ALLOW_ISVG = .FALSE.)
      LOGICAL    IWARNU
      PARAMETER (IWARNU = .FALSE.)
      EXTERNAL   ISITPS, TABLE1, YESNO2, ATTRIB, PFILE1, PUTADV, SIM256,
     +           TRIM60, INFOFL 
      EXTERNAL   W_SVGCHK
      INTRINSIC  ABS, NINT
C
C Ininitialise ACCEPT then check input parameters
C
      DO I = N1, NMAX
         ACCEPT(I) = .FALSE.
      ENDDO
      IF (NIN.LT.N1 .OR. NMAX.LT.N1 .OR. NOUT.LT.N1) RETURN
C
C Make sure units are closed
C
      CLOSE (UNIT = NIN)
      CLOSE (UNIT = NOUT)
C
C Define w_current.cfg...This list MUST be consistent with PFILE1
C ===============================================================
C
      IF (ITYPE.EQ.N1) THEN
         W_RECENT_CFG = SIM256('a_recent.cfg')
      ELSEIF (ITYPE.EQ.N2) THEN
         W_RECENT_CFG = SIM256('v_recent.cfg')
      ELSEIF (ITYPE.EQ.N3) THEN
         W_RECENT_CFG = SIM256('m_recent.cfg')
      ELSEIF (ITYPE.EQ.N4) THEN
         W_RECENT_CFG = SIM256('g_recent.cfg')
      ELSEIF (ITYPE.EQ.N5) THEN
         W_RECENT_CFG = SIM256('f_recent.cfg')
      ELSEIF (ITYPE.EQ.N6) THEN
         W_RECENT_CFG = SIM256('p_recent.cfg')
      ELSEIF (ITYPE.EQ.N7) THEN
         W_RECENT_CFG = SIM256('c_recent.cfg')
      ELSEIF (ITYPE.EQ.N8) THEN
         W_RECENT_CFG = SIM256('s_recent.cfg')         
      ELSE
         CALL PUTADV ('ITYPE out of range in call to PFILES')
         RETURN
      ENDIF
C
C Reset NFILES unless same filetype requested
C
      IF (NFILES.GT.N0 .AND. ITYPE.EQ.IPREV) THEN
         WRITE (TITLE,100) NFILES
         YES = .TRUE.
         CALL YESNO2 (ICOLOR, IX, IY,
     +                TITLE,
     +                YES)
         IF (.NOT.YES) NFILES = N0
      ELSE
         NFILES = N0
      ENDIF
C
C ---------------------------------------------------------------------
C Start of inner loop for multiple selection
C ---------------------------------------------------------------------
C
      AGAIN = .TRUE.
      DO WHILE (AGAIN)

C
C Call PFILE1 for multiple file selection
C
         NBAD = N0
         NEW = .FALSE.
         CALL PFILE1 (ITYPE, NFILES, NMAX,
     +                FILES,
     +                NEW)
         IF (NFILES.GT.N0) THEN
C
C Check each file for consistency
C
            DO I = N1, NFILES
C
C Open the file
C
               ACCEPT(I) = .TRUE.
               CLOSE (UNIT = NIN)
               OPEN (UNIT = NIN, FILE = FILES(I), IOSTAT = IOS)
               IF (IOS.NE.N0) ACCEPT(I) = .FALSE.
C
C Read the first line
C
               IF (IOS.EQ.N0) READ (NIN,'(A)',IOSTAT=IOS) TITLE
               IF (IOS.NE.N0) THEN
                  ACCEPT(I) = .FALSE.
C
C Otherwise read the second line, etc.
C
               ELSEIF (ITYPE.EQ.N1) THEN
C
C No check required for any files
C
                  CLOSE (UNIT = NIN)
               ELSEIF (ITYPE.EQ.N2) THEN
C
C Check for vector files
C
                  READ (NIN,*,IOSTAT=IOS) NROW, NCOL
                  CLOSE (UNIT = NIN)
                  IF (IOS.EQ.N0) THEN
                      IF (NROW.LT.N1) ACCEPT(I) = .FALSE.
                      IF (NCOL.NE.N1) ACCEPT(I) = .FALSE.
                  ELSE
                     ACCEPT(I) = .FALSE.
                  ENDIF
               ELSEIF (ITYPE.EQ.N3) THEN
C
C Check for matrix files
C
                  READ (NIN,*,IOSTAT=IOS) NROW, NCOL
                  CLOSE (UNIT = NIN)
                  IF (IOS.EQ.N0) THEN
                     IF (NROW.LT.N1) ACCEPT(I) = .FALSE.
                     IF (NCOL.LT.N1) ACCEPT(I) = .FALSE.
                  ELSE
                     ACCEPT(I) = .FALSE.
                  ENDIF
               ELSEIF (ITYPE.EQ.N4) THEN
C
C Check for graphics files
C
                  READ (NIN,*,IOSTAT=IOS) NROW, NCOL
                  CLOSE (UNIT = NIN)
                  IF (IOS.EQ.N0) THEN
                     IF (NROW.LT.N1) ACCEPT(I) = .FALSE.
                     IF (NCOL.LT.N2) ACCEPT(I) = .FALSE.
                     IF (NCOL.EQ.N5) ACCEPT(I) = .FALSE.
                     IF (NCOL.GT.N6) ACCEPT(I) = .FALSE.
                  ELSE
                     ACCEPT(I) = .FALSE.
                  ENDIF
               ELSEIF (ITYPE.EQ.N5) THEN
C
C Check for curve fit files
C
                  READ (NIN,*,IOSTAT=IOS) NROW, NCOL
                  IF (IOS.EQ.N0) THEN
                     IF (NROW.LT.N1) ACCEPT(I) = .FALSE.
                     IF (NCOL.LT.N2) ACCEPT(I) = .FALSE.
                     IF (NCOL.GT.N3) ACCEPT(I) = .FALSE.
                     IF (NCOL.EQ.N3) THEN
                        READ (NIN,*,IOSTAT=IOS) X1, X2, Y1
                        IF (IOS.EQ.N0) THEN
                           IF (Y1.LE.EPSI) ACCEPT(I) = .FALSE.
                        ELSE
                           ACCEPT(I) = .FALSE.
                        ENDIF
                     ENDIF
                  ELSE
                     ACCEPT(I) = .FALSE.
                  ENDIF
                  CLOSE (UNIT = NIN)
               ELSEIF (ITYPE.EQ.N6) THEN
C
C Check for eps files
C
                  CLOSE (UNIT = NIN)
                  OPEN (UNIT = NIN, FILE = FILES(I))
                  CALL ISITPS (NIN,
     +                         X1, X2, Y1, Y2, 
     +                         ABORT, IWARNU)
                  CLOSE (UNIT = NIN)
                  IF (ABORT) ACCEPT(I) = .FALSE.
               ELSEIF (ITYPE.EQ.N7) THEN
C
C Check for covariance matrix files
C
                  READ (NIN,*,IOSTAT=IOS) NROW, NCOL 
                  NCMAX = NCOL
                  NRMAX = NROW
                  IF (IOS.EQ.N0) THEN
                     IF (NROW.EQ.NCOL + N4 .AND. NCOL.GT.N0) THEN
                        IF (NROW.GT.NRMAX .OR. NCOL.GT.NCMAX) THEN
                           ACCEPT(I) = .FALSE.
                        ELSE  
                           IERR = N0
                           IF (ALLOCATED(A)) DEALLOCATE(A, STAT = IERR)
                           IF (IERR.NE.N0) RETURN
                           ALLOCATE(A(NRMAX,NCMAX), STAT = IERR)
                           IF (IERR.NE.N0) RETURN
                           IOS = N0
                           DO J = N1, NROW
                              IF (IOS.EQ.N0) READ (NIN,*,IOSTAT=IOS)
     +                           (A(J,K), K = N1, NCOL)
                           ENDDO
                           IF (IOS.EQ.N0) THEN
                              IF (NCOL.GT.N1) THEN
                                 DO J = N2, NCOL
                                    DO K = N1, J - N1
                                       IF (ABS(A(J,K)-A(K,J)).GT.SMALL)
     +                                     ACCEPT(I) = .FALSE.
                                    ENDDO
                                 ENDDO
                              ENDIF
                              J = NINT(A(NCOL + N2,N1))
                              K = NINT(A(NCOL + N3,N1))
                              IF (J.LE.NCOL .OR.
     +                            K.GT.NCOL .OR.
     +                            K.LT.N1)
     +                            ACCEPT(I) = .FALSE.
                              DO J = N2, NCOL
                                 IF (ABS(A(NCOL + N2,J)).GT.SMALL .OR.
     +                               ABS(A(NCOL + N3,J)).GT.SMALL)
     +                            ACCEPT(I) = .FALSE.
                              ENDDO
                              DO J = N1, NCOL
                                 K = NINT(A(NROW,J))
                                 IF (K.LT.N0 .OR. K.GT.N1)
     +                           ACCEPT(I) = .FALSE.
                              ENDDO
                           ELSE
                              ACCEPT(I) = .FALSE.
                           ENDIF
                           DEALLOCATE(A, STAT = IERR)
                        ENDIF
                     ELSE
                        ACCEPT(I) = .FALSE.
                     ENDIF
                  ELSE
                     ACCEPT(I) = .FALSE.
                  ENDIF
                  CLOSE (UNIT = NIN)
               ELSEIF (ITYPE.EQ.N8) THEN
C
C Check for svg files
C
                  CLOSE (UNIT = NIN)
                  CALL W_SVGCHK (ISVG, JSVG, KSVG,
     +                           FILES(I),
     +                           ALLOW_BLANKS, ALLOW_ISVG, IWARNU)
                  IF (KSVG.EQ.N1) THEN
                     ABORT = .FALSE.
                  ELSE
                     ABORT = .TRUE.
                  ENDIF                                                     
                  IF (ABORT) ACCEPT(I) = .FALSE.                  
               ENDIF
C
C Add to NBAD if there are any bad files and make sure NIN is closed
C
               IF (.NOT.ACCEPT(I)) NBAD = NBAD + N1
               CLOSE (UNIT = NIN)
            ENDDO
C
C Warn if there are any bad files
C
            IF (NBAD.GT.N0) THEN
               JCOLOR = N15
               CALL TABLE1 (JCOLOR, 'OPEN')
               JCOLOR = N4
               DO I = N1, NFILES
                  IF (ACCEPT(I)) THEN
                     JCOLOR = N0
                     WRITE (TITLE,200) I, ' OK'
                  ELSE
                     JCOLOR = N4
                     WRITE (TITLE,200) I, ' * Rejected'
                  ENDIF
                  CALL TABLE1 (JCOLOR, TITLE)
               ENDDO
               JCOLOR = N4
               IF (ITYPE.EQ.N1) THEN
                  CIPHER = 'not acceptable file format'
               ELSEIF (ITYPE.EQ.N2) THEN
                  CIPHER = 'not in vector format'
               ELSEIF (ITYPE.EQ.N3) THEN
                  CIPHER = 'not in matrix format'
               ELSEIF (ITYPE.EQ.N4) THEN
                  CIPHER = 'not in coordinate format'
               ELSEIF (ITYPE.EQ.N5) THEN
                  CIPHER = 'not in curve fit format'
               ELSEIF (ITYPE.EQ.N6) THEN
                  CIPHER = 'not in .eps PostScript format'
               ELSEIF (ITYPE.EQ.N7) THEN
                  CIPHER = 'not in Covariance Matrix format'
               ELSEIF (ITYPE.EQ.N8) THEN
                  CIPHER = 'not in Simfit .svg format'  
               ENDIF
               WRITE (TITLE,300) NBAD, CIPHER
               CALL TABLE1 (JCOLOR, TITLE)
               CALL TABLE1 (JCOLOR, 'CLOSE')
C
C Deselect any bad files
C
               ICOUNT = N0
               DO I = N1, NFILES
                  IF (ACCEPT(I)) THEN
                     ICOUNT = ICOUNT + N1
                     FILES(ICOUNT) = FILES(I)
                  ENDIF
               ENDDO
               NFILES = ICOUNT
            ENDIF
         ENDIF
C
C Go round again if any bad files have been eliminated
C
         IF (NBAD.GT.N0) THEN
            AGAIN = .TRUE.
         ELSE
            AGAIN = .FALSE.
         ENDIF
      ENDDO
C
C Refresh w_recent.cfg on exit
C
      CALL ATTRIB (W_RECENT_CFG, 
     +             THERE, READ_ONLY)
      IF (THERE .AND. READ_ONLY) CALL INFOFL (N6,
     +                                        W_RECENT_CFG)        
      IF (NEW .AND. NFILES.GT.N0 .AND. .NOT.THERE) THEN
         OPEN (UNIT = NOUT, FILE = W_RECENT_CFG, IOSTAT = IOS)
         IF (IOS.EQ.N0) THEN
            THERE = .TRUE.
            READ_ONLY = .FALSE.
         ENDIF
         CLOSE (UNIT = NOUT)
      ENDIF
      IF (NEW .AND. NFILES.GT.N0 .AND. THERE .AND. .NOT.READ_ONLY) THEN
         WRITE (TITLE,400) NFILES, TRIM60(W_RECENT_CFG)
         YES = .TRUE.
         CALL YESNO2 (ICOLOR, IX, IY,
     +                TITLE,
     +                YES)
         IF (YES) THEN
            OPEN (UNIT = NOUT, FILE = W_RECENT_CFG, IOSTAT = IOS)
            N_PROJECT = N0
            DO WHILE (IOS.EQ.N0)
               READ (NOUT,'(A)',IOSTAT=IOS) FNAME
               IF (IOS.EQ.N0 .AND. N_PROJECT.LT.MAXPRO) THEN
                  N_PROJECT = N_PROJECT + N1
                  BUFFER(N_PROJECT) = FNAME
               ENDIF
            ENDDO
            CLOSE (UNIT = NOUT)
            OPEN (UNIT = NOUT, FILE = W_RECENT_CFG, IOSTAT = IOS)
            ICOUNT = N0
            DO I = N1, NFILES
               IF (ICOUNT.LT.MAXPRO) THEN
                  ICOUNT = ICOUNT + N1
                  WRITE (NOUT,'(A)') FILES(I)
               ENDIF
            ENDDO
            DO I = N1, N_PROJECT
               IF (ICOUNT.LT.MAXPRO) THEN
                  ICOUNT = ICOUNT + N1
                  WRITE (NOUT,'(A)') BUFFER(I)
               ENDIF
            ENDDO
            CLOSE (UNIT = NOUT)
         ENDIF
      ENDIF
C
C Close units then assign IPREV and ACCEPT
C
      CLOSE (UNIT = NIN)
      CLOSE (UNIT = NOUT)
      IPREV = ITYPE
      IF (NFILES.GT.N0) THEN
         DO I = N1, NFILES
            ACCEPT(I) = .TRUE.
         ENDDO
      ENDIF
C
C Format statements
C
  100 FORMAT ('Include the current',i4,' files in the project')
  200 FORMAT ('File',I4,A)
  300 FORMAT (i4,' files rejected:',1X,A)
  400 FORMAT ('Add these',i4,' files to the PROJECT ARCHIVE list:',1x,A)
      END
C
C-------------------------------------------------------------------------------
C
      SUBROUTINE QFILES (ITYPE, NFILES, NIN, NMAX, NOUT,
     +                   FILES,
     +                   ACCEPT)
C 
C
C
C ACTION: Edit a project archive (not a SELECTION)
C AUTHOR: W. G. Bardsley, University of Manchester, U.K.,23/02/2001
C         04/02/2019 developed from PFILES to be used by QFILE0
C         02/03/2019 corrected NFILES when files are rejected or deleted 
C
C  ITYPE: (input/unchanged) selection type
C NFILES: (output) = no. files selected on exit
C    NIN: (input/unchanged) unconnected unit for data input
C   NMAX: (input/unchanged) max no. files
C   NOUT: (input/unchanged) unconnected output unit for library file or project
C  FILES: (output) files selected
C ACCEPT: (output) workspace then checks each file for OK on exit
C
C         MAXPRO = max. size of project file
C         ******************************************************
C         Note: MAXPRO must be consistent with QFILE1 and QFILE2
C         ******************************************************
C
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)  :: ITYPE, NIN, NMAX, NOUT 
      INTEGER,             INTENT (OUT) :: NFILES
      CHARACTER (LEN = *), INTENT (OUT) :: FILES(NMAX)
      LOGICAL,             INTENT (OUT) :: ACCEPT(NMAX)
C
C Local alocatable workspace
C     
      DOUBLE PRECISION, ALLOCATABLE :: A(:,:) 
C
C Locals
C
      INTEGER    MAXPRO
      PARAMETER (MAXPRO = 1000)
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N7, N8, N15
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4,
     +           N5 = 5, N6 = 6, N7 = 7, N8 = 8, N15 = 15)
      INTEGER    NCMAX, NRMAX
      INTEGER    ISVG, JSVG, KSVG
      INTEGER    I, ICOUNT, IERR, IOS, J, JCOLOR, K, NBAD, NCOL,
     +           NROW
      DOUBLE PRECISION X1, X2, Y1, Y2
      DOUBLE PRECISION EPSI, SMALL
      PARAMETER (EPSI = 1.0D-100, SMALL = 1.0D-10)
      CHARACTER (LEN = 1024) TITLE, SIM256, W_RECENT_CFG  
      CHARACTER (LEN = 40  ) CIPHER   
      LOGICAL    THERE, READ_ONLY
      LOGICAL    ABORT, AGAIN
      LOGICAL    ALLOW_BLANKS, ALLOW_ISVG
      PARAMETER (ALLOW_BLANKS = .FALSE., ALLOW_ISVG = .FALSE.)
      LOGICAL    IWARNU
      PARAMETER (IWARNU = .FALSE.)
      EXTERNAL   ISITPS, TABLE1, ATTRIB, QFILE1, PUTADV, SIM256,
     +           INFOFL 
      EXTERNAL   W_SVGCHK
      INTRINSIC  ABS, NINT
C
C Initialise NFILES, FILES, and ACCEPT then check input parameters
C
      NFILES = 0
      DO I = N1, NMAX
         FILES(I) = ' '
         ACCEPT(I) = .FALSE.
      ENDDO
      IF (NIN.LT.N1 .OR. NMAX.LT.N1 .OR. NOUT.LT.N1) RETURN
C
C Make sure units are closed
C
      CLOSE (UNIT = NIN)
      CLOSE (UNIT = NOUT)
C
C Define w_current.cfg...This list MUST be consistent with QFILE1
C ===============================================================
C
      IF (ITYPE.EQ.N1) THEN
         W_RECENT_CFG = SIM256('a_recent.cfg')
      ELSEIF (ITYPE.EQ.N2) THEN
         W_RECENT_CFG = SIM256('v_recent.cfg')
      ELSEIF (ITYPE.EQ.N3) THEN
         W_RECENT_CFG = SIM256('m_recent.cfg')
      ELSEIF (ITYPE.EQ.N4) THEN
         W_RECENT_CFG = SIM256('g_recent.cfg')
      ELSEIF (ITYPE.EQ.N5) THEN
         W_RECENT_CFG = SIM256('f_recent.cfg')
      ELSEIF (ITYPE.EQ.N6) THEN
         W_RECENT_CFG = SIM256('p_recent.cfg')
      ELSEIF (ITYPE.EQ.N7) THEN
         W_RECENT_CFG = SIM256('c_recent.cfg')
      ELSEIF (ITYPE.EQ.N8) THEN
         W_RECENT_CFG = SIM256('s_recent.cfg')         
      ELSE
         CALL PUTADV ('ITYPE out of range in call to QFILES')
         RETURN
      ENDIF
C
C ---------------------------------------------------------------------
C Start of inner loop for multiple selection
C ---------------------------------------------------------------------
C
      AGAIN = .TRUE.
      DO WHILE (AGAIN)

C
C Call QFILE1 for multiple file selection
C
         NBAD = N0
         CALL QFILE1 (ITYPE, NFILES, NMAX,
     +                FILES)
         IF (NFILES.GT.N0) THEN
C
C Check each file for consistency
C
            DO I = N1, NFILES
C
C Open the file
C
               ACCEPT(I) = .TRUE.
               CLOSE (UNIT = NIN)
               OPEN (UNIT = NIN, FILE = FILES(I), IOSTAT = IOS)
               IF (IOS.NE.N0) ACCEPT(I) = .FALSE.
C
C Read the first line
C
               IF (IOS.EQ.N0) READ (NIN,'(A)',IOSTAT=IOS) TITLE
               IF (IOS.NE.N0) THEN
                  ACCEPT(I) = .FALSE.
C
C Otherwise read the second line, etc.
C
               ELSEIF (ITYPE.EQ.N1) THEN
C
C No check required for any files
C
                  CLOSE (UNIT = NIN)
               ELSEIF (ITYPE.EQ.N2) THEN
C
C Check for vector files
C
                  READ (NIN,*,IOSTAT=IOS) NROW, NCOL
                  CLOSE (UNIT = NIN)
                  IF (IOS.EQ.N0) THEN
                      IF (NROW.LT.N1) ACCEPT(I) = .FALSE.
                      IF (NCOL.NE.N1) ACCEPT(I) = .FALSE.
                  ELSE
                     ACCEPT(I) = .FALSE.
                  ENDIF
               ELSEIF (ITYPE.EQ.N3) THEN
C
C Check for matrix files
C
                  READ (NIN,*,IOSTAT=IOS) NROW, NCOL
                  CLOSE (UNIT = NIN)
                  IF (IOS.EQ.N0) THEN
                     IF (NROW.LT.N1) ACCEPT(I) = .FALSE.
                     IF (NCOL.LT.N1) ACCEPT(I) = .FALSE.
                  ELSE
                     ACCEPT(I) = .FALSE.
                  ENDIF
               ELSEIF (ITYPE.EQ.N4) THEN
C
C Check for graphics files
C
                  READ (NIN,*,IOSTAT=IOS) NROW, NCOL
                  CLOSE (UNIT = NIN)
                  IF (IOS.EQ.N0) THEN
                     IF (NROW.LT.N1) ACCEPT(I) = .FALSE.
                     IF (NCOL.LT.N2) ACCEPT(I) = .FALSE.
                     IF (NCOL.EQ.N5) ACCEPT(I) = .FALSE.
                     IF (NCOL.GT.N6) ACCEPT(I) = .FALSE.
                  ELSE
                     ACCEPT(I) = .FALSE.
                  ENDIF
               ELSEIF (ITYPE.EQ.N5) THEN
C
C Check for curve fit files
C
                  READ (NIN,*,IOSTAT=IOS) NROW, NCOL
                  IF (IOS.EQ.N0) THEN
                     IF (NROW.LT.N1) ACCEPT(I) = .FALSE.
                     IF (NCOL.LT.N2) ACCEPT(I) = .FALSE.
                     IF (NCOL.GT.N3) ACCEPT(I) = .FALSE.
                     IF (NCOL.EQ.N3) THEN
                        READ (NIN,*,IOSTAT=IOS) X1, X2, Y1
                        IF (IOS.EQ.N0) THEN
                           IF (Y1.LE.EPSI) ACCEPT(I) = .FALSE.
                        ELSE
                           ACCEPT(I) = .FALSE.
                        ENDIF
                     ENDIF
                  ELSE
                     ACCEPT(I) = .FALSE.
                  ENDIF
                  CLOSE (UNIT = NIN)
               ELSEIF (ITYPE.EQ.N6) THEN
C
C Check for eps files
C
                  CLOSE (UNIT = NIN)
                  OPEN (UNIT = NIN, FILE = FILES(I))
                  CALL ISITPS (NIN,
     +                         X1, X2, Y1, Y2, 
     +                         ABORT, IWARNU)
                  CLOSE (UNIT = NIN)
                  IF (ABORT) ACCEPT(I) = .FALSE.
               ELSEIF (ITYPE.EQ.N7) THEN
C
C Check for covariance matrix files
C
                  READ (NIN,*,IOSTAT=IOS) NROW, NCOL 
                  NCMAX = NCOL
                  NRMAX = NROW
                  IF (IOS.EQ.N0) THEN
                     IF (NROW.EQ.NCOL + N4 .AND. NCOL.GT.N0) THEN
                        IF (NROW.GT.NRMAX .OR. NCOL.GT.NCMAX) THEN
                           ACCEPT(I) = .FALSE.
                        ELSE  
                           IERR = N0
                           IF (ALLOCATED(A)) DEALLOCATE(A, STAT = IERR)
                           IF (IERR.NE.N0) RETURN
                           ALLOCATE(A(NRMAX,NCMAX), STAT = IERR)
                           IF (IERR.NE.N0) RETURN
                           IOS = N0
                           DO J = N1, NROW
                              IF (IOS.EQ.N0) READ (NIN,*,IOSTAT=IOS)
     +                           (A(J,K), K = N1, NCOL)
                           ENDDO
                           IF (IOS.EQ.N0) THEN
                              IF (NCOL.GT.N1) THEN
                                 DO J = N2, NCOL
                                    DO K = N1, J - N1
                                       IF (ABS(A(J,K)-A(K,J)).GT.SMALL)
     +                                     ACCEPT(I) = .FALSE.
                                    ENDDO
                                 ENDDO
                              ENDIF
                              J = NINT(A(NCOL + N2,N1))
                              K = NINT(A(NCOL + N3,N1))
                              IF (J.LE.NCOL .OR.
     +                            K.GT.NCOL .OR.
     +                            K.LT.N1)
     +                            ACCEPT(I) = .FALSE.
                              DO J = N2, NCOL
                                 IF (ABS(A(NCOL + N2,J)).GT.SMALL .OR.
     +                               ABS(A(NCOL + N3,J)).GT.SMALL)
     +                            ACCEPT(I) = .FALSE.
                              ENDDO
                              DO J = N1, NCOL
                                 K = NINT(A(NROW,J))
                                 IF (K.LT.N0 .OR. K.GT.N1)
     +                           ACCEPT(I) = .FALSE.
                              ENDDO
                           ELSE
                              ACCEPT(I) = .FALSE.
                           ENDIF
                           DEALLOCATE(A, STAT = IERR)
                        ENDIF
                     ELSE
                        ACCEPT(I) = .FALSE.
                     ENDIF
                  ELSE
                     ACCEPT(I) = .FALSE.
                  ENDIF
                  CLOSE (UNIT = NIN)
               ELSEIF (ITYPE.EQ.N8) THEN
C
C Check for svg files
C
                  CLOSE (UNIT = NIN)
                  CALL W_SVGCHK (ISVG, JSVG, KSVG,
     +                           FILES(I),
     +                           ALLOW_BLANKS, ALLOW_ISVG, IWARNU)
                  IF (KSVG.EQ.N1) THEN
                     ABORT = .FALSE.
                  ELSE
                     ABORT = .TRUE.
                  ENDIF                                                     
                  IF (ABORT) ACCEPT(I) = .FALSE.                  
               ENDIF
C
C Add to NBAD if there are any bad files and make sure NIN is closed
C
               IF (.NOT.ACCEPT(I)) NBAD = NBAD + N1
               CLOSE (UNIT = NIN)
            ENDDO
C
C Warn if there are any bad files
C
            IF (NBAD.GT.N0) THEN
               JCOLOR = N15
               CALL TABLE1 (JCOLOR, 'OPEN')
               JCOLOR = N4
               DO I = N1, NFILES
                  IF (ACCEPT(I)) THEN
                     JCOLOR = N0
                     WRITE (TITLE,100) I, ' OK'
                  ELSE
                     JCOLOR = N4
                     WRITE (TITLE,100) I, ' * Rejected'
                  ENDIF
                  CALL TABLE1 (JCOLOR, TITLE)
               ENDDO
               JCOLOR = N4
               IF (ITYPE.EQ.N1) THEN
                  CIPHER = 'not acceptable file format'
               ELSEIF (ITYPE.EQ.N2) THEN
                  CIPHER = 'not in vector format'
               ELSEIF (ITYPE.EQ.N3) THEN
                  CIPHER = 'not in matrix format'
               ELSEIF (ITYPE.EQ.N4) THEN
                  CIPHER = 'not in coordinate format'
               ELSEIF (ITYPE.EQ.N5) THEN
                  CIPHER = 'not in curve fit format'
               ELSEIF (ITYPE.EQ.N6) THEN
                  CIPHER = 'not in .eps PostScript format'
               ELSEIF (ITYPE.EQ.N7) THEN
                  CIPHER = 'not in Covariance Matrix format'
               ELSEIF (ITYPE.EQ.N8) THEN
                  CIPHER = 'not in Simfit .svg format'  
               ENDIF
               WRITE (TITLE,200) NBAD, CIPHER
               CALL TABLE1 (JCOLOR, TITLE)
               CALL TABLE1 (JCOLOR, 'CLOSE')
C
C Deselect any bad files
C
               ICOUNT = N0
               DO I = N1, NFILES
                  IF (ACCEPT(I)) THEN
                     ICOUNT = ICOUNT + N1
                     FILES(ICOUNT) = FILES(I)
                  ENDIF
               ENDDO
               NFILES = ICOUNT
            ENDIF
         ENDIF
C
C Go round again if any bad files have been eliminated
C
         IF (NBAD.GT.N0) THEN
            AGAIN = .TRUE.
            CALL ATTRIB (W_RECENT_CFG, 
     +                   THERE, READ_ONLY)
            IF (THERE .AND. READ_ONLY) CALL INFOFL (N6,
     +                                              W_RECENT_CFG)        
            IF (NFILES.GT.N0 .AND. .NOT.THERE) THEN
               OPEN (UNIT = NOUT, FILE = W_RECENT_CFG, IOSTAT = IOS)
               IF (IOS.EQ.N0) THEN
                  THERE = .TRUE.
                  READ_ONLY = .FALSE.
               ENDIF
               CLOSE (UNIT = NOUT)
            ENDIF
            IF (NFILES.GT.N0 .AND. THERE .AND. .NOT.READ_ONLY) THEN
               CLOSE (UNIT = NOUT)
               OPEN (UNIT = NOUT, FILE = W_RECENT_CFG, IOSTAT = IOS)
               ICOUNT = N0
               DO I = N1, NFILES
                  IF (ICOUNT.LT.MAXPRO) THEN
                     IF (ACCEPT(I)) THEN
                        ICOUNT = ICOUNT + N1
                        WRITE (NOUT,'(A)') FILES(I)
                     ENDIF   
                  ENDIF
               ENDDO
               CLOSE (UNIT = NOUT)
               NFILES = ICOUNT
            ENDIF   
         ELSE
            AGAIN = .FALSE.
         ENDIF
      ENDDO
C
C Refresh w_recent.cfg on exit
C
      CALL ATTRIB (W_RECENT_CFG, 
     +             THERE, READ_ONLY)
      IF (THERE .AND. READ_ONLY) CALL INFOFL (N6,
     +                                        W_RECENT_CFG)        
      IF (NFILES.GT.N0 .AND. .NOT.THERE) THEN
         OPEN (UNIT = NOUT, FILE = W_RECENT_CFG, IOSTAT = IOS)
         IF (IOS.EQ.N0) THEN
            THERE = .TRUE.
            READ_ONLY = .FALSE.
         ENDIF
         CLOSE (UNIT = NOUT)
      ENDIF
      IF (NFILES.GT.N0 .AND. THERE .AND. .NOT.READ_ONLY) THEN
         CLOSE (UNIT = NOUT)
         OPEN (UNIT = NOUT, FILE = W_RECENT_CFG, IOSTAT = IOS)
         ICOUNT = N0
         DO I = N1, NFILES
            IF (ICOUNT.LT.MAXPRO) THEN
               IF (ACCEPT(I)) THEN
                  ICOUNT = ICOUNT + N1
                  WRITE (NOUT,'(A)') FILES(I)
               ENDIF   
            ENDIF
         ENDDO
         CLOSE (UNIT = NOUT)
         NFILES = ICOUNT
      ENDIF
C
C Make sure units are closed 
C
      CLOSE (UNIT = NIN)
      CLOSE (UNIT = NOUT)
C
C Format statements
C
  100 FORMAT ('File',I4,A)
  200 FORMAT (i4,' files rejected:',1X,A)
      END
C
C






















 