c   
c
      subroutine puterr (ierr,
     +                   c) 
c
c action: inform user of an error condition
c author: w.g.bardsley, university of manchester, u.k., 26/03/2008
c         04/04/2011 now displays the rest of c and uses x_putfat
c ierr: 0 for no error so silent return
c       otherwise report the error as follows:
c c(1:1) = 'a' or 'A' for memory allocation error
c c(1:1) = 'd' or 'D' for memory allocation error
c c(1:1) = other for unspecified error
c
      implicit none
c
c arguments
c          
      integer,             intent (in) :: ierr
      character (len = *), intent (in) :: c 
c
c locals
c      
      integer    l, l1, l2, len200
      character  c1*1, c2*1024, line*1024, word10*10
      external   x_putfat, triml1, ucase1, len200
      if (ierr.ne.0) then
c
c action required as ierr is nonzero
c        
         write (word10,'(i10)') ierr
         call triml1 (word10)
         l = len200 (c)
         if (l.ge.1) then
            c1 = c(1:1)
         else
            c1 = '?'
         endif      
         if (l.gt.1) then
            c2 = c(2:l)
         else
            c2 = ', No details'
         endif      
         call ucase1 (c1)
         l1 = len200 (word10)
         l2 = len200 (c2)
         if (c1.eq.'A') then
c
c allocation error
c           
            write (line,100) word10(1:l1)//c2(1:l2)
         elseif (c1.eq.'D') then
c
c deallocation error
c         
            write (line,200) word10(1:l1)//c2(1:l2)
         else
c
c unspecified error
c           
            write (line,300) word10(1:l1)//c2(1:l2)
         endif    
         call x_putfat (line)
      endif
  100 format ('Memory allocation error',1x,a)      
  200 format ('Memory deallocation error =',1x,a)      
  300 format ('IERR in call to PUTERR =',1x,a)      
      end
c
c        