C
C
      SUBROUTINE PUTIFA (IFAIL, NF, STRNG)
C
C ACTION : Declare WARNING: IFAIL etc.
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 27/12/92
C          27/12/1996 W95 version
C          24/09/2002 Added FIRST
C          22/01/2005 edited to accomodate true NAG DLL errors
C          28/02/2007 added INTENTS
C
C          IFAIL: (input/unchanged)
C             NF: (input/unchanged) preconnected unit for results
C                 Writes to output unit NF only if NF > 0
C          STRNG: (input/unchanged) the error message
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN) :: IFAIL, NF
      CHARACTER (LEN = *), INTENT (IN) :: STRNG
C
C Locals
C
      INTEGER    NTEXT
      PARAMETER (NTEXT = 23)
      CHARACTER  LINE*100, TEXT(NTEXT)*100, WORD3*3
      LOGICAL    FIRST
      EXTERNAL   PUTFAT, PUTMES, UCASE1
      SAVE       FIRST
      DATA       FIRST / .TRUE. /
      IF (IFAIL.EQ.0) THEN
C
C IFAIL = 0 means all is well
C
         RETURN
      ELSEIF (IFAIL.EQ.999 .OR. IFAIL.EQ.-399) THEN
C
C IFAIL = 999 OR -399 means NAG DLLs are out of date
C
         WRITE (LINE,100)
         CALL PUTFAT (LINE)
         RETURN
      ENDIF
C
C Check for E04 routines otherwise report the error
C
      WORD3 = STRNG(1:3)
      CALL UCASE1 (WORD3)
      IF (WORD3.EQ.'E04') THEN
C
C Silent exit if returned from a E04 type routine
C
         RETURN
      ELSE
C
C IFAIL nonzero so report the error
C
         WRITE (LINE,200) IFAIL, STRNG
         CALL PUTFAT (LINE)
         IF (NF.GT.0) WRITE (NF,300) IFAIL, STRNG
         IF (FIRST) THEN
C
C More information if it is the first error
C
            FIRST = .FALSE.
            WRITE (TEXT,400)
            CALL PUTMES (NTEXT, TEXT)
         ENDIF
      ENDIF  
C
C Format statements
C      
  100 FORMAT ('IFAIL = 999 or -399 ... update your NAG licence key')
  200 FORMAT ('IFAIL =',I4,1X,'from',1X,A)
  300 FORMAT ('FATAL: IFAIL =',I4,1X,'from',1X,A)
  400 FORMAT (
     + 'NAG library IFAIL messages'
     +/
     +/'When a calculation fails for some reason, the value of a'
     +/'parameter called IFAIL is set as nonzero and users are then'
     +/'warned so that the results can be rejected, the fault can'
     +/'be corrected, and then the data can be re-analysed.'
     +/'Messages will look something like this:'
     +/
     +/'IFAIL = 1 from C05AZF/ZSOLVE'
     +/
     +/'This means that an error has occurred in the NAG routine C05AZF'
     +/'in the Simfit subroutine ZSOLVE.'
     +/
     +/'In this case it means that f(x1)f(x2) > 0 on entry so that the'
     +/'nonlinear root finding procedure used by C05AZF cannot start,'
     +/'and so no root can be estimated.'
     +/
     +/'To find out what IFAIL messages mean, just search for the name'
     +/'of the NAG routine (C05AZF in this case) using a search engine,'
     +/'or browse the corresponding page of the NAG manual, e.g'
     +/'http://www.nag.co.uk/numeric/fl/manual/pdf/C05/C05azf.pdf.'
     +/
     +/'Note: NAG-Simfit writes error details to the file nagifail.txt')
      END
C
C
