C
C
      SUBROUTINE PUTMES (N,
     +                   TEXT)
C
C ACTION : Display N lines of TEXT  ... i.e. a message
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 26/11/92
C          26/12/1996 W95 version
C          21/02/1998 routed through patch1 to pass via w_dbleup
C          09/12/1998 Derived from PUTTXT
C          07/01/2001 increased NMAX to 100 and simplified
C          21/04/2006 now uses ICOLOR = 9 and LSHADE = 1 as defined
C                     by the PATCH1 colour scheme, also automatically
C                     sets NUMBLD(1) = 1 if N > 1
C          26/01/2007 edited
C          01/05/2011 edited for SIMPLOT first time messages
C
C ICOLOR, NUMBLD and FIXED are not used by the call to W_PATCH1
C 
C    N: (input/unchanged) number of lines of text, N >= 1
C TEXT: (input/unchanged) text array to be passed on to PATCH1
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN) :: N
      CHARACTER (LEN = *), INTENT (IN) :: TEXT(N)
C
C Locals
C
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMTXT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1)
      INTEGER    N0, N1, N2, N3, N4, NMAX
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, NMAX = 100)
      INTEGER    NUMBLD(NMAX)
      INTEGER    I
      CHARACTER  STRNG(NMAX)*129
      CHARACTER  BLANK*1, SPEEDUP*32
      PARAMETER (BLANK = ' ', 
     +           SPEEDUP ='[Configure],[Advanced],[Speedup]')
      LOGICAL    FIXED
      PARAMETER (FIXED = .FALSE.)
      EXTERNAL   PATCH1
      INTRINSIC  MIN, INDEX
C
C Check N then define NUMTXT
C
      IF (N.LT.N1) RETURN
      NUMTXT = MIN(N,NMAX)
      STRNG(N1) = TEXT(N1)
      IF (N.EQ.N1) THEN
C
C If N = 1 do not highlight
C
         NUMBLD(N1) = N0
      ELSE
C
C If N > 1 highlight the first line only if the second line is blank
C
         STRNG(N2) = TEXT(N2) 
         IF (STRNG(N2).EQ.BLANK) THEN
            NUMBLD(N1) = N1
         ELSE   
            NUMBLD(N1) = N0
         ENDIF 
         NUMBLD(N2) = N0  
         DO I = N3, NUMTXT
            STRNG(I) = TEXT(I)
            NUMBLD(I) = N0
         ENDDO
      ENDIF
C
C Check for SIMPLOT first time messages
C      
      IF (N.GT.N3) THEN
         IF (STRNG(N2).EQ.BLANK .AND. STRNG(N4).EQ.BLANK .AND.
     +       INDEX(STRNG(N3),SPEEDUP).GT.N0) NUMBLD(3) = N2
      ENDIF
C
C Display the text
C
      CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMTXT,
     +             STRNG,
     +             FIXED)
      END
C
C
