c     
c
      subroutine rbox02 (numdec, numopt, numsta, numtxt,
     +                   text)
c
c action: choose only one option from a ganged check box 
c author: w.g.bardsley, university of manchester, u.k., 09/11/2016
c         13/05/2019 corrected error with numbld(1) = 1 allowing > 1 selection   
c         30/05/2019 set itype = 0 to get radio buttons  
c    
c numdec: sets the chosen box on input then returns the boc checked
c numopt: the number of options available
c numsta: line number for first option
c numtxt: total number of lines of text
c
c Note that blank lines are ignored so put a dot or similar instead
c 
      implicit none
c
c arguments
c      
      integer, intent (inout)          :: numdec
      integer, intent (in)             :: numopt, numsta, numtxt
      character (len = *), intent (in) :: text(numtxt)
c
c locals
c      
      integer    icolor, ixl, iyl, lshade, nmax, ntype
      parameter (icolor = 7, ixl = 0, iyl = 0, lshade = 0, nmax = 100,
     +           ntype = 0)
      integer    i, istart, istop, numbld(nmax), numpos(nmax) 
      logical    border, flash, high
      parameter (border = .false., flash = .true., high = .false.)
      external   rbox01, putfat
c
c check arguments supplied
c      
      if (numopt.lt.2) then
         call putfat ('Call to RBOX02 with NUMOPT < 2')
         return
      endif
      if (numdec.lt.1 .or. numdec.gt.numopt) then
         call putfat ('Call to RBOX02 with NUMDEC < 1 or > NUMOPT')
         return
      endif
      if (numsta.lt.1 .or. numsta.gt.numtxt) then
         call putfat ('Call to RBOX02 with NUMSTA < 1 or > NUMTXT')
         return
      endif
       if (numtxt.lt.numsta + numopt - 1) then
         call putfat ('Call to RBOX02 with NUMTXT < NUMSTA+NUMOPT-1')
         return
      endif
c
c set up the call to rbox01
c      
      istart = numsta 
      istop = istart + numopt - 1
      do i = 1, numtxt
         if (i.ge.istart .and. i.le.istop) then
            numbld(i) = 100 
         else   
            numbld(i) = 0
         endif
      enddo         
      do i = 1, numtxt
        if (i.eq.numdec) then       
           numpos(i) = 1
        else
           numpos(i) = 0
        endif      
      enddo   
      call rbox01 (icolor, ixl, iyl, lshade, numbld, ntype, numopt,
     +             numpos, numsta, numtxt,
     +             text,
     +             border, flash, high)
c
c iterpret the numpos array returned to find the box checked
c     
      do i = 1, numopt
         if (numpos(i).eq.1) then
            numdec = i
            exit
         endif    
      enddo
      end
c
c









