c
c
      subroutine rbox03 (numdec, numopt, numsta, numtxt,
     +                   text)
c
c action: check/tick all the options in an un-ganged check box 
c author: w.g.bardsley, university of manchester, u.k., 09/11/2016
c    
c numdec: sets the starting values on input then returns the boxes checked where
c         numdec(i) = 0 implies .false. and numdec(i) = 1 implies .true.
c numopt: the number of options available
c numsta: line number for first option
c numtxt: total number of lines of text
c
c Note that blank lines are ignored so put a dot or similar instead
c 
      implicit none
c
c arguments
c      
      integer, intent (in)             :: numopt, numsta, numtxt
      integer, intent (inout)          :: numdec(numopt)
      character (len = *), intent (in) :: text(numtxt)
c
c locals
c      
      integer    icolor, ixl, iyl, lshade, nmax, ntype
      parameter (icolor = 7, ixl = 4, iyl = 4, lshade = 0, nmax = 100,
     +           ntype = 1)
      integer    i, numbld(nmax) 
      logical    iwarnu
      logical    border, flash, high
      parameter (border = .false., flash = .true., high = .false.)
      external   rbox01, putfat, putwar
c
c check arguments supplied
c      
      if (numopt.lt.2) then
         call putfat ('Call to RBOX03 with NUMOPT < 2')
         return
      endif
      if (numsta.lt.1 .or. numsta.gt.numtxt) then
         call putfat ('Call to RBOX03 with NUMSTA < 1 or > NUMTXT')
         return
      endif
       if (numtxt.lt.numsta + numopt - 1) then
         call putfat ('Call to RBOX03 with NUMTXT < NUMSTA+NUMOPT-1')
         return
      endif
      iwarnu = .false.
      do i = 1, numopt
         if (numdec(i).lt.0) then
            iwarnu = .true.
            numdec(i) = 0
         elseif (numdec(i).gt.1) then
            iwarnu = .true.
            numdec(i) = 1   
         endif
      enddo
      if (iwarnu) call putwar (
     +'NUMDEC(i) supplied to RBOX03 must be 0(.false.) or 1(.true.)')       
c
c set up the call to rbox01
c      
      do i = 1, numtxt
         if (numsta.gt.1 .and. i.eq.1) then
            numbld(1)  = 1
         else   
            numbld(i) = 0
         endif
      enddo         
      call rbox01 (icolor, ixl, iyl, lshade, numbld, ntype, numopt,
     +             numdec, numsta, numtxt,
     +             text,
     +             border, flash, high)
      end
c
c
