
c
c
      subroutine rbox04 (isend, numopt, numsta, numtxt,
     +                   yesno,  
     +                   text)
c
c action: minimalist check box calling rbox01 but with no ganging
c author: w.g.bardsley, university of manchester, uk, 02/05/2024  
c         14/05/2024 isend and call to rbox02 added for greater versatility
c
 
c isend : provided for further developments other than isend = 1
c         isend = 1 for any possible choice of input for yesno otherwise
c         only one item should be set because of ganging but if no   
c         or too many yesno(i) = .true. are input then defaults are set   
c numopt: number of options
c numsta: starting value for offset (usually 2 for a margin after the title)
c numtxt: number of text lines (usually numopt + 2) 
c yesno : logical value for initialising options then return check boxes ticked 
c text  : options plus header title and a space 
c
    
c
c arguments
c
      integer,             intent(in)    :: isend 
      integer,             intent(in)    :: numopt, numsta, numtxt
      logical,             intent(inout) :: yesno(numopt) 
      character (len = *), intent(in)    :: text(numtxt)
c
c locals
c
      integer i, iadd1 
      integer numbld(50), numpos(50)
      integer icolor, ix, iy, lshade, numdec, numdec1
      parameter (icolor = 9, ix = 0, iy = 0, lshade = 0, numdec = 1)
      logical border, flash, high 
      parameter (border = .false., flash = .false., high = .false.)
      data numbld / 50*1 /
      external rbox01, rbox02, putadv
c
c check that numopt >= 1 and numtxt >= numopt and numtxt < numopt + numsta - 1
c      
      if (numopt.lt.1) then
         call putadv ('numopt < 1 in call to RBOX04')
         return
      endif    
      if (numtxt.lt.numopt) then
         call putadv ('numtxt < numopt in call to RBOX04')
         return
      endif   
      if (numsta.lt.0) then
         call putadv ('numsta < 0 in call to RBOX04')
         return
      endif  
      if (numtxt.lt.numopt + numsta - 1) then
         call putadv ('numtxt < numopt + numsta - 1 in call to RBOX04')
         return
      endif   
c
c use yesno from input to define numpos then call rbox01
c      
      if (isend.eq.1) then
         do i = 1, numopt
            if (yesno(i)) then
               numpos(i) = 1
            else
               numpos(i) = 0
            endif     
         enddo
         call rbox01 (icolor, ix, iy, lshade, numbld, numdec, numopt, 
     +                numpos, numsta, numtxt,
     +                text,
     +                border, flash, high)
c
c use numpos on exit from rbox01 to define yesno
c     
         do i = 1, numopt
            if (numpos(i).eq.1) then
               yesno(i) = .true.
            else
               yesno(i) = .false.
            endif
         enddo  
c
c option for ganged boxes when isend not equal to 1
c         
      else
         numdec1 = 0
         iadd1 = 0
         do i = 1, numopt
            if (yesno(i)) then
               iadd1 = iadd1 + 1
               if (iadd1.eq.1) then 
                 yesno(i) = .true.
                 numdec1 = i
               else
                  yesno(i) = .false.   
               endif
            endif   
         enddo  
         if (iadd1.eq.0) numdec1 = 1
         call rbox02 (numdec1, numopt, numsta, numtxt,
     +                text)
         do i = 1, numopt
            if (i.eq.numdec1) then
               yesno(numdec1) = .true.
            else
               yesno(i) = .false.
            endif
         enddo         
      endif
       
      end
c
c         