c
c
      subroutine recent
c
c action: display recent files
c author: w.g.bardsley, university of manchester, u.k., 03/06/2005 
c         29/11/2006 introduced a call to simdir to generate full_path
c         19/01/2007 made sure Simfit folder exists before using as a prefix 
C                    and introduced calls to sim256 and infofl
c         19/04/2014 changed nmax3 from 20 to 27, trim80 to trim100, and added again
c
c Note: to remain consistent between Linux and Windows the following rule
c       must be followed:
c       1) w_input.cfg and w_output.cfg are created in the simfit folder
c       2) w_result.cfg is also created in the simfit folder
c
      implicit   none
      integer    iadd1, ios, jsend, kfile1, kfile2, kfile3, l, nfile1,
     +           nfile2, nfile3, nin, numdec
      integer    isend, ksend, nmax1, nmax2, nmax3, numopt
      parameter (isend = 1, ksend = 2, nmax1 = 200, nmax2 = 200,
     +           nmax3 = 27, numopt = 6)
      character  line*1024, fname1(nmax1)*1024, fname2(nmax2)*1024,
     +           fname3(nmax3)*1024, option(numopt)*100,
     +           text1(nmax1 + 1)*100, text2(nmax2 + 1)*100,
     +           text3(nmax3 + 1)*100    
      character  full_path*1024, sim256*1024, trim100*100
      character  path_res*1024, path_usr*1024
      character  cancel*20         
      parameter (cancel = 'Cancel')!translate 
      character  w_input*11, w_output*12, w_results*12
      parameter (w_input = 'w_input.cfg',
     +           w_output = 'w_output.cfg',
     +           w_results = 'w_result.cfg')
      character  blank*1, path*1, pattern*1
      parameter (blank = ' ', path = blank, pattern = blank)
      logical    again, done1, done2, done3, repeet, there
      external   listbx, trim100, getnou, viewer, sim256, infofl,
     +           resdir, usrdir, putfat 
c
c initialise
c                   
      kfile1 = 1
      kfile2 = 1
      kfile3 = 1
      nfile1 = 0
      nfile2 = 0
      nfile3 = 0
      numdec = 1
      done1 = .false.
      done2 = .false.
      done3 = .false.
      repeet = .true.
      write (option,100)
c
c main loop
c
      do while (repeet)
         call listbx (numdec, numopt,
     +                option)
c
c check that the cfg files exist
c
         if (numdec.eq.1) then   
            full_path = sim256(w_input)
            inquire (file = full_path, exist = there)
            if (.not.there) then    
                jsend = 1
                call infofl (jsend,
     +                       full_path)                
                numdec = 0
            endif
         elseif (numdec.eq.2) then   
            full_path = sim256(w_output)
            inquire (file = full_path, exist = there)
            if (.not.there) then  
                jsend = 1
                call infofl (jsend,
     +                       full_path)                
                numdec = 0
            endif
         elseif (numdec.eq.3) then    
            full_path = sim256(w_results)
            inquire (file = full_path, exist = there)
            if (.not.there) then  
                jsend = 1
                call infofl (jsend,
     +                       full_path)                
                numdec = 0
            endif
         endif
         if (numdec.eq.0) then
c
c file missing
c
            numdec = numopt
         elseif (numdec.eq.1) then
c
c analysed
c
            if (.not.done1) then
               call getnou (nin)     
               full_path = sim256(w_input)
               open (unit = nin, file = full_path, iostat = ios)
               if (ios.eq.0) then
                  iadd1 = 0
                  do while (ios.eq.0)
                     read (nin,'(a)',iostat=ios) line
                     if (line.eq.blank) ios = -1
                     if (ios.eq.0 .and. iadd1.lt.nmax1) then
                        iadd1 = iadd1 + 1
                        fname1(iadd1) = line
                        text1(iadd1) = trim100(line)
                     endif
                  enddo
                  nfile1 = iadd1 + 1
                  text1(nfile1) = cancel
               else
                  nfile1 = 0          
                  jsend = 7
                  call infofl (jsend,
     +                         full_path)                  
               endif
               done1 = .true.
               close (unit = nin)
            endif
            if (nfile1.gt.1) then
               call listbx (kfile1, nfile1,
     +                      text1)
               if (kfile1.lt.nfile1) call viewer (isend,
     +                                            fname1(kfile1), path,
     +                                            pattern)
            else    
               jsend = 8
               call infofl (jsend,
     +                      full_path)               
            endif
         elseif (numdec.eq.2) then
c
c created
c
            if (.not.done2) then
               call getnou (nin)                 
               full_path = sim256(w_output)
               open (unit = nin, file = full_path, iostat = ios)
               if (ios.eq.0) then
                  iadd1 = 0
                  do while (ios.eq.0)
                     read (nin,'(a)',iostat=ios) line
                     if (line.eq.blank) ios = -1
                     if (ios.eq.0 .and. iadd1.lt.nmax2) then
                        iadd1 = iadd1 + 1
                        fname2(iadd1) = line
                        text2(iadd1) = trim100(line)
                     endif
                  enddo
                  nfile2 = iadd1 + 1
                  text2(nfile2) = cancel
               else
                  nfile2 = 0 
                  jsend = 7
                  call infofl (jsend,
     +                         full_path)                   
               endif
               done2 = .true.
               close (unit = nin)
            endif
            if (nfile2.gt.1) then
               call listbx (kfile2, nfile2,
     +                      text2)
               if (kfile2.lt.nfile2) call viewer (isend,
     +                                            fname2(kfile2), path,
     +                                            pattern)
            else 
               jsend = 8
               call infofl (jsend,
     +                      full_path)               
            endif
         elseif (numdec.eq.3) then
c
c results
c
            if (.not.done3) then
               call getnou (nin)  
               full_path = sim256(w_results)
               open (unit = nin, file = full_path, iostat = ios)
               if (ios.eq.0) then
                  iadd1 = 0
                  do while (ios.eq.0)
                     read (nin,'(a)',iostat=ios) line
                     if (line.eq.blank) ios = -1
                     if (ios.eq.0 .and. iadd1.lt.nmax3) then
                        iadd1 = iadd1 + 1
                        fname3(iadd1) = line
                        text3(iadd1) = trim100(line)
                     endif
                  enddo
                  nfile3 = iadd1 + 1
                  text3(nfile3) = cancel
               else
                  nfile3 = 0  
                  jsend = 7
                  call infofl (jsend,
     +                         full_path)                  
               endif
               done3 = .true.
               close (unit = nin)
            endif
            if (nfile3.gt.1) then
               again = .true.
               do while (again)
                  call listbx (kfile3, nfile3,
     +                         text3)
                  if (kfile3.lt.nfile3) then
                     call viewer (isend,
     +               fname3(kfile3), path, pattern)
                  else
                     again = .false.
                  endif
               enddo      
            else  
               jsend = 8
               call infofl (jsend,
     +                      full_path)                
            endif
         elseif (numdec.eq.4) then
c
c results file
c            
            call resdir (l,
     +                   path_res)
            if (l.le.5) then
               call putfat ('Cannot find results folder ...\Simfit\res')              
            else
               call viewer (ksend,
     +                      full_path, path_res, pattern)
            endif                  
         elseif (numdec.eq.5) then
c
c users files
c            
            call usrdir (l,
     +                   path_usr)
            if (l.le.5) then
               call putfat ('Cannot find user folder ...\Simfit\usr')              
            else
               call viewer (ksend,
     +                      full_path, path_usr, pattern)
            endif                  
         else
            repeet = .false.
         endif 
      enddo
c
c format statement
c      
  100 format (
     + 'View recently analysed files'
     +/'View recently created files'
     +/'View recent results log files'
     +/'Browse results folder'
     +/'Browse user folder'
     +/'Cancel')
      end
c
c
