
c
c FILE RESFIL.FOR ... extensively revised by w.g.bardsley, 17/04/2019
C 10/09/2019 added call to resfil_repair                 
c
c contains     
c
c SUBROUTINES:
c RESFIL
c RESFIL_ARCHIV
c RESFIL_DEFAULTS
c RESFIL_RENAME
C RESFIL_REPAIR
c RESFIL_UPDATE      
c RESULTS_FILE
c FUNCTION:
c LEN_UPTO_MAX 
c----------------------------------------------------------------------
c
      subroutine resfil (nout,
     +                   fname,
     +                   abort)
c
c action: third "new" version of resfil 
c author: w.g.bardsley, university of manchester, u.k., 11/04/2019
c action: connects nout to fname and writes the results file header
c
c  nout: unconnected unit
c fname: full path filename for f$result.txt in the results folder
c abort: error indicator
c  
      implicit none  
c
c arguments
c      
      integer,             intent (in)  :: nout
      character (len = *), intent (out) :: fname 
      logical,             intent (out) :: abort
c
c locals
c      
      integer    nmax
      parameter (nmax = 101)
      integer    ios
      character (len = 1024) fnames(nmax), fsav(nmax) 
      character (len = 100 ) line
      character (len = 80  ) date
      character (len = 1   ) blank
      parameter (blank = ' ')
      logical    op, first
      external   putwar, date01, resfil_defaults, resfil_rename,
     +           resfil_repair, resfil_update
      save       first
      save       fnames, fsav
      data       first / .true. /
      data       fnames, fsav / nmax*blank, nmax*blank /
c
c initialise then check input arguments
c
      fname = blank
      abort = .false.
      ios = 0
      if (nout.lt.1) then
         abort = .true.
         ios = -1
         write (line,100)
         call putwar (line)
      endif
      if (ios.eq.0) then
         inquire (unit = nout, opened = op, iostat = ios)
         if (op .and. ios.eq.0) then
            abort = .true.
            ios = -2
            write (line,200)
            call putwar (line)
         endif
      endif 
c
c get the results files  
c
      call resfil_defaults (nmax, 
     +                      fsav)
c
c first time round update w_result.cg
c     
      if (first) then
         first = .false.  
         call resfil_repair (nmax,
     +                       fsav)                         
         call resfil_update (nmax,
     +                       fnames, fsav,   
     +                       abort)
      endif
c
c do any renaming and rolling that may be required
c      
      call resfil_rename (nmax, 
     +                    fnames, fsav)
c
c attempt to load the first default file
c     
      fname = fnames(1)
      if (ios.eq.0) open (unit = nout, file = fsav(1), iostat = ios)
      if (ios.ne.0) then   
         abort = .true.
         close (unit = nout)    
         write (line,300) 
         call putwar (line)
         open (unit = nout, status = 'SCRATCH', iostat = ios)
      endif            
      call date01 (date)
      write (nout,400,iostat=ios) date
c
c format statements
c       
  100 format ('NOUT < 1 in call to RESFIL')    
  200 format ('NOUT already connected in call to RESFIL') 
  300 format ('Correct the',
     +' errors in \ProgramData\Simfit\you\cfg and res folders') 
  400 format (
     + 'Simfit results file:',1X,A
     +/'Monospaced fonts (e.g. Courier) will preserve formatting but,'
     +/'to extract tables for importing into documents, press [Results]'
     +/'from the main Simfit menu then [Extract tables] and choose tab,'
     +/'html, xml, or LaTeX output style as described in the tutorial'
     +/'document ... extracting_tables_from_simfit_results_files.pdf.')         
      end
c
c SUBROUTINE RESFIL_ARCHIV
c--------------------------------------------------------------------
c
      subroutine resfil_archiv (nfiles, nmax,
     +                          files, text)
c
c action: get filename, date, driving program, and size for results files
c author: w.g.bardsley, university of manchester, u.k., 26/09/2016
c         20/10/2016 restricted search for program generating the results file to first ten lines     
c         02/05/2019 stricter code for adding files(i) and incrementing nfiles            
c     
c nfiles: number of files
c   nmax: maximum number of files 
c  files: fully qualified paths-filenames
c   text: (1) table header followed by
c         (2, 3, ..., nfiles) short filename//date//driving-program followed by
c         (nfiles + 2) final Cancel
c
      implicit none
c
c arguments
c          
      integer,             intent (in)  :: nmax
      integer,             intent (out) :: nfiles    
      character (len = *), intent (out) :: files(nmax), text(nmax + 2)
c
c locals
c      
      integer    i, iadd1, ios, j, jcount,  k, l, nbytes, nin(2)  
      integer    len_upto_max
      integer    isend, n12, n20
      parameter (isend = 5, n12 = 12, n20 = 20)
      character (len = 1024) fname, rfile, ftemp
      character (len = 1024) line
      character (len = 20  ) c1, c2, c5 
      parameter (c1 = 'Simfit Results file`',
     +           c2 = 'Date (dd/mm/yyyy)  `',
     +           c5 = 'Cancel             `')  
      character (len = 16) c3
      parameter (c3 = 'Program used   `')
      character (len = 10) c4 
      parameter (c4 = 'Size (KB)')
      character (len = 12  ) progrm
      character (len = 10  ) word10, wtime
      character (len = 2   ) word2
      parameter (word2 = ' `')
      character (len = 1   ) blank, bslash, colon, grave 
      parameter (blank = ' ', bslash = '\', colon = ':', grave = '`')
      logical    ok, there
      external   fwdate, getnou, lcase1, cfgdir, len_upto_max
      external   w_flinfo
      intrinsic  index, len_trim, adjustl, min

c
c initialise
c
      nfiles = 0
      do i = 1, nmax + 2
         if (i.le.nmax) files(i) = blank
         text(i) = blank
      enddo   
c
c open the configuration file
c
      call cfgdir (l,
     +             rfile)
      if (rfile(l:l).ne.bslash) then
         l = l + 1
         rfile(l:l) = bslash
      endif    
      fname = rfile(1:l)//'w_result.cfg'
      
      call getnou (nin(1))
      open (nin(1), file = fname, iostat = ios)
      if (ios.ne.0) then
         close (unit = nin(1))
         return
      endif 
c
c get nfiles and the file names, i.e., files(i) for i = 1, nfiles
c      
      nfiles = 0  
      do while (ios.eq.0 .and. nfiles.lt.nmax - 1)
         read (nin(1),'(a)',iostat=ios) ftemp
         i = -1
         there = .false.
         if (ios.eq.0) inquire (file = ftemp, exist = there, iostat = i)
         if (ios.eq.0 .and. i.eq.0 .and. there) then
             k = len_upto_max(n20,
     +                        ftemp)
         else
             k = 0
         endif 
         if (ios.eq.0 .and. i.eq.0 .and. k.ge.n12 .and. there .and.
     +       ftemp.ne.blank .and. nfiles.lt.nmax) then
            nfiles = nfiles + 1
            files(nfiles) = ftemp
         endif
      enddo 
      close (unit = nin(1))
      
     
c
c loop over the acceptable archived results files
c      
      ios = 0
      jcount = 1
      text(jcount) = c1//c2//c3//c4
      do i = 1, min(nfiles, nmax)
c        
c---------start of outer loop         
c
         rfile = files(i)
         rfile = adjustl(rfile)
         call getnou (nin(2))
         open (unit = nin(2), file = rfile, iostat = ios)
         iadd1 = 0
         ios = 0
         inner_loop: do while (ios.eq.0 .and. rfile.ne.blank)
c
c--------- start of inner loop 
c              
               iadd1 = iadd1 + 1 
               read (nin(2),'(a)',iostat=ios) line
               if (ios.eq.0 .and. iadd1.lt.10) then
                  line = adjustl(line)
                  call lcase1 (line)
                  ok = .false.
                  j = index(line,'program')
                  k = index(line,colon)
                  if (j.gt.0 .and. k.gt.0) ok = .true.
                  if (ok) then  
                     progrm = line(k + 1:k + 14)
                     progrm = adjustl(progrm)
                     call fwdate (rfile, wtime)
                     call w_flinfo (isend, nbytes,
     +                              rfile) 
                     write (word10,'(i10)') nbytes/1024                      
                     if (jcount.le.nmax + 1) then
                        jcount = jcount + 1
                        l = len_trim(rfile)
                        write (text(jcount),'(a)',iostat=ios)
     +rfile(l - 11:l)//grave//wtime//grave//progrm//grave//word10
                        ios = -1
                     endif
                  endif   
               else
                  progrm = 'unknown'
                  call fwdate (rfile, wtime)
                  call w_flinfo (isend, nbytes,
     +                        rfile) 
                  write (word10,'(i10)') nbytes/1024                      
                  if (jcount.le.nmax + 1) then
                     jcount = jcount + 1
                     l = len_trim(rfile)
                     write (text(jcount),'(a)',iostat=ios)
     +rfile(l - 11:l)//grave//wtime//grave//progrm//grave//word10
                     ios = -1 
                  endif
               endif
c              
c-----------------------end of inner loop
c               
          enddo inner_loop
          close (unit = nin(2))
c
c---------------------end of outer loop
c      
      enddo 
      
      jcount = jcount + 1
      text(jcount) = c5//word2//word2//blank
      close (unit = nin(1))
      close (unit = nin(2))
      nfiles = jcount - 2

      end
c
c SUBROUTINE RESFIL_DEFAULTS
c----------------------------------------------------------------------
c
      subroutine resfil_defaults (nmax, 
     +                            fsav)
c
c author: w.g.bardsley, university of manchester, u.k., 11/04/2019
c action: sets up default file names fsav
c                            
      implicit none
c
c arguments
c      
      integer,             intent (in)  :: nmax
      character (len = *), intent (out) :: fsav(nmax)
c
c locals
c      
      integer    i, m, nmax1
      parameter (nmax1 = 201)
      character (len = 1024) dirres, ftemp(nmax1)
      character (len = 100 ) line
      character (len = 12  ) stub
      character (len = 1   ) blank
      parameter (blank = ' ')
      logical    first
      external   resdir, lcase1, putwar
      intrinsic  min
      data       first / .true. /
      data       ftemp / nmax1*blank /
      if (first) then 
        first = .false.
c
c prepare the default fnames first time round
c      
         call resdir (m,
     +                dirres)
         if (dirres(m:m).ne.'\') then
            m = m + 1
            dirres(m:m) = '\'
         endif   
         call lcase1 (dirres)
         do i = 1, nmax
            if (i.eq.1) then
               stub = 'f$result.txt'
            elseif (i.le.10) then
               write (stub,100) i - 1 
            elseif (i.le.100) then
               write (stub,200) i - 1
            else
               write (stub,300) i - 1 
            endif  
            ftemp(i) = dirres(1:m)//stub
         enddo
      endif
      if (nmax.gt.nmax1) then
        write (line,400) 
        call putwar (line)
      endif   
      do i = 1, min(nmax, nmax1)
         fsav(i) = ftemp(i)
      enddo    
c 
c format statements
c      
  100 format ('f$result.00',i1)
  200 format ('f$result.0',i2)
  300 format ('f$result.',i3)
  400 format ('NMAX > MAX1 in call to RESFIL_DEFAULTS')
      end 
c
c SUBROUTINE RESFIL_RENAME  
c----------------------------------------------------------------------
c
      subroutine resfil_rename (nmax, 
     +                          fnames, fsav)
c
c author: w.g.bardsley, university of manchester, u.k., 12/04/2019
c action: rename/re-order the files saved in w_result.cfg
c                            
      implicit none
c
c arguments
c      
      integer,             intent (in)    :: nmax
      character (len = *), intent (in)    :: fsav(nmax)
      character (len = *), intent (inout) :: fnames(nmax) 
c
c locals
c      
      integer    nmax1, n12, n20
      parameter (nmax1 = 201, n12 = 12, n20 = 20)
      integer    len_upto_max
      integer    i, ierr, ios, k, nfiles, notdel, nin, nout
      character (len = 1024) dummy, results_file 
      character (len = 100 ) line
      character (len = 1   ) blank
      parameter (blank = ' ')
      logical    op, test1, test2, there
      logical    askif
      parameter (askif = .false.) 
      external   putadv, putwar, getnou, cfgdir, rename, deleet,
     +           len_upto_max
      intrinsic  trim
c
c initialise notdel then check nmax and try to open the results file
c      
      notdel = 0  
      if (nmax.gt.nmax1) then
         write (line,100)! nmax > nmax1
         call putwar (line)
         return
      endif 
      call cfgdir (k, 
     +             results_file)
      if (results_file(k:k) .ne. '\') then
         k = k + 1
         results_file(k:k) = '\'
      endif
      results_file(k:k + 12) = '\w_result.cfg'  
      inquire (file = results_file, exist = there, opened = op)
      if (op) then
         write (line,200)! already opened
         call putwar (line) 
         return 
      endif 
      if (.not.there) then
         write (line,300)! try create new w_result.cfg
         call putadv (line)
      endif   
      call getnou (nin)
      ios = 0
      open (unit = nin, file = results_file, iostat = ios) 
      if (ios.ne.0) then
         write (line,400)! cannot open w_result.cfg
         call putwar (line)
         close (unit = nin)
         return
      endif
c
c read current filenames then close w_result.cfg if nfiles = 0
c      
      nfiles = 0 
      do while (ios.eq.0 .and. nfiles.lt.nmax)
         read (nin,'(a)',iostat=ios) dummy
         if (ios.eq.0) then
            test1 = .false.
            test2 = .false.
            if (dummy.ne.blank) test1 = .true.
            if (test1) inquire (file = dummy, exist = test2, iostat = i)
            if (i.eq.0 .and. ios.eq.0 .and. test1 .and. test2) then    
               nfiles = nfiles + 1
               fnames(nfiles) = dummy
            endif   
         endif
      enddo
      if (nfiles.eq.0) then
         write (nin,'(a)', iostat=ios) fsav(1)
         fnames(1) = fsav(1)   
         if (ios.ne.0) then
            write (line,500)! cannot write f$result.txt to w_result.cfg
            call putwar (line)
         endif
         nfiles = 1
         close (unit = nin)
         return
      endif 
      close (unit = nin)
c
c  deleet any extra files and then redefine nfiles unless first file is effectively empty
c      
      if (nfiles.ge.nmax - 1) then
         do i = nmax, nfiles
            call deleet (fnames(i),
     +                   askif, there)
            if (there) notdel = notdel + 1
         enddo
         nfiles = nmax - 1
      endif 
      
      k = len_upto_max(n20,
     +                 fnames(1))
      if (k.lt.n12) then
c
c delete the empty first file 
c        
         call deleet (fnames(1),
     +                askif, there)
      else 
c
c roll the list up one notch
c          
         ierr = 0
         do i = nfiles, 1, -1
            call deleet (fsav(i + 1),
     +                   askif, there)           
            call rename (fnames(i), fsav(i + 1),
     +                   ios)  
            if (ios.ne.0) ierr = ierr + 1
            fnames(i + 1) = fsav(i + 1)      
         enddo
         nfiles = nfiles + 1
         if (ierr.ne.0) then
            write (line,600) ierr
            call putwar (line)! cannot rename
            return
         endif   
      endif 
c
c make sure the first file is fsav(1)
c     
      fnames(1) = fsav(1)
c
c write out renamed files
c   
      call getnou (nout) 
      close (unit = nout)
      open (unit = nout, file = results_file, iostat = ios)   
      if (ios.ne.0) then
         write (line,400)
         call putwar (line)
         close (unit = nout)
         return
      endif 
      do i = 1, nfiles
         write (nout,'(a)',iostat = ios) trim(fnames(i))
      enddo
      close (unit = nout) 
      if (notdel.gt.0) then
         write (line,700) notdel! cannot delete
         call putwar (line)
      endif 
      
c
c format statements
c        
  100 format ('RESFIL_RENAME called with NMAX > MAX1')
  200 format ('RESFIL_RENAME finds w_result.cfg already connected')
  300 format ('RESFIL_RENAME will try to create w_result.cfg')
  400 format ('RESFIL_RENAME Cannot open w_result.cfg')
  500 format ('RESFIL_RENAME cannot write f$result.txt to w_result.cfg')
  600 format ('RESFIL_RENAME cannot rename',i4,' files')
  700 format ('RESFIL_RENAME cannot delete/rename',i4,' files')
      end
c
c--------------------------------------------------------------------------
c
      subroutine resfil_repair (nmax,
     +                          fsav)
      implicit   none
c
c arguments
c      
      integer,             intent (in) :: nmax
      character (len = *), intent (in) :: fsav(nmax)
c
c locals
c      
      integer    i, ios, j, nout
      character (len = 1024) fname 
      character (len = 200 ) line
      character (len = 100 ) trim100, word100
      character (len = 20  ) cipher  
      character (len = 1   ) bslash
      parameter (bslash = '\')
      logical    exist, first, op, read_only, there 
      logical    noisy, noisy_1
      parameter (noisy_1 = .false.)
      external   attrib, cfgdir, getnou, putwar, trim100
      intrinsic  trim
      data       first / .true. /
c
c Part 1: define noisy then refresh w_result.cfg
c      
      noisy = noisy_1  
      if (first) then
         first = .false.
         call getnou (nout)
         close (unit = nout)
         call cfgdir (j,
     +                fname)
         if (fname(j:j).ne.bslash) then
            j = j + 1
            fname(j:j) = bslash
         endif    
         fname(j + 1:j + 12) = 'w_result.cfg'  
         open (nout, file = fname, iostat = ios)
         if (ios.eq.0) then
            do i = 1, nmax
               if (ios.eq.0) write (nout,'(a)',iostat=ios) trim(fsav(i))
            enddo
         else
            word100 = trim100(fname)
            write (line,100) word100
            call putwar (line)
         endif       
         close (unit = nout)
      endif 
c
c Part 2: check if all the files exist, otherwise create dummy files
c                  
      do i = 1, nmax
         call attrib (fsav(i),
     +                exist, read_only)
         if (exist) then
            if (read_only) then
               cipher = 'read_only'
               word100 = trim100(fsav(i))
               write (line,100,iostat=ios) word100
               call putwar (line)
            else
               cipher = 'ok'
            endif
         else
            cipher = 'missing'
            inquire (file = fsav(i), exist = there, opened = op)
            if (there .and. op) then
               word100 = trim100(fsav(i))
               write (line,100,iostat=ios) word100
               call putwar (line)
               cipher = 'opened'  
            else   
               call getnou (nout)
               close (nout)
               fname = fsav(i)
               open (unit = nout, file = fname, iostat = ios)
               if (ios.eq.0) then
                  write (nout,200,iostat=ios)
                  cipher = 'repaired'
               else
                  word100 = trim100(fname)
                  write (line,100,iostat=ios) word100
                  call putwar (line)
                  cipher = 'error'  
               endif  
               close (nout)
            endif      
         endif 
         if (noisy) write (*,'(a,2x,a)') trim(fsav(i)), cipher
       enddo
  100 format ('RESFIL_REPAIR cannot open ',a) 
  200 format (
     + 'Temporary Simfit results file'
     +/'Monospaced fonts (e.g. Courier) will preserve formatting but,'
     +/'to extract tables for importing into documents, press [Results]'
     +/'from the main Simfit menu then [Extract tables] and choose tab,'
     +/'html, xml, or LaTeX output style as described in the tutorial'
     +/'document ... extracting_tables_from_simfit_results_files.pdf.'   
     +/' PACKAGE : SIMFIT'
     +/' PROGRAM : TEMPORARY'
     +/' MODEL   : NONE'
     +/' AUTHOR  : W. G. Bardsley, University of Manchester, U.K.'
     +/
     +/'Explanation' 
     +/'-----------' 
     +/'As Simfit proceeds it will create genuine results files with'
     +/'the output from analysing your data which will replace these'
     +/'temporary files until 101 files are archived. From then on,'
     +/'after performing an analysis, the list of archived files'
     +/'will be re-organised as follows:'
     +/
     +/'f$result.100 deleted'
     +/'f$result.099 renamed f$result.100'
     +/'f$result.098 renamed f$result.099' 
     +/'f$result.097 renamed f$result.098'
     +/'...'
     +/'...'
     +/'f$result.txt renamed f$result.001'
     +/'f$result.txt created with the latest results.')    
      end               
                 
c
c---------------------------------------------------------------------------
c
      subroutine resfil_update (nmax,
     +                          fnames, fsav,
     +                          abort) 
c
c author: w.g.bardsley, university of manchester, u.k., 03/05/2019
c action: clean up w_result.cfg with the following intentions
c         1) Only files with >= 13 non-blank lines in the first 20 are included
c         2) File names are re-named if required in strictly increasing order
c    
      implicit none
c
c arguments
c      
      integer,             intent (in)    :: nmax
      character (len = *), intent (in)    :: fsav(nmax)
      character (len = *), intent (inout) :: fnames(nmax) 
      logical,             intent (out)   :: abort  
c
c locals
c      
      integer    nmax1, n12, n20
      parameter (nmax1 = 201, n12 = 12, n20 = 20)
      integer    len_upto_max
      integer    i, icount, ierr, ios, k, l, nfiles, nin, nout
      character (len = 1024) dummy, results_file 
      character (len = 1024) f$temp(nmax) 
      character (len = 100 ) line
      logical    op, there
      logical    askif
      parameter (askif = .false.) 
      external   putadv, putwar, getnou, cfgdir, rename, deleet,
     +           len_upto_max
      intrinsic  trim, len_trim
c
c initialise abort then check nmax and try to open the results file
c
      abort = .true.      
      if (nmax.gt.nmax1) then
         write (line,100)! nmax > nmax1
         call putwar (line)
         return
      endif 
      call cfgdir (k, 
     +             results_file)
      if (results_file(k:k) .ne. '\') then
         k = k + 1
         results_file(k:k) = '\'
      endif
      results_file(k:k + 12) = '\w_result.cfg'  
      inquire (file = results_file, exist = there, opened = op)
      if (op) then
         write (line,200)! already opened
         call putwar (line) 
         return 
      endif 
      if (.not.there) then
         write (line,300)! try to create a new w_result.cfg
         call putadv (line)
      endif   
      call getnou (nin)
      ios = 0
      open (unit = nin, file = results_file, iostat = ios) 
      if (ios.ne.0) then
         write (line,400)! cannot open w_result.cfg
         call putwar (line)
         close (unit = nin)
         return
      endif
c
c read current filenames then close w_result.cfg if nfiles = 0
c      
      nfiles = 0 
      do while (ios.eq.0 .and. nfiles.lt.nmax)
         read (nin,'(a)',iostat=ios) dummy
         if (ios.eq.0) then
            nfiles = nfiles + 1
            fnames(nfiles) = dummy
         endif
      enddo
      if (nfiles.eq.0) then
         write (nin,'(a)', iostat=ios) fsav(1)
         fnames(1) = fsav(1)   
         if (ios.ne.0) then
            write (line,500)! cannot write f$result.txt to w_result.cfg
            call putwar (line)
         else
            abort = .false.   
         endif
         nfiles = 1
         close (unit = nin)
         return
      endif 
      close (unit = nin)
c
c  deleet any extra files and then redefine nfiles unless first file is effectively empty
c      
      if (nfiles.ge.nmax - 1) then
         do i = nmax, nfiles
            call deleet (fnames(i),
     +                   askif, there)
         enddo
         nfiles = nmax - 1
      endif 
c
c create dummy filenames f$temp unless one cannot be deleted
c      
      l = len_trim(fsav(1))
      do i = 1, nmax
         f$temp(i) = fsav(i)(1:l)//'.tmp'
         inquire (file = f$temp(i), exist = there, iostat = ios)
         if (ios.eq.0 .and. there) then
           call deleet (f$temp(i),
     +                  askif, there)      
           if (there) then
              write (line,600) trim(f$temp(i))
              call putwar (line)
              return
           endif
         endif           
      enddo
c
c copy if valid     
c
      icount = 0
      do i = 1, nfiles
         inquire (file = fnames(i), exist = there, iostat = ios)
         if (ios.eq.0 .and. there) then
            k = len_upto_max(n20,
     +                       fnames(i))
            if (k.lt.n12) then
c
c delete the empty file 
c        
               call deleet (fnames(i),
     +                      askif, there)
               if (there) then
                  write (line,600) trim(fnames(i))
                  call putwar (line)
                  return
               endif   
            else 
               icount = icount + 1
               inquire (file = f$temp(icount), exist = there,
     +                  iostat = ios)
               if (ios.eq.0 .and. there) then
                  call deleet (f$temp(icount),
     +                         askif, there)
                  if (there) then
                     write (line,600) f$temp(icount)
                     call putwar (line)
                     return
                  endif
               endif  
c
c at this point fnames(i) must exist but f$temp(icount) must not exist 
c               
               call rename (fnames(i), f$temp(icount), ierr)
               if (ierr.ne.0) then
                  write (line,700) trim(fnames(i))
                  call putwar (line)
                  return
               endif
            endif   
         endif   
      enddo  
c
c rename fnames in correct order
c          
      do i = 1, icount
         call deleet (fsav(i),
     +                askif, there)
         if (there) then
            write (line,600) trim(fsav(i))
            call putwar (line)
            return
         endif   
         call rename (f$temp(i), fsav(i), ierr)
         if (ierr.eq.0) then
            fnames(i) = fsav(i)
         else
            write (line,700) trim(f$temp(i))
            call putwar (line)
            return
         endif
      enddo
      nfiles = icount
c
c write out renamed files
c   
      call getnou (nout) 
      close (unit = nout)
      open (unit = nout, file = results_file, iostat = ios)   
      if (ios.ne.0) then
         write (line,400)
         call putwar (line)
         close (unit = nout)
         return
      endif 
      ierr = 0  
      do i = 1, nfiles
         write (nout,'(a)',iostat = ios) trim(fnames(i))
         if (ios.ne.0) ierr = ierr + 1
      enddo
      close (unit = nout) 
      if (ierr.gt.0) then
         write (line,800) ierr! cannot write
         call putwar (line)
      else
         abort = .false.   
      endif 
c
c format statements
c        
  100 format ('RESFIL_UPDATE called with NMAX > MAX1')
  200 format ('RESFIL_UPDATE finds w_result.cfg already connected')
  300 format ('RESFIL_UPDATE will try to create w_result.cfg')
  400 format ('RESFIL_UPDATE Cannot open w_result.cfg')
  500 format ('RESFIL_UPDATE cannot write f$result.txt to w_result.cfg')
  600 format ('RESFIL_UPDATE cannot delete',1x,a)
  700 format ('RESFIL_UPDATE cannot rename',1x,a)
  800 format ('RESFIL_UPDATE cannot write',i4,' files to w_result.cfg')
      end
c
c SUBROUTINE RESULTS_FILE
c------------------------
c
      subroutine results_file (isend,
     +                         fname)
c
c author: w.g.bardsley, university of manchester, u.k
c         11/04/2014 extensive editing of the original version to agree with RESFIL
c                    The results file is read and re-organised if necessary.
c                    If isend = 0 no further action is taken
c                    Otherwise a list can be displayed 
c         03/09/2016 added fname as argument and complete revision
c         26/09/2016 added call to archiv
c         11/04/2019 now checks that nfiles < nmax

c
c isend = 0: no action except to force initialisation
c isend = 1: view/copy/print/save
c isend = 2: just print 
c isend = 3: just save  
c isend = 4: just edit  
c isend = 5: just return the selected filename
c
c
      implicit   none
c
c argument
c      
      integer,             intent (in)  :: isend
      character (len = *), intent (out) :: fname
c
c locals
c      
      integer    nmax1, nmax1p2
      parameter (nmax1 = 201, nmax1p2 = nmax1 + 2)
      integer    ios, lpt1, mode, nfiles, 
     +           nout1, nout2, numopt, numtxt
      integer    ix, iy, numdec, numsta 
      parameter (ix = 4, iy = 4, numsta = 2)
      character (len = 1024) line, new_file, rfile
      character (len = 1024) all_files(nmax1) 
      character (len = 125 ) text(nmax1p2)
      character (len = 60  ) trim60 
      character (len = 1   ) blank
      parameter (blank = ' ')
      logical    abort, repeet, there
      logical    titles
      parameter (titles = .true.)
      external   putfat, getnou, viewer, fprint, ofiles, putadv, trim60, 
     +           lview1   
      external   run_editor
      external   resfil_archiv
c
c initialise 
c
      fname = 'No File'
c
c further action if 1 =< isend =< 5
c      
      if (isend.ge.1 .and. isend.le.5) then
         call resfil_archiv (nfiles, nmax1,
     +                       all_files, text)
c
c check that nfiles < nmax
c     
         if (nfiles.gt.nmax1) nfiles = nmax1        
         numopt = nfiles + 1
         numtxt = nfiles + 2
         numdec = 1
         repeet = .true.
         do while (repeet)
c
c main loop to view results files
c           
            call lview1 (ix, iy, numdec, numopt, numsta, numtxt,
     +                   text,
     +                   titles)
            if (numdec.eq.numopt) then
               return
            else          
               rfile = all_files(numdec)
            endif   
c
c see if the named file exists
c
            inquire (file = rfile, exist = there, iostat = ios)
            if (.not.there) then
               call putfat ('Results file could not be found')
               return
            endif  
c
c action for isend = 1, 2, 3, 4, 5
c
            if (isend.eq.1) then
c
c isend = 1: view
c
               mode = 1
               call viewer (mode,
     +                      rfile, blank, blank)
            elseif (isend.eq.2) then
c
c isend = 2: print
c
               lpt1 = 1
               call fprint (lpt1,
     +                      rfile)
            elseif (isend.eq.3) then
c
c isend = 3: save as
c
               call getnou (nout2)
               mode = 1
               call ofiles (mode, nout2,
     +                      new_file,
     +                      abort)
               if (.not.abort) then
                  call getnou (nout1)
                  open (unit = nout1, file = rfile, iostat = ios)
                  if (ios.eq.0) then
                     do while (ios.eq.0)
                        read (nout1,'(a)',iostat=ios) line
                        if (ios.eq.0) write (nout2,'(a)',iostat=ios)
     +                                       line
                     enddo
                     close (unit = nout1)
                     line = 'Results Saved As ...'//trim60(new_file)
                     call putadv (line)
                  endif
               endif
               close (unit = nout2)
            elseif (isend.eq.4) then
c
c isend = 4: edit
c
               call run_editor (rfile)
            elseif (isend.eq.5) then
c
c isend = 5: select a file
c
               fname = rfile
               repeet = .false.
            endif
         enddo 
      endif
      end

c
c----------------------------------------------------------------------------------
c FUNCTION LEN_UPTO_MAX
c-------------------------------------------------------------------------
c
      integer function len_upto_max (nmax, 
     +                               fname)
c
c action: return the number of nonblank lines in a text file up to a maximum of nmax
c author: w.g.bardsley, university of manchester, u.k. 12/04/2014
c
c         fname: (input/unchanged)
c
      implicit   none
c
c argument
c
      integer,             intent (in) :: nmax
      character (len = *), intent (in) :: fname
c
c locals
c
      integer    ios, nout
      character (len = 1024) line
      character (len = 1   ) blank
      parameter (blank = ' ')
      logical    there, op
      external   getnou
      len_upto_max = 0
      inquire (file = fname, exist = there, opened = op, iostat = ios)
      if (ios.eq.0 .and. there .and. .not.op) then
         call getnou (nout)
         open (unit = nout, file = fname, iostat = ios)
         do while (ios.eq.0 .and. len_upto_max.lt.nmax)
            read (nout,'(a)',iostat=ios) line
            if (ios.eq.0 .and. line.ne.blank) 
     +          len_upto_max = len_upto_max + 1
         enddo
         close (unit = nout)
      endif
      end
c
c----------------------------------------------------------------------
c      