c
c
      subroutine revpro (nout)
c
c action : review progress so far by viewing results file on nout
c author : w.g.bardsley, university of manchester, u.k., 18/11/97
c          08/01/2001 replaced do-while/end-while by while-do/enddo
c          18/02/2007 added intent
c          06/03/2012 checked for nout > 0
c
      implicit   none 
c
c argument
c      
      integer, intent (in) :: nout
c
c locals
c      
      integer    ifail, ios, isend, ndummy
      parameter (isend = 1)
      character  dummy1*1, dummy2*1, fname*1024, line*1024
      parameter (dummy1 = ' ', dummy2 = ' ')
      logical    askif, there
      parameter (askif = .false.)
      external   deleet, getnou, gettmp, putfat, viewer
c
c check nout
c     
      if (nout.lt.1) then
         call putfat ('nout < 1 in call to revpro')
         return
      endif    
c
c Make sure the unit is opened
c
      inquire (unit = nout, opened = there, iostat = ios)
      if (ios.ne.0 .or. .not.there) then
         call putfat ('Results file has not yet been opened')
         return
      endif
c
c open a temporary file
c
      call getnou (ndummy)
      if (ndummy.le.11) return
      call gettmp (ifail, fname)
      if (ifail.ne.0) return
      open (unit = ndummy, file = fname)
c
c rewind the log file then copy it into the temporary file
c
      rewind (nout)
      ios = 0
      do while (ios.eq.0)
          read (nout,'(a)',end=20,err=20,iostat=ios) line
          if (ios.eq.0) write (ndummy,'(a)') line
      enddo
c
c close the temporary unit and backspace the log file
c
   20 continue
      close (unit = ndummy)
      backspace (nout)
c
c view the temporary file then erase it
c
      call viewer (isend,
     +             fname, dummy1, dummy2)
      call deleet (fname,
     +             askif, there)
      end

c
c
