C
C
      SUBROUTINE SRTVEC (M, N, NRMAX,
     +                   A, V)
C
C ACTION : Warn ... then sort if required
C AUTHOR : W. G. Bardsley, University of manchester, U.K., 29/9/94
C          03/02/1997 Windows 95 version 
C          28/02/2007 added INTENTS
C          01/04/2008 edited to be consistent with VECSRT
C
C Column A(1,1) to A(N,1) is rearranged if requested and V is workspace
C A is supplied as a matrix only to be consisent with matrix routines
C when there is only one meaningful column
C       
C     M: (input/unchanged) column dimension for A (M > = 1)
C     N: (input/unchanged) no. of rows in column 1 to be re-ordered (N =< NRMAX)
C NRMAX: (input/unchanged) leading dimension of A (NRMAX >= N >= 1)
C     A: (input/output) matrix returned but only in column 1
C     B: (workspace 
C
      IMPLICIT   NONE  
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: M, N, NRMAX 
      DOUBLE PRECISION, INTENT (INOUT) :: A(NRMAX,M), V(N)
C
C Locals
C      
      INTEGER    ICOLOR, IX, IY, LSHADE, I, J, NTEXT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, I = 2, J = 0,
     +           NTEXT = 6)
      CHARACTER  LINE*50, TEXT(NTEXT)*100
      PARAMETER (LINE = 'Proceed to put the vector in order ?')
      LOGICAL    YES
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL YESNO1
      EXTERNAL VECSRT
      WRITE (TEXT,100)
      YES = .FALSE.
      CALL YESNO1 (ICOLOR, IX, IY, LSHADE, I, J, NTEXT,
     +             LINE, TEXT,
     +             BORDER, FLASH, HIGH,
     +             YES)
      IF (YES) CALL VECSRT (M, N, NRMAX, 
     +                      A, V)
  100 FORMAT (
     + 'This option first checks to see if the vector is in'
     +/'increasing/decreasing order then gives you a chance'
     +/'to rearrange it if required. If you do rearrange the'
     +/'vector you will lose the natural order, which could'
     +/'be problematical with some of the statistical tests'
     +/'such as the run or paired t tests.')
      END
C
C
