C
C
      SUBROUTINE STATMT (NCMAX, NCOL, NF, NIN, NMAX, NROW, NSMALL,
     +                   A, B, X,
     +                   FNAME, FSAV, TITLE, TSAV)
C
C ACTION: Input/Edit a data matrix for statistical analysis
C AUTHOR: W. G. Bardsley, University of Manchester, U.K., 30/01/2002
C         21/05/2006 removed arguments B and X from call to MATTRN 
C         02/11/2006 edited and now sets ICMAX = NCMAX
C
C  NCMAX: (input/unchanged) max. column dimension
C   NCOL: (output) column dimension
C     NF: (input/unchanged) pre-connected unit for results
C    NIN: (input/unchanged) unconnected unit for data input
C   NMAX: (input/unchanged) max. row dimension
C   NROW: (output) row dimension
C NSMALL: (input/unchanged) max. no. of columns from library file
C      A: (output) data matrix
C      B: workspace
C      X: workspace
C  FNAME: (output) filename
C   FSAV: (input/output) library file names
C  TITLE: (output) data title
C   TSAV: (input/output) library file titles
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NCMAX, NF, NIN, NMAX,
     +                                       NSMALL 
      INTEGER,             INTENT (OUT)   :: NCOL, NROW
      DOUBLE PRECISION,    INTENT (OUT)   :: A(NMAX,NCMAX), B(NMAX),
     +                                       X(NMAX)
      CHARACTER (LEN = *), INTENT (OUT)   :: FNAME, TITLE
      CHARACTER (LEN = *), INTENT (INOUT) :: FSAV(NSMALL), TSAV(NSMALL)
C
C Locals
C
      INTEGER    ICMAX
      INTEGER    I, ISEND, J, NFILES
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NOPT, NSTART, NUMTXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 1, NOPT = 6)
      INTEGER    NDEC, NUMBLD(30), NUMPOS(NOPT) 
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER  LINE*100, TEXT(30)*100
      CHARACTER  NODATA*15 , NOFILE*15
      PARAMETER (NODATA = 'No data', NOFILE = 'No file')
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    FIXCOL, FIXROW, LABEL
      PARAMETER (FIXCOL = .FALSE., FIXROW = .FALSE., LABEL = .TRUE.)
      LOGICAL    ABORT, MATRIX, LIBFIL, REPEET
      EXTERNAL   PUTFAT, MATTIN, GETSTR, MATTRN, PATCH1,
     +           LBOX01, VECFIL, VECCHK, VECCPY, PUTWAR
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / NOPT*1 /   
C
C Check
C      
      IF (NMAX.LT.1 .OR. NCMAX.LT.1 .OR. NSMALL.LT.1) THEN
         CALL PUTFAT ('NMAX, NCMAX, or NSMALL < 1 in call to STATMT')
         RETURN  
      ENDIF   
C
C Initialise
C
      NCOL = 0
      NROW = 0
      DO I = 1, NMAX 
         B(I) = ZERO
         X(I) = ZERO
         DO J = 1, NCMAX
            A(I,J) = ZERO
         ENDDO
      ENDDO
      FNAME = NOFILE
      TITLE = NODATA  
      ICMAX = NCMAX
      NDEC = NOPT - 1
C
C Main loop
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
C
C Main menu
C
         NSTART = 6
         NUMTXT = NSTART + NOPT - 1
         WRITE (TEXT,100)
         NUMBLD(1) = 4
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC, NOPT,
     +                NUMPOS, NSTART, NUMTXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = 0
         IF (NDEC.EQ.1) THEN
            MATRIX = .TRUE.
            LIBFIL = .FALSE.
         ELSEIF (NDEC.EQ.2) THEN
            MATRIX = .FALSE.
            LIBFIL = .FALSE.
         ELSEIF (NDEC.EQ.3) THEN
            MATRIX = .FALSE.
            LIBFIL = .TRUE.
         ENDIF
         IF (NDEC.EQ.1) THEN
C
C NDEC = 1: Read in a data matrix 
C
            NDEC = NOPT
            ISEND = 0
            CLOSE (UNIT = NIN)
            CALL MATTIN (ISEND, NCMAX, NCOL, NIN, NMAX, NROW,
     +                   A, B,
     +                   FNAME, TITLE,
     +                   ABORT, FIXCOL, FIXROW, LABEL)
            CLOSE (UNIT = NIN)
            IF (NCOL.LT.2 .OR. NROW.LT.2) THEN
               ABORT = .TRUE.
               CALL PUTFAT ('Insufficient data')
            ENDIF
            IF (ABORT) THEN
               NCOL = 0
               NROW = 0
               NDEC = 1
               FNAME = NOFILE
               TITLE = NODATA
            ENDIF
         ELSEIF (NDEC.LE.3) THEN
C
C NDEC =< 3: Read in files
C
            NDEC = NOPT
            CALL VECFIL (NFILES, NIN, NMAX, NSMALL,
     +                   X,
     +                   FSAV, TSAV,
     +                   ABORT, LIBFIL)
            CLOSE (UNIT = NIN)
            IF (ABORT) THEN
               NCOL = 0
               NROW = 0
               NDEC = NOPT - 1
               TITLE = NODATA
            ENDIF
C
C Check dimension
C
            IF (.NOT.ABORT) THEN
               IF (NFILES.GT.ICMAX) THEN
                  NCOL = ICMAX
                  NFILES = ICMAX
                  WRITE (LINE,300) ICMAX
                  CALL PUTWAR (LINE)
               ELSE
                  NCOL = NFILES
               ENDIF
C
C Check that all columns have the same length
C
               ISEND = 1
               CALL VECCHK (ISEND, NFILES, NIN, NROW,
     +                      FSAV,
     +                      ABORT)
               CLOSE (UNIT = NIN)
               IF (ABORT) THEN
                  NCOL = 0
                  NROW = 0
                  NDEC = NOPT - 1
                  TITLE = NODATA
               ENDIF
            ENDIF
C
C Copy all the files into A
C
            IF (.NOT.ABORT) CALL VECCPY (NCMAX, NCOL, NFILES, NIN,
     +                                   NMAX, NROW,
     +                                   A,
     +                                   FSAV, TSAV,
     +                                   ABORT)
            IF (ABORT) THEN
               NCOL = 0
               NROW = 0
               NDEC = NOPT - 1
               TITLE = NODATA
            ENDIF
C
C Write the data details to output file
C
            IF (.NOT.ABORT .AND. .NOT.MATRIX) THEN
               TITLE = 'Matrix data from vector files'
               CALL GETSTR ('Define a title for these data', TITLE)
               WRITE (NF,400) ' '
               WRITE (NF,400) 'Data files used for Analysis'
               WRITE (NF,400) '============================'
               WRITE (NF,400) ' '
               DO I = 1, NCOL
                  WRITE (NF,400) FSAV(I)
               ENDDO
            ENDIF
         ELSEIF (NDEC.EQ.4) THEN
            IF (NCOL.GT.0 .AND. NROW.GT.0) THEN
               ISEND = 3
               CALL MATTRN (ISEND, NCOL, NMAX, NROW,
     +                      A,
     +                      TITLE)
               REPEET = .FALSE.
            ELSE
               CALL PUTFAT ('First read in some data')
               NDEC = 1
            ENDIF
         ELSEIF (NDEC.EQ.NOPT - 1) THEN
            WRITE (TEXT,200)
            NUMBLD(1) = 1
            NUMBLD(16) = 1
            NUMTXT = 20
            CALL PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMTXT,
     +                   TEXT,
     +                   BORDER)
            NUMBLD(1) = 0
            NUMBLD(16) = 0
            NDEC = 1
         ELSE
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statements
C
  100 FORMAT (                        
     + 'Supplying Data'
     +/
     +/'Data can be as a matrix, individual'
     +/'column vectors, or as a library file.'
     +/
     +/'Input a matrix'
     +/'Input column vectors'
     +/'Input a library file'
     +/'Edit/Transform/View'
     +/'Help'
     +/'Accept')
  200 FORMAT (
     + 'Five techniques to input data into Simfit for analysis'
     +/
     +/'1) Open a Simfit data file (recommended)'
     +/'2) Paste data from the clipboard'
     +/'3) Type values at the terminal'
     +/'4) Supply individual column vectors'
     +/'5) Open a library file'
     +/
     +/'Method 1) is strongly recommended, and such files can be made'
     +/'using program Makmat, or saved from Excel using simfit4.xls.'
     +/'Method 2) is only possible if you have previously copied the'
     +/'data matrix to the clipboard from your editor or spreadsheet.'
     +/'Method 3) is useful for beginners with small data sets.'
     +/'Methods 4) and 5) are provided for experienced users.'
     +/
     +/'Transforming and editing data interactively'
     +/'After supplying data you can edit or transform, and re-analyse.'
     +/'Such editing is performed sequentially so, if you have not used'
     +/'Method 3, you can just re-enter the data to perform an Undo, as'
     +/'Simfit will never over-write data in a data file.')
  300 FORMAT (
     +'Too many columns  ...  Only',I4,' columns will be analysed')
  400 FORMAT (1X,A)
      END
C
C
