C
C
      SUBROUTINE STOP02 (NOUT,
     +                   DNAME1, DNAME2, FNAME, PNAME,
     +                   ABORT)
C
C ACTION : Declare end and files used then ask if a repeat run is required
C          Derived from STOPGO by adding facility to review progress
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          07/02/2008 derived from STOPGO
C
      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: NOUT 
      CHARACTER (LEN = *), INTENT (IN)  :: DNAME1, DNAME2, FNAME, PNAME 
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Locals
C      
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMDEC, NUMOPT, NSTART, N1,
     +           N2, N3, N4, N5, N20
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, LSHADE = 1,
     +           N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5, N20 = 20)
      INTEGER    ISEND
      PARAMETER (ISEND = 1)
      INTEGER    NUMBLD(N20), NUMPOS(N5)
      INTEGER    NTEXT
      CHARACTER  LINE*100, TEXT(30)*100, TRIM80*80
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    REPEET
      LOGICAL    BORDER, FLASH, HIGH, SUPPLY(2)
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   LBOX01, REVPRO, VIEWER, TRIM80
      DATA       NUMBLD / N20*0 /
      DATA       NUMPOS / N5*1 /
C
C Initialise
C
      NUMBLD(N1) = N4
      NTEXT = N1
      WRITE (TEXT(NTEXT),100) PNAME
      NTEXT = NTEXT + N1
      TEXT(NTEXT) = BLANK
C
C See if DNAME1 and DNAME2 exist
C      
      INQUIRE (FILE = DNAME1, EXIST = SUPPLY(1))
      INQUIRE (FILE = DNAME2, EXIST = SUPPLY(2))
      IF (SUPPLY(1) .AND. SUPPLY(2)) THEN
C
C Both files were located
C        
         NUMOPT = 5
         NTEXT = NTEXT + N1
         TEXT(NTEXT) = 'Input data were contained in the files'
         NTEXT = NTEXT + N1
         LINE = TRIM80(DNAME1)
         TEXT(NTEXT) = LINE
         NUMBLD(NTEXT) = N1
         NTEXT = NTEXT + N1
         TEXT(NTEXT) = BLANK   
         NTEXT = NTEXT + N1
         LINE = TRIM80(DNAME2)
         TEXT(NTEXT) = LINE
         NUMBLD(NTEXT) = N1
         NTEXT = NTEXT + N1
         TEXT(NTEXT) = BLANK   
      ELSEIF (SUPPLY(1)) THEN
C
C Only DNAME1 was located
C      
         NUMOPT = 4
         NTEXT = NTEXT + N1
         TEXT(NTEXT) = 'Input data were contained in the file'
         NTEXT = NTEXT + N1
         LINE = TRIM80(DNAME1)
         TEXT(NTEXT) = LINE
         NUMBLD(NTEXT) = N1
         NTEXT = NTEXT + N1
         TEXT(NTEXT) = BLANK
      ELSEIF (SUPPLY(2)) THEN
C
C Only DNAME2 was located
C      
         NUMOPT = 4
         NTEXT = NTEXT + N1
         TEXT(NTEXT) = 'Input data were contained in the file'
         NTEXT = NTEXT + N1
         LINE = TRIM80(DNAME2)
         TEXT(NTEXT) = LINE
         NUMBLD(NTEXT) = N1
         NTEXT = NTEXT + N1
         TEXT(NTEXT) = BLANK 
      ELSE
C
C No data files were located
C        
         NUMOPT = N3     
      ENDIF
      IF (FNAME.NE.BLANK) THEN
C
C A results file was opened
C        
         NTEXT = NTEXT + N1
         TEXT(NTEXT) = 'Results have been written to the file'
         NTEXT = NTEXT + N1
         LINE = TRIM80(FNAME)
         TEXT(NTEXT) = LINE
         NUMBLD(NTEXT) = N1
         NTEXT = NTEXT + N1
         TEXT(NTEXT) = BLANK
      ENDIF
      NTEXT = NTEXT + N1
      NSTART = NTEXT
      TEXT(NTEXT) = 'Review analysis so far'
      IF (SUPPLY(1)) THEN
         NTEXT = NTEXT + 1
         TEXT(NTEXT) = 'View the current data set 1'
      ENDIF
      IF (SUPPLY(2)) THEN
         NTEXT = NTEXT + 1
         TEXT(NTEXT) = 'View the current data set 2'
      ENDIF
      NTEXT = NTEXT + N1
      TEXT(NTEXT) = 'Run the program again'
      NTEXT = NTEXT + N1
      TEXT(NTEXT) = 'Quit ... Exit program'//BLANK//PNAME
C
C The main loop
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         NUMDEC = N1
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT, 
     +                BORDER, FLASH, HIGH)
         IF (NUMDEC.EQ.N1) THEN
            CALL REVPRO (NOUT)
         ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
            ABORT = .TRUE.
            REPEET = .FALSE.   
         ELSEIF (SUPPLY(1) .AND. SUPPLY(2)) THEN
            IF (NUMDEC.EQ.N2) THEN
               CALL VIEWER (ISEND, 
     +                      DNAME1, BLANK, BLANK)
            ELSE
               CALL VIEWER (ISEND, 
     +                      DNAME2, BLANK, BLANK)
            ENDIF 
         ELSEIF (SUPPLY(1)) THEN 
            CALL VIEWER (ISEND, 
     +                   DNAME1, BLANK, BLANK)
         ELSE
            CALL VIEWER (ISEND, 
     +                   DNAME2, BLANK, BLANK)
         ENDIF
      ENDDO
C
C Format statement
C      
  100 FORMAT ('Program',1X,A,1X,'has completed the analysis')
      END
C
C
