c
c
      subroutine suprc1 (isend, ncmax, ncol, nrmax, nrow,
     +                   a,
     +                   title)
c
c action: suppress rows and columns in a matrix
c author: w.g.bardsley, university of manchester, u.k., 07/06/2005
c         28/02/2007 added intents
c
c         Note: all temporary variables are declared and dimensioned locally
c               and ncol and nrow are both returned as 1 if user suppresses
c               all the corresponding items.
c
c         isend: (input/unchanged) program options as follows
c                 isend = 1: rows only
c                 isend = 2: columns only
c                 isend = 3: rows and columns
c         ncmax: (input/unchanged) dimension
c          ncol: (input/output) ncol is input as the starting dimension
c                               but may be returned as a lower value if
c                               any rows have been suppressed
c         nrmax: (input/unchanged) dimension
c          nrow: (input/output) nrow is input as the starting dimension
c                               but may be returned as a lower value if
c                               any columns have been suppressed
c             a: (input/output) input as the starting matrix then output
c                               after editing
c         title: (input/output) changed if editing has taken place
c
c
      implicit   none
c
c arguments
c
      integer,             intent (in)    :: isend, ncmax, nrmax  
      integer,             intent (inout) :: ncol, nrow
      double precision,    intent (inout) :: a(nrmax,ncmax)
      character (len = *), intent (inout) :: title
c
c locals
c
      integer    i, iadd1, j, jadd1, kcol, krow
      integer    nstart, nedit
      integer    ncbig, nrbig
      parameter (ncbig = 100, nrbig = 10000)
      integer    icolor, ix, iy, lshade, numtxt
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1, numtxt = 20)
      integer    numbld(numtxt)
      integer    numdec, numopt
      parameter (numopt = 7)
      integer    nout, nmax, ntype
      parameter (nout = 4, nmax = 1000, ntype = 3)
      double precision atemp(nrbig,ncbig)
      character  cipher(2)*10, line*100, text(30)*100
      character  title1*80, title2*80, labels(nrbig)*6
      character  blank*1, notav*4
      parameter (blank = ' ', notav = '[NA]')
      logical    cols_in(ncbig), rows_in(nrbig)
      logical    repeet
      logical    border, fileit
      parameter (border = .false., fileit = .false.)
      external   putfat, listbx, dsplay, chkbox, patch1, getstr, getjm1
      intrinsic  max, min
      data       numbld / numtxt*0 /
c
c check
c
      if (isend.lt.1 .or. isend.gt.3) then
         write (line,100)
         call putfat (line)
         return
      endif
      if (ncol.lt.1 .or. ncol.gt.ncmax .or. ncol.gt.ncbig) then
         write (line,200)
         call putfat (line)
         return
      endif
      if (nrow.lt.1 .or. nrow.gt.nrmax .or. nrow.gt.nrbig) then
         write (line,300)
         call putfat (line)
         return
      endif
c
c initialise
c
      kcol = ncol
      krow = nrow
      do i = 1, ncol
         cols_in(i) = .true.
      enddo
      do i = 1, nrow
         rows_in(i) = .true.
      enddo
      if (isend.eq.1) then
         cipher(1) = blank
         cipher(2) = notav
      elseif (isend.eq.2) then
         cipher(1) = notav
         cipher(2) = blank
      else
         cipher(1) = blank
         cipher(2) = blank
      endif
      do j = 1, ncol
         do i = 1, nrow
            atemp(i,j) = a(i,j)
         enddo
      enddo
      do i = 1, max(ncol, nrow)
         write (labels(i),'(i6)') i
      enddo
      title1 = 'Edited matrix'
c
c main loop
c
      repeet = .true.
      do while (repeet)
         write (text,400) nrow - krow, cipher(1),
     +                    ncol - kcol, cipher(2),
     +                    nrow, ncol, krow, kcol
         numdec = numopt - 2
         call listbx (numdec, numopt,
     +                text)
         if (numdec.eq.1) then
c
c suppress/restore rows
c
            if (cipher(1).eq.notav) then
               write (line,500)
               call putfat (line)
            else
               if (nrow.le.nmax) then
                  title2 = 'Select the rows required'
                  call chkbox (nrow,
     +                         labels, title2,
     +                         rows_in)
               else
                  title2 = 'Choose the starting row'
                  i = 1
                  j = nrow - 1
                  call getjm1 (i, nstart, j,
     +                         title2)
                  nedit = min(nrow - nstart + 1, nmax)
                  title2 = 'Select the rows required'
                  call chkbox (nedit,
     +                         labels(nstart), title2,
     +                         rows_in)
               endif
               iadd1 = 0
               do i = 1, nrow
                  if (rows_in(i)) then
                     iadd1 = iadd1 + 1
                     jadd1 = 0
                     do j = 1, ncol
                        if (cols_in(j)) then
                           jadd1 = jadd1 + 1
                           atemp(iadd1,jadd1) = a(i,j)
                        endif
                     enddo
                  endif
               enddo
               krow = iadd1
               if (krow.eq.0) then
                  krow = 1
                  rows_in(1) = .true.
               endif
            endif
         elseif (numdec.eq.2) then
c
c suppress/restore columns
c
            if (cipher(2).eq.notav) then
               write (line,500)
               call putfat (line)
            else
               title2 = 'Select columns required'
               call chkbox (ncol,
     +                      labels, title2,
     +                      cols_in)
               iadd1 = 0
               do i = 1, nrow
                  if (rows_in(i)) then
                     iadd1 = iadd1 + 1
                     jadd1 = 0
                     do j = 1, ncol
                        if (cols_in(j)) then
                           jadd1 = jadd1 + 1
                           atemp(iadd1,jadd1) = a(i,j)
                        endif
                     enddo
                  endif
               enddo
               kcol = jadd1
               if (kcol.eq.0) then
                  kcol = 1
                  cols_in(1) = .true.
               endif
            endif
         elseif (numdec.eq.3) then
c
c view old
c
             call dsplay (ncmax, ncol, nout, nrmax, nrow, ntype,
     +                    a,
     +                    title,
     +                    fileit)
         elseif (numdec.eq.4) then
c
c view new
c
             call dsplay (ncbig, kcol, nout, nrbig, krow, ntype,
     +                    atemp,
     +                    title1,
     +                    fileit)

         elseif (numdec.eq.numopt - 2) then
c
c help
c
            write (text,600)
            numbld(1) = 1
            numbld(12) = 1
            numbld(17) = 1
            call patch1 (icolor, ix, iy, lshade, numbld, numtxt,
     +                   text,
     +                   border)
            numbld(1) = 0
            numbld(12) = 0
            numbld(17) = 0
         elseif (numdec.eq.numopt - 1) then
c
c apply changes
c
            if (kcol.lt.ncol .or. krow.lt.nrow) then
               write (line,700)
               call getstr (line, title)
               ncol = kcol
               nrow = krow
               do j = 1, kcol
                  do i = 1, krow
                     a(i,j) = atemp(i,j)
                  enddo
               enddo
            endif
            repeet = .false.
         else
c
c no changes
c
            repeet = .false.
         endif
      enddo      
c
c format statements
c      
  100 format ('ISEND out of range in call to SUPRC1')
  200 format ('NCOL or NCMAX out of range in call to SUPRC1')
  300 format ('NROW or NRMAX out of range in call to SUPRC1')
  400 format (
     + 'Suppress/Restore rows: no. suppressed =',i4,1x,a
     +/'Suppress/Restore cols: no. suppressed =',i4,1x,a
     +/'View original matrix: dimensions',i5,' by',i4
     +/'View edited matrix: dimensions',i5,' by',i4
     +/'Help'
     +/'Apply ... use edited matrix'
     +/'Cancel ... use original matrix')
  500 format ('Option not available in current mode')
  600 format (
     + 'Suppressing rows (i.e. cases) and columns (i.e. variables)'
     +/'In multivariate analysis it is often only required to analyse'
     +/'a sub-set from a main data set, say suppressing selected cases'
     +/'or variables. So, if it is not necessary to use a complete data'
     +/'set, you can select which rows and columns to include. You just'
     +/'decide which rows and columns to retain, and analysis will then'
     +/'proceed with the smaller edited matrix but with no changes made'
     +/'to the original larger matrix. However there are restrictions,'
     +/'for instance the new data set must contain at least one row and'
     +/'one column, and there may be other considerations as follows.'
     +/
     +/'Restrictions on columns'
     +/'If columns have specific meanings, e.g. curve fitting or plots,'
     +/'then no columns can be suppressed. Note that it may be best to'
     +/'suppress columns interactively in multivariate analysis.'
     +/
     +/'Restrictions on rows'
     +/'Sometimes the rows come in pairs, e.g. in meta analysis where'
     +/'adjacent rows represent 2 by 2 contingency tables, so both rows'
     +/'must be suppressed in corresponding pairs.')
  700 format ('Choose a new title for the edited matrix')
      end
c
c
