c
c
      subroutine symcfg (isend, jcolor, kcolor, l, m, n,
     +                   sizes, thick)
c
c action: interface to configure colours/lines/symbols using w_symbols
c author: w.g.bardsley, university of manchester, u.k., 14/02/2011
c         05/07/2014 added data statements to make sure values are saved, i.e. always defined
c
c  isend: isend = 1 ... retrieve current defaults   ... return new values
c         isend = 2 ... edit defaults interactively ... return new values
c         isend = 3 ... restore built-in defaults   ... return new values
c         isend = 4 ... over-write current defaults ... use values supplied
c jcolor: symbol colours
c kcolor: feature colours
c      l: line styles
c      m: symbol styles
c      n: dimension 
c  sizes: symbol sizes
c  thick: line thicknesses           
c 
c
      implicit none
c
c arguments
c      
      integer,          intent (in)    :: isend, n
      integer,          intent (inout) :: jcolor(n), kcolor(n),
     +                                    l(n), m(n)
      double precision, intent (inout) :: sizes(n), thick(n)
c
c locals
c      
      integer    i
      integer    jsend, nmax
      parameter (jsend = 1, nmax = 20)
      integer    jcolor_1(nmax), kcolor_1(nmax), l_1(nmax), m_1(nmax)
      double precision sizes_1(nmax), thick_1(nmax)
      double precision one
      parameter (one = 1.0d+00)
      character  line*100
      external   x_putfat, w_symbol 
c
c next parameters must equal those in w_symbol
c
      data       jcolor_1 /  0,  4,  1,  2,  3,  5,  6,  9, 10, 11, 
     +                      14, 12, 13,  7,  8, 28, 39, 40, 44, 48 /
      data       kcolor_1 /  4,  0,  0,  1,  1, 22, 22, 15,  4,  0,
     +                       0,  0,  0,  0,  0,  0,  0,  0,  0,  0 /
      data            l_1 /  1,  2,  3,  1,  2,  3,  1,  2,  3,  1,
     +                       2,  3,  1,  2,  3,  1,  2,  3,  1,  2  /
      data            m_1 /  5,  8, 11, 14,  34, 6,  9, 12, 15, 35, 
     +                       7, 10, 13, 16, 37, 18, 19,  1,  2,  3  /
      data        sizes_1 / nmax*one /
      data        thick_1 / nmax*one /
c
c check isend
c      
      if (isend.lt.1 .or. isend.gt.4) then
         write (line,100)
         call x_putfat (line)
         return
      endif         
c
c check n
c      
      if (n.lt.1 .or. n.gt.nmax) then
         write (line,200) nmax
         call x_putfat (line)
         return
      endif
c
c retrieve current defaults using jsend = 1
c         
      call w_symbol (jsend, jcolor_1, kcolor_1, l_1, m_1, 
     +               sizes_1, thick_1)
      if (isend.eq.1) then 
c
c isend = 1: return current defaults
c        
         do i = 1, n
            jcolor(i) = jcolor_1(i)
            kcolor(i) = kcolor_1(i)
            l(i) = l_1(i)
            m(i) = m_1(i)
            sizes(i) = sizes_1(i)
            thick(i) = thick_1(i)
         enddo 
      elseif (isend.eq.2 .or. isend.eq.3) then
c
c isend = 2: interactive editing
c isend = 3: install built-in defaults
c      
         call w_symbol (isend, jcolor_1, kcolor_1, l_1, m_1,
     +                  sizes_1, thick_1) 
         do i = 1, n
            jcolor(i) = jcolor_1(i)
            kcolor(i) = kcolor_1(i)
            l(i) = l_1(i)
            m(i) = m_1(i)
            sizes(i) = sizes_1(i)
            thick(i) = thick_1(i)
         enddo  
      elseif (isend.eq.4) then
c
c isend = 4: install new defaults
c      
         do i = 1, n
            jcolor_1(i) = jcolor(i)
            kcolor_1(i) = kcolor(i)
            l_1(i) = l(i)
            m_1(i) = m(i)
            sizes_1(i) = sizes(i)
            thick_1(i) = thick(i)
         enddo 
         call w_symbol (isend, jcolor_1, kcolor_1, l_1, m_1,
     +                  sizes_1, thick_1)  
      endif 
c
c format statement
c          
  100 format ('ISEND out of range (1,4) in call to SYMCFG')
  200 format ('N out of range (1,',i2,') in call to SYMCFG')        
      end
c
c 