c
c
      subroutine table1 (icolor,
     +                   strng)
c
c action: call w_table1
c author: w.g.bardsley, university of manchester, u.k., 15/04/2010
c         24/04/2012 changed .le. to .lt. at check for bogus 'CLOSE'  
c         08/06/2012 added temp, triml, ucase1 
c         29/12/2016 added iwarnu to control warnings 
c
c This version is protected to prevent bogus calls to w_table1 as follows:
c icount < 0: waiting to be opened
c icount = 0: first genuine call
c icount > 0: subsequent genuine calls 
c
      implicit none
c
c arguments
c
      integer,             intent (in) :: icolor
      character (len = *), intent (in) :: strng
c
c locals
c    
      integer    icount, icolor_sav, ierr 
      character (len = 129) temp  
      character (len = 1  ) blank
      parameter (blank = ' ')
      logical    iwarnu
      save       icount, icolor_sav
      data       icount, icolor_sav / -1, 15 /
      external   triml1, ucase1
      external   w_table1
c
c switch error reporting on/off
c
      iwarnu = .false.
c
c check for 'OPEN' or 'CLOSE'
c      
      temp = strng
      if (temp.ne.blank) then
         call triml1 (temp)
         call ucase1 (temp)
      endif   
c
c deal with the three distinct cases 'OPEN', 'CLOSE', or neither 
c      
      if (temp.eq.'OPEN') then
         if (icount.lt.0) then
c
c a genuine call to open w_table1 so set icount = 0 and save icolor_sav
c           
            icount = 0
            icolor_sav = icolor
         else
c
c a bogus call to open w_table1 which is already open
c           
            if (iwarnu) then
               ierr = 1
               write (temp,100) ierr, 'Table already opened'
               write (*,'(a)') temp
            endif   
            return
         endif
      elseif (temp.eq.'CLOSE') then
         if (icount.lt.0) then
c
c a bogus call to close w_table1 which is already closed 
c           
            if (iwarnu) then
               ierr = 2
               write (temp,100) ierr, 'Table already closed'
               write (*,'(a)') temp
            endif   
            return
         else
c
c a genuine call to close w_table1 so set icount = -1
c           
            icount = -1
            call w_table1 (icolor, 'CLOSE')
         endif      
      else
         if (icount.lt.0) then
c
c a bogus call to write to an unopened window
c           
            if (iwarnu) then
               ierr = 3
               write (temp,100) ierr, strng
               write (*,'(a)') temp
            endif    
            icount = 1
            call w_table1 (icolor_sav, 'OPEN')
         elseif (icount.eq.0) then
c
c called with the first character string for w_table1 so set icount = 1
c         
            icount = 1
            call w_table1 (icolor_sav, 'OPEN')
         endif       
                         
c
c pass subsequent arguments on to w_table1
c           
         call w_table1 (icolor, strng)
      endif
c
c format stsatement 
c      
  100 format ('Error',i2,' in call to TABLE1',1X,A)      
      end
c
c                       
                   