C
C
      SUBROUTINE TABLE4 (ICOLOR, N,
     +                   X,
     +                   STRNG_OLD)
C
C ACTION : Output a table of calculations to the screen
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 7/11/95
C          05/04/1997 Temporary version calling w_linein
C          21/05/1997 Edited to remove w_dbleup and call linein directly
C          07/10/1997 Added GETRG3
C          16/11/1998 Completely revised to call I/O functions directly and
C                     to use w_output for output tables
C          18/11/2006 changed IY to be consistent with W_OUTPUT  
C          28/06/2022 increased nlines from 20 to 21 and nwide from 80 to 90 to allow wider lines and
C                     a header title to be output by calling immediately after the call with 'OPEN'
C                     without changing the simfit code that assumes a maximum of 20 lines
C
C          NLINES and NWIDE must be consistent with the length and depth of
C          the %cw in w_output
C
C    ICOLOR: (input/unchanged) colour
C         N: (input/output) defaults then results ... integers
C         X: (input/output) defaults then results ... double precisions
C STRNG_OLD: (input/unchanged) message/control string 
C 
C Usage of these arguments as follows:
C
C          ICOLOR is not used in this version
C          ==================================
C
C          Use N and X for input/ouput functions as follows:-
C          ===================================================
C          GETI01: N(1) = IMID
C          GETIL1: N(1) = IBOT, N(2) = IMID, N(3) = ITOP
C          GETIM1: N(1) = IBOT, N(2) = IMID, N(3) = ITOP
C          GETRG3: X(1) = X, X(2) = Y, X(3) = Z Z>= Y >= X
C          GETRL1: X(1) = XBOT, X(2) = XMID, X(3) = XTOP
C          GETRM1: X(1) = XBOT, X(2) = XMID, X(3) = XTOP
C          GETR01: X(1) = X
C
C          Open/Close using
C          ================
C          STRNG = 'OPEN': start table
C          STRNG = 'CLOSE: close table
C          STRNG = 'CLOSE (NO PROMPT)': close table witth no prompt
C          STRNG = '****': output STRING
C
C          Defining the function
C          =====================
C          This version must be called twice in succession to use
C          one of the input/output functions. The first time READY
C          is set .TRUE. and the function is identified. The second
C          time the function is called.
C          1) STRNG = SRNAME
C          2) STRNG = argument to primitive
C
      IMPLICIT   NONE   
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ICOLOR
      INTEGER,             INTENT (INOUT) :: N(*)
      DOUBLE PRECISION,    INTENT (INOUT) :: X(*) 
      CHARACTER (LEN = *), INTENT (IN)    :: STRNG_OLD
C
C Locals
C      
      INTEGER    ICOUNT
      INTEGER    IX, IY, NLINES, NWIDE, N0
      PARAMETER (IX = 4, IY = 4, NLINES = 21, NWIDE = 90, N0 = 0)
      CHARACTER  STRNG*129
      CHARACTER  SRNAME*20
      CHARACTER  LINE*(NWIDE)
      CHARACTER  TEMP*(NWIDE)
      LOGICAL    READY
      EXTERNAL   TRIML1, UCASE1, PUTADV
      EXTERNAL   GETI01, GETIL1, GETIM1, GETR01, GETRL1, GETRM1, GETRG3
      EXTERNAL   W_OUTPUT
      SAVE       ICOUNT, READY, SRNAME
      STRNG = STRNG_OLD
      TEMP = STRNG(1:NWIDE)
      CALL TRIML1 (TEMP)
      CALL UCASE1 (TEMP)
      IF (TEMP.EQ.'OPEN') THEN
C
C Open the table
C
         ICOUNT = ICOLOR!to silence FTN95
         CALL W_OUTPUT (IX, IY,
     +                  TEMP)
         ICOUNT = N0
         READY = .FALSE.
      ELSEIF (TEMP.EQ.'CLOSE') THEN
C
C Close the table
C
         CALL PUTADV ('Analysis is completed')
         CALL W_OUTPUT (IX, IY,
     +                  TEMP)
      ELSEIF (TEMP.EQ.'CLOSE (NO PROMPT)') THEN
C
C Close the table
C
         TEMP = 'CLOSE'
         CALL W_OUTPUT (IX, IY,
     +                  TEMP)
      ELSEIF (TEMP.EQ.'GETIL1' .OR.
     +        TEMP.EQ.'GETIM1' .OR.
     +        TEMP.EQ.'GETI01' .OR.
     +        TEMP.EQ.'GETRG3' .OR.
     +        TEMP.EQ.'GETRL1' .OR.
     +        TEMP.EQ.'GETRM1' .OR.
     +        TEMP.EQ.'GETR01') THEN
C
C Store input functions GETIL1, GETIM1, GETI01, GETRG3, GETRL1, GETRM1, GETR01
C
         READY = .TRUE.
         SRNAME = STRNG(1:20)
      ELSEIF (READY) THEN
C
C Set READY = .FALSE. then call the input functions
C
         READY = .FALSE.
         LINE = STRNG(1:NWIDE)
         IF (SRNAME.EQ.'GETI01') THEN
            CALL GETI01 (N(1), 
     +                   LINE)
         ELSEIF (SRNAME.EQ.'GETIL1') THEN
            CALL GETIL1 (N(1), N(2), N(3),
     +                   LINE)
         ELSEIF (SRNAME.EQ.'GETIM1') THEN
            CALL GETIM1 (N(1), N(2), N(3),
     +                   LINE)
         ELSEIF (SRNAME.EQ.'GETR01') THEN
            CALL GETR01 (X(1),
     +                   LINE)
         ELSEIF (SRNAME.EQ.'GETRL1') THEN
            CALL GETRL1 (X(1), X(2), X(3),
     +                   LINE)
         ELSEIF (SRNAME.EQ.'GETRM1') THEN
            CALL GETRM1 (X(1), X(2), X(3),
     +                   LINE)
         ELSEIF (SRNAME.EQ.'GETRG3') THEN
            CALL GETRG3 (X(1), X(2), X(3),
     +                   LINE)
         ENDIF
      ELSE
C
C Construct the output table
C
         ICOUNT = ICOUNT + 1
         IF (ICOUNT.LE.NLINES) CALL W_OUTPUT (IX, IY, 
     +                                        STRNG)
      ENDIF
      END
C
C
