C
C
      SUBROUTINE TBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                   NUMOPT, NUMPOS, NSTART, NTEXT,
     +                   TEXT,
     +                   TAB_BOT, TAB_MID, TAB_TOP)
C
C ACTION : Get a decision from a tabbed list box
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 09/09/99
C          06/12/2000 now calls LVIEW1 but if there are no grave accents
C                     it calls lbox01
C          02/04/2004 now calls LVIEW3 if there are any colour changes
C                     TAB_BOT, TAB_MID, TAB_TOP are not used in this version
C          28/02/2007 added INTENTS and ALLOCATABLE
C          05/03/2012 added error messages
C
      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ICOLOR, IXL, IYL, LSHADE,
     +                                       NUMOPT, NSTART, NTEXT 
      INTEGER,             INTENT (INOUT) :: NUMDEC
      INTEGER,             INTENT (IN)    :: NUMBLD(NTEXT),
     +                                       NUMPOS(NUMOPT) 
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT(NTEXT) 
      LOGICAL,             INTENT (IN)    :: TAB_BOT, TAB_MID, TAB_TOP
C
C local allocatable array
C       
      CHARACTER (LEN = 100), ALLOCATABLE :: TEXT_NEW(:)
C
C Locals
C      
      INTEGER    I, IADD1, IERR, NGRAVE, NTEXT_NEW
      INTEGER    NMAX
      CHARACTER  GRAVE*1
      PARAMETER (GRAVE = '`')
      LOGICAL    TITLES
      PARAMETER (TITLES = .FALSE.)
      EXTERNAL   LVIEW1, LBOX01, LVIEW3, PUTFAT
      INTRINSIC  INDEX, MIN  
      IF (NSTART.LT.1) THEN
         CALL PUTFAT ('NSTART < 1 in call to TBOX01')
         RETURN
      ENDIF
      IF (NTEXT.LT.1) THEN
         CALL PUTFAT ('NTEXT < 1 in call to TBOX01')
         RETURN
      ENDIF
      IF (NUMOPT.LT.1) THEN
         CALL PUTFAT ('NUMOPT < 1 in call to TBOX01')
         RETURN   
      ENDIF   
      IF (NSTART + NUMOPT - 1.GT.NTEXT) THEN
         CALL PUTFAT ('NSTART + NUMOPT - 1 > NUMTXT in call to TBOX01')
         RETURN
      ENDIF
      IF (NUMDEC.LT.1 .OR. NUMDEC.GT.NUMOPT) THEN
         CALL PUTFAT ('NUMDEC out of range in call to TBOX01')
         NUMDEC = NUMOPT
         RETURN
      ENDIF        
      IF (NUMOPT.EQ.1) THEN
         NUMDEC = 1
         RETURN
      ENDIF           
C
C Allocate
C      
      IERR = 0
      IF (ALLOCATED(TEXT_NEW)) DEALLOCATE(TEXT_NEW, STAT = IERR)
      IF (IERR.NE.0) RETURN 
      NMAX = NTEXT + 1  
      ALLOCATE (TEXT_NEW(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN   
C
C Initialise
C      
      IF (TAB_BOT) NGRAVE = 0!to silence ftn95
      IF (TAB_MID) NGRAVE = 0!to silence ftn95
      IF (TAB_TOP) NGRAVE = 0!to silence ftn95
      NGRAVE = 0
      DO I = NSTART, NSTART + NUMOPT - 1  
         IF (NGRAVE.EQ.0) THEN
            IF (INDEX(TEXT(I),GRAVE).GT.0) NGRAVE = NGRAVE + 1
         ENDIF   
      ENDDO
      NTEXT_NEW = MIN(NMAX,NTEXT)
      DO I = 1, NTEXT_NEW
         TEXT_NEW(I) = TEXT(I)
      ENDDO   
C
C Call the appropriate interface
C      
      IF (NGRAVE.GT.0) THEN
         IADD1 = 0
         DO I = 1, NTEXT
            IF (NUMBLD(I).NE.0) IADD1 = IADD1 + 1
         ENDDO
         IF (IADD1.EQ.0) THEN
C
C There are tabs but no font changes so call lview1
C           
            CALL LVIEW1 (IXL, IYL, NUMDEC, NUMOPT, NSTART, NTEXT_NEW,
     +                   TEXT_NEW,
     +                   TITLES)
         ELSE
C
C There are tabs and font changes so call lview3
C           
            CALL LVIEW3 (IXL, IYL, NUMBLD, NUMDEC, NUMOPT, NSTART,
     +                   NTEXT_NEW,
     +                   TEXT_NEW,
     +                   TITLES)
         ENDIF
      ELSE
C
C There are no tabs so call lbox01
C        
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                NUMOPT, NUMPOS, NSTART, NTEXT_NEW,
     +                TEXT,
     +                TITLES, TITLES, TITLES)
      ENDIF 
      DEALLOCATE (TEXT_NEW, STAT = IERR)
      END
C
C
