C
C
      SUBROUTINE TESTER (A, M, N, RTOL)
C
C ACTION : Make sure error in Y  > = 0.0
C          N = 1, analyse single data point number M
C          N > 1, analyse error values from 1 to N
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          16/02/1997 Win32 version 
C          28/02/2007 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: M, N 
      DOUBLE PRECISION, INTENT (IN)    :: RTOL  
      DOUBLE PRECISION, INTENT (INOUT) :: A(N)
C
C Locals
C      
      INTEGER    I, J
      INTEGER    N1
      PARAMETER (N1 = 1)
      CHARACTER  LINE*100, VALUE*6
      LOGICAL    NGT1
      EXTERNAL   GETRGE, PUTFAT, TRIML1
      IF (N.LT.N1 .OR. N.EQ.N1 .AND. M.LT.N1) THEN
         CALL PUTFAT ('Error in call to TESTER')
         RETURN
      ENDIF
      IF (N.EQ.N1) THEN
         NGT1 = .FALSE.
      ELSE
         NGT1 = .TRUE.
      ENDIF
      DO I = N1, N
         IF (A(I).LT.RTOL) THEN
            CALL PUTFAT ('s value too small')
            IF (NGT1) THEN
               J = I
            ELSE
               J = M
            ENDIF
            WRITE (VALUE,'(I6)') J
            CALL TRIML1 (VALUE)
            WRITE (LINE,100) VALUE
            CALL GETRGE (A(I), RTOL, LINE)
         ENDIF
      ENDDO
  100 FORMAT ('The s-value required at line ',A,'(...must be > 0)')
      END
C
C
