c
c
      subroutine tfileq (line)
c
c action: Query and advice about test file and data format required
c author: w.g.bardsley, university of manchester, u.k., 28/04/2011
c         31/08/2015 revised and added call to switch
c
c line should be something like ... Now input a file formatted like mmfit.tf4 
c
      implicit none
c
c argument
c
      character (len = *) :: line
c
c locals
c
      integer    n_speed
      parameter (n_speed = 33)
      integer    ios, k, l, len200, n, numdec
      integer    icolor, isend, numhdr, numopt
      parameter (icolor = 7, isend = 1, numhdr = 20, numopt = 3)
      integer    numbld(numhdr), numpos(numopt)
      character (len = 1) blank
      parameter (blank = ' ') 
      character (len = 15) tfile
      character (len = 10) option(3)
      character (len = 100) header(30)
      character (len = 1024) sim256, path
      logical    op, repeet, there
      external   len200, sim256, title2, viewer
      external   switch
      data       numbld / 20*0 /
      data       numpos / 3*1 /
c
c get the length of line and check it looks reasonable
c
      k = len200(line)
      if (k.lt.15) return
c
c extract the final filename
c
      do l = k, 1, -1
         n = l
         if (line(n:n).eq.blank) then
            tfile = line(n + 1:k)
            path = sim256(tfile)
            exit
         endif
      enddo
c
c make sure the test file can be located
c
      inquire (file = path, exist = there, opened = op, iostat = ios)
      if (ios.ne.0 .or. op .or. .not.there) return
c
c prepare the main page
c
      write (header,100) tfile
      header(numhdr) = line
      write (option,200) 
c
c now loop to view or proceed
c
      numbld(1) = 4
      numbld(3) = 2
      numbld(15) = 1
      numbld(numhdr) = 1
      numdec = 1 
      repeet = .true.
      do while (repeet)
         call title2 (icolor, numbld, numdec, numhdr, numopt, numpos,
     +                header, option)
         if (numdec.eq.1) then
            call viewer (isend,
     +                   path, blank, blank) 
                   
         elseif (numdec.eq.2) then  
            repeet = .false.
         else
            call switch (n_speed)
            repeet = .false.    
         endif   
      enddo  
c
c format statements
c
  100 format (
     + 'Advice about the data format required for this analysis'
     +/
     +/'To switch this advice on/off use the Simfit [Speedup] option.'
     +/
     +/'The procedure requested needs a rectangular data table to be'
     +/'provided by one of the following techniques.'
     +/
     +/'1.`Pasted in from the clipboard'
     +/'2.`Imported as a spread sheet export file'         
     +/'3.`Imported as a Simfit data file'
     +/'4.`Typed in from the terminal (not always available)' 
     +/
     +/'To appreciate the format required you can view the test file'
     +/
     +/a
     +/
     +/'now, or input your own data. To speed up Simfit you can'
     +/'suppress this advice and proceed directly to data input.'
     +/
     +/)
  200 format (
     + 'View'
     +/'Input data'
     +/'Suppress')    
      end
c
c
           