c
c----------------------------------------------------------------------------------------------------
c
c Advice: the token* routines are designed to extract integers or doubles from a text string
c         given a symbol to be used as a separator. It is really intended that the symbol should be a
c         blank but the routines will also then call the pre-processor routine tokenp to deal with colons,
c         commas, semicolons and tabs. Commas and semicolons seem to be ok but not colons and tabs.
c         The routines have only been fully tested for the case symbol = blank 
c
c tokenx: edits typical *.tf test file data lines
c  subroutine tokenx (line_in, line_out)  
c
c token0: returns the start/stop positions in a string delineated by a symbol
c      subroutine token0 (icount, nmax, nstart, nstop, 
c     +                   line, symbol)
c
c tokenp: replaces colons, commas, semicolons, and tabs in a string if preceded by an integer 
c     subroutine tokenp (line_in, line_out)
c
c token1: returns number of integers in a string and the start positions 
c     subroutine token1 (nmax, npi, numint, nvalue,   
c    +                   line, symbol)
c     if symbol = blank it first calls tokenp then token0 o/w it calls token0 directly 
c  
c token2: returns number of doubles in a string and the start positions 
c     subroutine token2 (nmax, npd, nstop, numval,
c    +                   dvalue,   
c    +                   line, symbol)
c     if symbol = blank it first calls tokenp then token0 o/w it calls token0 directly 
c
c---------------------------------------------------------------------------------------
c
      subroutine tokenx (line_in, line_out)
c
c action: transform line_in to line_out where line_in is a simfit test file line of data
c author: w.g.bardsley, university of manchester, u.k., 26/01/2022
c
         
c
c arguments
c        
      character (len = *), intent (in)  :: line_in
      character (len = *), intent (out) :: line_out 
c
c locals
c 
      integer    i, icount, ios, istart, itemp, j, k
      integer    nmax
      parameter (nmax = 1024)
      integer    nstart(nmax), nstop(nmax) 
      double precision dtemp
      character (len = nmax) new_line
      character (len = 14  ) word14
      character (len = 13  ) word13, showrj
      character (len = 2   ) eplus, eminus, word2
      parameter (eplus = 'E+', eminus = 'E-')
      character (len = 1   ) blank, letter
      parameter (blank = ' ')
      logical    ok(nmax)
      external   showrj
      external   tokenp, ucase1, token0
      intrinsic  len_trim, index
c
c initialise
c     
      do i = 1, nmax
         ok(i) = .true.
      enddo      
      call tokenp (line_in, line_out)
      k = len_trim(line_out)
      call ucase1 (line_out(1:k)) 
c
c find potential exponentials
c      
      do i = 1, k - 1
        word2 = line_out(i:i + 1)
        if (word2.eq.eplus .or.
     +      word2.eq.eminus) then
            ok(i) = .false.
         endif     
      enddo
c
c edit line_out
c      
      do i = 1, k
         if (ok(i)) then
            letter = line_out(i:i)
            if (letter.ne.'0' .and.
     +          letter.ne.'1' .and.    
     +          letter.ne.'2' .and.    
     +          letter.ne.'3' .and.    
     +          letter.ne.'4' .and.    
     +          letter.ne.'5' .and.    
     +          letter.ne.'6' .and.    
     +          letter.ne.'7' .and.    
     +          letter.ne.'8' .and.  
     +          letter.ne.'9' .and.      
     +          letter.ne.'.' .and.    
     +          letter.ne.'+' .and.    
     +          letter.ne.'-') then    
                   line_out (i:i) = blank
            endif
         endif
      enddo 
      call token0 (icount, nmax, nstart, nstop, 
     +             line_out, blank)
      istart = 1
      new_line = blank
      do i = 1, icount
         j = nstart(i)
         k = nstop(i) 
         read (line_out(j:k),*,iostat=ios) itemp
         if (ios.eq.0) then
            write (word14,'(i14)') itemp
         else
            read (line_out(j:k),*,iostat=ios) dtemp
            if (ios.eq.0) then
               word13 = showrj(dtemp)
               word14 = blank//word13
            endif
         endif
         new_line(istart:istart + 13) = word14
         istart = istart + 14          
      enddo  
      line_out = new_line
      end
c
c     

c
c----------------------------------------------------------------------------------------
c
      subroutine token0 (icount, nmax, nstart, nstop, 
     +                   line, symbol)
c
c action: supply a character string (line) and cipher (symbol)
c         then return all sub-strings delineated by the cipher 
c         It is recommended to use symbol = ' ' as other possibilities have not been tested
c author: w.g.bardsley, university of manchester, u.k., 23/01/2022
c 
c icount: the number of substrings found
c   nmax: dimension for maximum number of sub-strings    
c nstart: starting point for sub-strings
c  nstop: stopping point for sub-strings
c symbol: cipher, e.g, blank, comma, semi-colon
c   line: string to be analysed
c

c arguments
c
      integer, intent (in)                :: nmax
      integer, intent (out)               :: icount, nstart(nmax),
     +                                       nstop(nmax)
      character (len = *), intent (in)    :: line, symbol
c      
c locals
c       
      integer i, k
      character (len = 1024) line_copy
      character (len = 1   ) blank, letter, no, yes
      parameter (blank = ' ', no = 'N', yes = 'Y')
      external  putadv
      intrinsic len_trim
c
c chaek nmax then initialise line_copy, nstart, nstop and icount
c     
      if (nmax.lt.1) then
         call putadv ('TOKEN00 called with NMAX < 1')
         return
      endif
      if (nmax.gt.1024) then
         call putadv ('TOKEN00 caled with NMAX > 1024')
         return
      endif       
      line_copy = blank
      icount = 0
      do i = 1, nmax
         nstart(i) = 0
         nstop(i) = 0
      enddo
c
c fill in line copy using 'Y' and 'N' to delineate sections of line to allow 
c for possible future developments involving possible multiple symbols, etc.
c      
      k = len_trim(line)  
      if (k.eq.1) then
c
c deal with k = 1 as a special case
c        
         if (line(1:1).ne.symbol) then
            icount = 1
            nstart(1) = 1
            nstop(1) = 1
         endif       
         return
      endif 
c
c fill-in line_copy to make the token(s) easily identified in case symbol becomes an array
c          
      do i = 1, k
         letter = line(i:i)
         if (letter.eq.symbol) then
            line_copy(i:i) = no
         else    
            line_copy(i:i) = yes
         endif
      enddo 
      do i = 1, k
         letter = line_copy(i:i)
         if (i.eq.1) then
c
c check the first letter
c           
            if (letter.eq.yes) then
               icount = icount + 1
               nstart(icount) = 1 
               letter = line_copy(2:2)
               if (letter.eq.no) nstop(icount) = 1
           endif
         elseif (i.eq.k) then
c
c check the last letter
c         
            if (letter.eq.yes) then
               letter = line_copy(i - 1:i - 1)
               if (letter.eq.no) then
                  icount = icount + 1
                  nstart(icount) = k
                  nstop(icount) = k
               else   
                 nstop(icount) = k
               endif
            endif
         else   
c
c check the intermediate letters
c                
            if (letter.eq.yes) then
               letter = line_copy(i - 1:i - 1)
               if (letter.eq.no) then
                  icount = icount + 1
                  nstart(icount) = i
               endif
               letter = line_copy(i + 1:i + 1)   
               if (letter.eq.no) then
                  nstop(icount) = i
               endif 
            endif   
         endif
      enddo   
      end
c
c-----------------------------------------------------------------------------------------
c
      subroutine token1 (nmax, npi, numint, nvalue,   
     +                   line, symbol)
c
c action: supply a character string (line) and cipher (symbol)
c         then calculate all sub-strings delineated by the cipher 
c         and return the number and values of integers in the string
c         if symbol = blank then call tokenp for pre-processing 
c         It is recommended to use symbol = ' ' as other possibilities have not been tested
c author: w.g.bardsley, university of manchester, u.k., 23/01/2022
c 
c   nmax: dimension for nstart, nstop, nvalue    
c    npi: starting position for integers
c nstart: starting point for sub-strings
c  nstop: stopping point for sub-strings
c numint: number of integers read off the string (line)
c nvalue: integers read off the string (line)
c symbol: cipher, e.g, blank, comma, semi-colon
c   line: string to be analysed
c  

c
c arguments
c
      integer, intent (in)             :: nmax
      integer, intent (out)            :: npi(nmax), numint,
     +                                    nvalue(nmax)
      character (len = 1), intent (in) :: symbol
      character (len = *), intent (in) :: line  
c
c allocatables
c         
      integer, allocatable :: nstart(:), nstop(:)
c
c locals
c
      integer i, icount, ios, j, k, l, ntemp
      character (len = 1024) line_copy
      character (len = 1   ) blank
      parameter (blank = ' ')
      external token0, tokenp, putadv
      intrinsic len_trim
      if (nmax.lt.1) then
         call putadv ('NMAX < 1 in call to TOKEN1')
         return
      endif   
      ntemp = nmax
      allocate (nstart(ntemp))
      allocate (nstop(ntemp))
      do i = 1, nmax      
         nvalue(i) = 0
      enddo   
      line_copy = blank
      if (symbol.eq.blank) then
         call tokenp (line, line_copy)
      else 
         k = len_trim(line)
         line_copy(1:k) = line  
      endif    
      call token0 (icount, nmax, nstart, nstop, 
     +             line_copy, symbol)  
      numint = 0 
      do i = 1, icount
         j = nstart(i)
         k = nstop(i)
         read (line_copy(j:k),*,iostat=ios) l
         if (ios.eq.0) then
            numint = numint + 1 
            npi(numint) = j
            nvalue(numint) = l
         endif
      enddo   
      deallocate (nstart)
      deallocate(nstop)
      end
c
c-----------------------------------------------------------------------------------------
c 
      subroutine token2 (nmax, npd, numval,
     +                   dvalue,   
     +                   line, symbol)
c
c action: supply a character string (line) and cipher (symbol)
c         then calculate all sub-strings delineated by the cipher 
c         and return the number and values of doubles in the string
c         if symbol = blank then call tokenp for preprocessing 
c         It is recommended to use symbol = ' ' as other possibilities have not been tested
c author: w.g.bardsley, university of manchester, u.k., 23/01/2022
c 
c   nmax: dimension for nstart, nstop, nvalue   
c    npd: start positions for doubles 
c nstart: starting point for sub-strings
c  nstop: stopping point for sub-strings
c numval: number of doubles read off the string (line)
c dvalue: doubles read off the string (line)
c symbol: cipher, e.g, blank, comma, semi-colon
c   line: string to be analysed
c  

c
c arguments
c
      integer, intent (in)             :: nmax
      integer, intent (out)            :: npd(nmax), numval
      double precision, intent (out)   :: dvalue(nmax)
      character (len = 1), intent (in) :: symbol
      character (len = *), intent (in) :: line 
c
c allocatable
c          
      integer, allocatable :: nstart(:), nstop(:)
c
c locals
c
      integer i, icount, ios, j, k, l, ntemp
      double precision temp
      character (len = 1024) line_copy
      character (len = 1   ) blank, dot
      parameter (blank = ' ', dot = '.')
      external token0, tokenp, putadv
      if (nmax.lt.1) then
         call putadv ('NMAX < 1 in call to TOKEN2')
         return
      endif   
      ntemp = nmax
      allocate (nstart(ntemp))
      allocate (nstop(ntemp))
      do i = 1, nmax      
         dvalue(i) = 0.0d+00
      enddo   
      if (symbol.eq.blank) then
         call tokenp (line, line_copy)
      else 
         k = len_trim(line)
         line_copy(1:k) = line  
      endif
      call token0 (icount, nmax, nstart, nstop, 
     +             line, symbol)  
      numval = 0 
      do i = 1, icount
         j = nstart(i)
         k = nstop(i)
         l = index(line(j:k),dot)
         if (l.gt.0) then
            read (line_copy(j:k),*,iostat=ios) temp
            if (ios.eq.0) then
               numval = numval + 1 
               npd(numval) = j
               dvalue(numval) = temp 
            endif
         endif   
      enddo   
      end
c
c-----------------------------------------------------------------------------
c 
      subroutine tokenp (line_in, line_out)
c
c action: supply a character string (line_in) and pre-processes i.e., output line_out
c         with colons, commas, semicolons and tabs replaced by blanks to make it easier
c         for token0, token1, token2, etc. to recognise tokens, integers and doubles
c author: w.g.bardsley, university of manchester, u.k., 23/01/2022
c       
c
c arguments
c          
      character (len = *), intent (in)  :: line_in
      character (len = *), intent (out) :: line_out  
c
c locals
c
      character (len = 1) blank, colon, comma, semi, tab
      parameter (blank = ' ', colon = ':', comma = ',', semi = ';',
     +           tab = char(9))
      integer    j, k, l
      intrinsic index, len_trim
      line_out = blank
      k = len_trim(line_in)
      line_out(1:k) = line_in(1:k) 
      j = index(line_in,colon)
      if (j.gt.0) then
         do l = j, k
           if (line_out(l:l).eq.colon) line_out(l:l) = blank 
         enddo
       endif  
      j = index(line_in,comma)
      if (j.gt.0) then
         do l = j, k
           if (line_out(l:l).eq.comma) line_out(l:l) = blank 
         enddo
       endif  
      j = index(line_in,semi)
      if (j.gt.0) then
         do l = j, k
           if (line_out(l:l).eq.semi) line_out(l:l) = blank 
         enddo
      endif   
      j = index(line_in,tab)
      if (j.gt.0) then
         do l = j, k
           if (line_out(l:l).eq.tab) line_out(l:l) = blank 
         enddo
      endif   
      end  
c
c
