C
C
      SUBROUTINE TRIGFN (N, NTRIG,
     +                   X, Y,
     +                   ABORT)
C
C ACTION : Transform a vector X to Y = F(X), F a trig function
C ADVICE : On exit Y will be completely transformed or not transformed at all
C          On exit X will be unchanged
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 13/2/97
C          13/11/1997 split the list box arguments
C          20/05/2006 improved the options and made X unchanged on exit
C          28/02/2007 added INTENTS 
C
C     N: (input/unchanged) size of the vector
C NTRIG: (input/output) incremented after each success
C     X: (input/unchanged) starting vector
C        Actually X is saved as XSAV(i,1) then restored on exit
C        Hence the intent is (INOUT) and not (IN) 
C     Y: (output) depending on ABORT
C ABORT: (output) as follows:
C                 if .TRUE. then Y is returned as Y = X
C                 if .FALSE. then Y is returned as the transformed vector Y = F(X)
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN)    :: N 
      INTEGER,          INTENT (INOUT) :: NTRIG
      DOUBLE PRECISION, INTENT (INOUT) :: X(N), Y(N)
      LOGICAL,          INTENT (OUT)   :: ABORT
C
C Local allocatable array
C
      DOUBLE PRECISION, ALLOCATABLE :: XSAV(:,:)
C
C Locals
C
      INTEGER    I, IERR, J, NDEC, NRMAX, NROW, NTRAN
      INTEGER    NCOL, NTYPE
      PARAMETER (NCOL = 3, NTYPE = 3)
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IX = 20, IY = 4, LSHADE = 1, NUMOPT = 14,
     +           NSTART = 1, NTEXT = 20)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      DOUBLE PRECISION X02AMFG
      DOUBLE PRECISION PI
      PARAMETER (PI = 3.14159265358979323846264338328D+00)
      DOUBLE PRECISION ONE, TODEG, TORAD
      PARAMETER (ONE = 1.0D+00, TODEG = 180.0D+00/PI, TORAD = ONE/TODEG)
      DOUBLE PRECISION TOPVAL, VSMALL, ZERO
      PARAMETER (TOPVAL = 0.999D+00, VSMALL = 1.0D-06, ZERO = 0.0D+00)
      DOUBLE PRECISION EPSI, TEMP
      CHARACTER  INFO(11)*20, LINE*100, TEXT(NTEXT)*100
      CHARACTER  TITLE*44
C
C TITLE must be consistent with FORMAT for output 1P,3E13.5
C
      PARAMETER (TITLE = '    Supplied      Transformed    Difference')
      CHARACTER  BLANK*1, YES*20
      PARAMETER (BLANK = ' ', YES = '(***Done***)')
      LOGICAL    DONE, REPEET
      LOGICAL    TAB_BOT, TAB_MID, TAB_TOP
      PARAMETER (TAB_BOT = .FALSE., TAB_MID = .TRUE., TAB_TOP = .FALSE.)
      EXTERNAL   PUTADV, PUTFAT, TBOX01, VIEWIT
      EXTERNAL   X02AMFG
      INTRINSIC  ABS, SIN, COS, TAN, ASIN, ACOS, ATAN, SINH, COSH, TANH
      DATA       NUMBLD / 18*0, 2*1/
      DATA       NUMPOS / NUMOPT*1 /
C
C Set ABORT = .TRUE. then check, allocate XSAV, then initialise
C
      ABORT = .TRUE.
      IF (N.LT.1) RETURN
      IERR = 0
      IF (ALLOCATED(XSAV)) DEALLOCATE(XSAV, STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE (XSAV(N,3), STAT = IERR)
      IF (IERR.NE.0) RETURN
      DO I = 1, N
         XSAV(I,1) = X(I)
         Y(I) = X(I)
         XSAV(I,2) = Y(I)
         XSAV(I,3) = ZERO
      ENDDO
      DO I = 1, 11
         INFO(I) = BLANK
      ENDDO
      EPSI = 1.0D+09*X02AMFG()
      NTRAN = 0
C
C Main loop
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         WRITE (TEXT,100) (INFO(I), I = 1, 11), NTRAN, NTRIG
         NDEC = NUMOPT - 2
         CALL TBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                TAB_BOT, TAB_MID, TAB_TOP)
         IF (NDEC.EQ.NUMOPT - 1) THEN
C
C Accept current transformations
C
            IF (NTRAN.GT.0) THEN
               ABORT = .FALSE.
               NTRIG = NTRIG + NTRAN
            ELSE
               ABORT = .TRUE.
            ENDIF
            DO I = 1, N
               X(I) = XSAV(I,1)
            ENDDO
            DEALLOCATE (XSAV, STAT = IERR)
            RETURN
         ELSEIF (NDEC.EQ.NUMOPT) THEN
C
C Cancel current transformations
C
            ABORT = .TRUE.
            DO I = 1, N
               X(I) = XSAV(I,1)
               Y(I) = X(I)
            ENDDO
            DEALLOCATE (XSAV, STAT = IERR)
            RETURN
         ENDIF
C
C Set DONE = .TRUE. the apply the transformations
C
         DONE = .TRUE.
         IF (NDEC.EQ.1) THEN
            DO I = 1, N
               Y(I) = X(I)*TORAD
            ENDDO
         ELSEIF (NDEC.EQ.2) THEN
            DO I = 1, N
               Y(I) = X(I)*TODEG
            ENDDO
         ELSEIF (NDEC.EQ.3) THEN
            DO I = 1, N
               Y(I) = SIN(X(I))
            ENDDO
         ELSEIF (NDEC.EQ.4) THEN
            DO I = 1, N
               Y(I) = COS(X(I))
            ENDDO
         ELSEIF (NDEC.EQ.5) THEN
            DO I = 1, N
               Y(I) = TAN(X(I))
            ENDDO
         ELSEIF (NDEC.EQ.6) THEN
            I = 0
            DO WHILE (I.LT.N .AND. DONE)
               I = I + 1
               J = I
               IF (ABS(X(I)).GT.TOPVAL) THEN
                  DONE = .FALSE.
               ELSE
                  Y(I) = ASIN(X(I))
               ENDIF
            ENDDO
         ELSEIF (NDEC.EQ.7) THEN
            I = 0
            DO WHILE (I.LT.N .AND. DONE)
               I = I + 1
               J = I
               IF (ABS(X(I)).GT.TOPVAL) THEN
                  DONE = .FALSE.
               ELSE
                  Y(I) = ACOS(X(I))
               ENDIF
            ENDDO
         ELSEIF (NDEC.EQ.8) THEN
            DO I = 1, N
               Y(I) = ATAN(X(I))
            ENDDO
         ELSEIF (NDEC.EQ.9) THEN
            DO I = 1, N
               Y(I) = SINH(X(I))
            ENDDO
         ELSEIF (NDEC.EQ.10) THEN
            DO I = 1, N
               Y(I) = COSH(X(I))
            ENDDO
         ELSEIF (NDEC.EQ.11) THEN
            DO I = 1, N
               Y(I) = TANH(X(I))
            ENDDO
         ELSEIF (NDEC.EQ.12) THEN
            DO I = 1, N
               TEMP = (XSAV(I,1) - XSAV(I,2))/
     +                (ABS(XSAV(I,1)) + ABS(XSAV(I,2)) + EPSI)
               IF (ABS(TEMP).LE.VSMALL) THEN
                  XSAV(I,3) = ZERO
               ELSE
                  XSAV(I,3) = XSAV(I,1) - X(I)
               ENDIF
            ENDDO
            NRMAX = N
            NROW = N
            CALL VIEWIT (NCOL, NRMAX, NROW, NTYPE,
     +                   XSAV,
     +                   TITLE)
         ENDIF
         IF (NDEC.NE.12) THEN
C
C Attend to the outcome unless View has been selected
C
            IF (DONE) THEN
C
C Record a success .... set X = Y
C
               NTRAN = NTRAN + 1
               INFO(NDEC) = YES
               DO I = 1, N
                  X(I) = Y(I)
                  XSAV(I,2) = Y(I)
               ENDDO
               WRITE (LINE,200)
               CALL PUTADV (LINE)
            ELSE
C
C Record a failure ... set Y = X
C
               DO I = 1, N
                  Y(I) = X(I)
               ENDDO
               WRITE (LINE,300) J, X(J)
               CALL PUTFAT (LINE)
            ENDIF
         ENDIF
      ENDDO   
C
C Format statements
C      
  100 FORMAT (
     + 'x := x*pi/180 `Degrees to Radians',1X,A
     +/'x := x*180/pi `Radians to Degrees',1X,A
     +/'x := sin(x)   `Sine'              ,1X,A
     +/'x := cos(x)   `Cosine'            ,1X,A
     +/'x := tan(x)   `Tangent'           ,1X,A
     +/'x := arcsin(x)`Inverse sine'      ,1X,A
     +/'x := arcos(x) `Inverse cosine'    ,1X,A
     +/'x := arctan(x)`Inverse tangent'   ,1X,A
     +/'x := sinh(x)  `Hyperbolic sine'   ,1X,A
     +/'x := cosh(x)  `Hyperbolic cosine' ,1X,A
     +/'x := tanh(x)  `Hyperbolic tangent',1X,A
     +/'View          `Original/Transformed'
     +/'Apply         `Accept transformations'
     +/'Cancel        `Discard transfromations'
     +/'Note that all x-values must be in radians before trigonometric'
     +/'functions are calculated, and inverse trigonometric functions'
     +/'will be be in radians. So if x is in degrees you must transform'
     +/'to radians before function evaluation'
     +/'No. of successful new Trig/Hyperbolic transformations =',i3
     +/'No. of previously applied Trig/Hyperbolic transformations =',i3)
  200 FORMAT ('The vector has now been transformed')
  300 FORMAT (
     +'No action taken...transformation stopped at x(',I6,') =',1PE12.4)
      END
C
C
