C
C
      SUBROUTINE TRIGMT (NCOLS, NRMAX, NROWS, NTRIG,
     +                   A,
     +                   ABORT)
C
C ACTION : Transform a matrix A to A = Y = F(X), F a trig function
C ADVICE : On exit A will be completely transformed or not transformed at all
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          26/05/2006 derived from TRIGFN 
C          28/02/2007 added INTENTS
C
C NCOLS: (input/unchanged) no. of columns
C NRMAX: (input/unchanged) leading dimension of matrix A
C NROWS: (input/unchanged) no. of rows
C NTRIG: (input/output) no. of trig/hyperbolic transformations
C     X: (input/output) depending on ABORT
C ABORT: (output) as follows:
C                 if .TRUE. then A and NTRIG are returned unchanged
C                 if .FALSE. then A and NTRIG are returned changed
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN)    :: NCOLS, NRMAX, NROWS
      INTEGER,          INTENT (INOUT) :: NTRIG
      DOUBLE PRECISION, INTENT (INOUT) :: A(NRMAX,NCOLS)
      LOGICAL,          INTENT (OUT)   :: ABORT
C
C Local allocatable array
C
      DOUBLE PRECISION, ALLOCATABLE :: X(:,:), Y(:,:)
C
C Locals
C
      INTEGER    I, IERR, J, NDEC, NTRAN
      INTEGER    NTYPE
      PARAMETER (NTYPE = 3)
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IX = 20, IY = 4, LSHADE = 1, NUMOPT = 14,
     +           NSTART = 1, NTEXT = 20)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      DOUBLE PRECISION X02AMFG
      DOUBLE PRECISION PI
      PARAMETER (PI = 3.14159265358979323846264338328D+00)
      DOUBLE PRECISION ONE, TODEG, TORAD
      PARAMETER (ONE = 1.0D+00, TODEG = 180.0D+00/PI, TORAD = ONE/TODEG)
      DOUBLE PRECISION TOPVAL, VSMALL, ZERO
      PARAMETER (TOPVAL = 0.999D+00, VSMALL = 1.0D-06, ZERO = 0.0D+00)
      DOUBLE PRECISION EPSI, TEMP
      CHARACTER  INFO(11)*20, LINE*100, TEXT(NTEXT)*100
      CHARACTER  TITLE*40
      PARAMETER (TITLE = 'Difference = Supplied - Transformed')
      CHARACTER  BLANK*1, YES*20
      PARAMETER (BLANK = ' ', YES = '(***Done***)')
      LOGICAL    DONE, REPEET
      LOGICAL    TAB_BOT, TAB_MID, TAB_TOP
      PARAMETER (TAB_BOT = .FALSE., TAB_MID = .TRUE., TAB_TOP = .FALSE.)
      EXTERNAL   PUTADV, PUTFAT, TBOX01, VIEWIT
      EXTERNAL   X02AMFG
      INTRINSIC  ABS, SIN, COS, TAN, ASIN, ACOS, ATAN, SINH, COSH, TANH
      DATA       NUMBLD / 18*0, 2*1/
      DATA       NUMPOS / NUMOPT*1 /
C
C Set ABORT = .TRUE. then check, allocate X and Y, then initialise
C
      ABORT = .TRUE.
      IF (NCOLS.LT.1 .OR. NROWS.LT.1 .OR. NROWS.GT.NRMAX) RETURN
      IERR = 0
      IF (ALLOCATED(X)) DEALLOCATE(X, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(Y)) DEALLOCATE(Y, STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE (X(NROWS,NCOLS), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE (Y(NROWS,NCOLS), STAT = IERR)
      IF (IERR.NE.0) RETURN
      DO J = 1, NCOLS
         DO I = 1, NROWS
            X(I,J) = A(I,J)
         ENDDO
      ENDDO
      DO I = 1, 11
         INFO(I) = BLANK
      ENDDO
      EPSI = 1.0D+09*X02AMFG()
      NTRAN = 0
C
C Main loop
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         WRITE (TEXT,100) (INFO(I), I = 1, 11), NTRAN, NTRIG
         NDEC = NUMOPT - 2
         CALL TBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                TAB_BOT, TAB_MID, TAB_TOP)
         IF (NDEC.EQ.NUMOPT - 1) THEN
C
C NDEC = NUMOPT - 1: Accept current transformations
C ==================
C
            IF (NTRAN.GT.0) THEN
               NTRIG = NTRIG + NTRAN
               DO J = 1, NCOLS
                  DO I = 1, NROWS
                     A(I,J) = X(I,J)
                  ENDDO
               ENDDO
               ABORT = .FALSE.
            ELSE
               ABORT = .TRUE.
            ENDIF
            DEALLOCATE (X, STAT = IERR)
            DEALLOCATE (Y, STAT = IERR)
            RETURN
         ELSEIF (NDEC.EQ.NUMOPT) THEN
C
C NDEC = NUMOPT: Cancel current transformations
C ==============
C
            DEALLOCATE (X, STAT = IERR)
            DEALLOCATE (Y, STAT = IERR)
            ABORT = .TRUE.
            RETURN
         ENDIF
C
C Set DONE = .TRUE. then apply the transformations
C
         DONE = .TRUE.
         IF (NDEC.EQ.1) THEN
C
C NDEC = 1: degrees to radians
C =========
C
            DO J = 1, NCOLS
               DO I = 1, NROWS
                  Y(I,J) = X(I,J)*TORAD
               ENDDO
            ENDDO
         ELSEIF (NDEC.EQ.2) THEN
C
C NDEC = 2: radians to degrees
C =========
C
            DO J = 1, NCOLS
               DO I = 1, NROWS
                  Y(I,J) = X(I,J)*TODEG
               ENDDO
            ENDDO
         ELSEIF (NDEC.EQ.3) THEN
C
C NDEC = 3: sine
C =========
C
            DO J = 1, NCOLS
               DO I = 1, NROWS
                  Y(I,J) = SIN(X(I,J))
               ENDDO
            ENDDO
         ELSEIF (NDEC.EQ.4) THEN
C
C NDEC = 4: cosine
C =========
C
            DO J = 1, NCOLS
               DO I = 1, NROWS
                  Y(I,J) = COS(X(I,J))
               ENDDO
            ENDDO
         ELSEIF (NDEC.EQ.5) THEN
C
C NDEC = 6: tangent
C =========
C
            DO J = 1, NCOLS
               DO I = 1, NROWS
                  Y(I,J) = TAN(X(I,J))
               ENDDO
            ENDDO
         ELSEIF (NDEC.EQ.6) THEN
C
C NDEC = 6: inverse sine
C =========
C
            J = 0
            DO WHILE (J.LT.NCOLS .AND. DONE)
               J = J + 1
               I = 0
               DO WHILE (I.LT.NROWS .AND. DONE)
                  I = I + 1
                  IF (ABS(X(I,J)).GT.TOPVAL) THEN
                     DONE = .FALSE.
                  ELSE
                     Y(I,J) = ASIN(X(I,J))
                  ENDIF
               ENDDO
            ENDDO
         ELSEIF (NDEC.EQ.7) THEN
C
C NDEC = 7: inverse cosine
C =========
C
            J = 0
            DO WHILE (J.LT.NCOLS .AND. DONE)
               J = J + 1
               I = 0
               DO WHILE (I.LT.NROWS .AND. DONE)
                  I = I + 1
                  IF (ABS(X(I,J)).GT.TOPVAL) THEN
                     DONE = .FALSE.
                  ELSE
                     Y(I,J) = ACOS(X(I,J))
                  ENDIF
               ENDDO
            ENDDO
         ELSEIF (NDEC.EQ.8) THEN
C
C NDEC = 8: inverse tangent
C =========
C
            DO J = 1, NCOLS
               DO I = 1, NROWS
                  Y(I,J) = ATAN(X(I,J))
               ENDDO
            ENDDO
         ELSEIF (NDEC.EQ.9) THEN
C
C NDEC = 9: sinh
C =========
C
            DO J = 1, NCOLS
               DO I = 1, NROWS
                  Y(I,J) = SINH(X(I,J))
               ENDDO
            ENDDO
         ELSEIF (NDEC.EQ.10) THEN
C
C NDEC = 10: cosh
C ==========
C
            DO J = 1, NCOLS
               DO I = 1, NROWS
                  Y(I,J) = COSH(X(I,J))
               ENDDO
            ENDDO
         ELSEIF (NDEC.EQ.11) THEN
C
C NDEC = 11: tanh
C ==========
C
            DO J = 1, NCOLS
               DO I = 1, NROWS
                  Y(I,J) = TANH(X(I,J))
               ENDDO
            ENDDO
         ELSEIF (NDEC.EQ.12) THEN
C
C NDEC = 12: view
C ==========
C
            DO J = 1, NCOLS
               DO I = 1, NROWS
                  TEMP = (A(I,J) - X(I,J))/
     +                   (ABS(A(I,J)) + ABS(X(I,J)) + EPSI)
                  IF (ABS(TEMP).LE.VSMALL) THEN
                     Y(I,J) = ZERO
                  ELSE
                     Y(I,J) = A(I,J) - X(I,J)
                  ENDIF
               ENDDO
            ENDDO
            CALL VIEWIT (NCOLS, NROWS, NROWS, NTYPE,
     +                   Y,
     +                   TITLE)
         ENDIF
         IF (NDEC.NE.12) THEN
C
C Attend to the outcome unless View has been selected
C
            IF (DONE) THEN
C
C Record a success .... set X = Y
C
               NTRAN = NTRAN + 1
               INFO(NDEC) = YES
               DO J = 1, NCOLS
                  DO I = 1, NROWS
                     X(I,J) = Y(I,J)
                  ENDDO
               ENDDO
               WRITE (LINE,200)
               CALL PUTADV (LINE)
            ELSE
C
C Record a failure ... set Y = X
C
               WRITE (LINE,300) I, J, X(I,J)
               CALL PUTFAT (LINE)
               DO J = 1, NCOLS
                  DO I = 1, NROWS
                     Y(I,J) = X(I,J)
                  ENDDO
               ENDDO
            ENDIF
         ENDIF
      ENDDO
  100 FORMAT (
     + 'x := x*pi/180 `Degrees to Radians',1X,A
     +/'x := x*180/pi `Radians to Degrees',1X,A
     +/'x := sin(x)   `Sine'              ,1X,A
     +/'x := cos(x)   `Cosine'            ,1X,A
     +/'x := tan(x)   `Tangent'           ,1X,A
     +/'x := arcsin(x)`Inverse sine'      ,1X,A
     +/'x := arcos(x) `Inverse cosine'    ,1X,A
     +/'x := arctan(x)`Inverse tangent'   ,1X,A
     +/'x := sinh(x)  `Hyperbolic sine'   ,1X,A
     +/'x := cosh(x)  `Hyperbolic cosine' ,1X,A
     +/'x := tanh(x)  `Hyperbolic tangent',1X,A
     +/'View          `Difference matrix'
     +/'Apply         `Accept transformations'
     +/'Cancel        `Discard transformations'
     +/'Note that all x-values must be in radians before trigonometric'
     +/'functions are calculated, and inverse trigonometric functions'
     +/'will be be in radians. So if x is in degrees you must transform'
     +/'the whole matrix to radians before function evaluation'
     +/'No. of successful new Trig/Hyperbolic transformations =',i3
     +/'No. of previously applied Trig/Hyperbolic transformations =',i3)
  200 FORMAT ('The whole matrix has now been transformed')
  300 FORMAT (
     +'No action taken...transformation stopped at x(',I6,',',I4,') =',
     +1P,E12.4)
      END
C
C
